/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.srt;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.servlet.util.EmptyEnumeration;
import com.ibm.websphere.servlet.request.IRequest;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.webcontainer.servlet.RequestUtils;
import com.ibm.ws.webcontainer.srt.IPrivateRequestAttributes;
import com.ibm.ws.webcontainer.srt.SRTConnectionContext;
import com.ibm.ws.webcontainer.srt.SRTRequestContext;
import com.ibm.ws.webcontainer.srt.http.HttpInputStream;
import com.ibm.ws.webcontainer.util.UnsynchronizedStack;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebAppConfiguration;
import com.ibm.ws.webcontainer.webapp.WebAppDispatcherContext;
import com.ibm.ws.webcontainer.webapp.WebGroup;
import com.ibm.wsspi.webcontainer.IPoolable;
import com.ibm.wsspi.webcontainer.WCCustomProperties;
import com.ibm.wsspi.webcontainer.WebContainer;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.servlet.IExtendedRequest;
import com.ibm.wsspi.webcontainer.servlet.IExtendedResponse;
import com.ibm.wsspi.webcontainer.servlet.IServletRequest;
import com.ibm.wsspi.webcontainer.util.EncodingUtils;
import com.ibm.wsspi.webcontainer.util.WSServletInputStream;
import com.ibm.wsspi.webcontainer.webapp.IWebAppDispatcherContext;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class SRTServletRequest
implements HttpServletRequest,
IExtendedRequest,
IServletRequest,
IPrivateRequestAttributes {
    protected static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.srt");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.srt.SRTServletRequest";
    protected static NLS nls = new NLS("com.ibm.ws.webcontainer.resources.Messages");
    private static String CLIENT_ENCODING_OVERRIDE;
    private static String DEFAULT_CLIENT_ENCODING;
    private static String suppressHeadersInRequest;
    private static ArrayList suppressheadersList;
    private static final String JAVAX_NET_SSL_PEER_CERTS = "javax.net.ssl.peer_certificates";
    private static final String JAVAX_NET_SSL_CIPHER_SUITE = "javax.net.ssl.cipher_suite";
    private static final String JAVAX_SERVLET_REQUEST_X509CERTIFICATE = "javax.servlet.request.X509Certificate";
    private static final String DIRECT_CONNECTION_PEER_CERTS = "com.ibm.websphere.ssl.direct_connection_peer_certificates";
    private static final String DIRECT_CONNECTION_CIPHER_SUITE = "com.ibm.websphere.ssl.direct_connection_cipher_suite";
    private static final String IS_DIRECT_CONNECTION = "com.ibm.websphere.webcontainer.is_direct_connection";
    private static final String INPUT_STREAM_CONTENT_TYPE = "ContentType";
    private static final String INPUT_STREAM_CONTENT_DATA = "ContentData";
    private static final String INPUT_STREAM_CONTENT_DATA_LENGTH = "ContentDataLength";
    private UnsynchronizedStack _paramStack = new UnsynchronizedStack();
    private SRTConnectionContext _connContext;
    private SRTRequestContext _requestContext = null;
    private WebAppDispatcherContext _dispatchContext = null;
    private SRTServletRequestHelper _srtRequestHelper;
    protected IRequest _request = null;
    protected WSServletInputStream _in;
    private boolean _runningCollaborators = false;
    private String _setInputStreamContentType;
    private int _setInputStreamContentLength;
    private boolean _setInputDataStreamCalled;
    private static final boolean enableSetCharacterEncodingAfterGetReader;
    private static boolean copyAttributesKeySet;

    public SRTServletRequest(SRTConnectionContext context) {
        this._connContext = context;
        this._requestContext = new SRTRequestContext(this);
        this._in = this.createInputStream();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "SRTServletRequest", "this->" + this + ": " + "inputStream is of type --> " + this._in);
        }
    }

    public Object getPrivateAttribute(String name) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getPrivateAttribute", "this->" + this + ": " + " name --> " + name);
        }
        if (this._srtRequestHelper._privateAttributes == null) {
            return null;
        }
        return this._srtRequestHelper._privateAttributes.get(name);
    }

    public Enumeration getPrivateAttributeNames() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getPrivateAttributeNames", "this->" + this + ": ");
        }
        if (this._srtRequestHelper._privateAttributes == null) {
            return EmptyEnumeration.instance();
        }
        return this._srtRequestHelper._privateAttributes.keys();
    }

    public void setPrivateAttribute(String name, Object value) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setPrivateAttribute", "this->" + this + ": " + " name --> " + name + " value --> " + value.toString());
        }
        if (this._srtRequestHelper._privateAttributes == null) {
            this._srtRequestHelper._privateAttributes = new Hashtable();
        }
        this._srtRequestHelper._privateAttributes.put(name, value);
    }

    public void initForNextRequest(IRequest req) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "initForNextRequest", "this->" + this + ": ");
        }
        try {
            if (req == null) {
                this._in.init(null);
                return;
            }
            this._setInputStreamContentType = null;
            this._setInputStreamContentLength = -1;
            this._setInputDataStreamCalled = false;
            this._request = req;
            this._srtRequestHelper = new SRTServletRequestHelper();
            this._in.init(this._request.getInputStream());
            if (this.getContentLength() > 0) {
                this._in.setContentLength(this.getContentLength());
            }
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webcontainer.srt.SRTServletRequest.initForNextRequest", "828", this);
        }
    }

    public Object getAttribute(String arg0) {
        Object obj;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getAttribute", "this->" + this + ": " + " name --> " + arg0);
        }
        if ((obj = this._srtRequestHelper._attributes.get(arg0)) == null) {
            if (arg0.equals(JAVAX_NET_SSL_PEER_CERTS) || arg0.equals(JAVAX_SERVLET_REQUEST_X509CERTIFICATE)) {
                obj = this.getPeerCertificates();
            } else if (arg0.equals(JAVAX_NET_SSL_CIPHER_SUITE)) {
                obj = this.getCipherSuite();
            } else if (arg0.equals(DIRECT_CONNECTION_PEER_CERTS)) {
                obj = this.getDirectConnectionPeerCertificates();
            } else if (arg0.equals(DIRECT_CONNECTION_CIPHER_SUITE)) {
                obj = this.getDirectConnectionCipherSuite();
            } else if (arg0.equals(IS_DIRECT_CONNECTION)) {
                obj = this.isDirectConnection();
            }
        }
        return obj;
    }

    public Enumeration getAttributeNames() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getAttributeNames", "this->" + this + ": ");
        }
        if (copyAttributesKeySet) {
            return new Enumeration(){
                private Iterator iter;
                {
                    this.iter = new ArrayList(SRTServletRequest.this._srtRequestHelper._attributes.keySet()).iterator();
                }

                public boolean hasMoreElements() {
                    return this.iter.hasNext();
                }

                public Object nextElement() {
                    return this.iter.next();
                }
            };
        }
        return new Enumeration(){
            private Iterator iter;
            {
                this.iter = SRTServletRequest.this._srtRequestHelper._attributes.keySet().iterator();
            }

            public boolean hasMoreElements() {
                return this.iter.hasNext();
            }

            public Object nextElement() {
                return this.iter.next();
            }
        };
    }

    public void setCharacterEncoding(String arg0) throws UnsupportedEncodingException {
        if (!enableSetCharacterEncodingAfterGetReader && this._srtRequestHelper._gotReader) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setCharacterEncoding", "this->" + this + ": " + " call ignored, already got reader");
            }
            return;
        }
        boolean isSupported = EncodingUtils.isCharsetSupported(arg0);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setCharacterEncoding", "this->" + this + ": " + " name --> " + arg0 + " isSupported --> " + String.valueOf(isSupported));
        }
        if (!isSupported) {
            String msg = nls.getFormattedMessage("unsupported.request.encoding.[{0}]", new Object[]{arg0}, "Unsupported encoding specified --> " + arg0);
            throw new UnsupportedEncodingException(msg);
        }
        this._srtRequestHelper._characterEncoding = arg0;
    }

    private boolean isHeaderinSuppressedHeadersList(String headername) {
        boolean suppressHeader = false;
        if (headername != null) {
            Iterator itList = suppressheadersList.iterator();
            while (itList.hasNext() && !suppressHeader) {
                String s = (String)itList.next();
                if (!headername.startsWith(s)) continue;
                suppressHeader = true;
                if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) continue;
                logger.logp(Level.FINE, CLASS_NAME, "isHeaderinSuppressedHeadersList", " suppressHeadersInRequest is set and headername --> " + headername + " begins with --> " + s);
            }
        }
        return suppressHeader;
    }

    public long getDateHeader(String name) {
        long header = -1L;
        if (suppressHeadersInRequest == null || !this.isHeaderinSuppressedHeadersList(name)) {
            header = this._request.getDateHeader(name);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getDateHeader", "this->" + this + ": " + " name --> " + name + " header --> " + String.valueOf(header));
        }
        return header;
    }

    public String getHeader(String name) {
        String header = null;
        if (suppressHeadersInRequest == null || !this.isHeaderinSuppressedHeadersList(name)) {
            header = this._request.getHeader(name);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getHeader", "this->" + this + ": " + " name --> " + name + " header --> " + header);
        }
        return header;
    }

    public String getHeaderDirect(String name) {
        String header = null;
        if (suppressHeadersInRequest == null || !this.isHeaderinSuppressedHeadersList(name)) {
            header = this._request.getHeader(name);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getHeaderDirect", "this->" + this + ": " + " name --> " + name + " header --> " + header);
        }
        return header;
    }

    public Enumeration getHeaderNames() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getHeaderNames", "this->" + this + ": ");
        }
        if (suppressHeadersInRequest == null) {
            return this._request.getHeaderNames();
        }
        ArrayList<String> alHeaderNames = new ArrayList<String>();
        Enumeration enumHeaderNames = this._request.getHeaderNames();
        while (enumHeaderNames.hasMoreElements()) {
            String headerNameParam = (String)enumHeaderNames.nextElement();
            if (this.isHeaderinSuppressedHeadersList(headerNameParam)) continue;
            alHeaderNames.add(headerNameParam);
        }
        return Collections.enumeration(alHeaderNames);
    }

    public int getIntHeader(String name) {
        int header = -1;
        if (suppressHeadersInRequest == null || !this.isHeaderinSuppressedHeadersList(name)) {
            header = this._request.getIntHeader(name);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getIntHeader", "this->" + this + ": " + " name --> " + name + " header --> " + String.valueOf(header));
        }
        return header;
    }

    public Enumeration getHeaders(String name) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getHeaders", "this->" + this + ": " + " name --> " + name);
        }
        Enumeration header = null;
        if (suppressHeadersInRequest == null || !this.isHeaderinSuppressedHeadersList(name)) {
            header = this._request.getHeaders(name);
        }
        return header;
    }

    public String getMethod() {
        if (this._srtRequestHelper._method == null) {
            this._srtRequestHelper._method = this._request.getMethod();
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getMethod", "this->" + this + ": " + " method --> " + this._srtRequestHelper._method);
        }
        return this._srtRequestHelper._method;
    }

    public int getContentLength() {
        int contentLength = !this._setInputDataStreamCalled ? this._request.getContentLength() : this._setInputStreamContentLength;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getContentLength", "this->" + this + ": " + " length --> " + String.valueOf(contentLength));
        }
        return contentLength;
    }

    public String getContentType() {
        String contentType = !this._setInputDataStreamCalled ? this._request.getContentType() : this._setInputStreamContentType;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getContentType", "this->" + this + ": " + " type --> " + contentType);
        }
        return contentType;
    }

    public String getProtocol() {
        String protocol = this._request.getProtocol();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getProtocol", "this->" + this + ": " + " protocol --> " + protocol);
        }
        return protocol;
    }

    public String getScheme() {
        String scheme = this._request.getScheme();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getScheme", "this->" + this + ": " + " scheme --> " + scheme);
        }
        return scheme;
    }

    public int getServerPort() {
        int port = this._request.getServerPort();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getServerPort", "this->" + this + ": " + " port --> " + String.valueOf(port));
        }
        return port;
    }

    public String getRemoteAddr() {
        String addr = this._request.getRemoteAddr();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getRemoteAddr", "this->" + this + ": " + " address --> " + addr);
        }
        return addr;
    }

    public String getRemoteHost() {
        String host = this._request.getRemoteHost();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getRemoteHost", "this->" + this + ": " + " host --> " + host);
        }
        return host;
    }

    public void setAttribute(String arg0, Object arg1) {
        Object oldValue;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setAttribute", "this->" + this + ": " + " name --> " + arg0 + " value --> " + (arg1 != null ? arg1.toString() : ""));
        }
        if ((oldValue = this._srtRequestHelper._attributes.put(arg0, arg1)) != null) {
            this.attributeReplaced(arg0, oldValue);
        } else {
            this.attributeAdded(arg0, arg1);
        }
    }

    public void removeAttribute(String arg0) {
        Object oldValue;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "removeAttribute", "this->" + this + ": " + " name --> " + arg0);
        }
        if ((oldValue = this._srtRequestHelper._attributes.remove(arg0)) != null) {
            this.attributeRemoved(arg0, oldValue);
        }
    }

    public Locale getLocale() {
        this.processLocales();
        Locale locale = this._srtRequestHelper._locales.size() > 0 ? this._srtRequestHelper._locales.get(0) : null;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getLocale", "this->" + this + ": " + " locale --> " + (locale != null ? locale.toString() : ""));
        }
        return locale;
    }

    public Enumeration getLocales() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getLocales", "this->" + this + ": ");
        }
        this.processLocales();
        return new Enumeration(){
            Iterator iter;
            {
                this.iter = SRTServletRequest.this._srtRequestHelper._locales.iterator();
            }

            public boolean hasMoreElements() {
                return this.iter.hasNext();
            }

            public Object nextElement() {
                return this.iter.next();
            }
        };
    }

    public boolean isSecure() {
        boolean secure = this._request.isSSL();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "isSecure", "this->" + this + ": " + " value --> " + String.valueOf(secure));
        }
        return secure;
    }

    public String getCipherSuite() {
        String cipherSuite = this._request.getCipherSuite();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getCipherSuite", "this->" + this + ": " + " value --> " + cipherSuite);
        }
        return cipherSuite;
    }

    public String getDirectConnectionCipherSuite() {
        String cipherSuite;
        block4: {
            Class<?> requestClass = this._request.getClass();
            cipherSuite = null;
            if (requestClass.getName().equals("com.ibm.ws.webcontainer.channel.WCCRequestImpl")) {
                try {
                    Method method = requestClass.getMethod("getConnectionCipherSuite", null);
                    cipherSuite = (String)method.invoke((Object)this._request, null);
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.webcontainer.srt.SRTServletRequest.getDirectConnectionCipherSuite", "587", this);
                    if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) break block4;
                    logger.logp(Level.FINE, CLASS_NAME, "getDirectConnectionCipherSuite", "failed to retrieve direction connection cipher suite", e);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getDirectConnectionCipherSuite", "this->" + this + ": " + " value --> " + cipherSuite);
        }
        return cipherSuite;
    }

    public X509Certificate[] getPeerCertificates() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getPeerCertificates", "this->" + this + ": ");
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getPeerCertificates", "this->" + this + ": ");
        }
        Object[] certs = this._request.getPeerCertificates();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getPeerCertificates", "this->" + this + ": " + "certificates", certs);
        }
        return certs;
    }

    public X509Certificate[] getDirectConnectionPeerCertificates() {
        X509Certificate[] certs;
        block4: {
            Class<?> requestClass = this._request.getClass();
            certs = null;
            if (requestClass.getName().equals("com.ibm.ws.webcontainer.channel.WCCRequestImpl")) {
                try {
                    Method method = requestClass.getMethod("getConnectionPeerCertificates", null);
                    certs = (X509Certificate[])method.invoke((Object)this._request, null);
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.webcontainer.srt.SRTServletRequest.getDirectConnectionPeerCertificates", "726", this);
                    if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) break block4;
                    logger.logp(Level.FINE, CLASS_NAME, "getDirectConnectionPeerCertificates", "failed to retrieve direction connection peer certificates", e);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getDirectConnectionPeerCertificates", "this->" + this + ": " + " value --> " + certs);
        }
        return certs;
    }

    private Boolean isDirectConnection() {
        Boolean direct;
        block4: {
            direct = Boolean.valueOf("false");
            Class<?> requestClass = this._request.getClass();
            if (requestClass.getName().equals("com.ibm.ws.webcontainer.channel.WCCRequestImpl")) {
                try {
                    Method method = requestClass.getMethod("checkForDirectConnection", null);
                    direct = (Boolean)method.invoke((Object)this._request, null);
                }
                catch (Exception e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) break block4;
                    logger.logp(Level.FINE, CLASS_NAME, "isDirectConnection", "failed to retrieve direct connection check", e);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "isDirectConnection", "return -> " + direct);
        }
        return direct;
    }

    public void setRequest(IRequest _request) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setRequest", "this->" + this + ": ");
        }
        this._request = _request;
    }

    public void attributeAdded(String key, Object newVal) {
        WebApp webapp;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "attributeAdded", "this->" + this + ": " + " key --> " + key + " value --> " + newVal);
        }
        if ((webapp = this._dispatchContext.getWebApp()) != null) {
            webapp.notifyServletRequestAttrAdded(this, key, newVal);
        }
    }

    public void attributeRemoved(String key, Object oldVal) {
        WebApp webapp;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "attributeRemoved", "this->" + this + ": " + " key --> " + key + " value --> " + oldVal);
        }
        if ((webapp = this._dispatchContext.getWebApp()) != null) {
            webapp.notifyServletRequestAttrRemoved(this, key, oldVal);
        }
    }

    public void attributeReplaced(String key, Object oldVal) {
        WebApp webapp;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "attributeReplaced", "this->" + this + ": " + " key --> " + key + " value --> " + oldVal);
        }
        if ((webapp = this._dispatchContext.getWebApp()) != null) {
            webapp.notifyServletRequestAttrReplaced(this, key, oldVal);
        }
    }

    protected void setLocales(Iterator iter) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setLocales", "this->" + this + ": ");
        }
        while (iter.hasNext()) {
            this._srtRequestHelper._locales.add(iter.next());
        }
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this._srtRequestHelper._gotReader) {
            throw new IllegalStateException(nls.getString("Reader.already.obtained", "Reader already obtained"));
        }
        this._srtRequestHelper._gotInputStream = true;
        return this._in;
    }

    public IRequest getIRequest() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getIRequest", "this->" + this + ": ");
        }
        return this._request;
    }

    public synchronized BufferedReader getReader() throws UnsupportedEncodingException, IOException {
        if (this._srtRequestHelper._gotInputStream) {
            throw new IllegalStateException(nls.getString("InputStream.already.obtained", "Input Stream already obtained"));
        }
        if (this._srtRequestHelper._reader == null) {
            this._srtRequestHelper._gotReader = true;
            this._srtRequestHelper._reader = new BufferedReader(new InputStreamReader((InputStream)this._in, this.getReaderEncoding()));
        }
        return this._srtRequestHelper._reader;
    }

    protected void releaseInputStream() {
        if (this._srtRequestHelper._gotInputStream) {
            this._srtRequestHelper._gotInputStream = false;
        }
    }

    protected void releaseReader() {
        if (this._srtRequestHelper._gotReader) {
            this._srtRequestHelper._gotReader = false;
        }
    }

    protected SRTConnectionContext getConnectionContext() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getConnectionContext", "");
        }
        return this._connContext;
    }

    public IWebAppDispatcherContext getWebAppDispatcherContext() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getWebAppDispatcherContext", "");
        }
        return this._dispatchContext;
    }

    public void setWebAppDispatcherContext(IWebAppDispatcherContext ctx) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setWebAppDispatcherContext", " old context [" + this._dispatchContext + "] new context [" + ctx + "]");
        }
        this._dispatchContext = (WebAppDispatcherContext)ctx;
        this.resetPathElements();
    }

    public void resetPathElements() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "resetPathElements", "");
        }
        if (this._srtRequestHelper != null) {
            this._srtRequestHelper._requestURI = null;
            this._srtRequestHelper._pathInfo = null;
        }
    }

    public String getLocalAddr() {
        String addr = this._request.getLocalAddr();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getLocalAddr", " address --> " + addr);
        }
        return addr;
    }

    public String getLocalName() {
        String name = this._request.getLocalName();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getLocalName", " name --> " + name);
        }
        return name;
    }

    public int getLocalPort() {
        int port = this._request.getLocalPort();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getLocalPort", " port --> " + String.valueOf(port));
        }
        return port;
    }

    public int getRemotePort() {
        int port = this._request.getRemotePort();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getRemotePort", " port --> " + String.valueOf(port));
        }
        return port;
    }

    public IExtendedResponse getResponse() {
        return this._connContext.getResponse();
    }

    public void setResponse(IExtendedResponse extResp) {
        this._connContext.setResponse(extResp);
    }

    public void start() {
    }

    public Object clone() throws CloneNotSupportedException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "clone", " entry");
        }
        SRTServletRequest clonedSRTServletRequest = (SRTServletRequest)super.clone();
        SRTRequestContext clonedRequestContext = null;
        if (this._requestContext != null) {
            clonedSRTServletRequest._requestContext = clonedRequestContext = (SRTRequestContext)this._requestContext.clone(clonedSRTServletRequest);
        }
        WebAppDispatcherContext clonedDispatchContext = null;
        if (this._dispatchContext != null) {
            clonedSRTServletRequest._dispatchContext = clonedDispatchContext = (WebAppDispatcherContext)this._dispatchContext.clone(clonedSRTServletRequest, clonedRequestContext);
        }
        SRTConnectionContext clonedConnContext = null;
        if (this._connContext != null) {
            clonedSRTServletRequest._connContext = clonedConnContext = (SRTConnectionContext)this._connContext.clone(clonedSRTServletRequest, clonedDispatchContext);
        }
        SRTServletRequestHelper _clonedsrtRequestHelper = null;
        if (this._srtRequestHelper != null) {
            clonedSRTServletRequest._srtRequestHelper = _clonedsrtRequestHelper = (SRTServletRequestHelper)this._srtRequestHelper.clone();
        }
        if (this._paramStack != null) {
            clonedSRTServletRequest._paramStack = (UnsynchronizedStack)this._paramStack.clone();
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "clone", " exit original -->" + this + " cloned -->" + clonedSRTServletRequest);
        }
        return clonedSRTServletRequest;
    }

    public String getAuthType() {
        String authType = null;
        authType = this._dispatchContext.isSecurityEnabledForApplication() ? (String)this.getPrivateAttribute("AUTH_TYPE") : this._request.getAuthType();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getAuthType", " authType --> " + authType);
        }
        if (authType != null) {
            if (authType.equals("BASIC")) {
                return "BASIC";
            }
            if (authType.equals("CLIENT_CERT")) {
                return "CLIENT_CERT";
            }
            if (authType.equals("DIGEST")) {
                return "DIGEST";
            }
            if (authType.equals("FORM")) {
                return "FORM";
            }
        }
        return authType;
    }

    public String getCharacterEncoding() {
        String _encoding;
        if (this._srtRequestHelper._characterEncoding != null) {
            return this._srtRequestHelper._characterEncoding;
        }
        String type = this.getContentType();
        int index = -1;
        if (type != null) {
            index = type.indexOf("charset=");
        }
        if ((_encoding = SRTServletRequest.getEncodingFromContentType(type, index)) != null) {
            try {
                this.setCharacterEncoding(_encoding);
            }
            catch (UnsupportedEncodingException e) {
                logger.logp(Level.INFO, CLASS_NAME, "getCharacterEncoding", "Unable to set request character encoding based upon request header ", e);
            }
        }
        return _encoding;
    }

    private static String getEncodingFromContentType(String type, int index) {
        int semicolonIndex;
        int endIndex;
        int startIndex;
        String _encoding = null;
        if (index > -1 && startIndex <= (endIndex = (semicolonIndex = type.indexOf(59, (startIndex = index + 8) + 1)) == -1 ? type.length() - 1 : semicolonIndex - 1)) {
            boolean endsWithQoute;
            boolean startsWithQoute = type.charAt(startIndex) == '\"' || type.charAt(startIndex) == '\'';
            boolean bl = endsWithQoute = type.charAt(endIndex) == '\"' || type.charAt(endIndex) == '\'';
            _encoding = startsWithQoute && endsWithQoute ? type.substring(startIndex + 1, endIndex) : (semicolonIndex == -1 ? type.substring(startIndex) : type.substring(startIndex, semicolonIndex));
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getEncodingFromContentType", "type->" + type + ", encoding --> " + _encoding);
        }
        return _encoding;
    }

    public String getReaderEncoding() {
        if (this._srtRequestHelper._readerEncoding != null) {
            return this._srtRequestHelper._readerEncoding;
        }
        String encoding = CLIENT_ENCODING_OVERRIDE;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getReaderEncoding", "client encoding override --> " + encoding);
        }
        if (encoding == null) {
            encoding = this.getCharacterEncoding();
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getReaderEncoding", "content-type header --> " + encoding);
            }
        }
        WebAppConfiguration webAppCfg = this._dispatchContext.getWebApp().getConfiguration();
        if (encoding == null && webAppCfg.isAutoRequestEncoding()) {
            Locale _locale;
            String acceptLanguage = this.getHeader("Accept-Language");
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getReaderEncoding", "accept-language --> " + acceptLanguage);
            }
            if (acceptLanguage != null && !acceptLanguage.equals("*") && (encoding = webAppCfg.getLocaleEncoding(_locale = this.getLocale())) == null) {
                encoding = EncodingUtils.getEncodingFromLocale(_locale);
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "getReaderEncoding", "encoding from locale --> " + encoding);
                }
            }
        }
        if (encoding == null) {
            encoding = DEFAULT_CLIENT_ENCODING;
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getReaderEncoding", "default client encoding -->" + encoding);
            }
        }
        if (encoding == null) {
            encoding = "ISO-8859-1";
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getReaderEncoding", "default encoding --> " + encoding);
            }
        }
        this._srtRequestHelper._readerEncoding = EncodingUtils.getJvmConverter(encoding);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getReaderEncoding", " encoding  converted --> " + this._srtRequestHelper._readerEncoding);
        }
        return this._srtRequestHelper._readerEncoding;
    }

    public Cookie[] getCookies() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getCookies", "");
        }
        if (!this._srtRequestHelper._cookiesParsed) {
            SRTServletRequestHelper.access$1402(this._srtRequestHelper, this._request.getCookies());
            this._srtRequestHelper._cookiesParsed = true;
        }
        return this._srtRequestHelper._cookies;
    }

    public void addParameter(String name, String[] values) {
        Hashtable<String, String[]> aParam = new Hashtable<String, String[]>(3);
        aParam.put(name, values);
        this.mergeQueryParams(aParam);
    }

    public void setMethod(String method) {
        this._srtRequestHelper._method = method;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setInputStreamData(HashMap inStreamInfo) throws IOException {
        if (this._srtRequestHelper._gotReader) {
            if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) throw new IllegalStateException(nls.getString("Reader.already.obtained", "Reader already obtained"));
            logger.logp(Level.FINE, CLASS_NAME, "setInputStreamData", "attempt to setInputStreamData after it has been read");
            throw new IllegalStateException(nls.getString("Reader.already.obtained", "Reader already obtained"));
        }
        this._setInputDataStreamCalled = true;
        if (inStreamInfo != null) {
            Integer contentLength = (Integer)inStreamInfo.get(INPUT_STREAM_CONTENT_DATA_LENGTH);
            if (contentLength == null) {
                if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) throw new IllegalStateException();
                logger.logp(Level.FINE, CLASS_NAME, "setInputStreamData", "No content length in passed map. Throw IOException");
                throw new IllegalStateException();
            }
            this._setInputStreamContentLength = contentLength;
            this._setInputStreamContentType = (String)inStreamInfo.get(INPUT_STREAM_CONTENT_TYPE);
            byte[] inStreamContentData = (byte[])inStreamInfo.get(INPUT_STREAM_CONTENT_DATA);
            if (inStreamContentData == null) return;
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setInputStreamData", "SetInputStreamData Content Type = " + this._setInputStreamContentType + ", " + "contentLength = " + this._setInputStreamContentLength + ", data length = " + inStreamContentData.length + " : this = " + this);
            }
            ByteArrayInputStream inDataInputStream = new ByteArrayInputStream(inStreamContentData);
            try {
                this._in.init(inDataInputStream);
                if (inStreamContentData.length <= 0) return;
                this._in.setContentLength(inStreamContentData.length);
                return;
            }
            catch (IOException exc) {
                if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) throw exc;
                logger.logp(Level.FINE, CLASS_NAME, "setInputStreamData", "Exception caught : " + exc);
                throw exc;
            }
        } else {
            if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) throw new IllegalArgumentException();
            logger.logp(Level.FINE, CLASS_NAME, "setInputStreamData", "No map passed as input");
            throw new IllegalArgumentException();
        }
    }

    public HashMap getInputStreamData() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "getInputStreamData");
            logger.logp(Level.FINE, CLASS_NAME, "getInputStreamData", "[" + this + "]");
        }
        ServletInputStream in = this.getInputStream();
        HashMap<String, Object> inStreamInfo = new HashMap<String, Object>();
        if (this.getContentType() != null) {
            inStreamInfo.put(INPUT_STREAM_CONTENT_TYPE, new String(this.getContentType()));
        } else {
            inStreamInfo.put(INPUT_STREAM_CONTENT_TYPE, null);
        }
        int offset = 0;
        int inputLen = 0;
        int len = this.getContentLength();
        inStreamInfo.put(INPUT_STREAM_CONTENT_DATA_LENGTH, new Integer(len));
        if (len > 0) {
            byte[] postedBytes = new byte[len];
            do {
                if ((inputLen = in.read(postedBytes, offset, len - offset)) > 0) continue;
                String msg = nls.getString("post.body.contains.less.bytes.than.specified", "post body contains less bytes than specified by content-length");
                throw new IOException(msg);
            } while (len - (offset += inputLen) > 0);
            inStreamInfo.put(INPUT_STREAM_CONTENT_DATA, postedBytes);
        } else {
            inStreamInfo.put(INPUT_STREAM_CONTENT_DATA, null);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getInputStreamData", "ContentType = " + this.getContentType() + ", data length = " + len);
            logger.exiting(CLASS_NAME, "getInputStreamData");
        }
        return inStreamInfo;
    }

    public void setRawParameters(Hashtable params) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setRawParameters", "");
        }
        this._srtRequestHelper._parameters = params;
    }

    public Hashtable getRawParameters() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getRawParameters", "");
        }
        this.parseParameters();
        return (Hashtable)this._srtRequestHelper._parameters;
    }

    public String getParameter(String name) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getParameter", " name --> " + name);
        }
        this.parseParameters();
        String[] values = (String[])this._srtRequestHelper._parameters.get(name);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public Enumeration getParameterNames() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getParameterNames", "");
        }
        this.parseParameters();
        return ((Hashtable)this._srtRequestHelper._parameters).keys();
    }

    public String[] getParameterValues(String name) {
        this.parseParameters();
        String[] values = (String[])this._srtRequestHelper._parameters.get(name);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getParameterValues", " name --> " + name);
        }
        return values;
    }

    public String getPathInfo() {
        String path;
        if (this._srtRequestHelper._pathInfo == null) {
            String aPathInfo = this._dispatchContext.getPathInfo();
            if (aPathInfo == null) {
                return null;
            }
            this._srtRequestHelper._pathInfo = WebGroup.stripURL(aPathInfo, false);
        }
        if ((path = this._srtRequestHelper._pathInfo).equals("")) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getPathInfo", " path is \"\", returning null");
            }
            return null;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getPathInfo", " path --> [" + path + "]");
        }
        return path;
    }

    public String getServletPath() {
        String path = this._dispatchContext.getServletPath();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getServletPath", "path --> " + path);
        }
        return path;
    }

    public String getPathTranslated() {
        String path = this._dispatchContext.getPathTranslated();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getPathTranslated", " --> path " + path);
        }
        return path;
    }

    public String getQueryString() {
        if (this._srtRequestHelper._queryString == null && !this._srtRequestHelper._qsSetExplicit) {
            this._srtRequestHelper._queryString = this._request.getQueryString();
        }
        String queryString = this._srtRequestHelper._queryString;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getQueryString", " queryString --> " + queryString);
        }
        return queryString;
    }

    public void setQueryString(String qs) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setQueryString", " queryString --> " + qs);
        }
        this._srtRequestHelper._qsSetExplicit = true;
        this._srtRequestHelper._queryString = qs;
    }

    public String getRealPath(String path) {
        String realPath = this._dispatchContext.getRealPath(path);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getRealPath", "path -->  " + path + " realPath --> " + realPath);
        }
        return realPath;
    }

    public String getRemoteUser() {
        if (this._dispatchContext.isSecurityEnabledForApplication()) {
            String user = SecurityContext.getName();
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getRemoteUser", " (security enabled)--> user " + user);
            }
            return user;
        }
        String user = this._request.getRemoteUser();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getRemoteUser", " user -->  " + user);
        }
        return user;
    }

    public String getRequestedSessionId() {
        String id = this._dispatchContext.getRequestedSessionId();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getRequestedSessionId", "id --> " + id);
        }
        return id;
    }

    public String getRequestURI() {
        if (this._srtRequestHelper._requestURI == null) {
            String aURI = this.getEncodedRequestURI();
            if (aURI == null) {
                return null;
            }
            this._srtRequestHelper._requestURI = WebGroup.stripURL(aURI);
        }
        String uri = this._srtRequestHelper._requestURI;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getRequestURI", " uri --> " + uri);
        }
        return uri;
    }

    public String getServerName() {
        String sName = this._request.getServerName();
        if (sName == null || sName.length() == 0) {
            try {
                sName = InetAddress.getLocalHost().getHostName();
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "getServerName", "using InetAddress --> " + sName);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (sName.charAt(0) != '[' && sName.indexOf(58) != -1) {
            sName = "[" + sName + "]";
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getServerName", "serverName --> " + sName);
        }
        return sName;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean create) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getSession", "create " + String.valueOf(create));
        }
        return this._requestContext.getSession(create, this._dispatchContext.getWebApp());
    }

    public boolean isRequestedSessionIdFromCookie() {
        boolean idFromCookie = this._dispatchContext.isRequestedSessionIdFromCookie();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "isRequestedSessionIdFromCookie", " " + String.valueOf(idFromCookie));
        }
        return idFromCookie;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromURL() {
        boolean idFromURL = this._dispatchContext.isRequestedSessionIdFromURL();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "isRequestedSessionIdFromURL", " " + String.valueOf(idFromURL));
        }
        return idFromURL;
    }

    public boolean isRequestedSessionIdValid() {
        boolean sessionInvalid = this._requestContext.isRequestedSessionIdValid(this._dispatchContext.getWebApp());
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "isRequestedSessionIdValid", " " + String.valueOf(sessionInvalid));
        }
        return sessionInvalid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void parseParameters() {
        String method;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "parseParameters", "");
        }
        if (this._srtRequestHelper._parameters != null) {
            return;
        }
        try {
            this._srtRequestHelper._parameters = new Hashtable();
            String ct = this.getContentType();
            if (ct != null) {
                ct = ct.toLowerCase();
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "parseParameters", "Content type -->" + ct);
                }
                if (ct.startsWith("java-internal")) {
                    String[] values = new String[]{ct};
                    this._srtRequestHelper._parameters.put(new String("Application specific data. Content-type "), values);
                    return;
                }
            }
        }
        catch (Exception npe) {
            FFDCFilter.processException((Throwable)npe, "com.ibm.ws.webcontainer.srt.SRTServletRequest.parseParameters", "667", this);
            logger.logp(Level.INFO, CLASS_NAME, "parseParameters", "Exception thrown during parsing of parameters", npe.toString());
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "parseParameters", "Content type is not java-internal");
        }
        if ((method = this.getMethod()).equalsIgnoreCase("post")) {
            String contentType = this.getContentType();
            if (contentType != null && contentType.startsWith("application/x-www-form-urlencoded")) {
                try {
                    if (this.getContentLength() > 0) {
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "parseParameters", "parsing post data based upon content length");
                        }
                        this._srtRequestHelper._parameters = RequestUtils.parsePostData(this.getContentLength(), this.getInputStream(), this.getReaderEncoding());
                    } else {
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "parseParameters", "parsing post data based upon input stream (possibly chunked)");
                        }
                        this._srtRequestHelper._parameters = RequestUtils.parsePostData(this.getInputStream(), this.getReaderEncoding());
                    }
                }
                catch (IOException io) {
                    FFDCFilter.processException((Throwable)io, "com.ibm.ws.webcontainer.srt.SRTServletRequest.parseParameters", "765", this);
                    logger.logp(Level.SEVERE, CLASS_NAME, "parseParameters", "Error.Parsing.Parameters", io);
                }
                finally {
                    this.releaseInputStream();
                }
                if (this._srtRequestHelper._parameters != null) {
                    this.parseQueryStringList();
                }
            }
            if (contentType != null && contentType.startsWith("multipart/form-data") && this._srtRequestHelper._parameters != null) {
                this.parseQueryStringList();
            }
            if (this._srtRequestHelper._parameters == null || this._srtRequestHelper._parameters.isEmpty()) {
                this.parseQueryStringList();
            }
        } else {
            this.parseQueryStringList();
        }
        if (this._srtRequestHelper._parameters == null) {
            this._srtRequestHelper._parameters = new Hashtable();
        }
    }

    private void parseQueryStringList() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "parseQueryStringList", "");
        }
        Hashtable tmpQueryParams = null;
        if (this._srtRequestHelper._queryStringList == null || this._srtRequestHelper._queryStringList.isEmpty()) {
            String queryString = this.getQueryString();
            if (queryString != null && queryString.indexOf("=") != -1) {
                if (this._srtRequestHelper._parameters == null || this._srtRequestHelper._parameters.isEmpty()) {
                    this._srtRequestHelper._parameters = RequestUtils.parseQueryString(this.getQueryString(), this.getReaderEncoding());
                } else {
                    tmpQueryParams = RequestUtils.parseQueryString(this.getQueryString(), this.getReaderEncoding());
                    this.mergeQueryParams(tmpQueryParams);
                }
            }
        } else {
            Iterator i = this._srtRequestHelper._queryStringList.iterator();
            QSListItem qsListItem = null;
            while (i.hasNext()) {
                qsListItem = (QSListItem)i.next();
                String queryString = qsListItem._qs;
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "parseQueryStringList", "queryString --> " + queryString);
                }
                if (qsListItem._qsHashtable != null) {
                    this.mergeQueryParams(qsListItem._qsHashtable);
                    continue;
                }
                if (queryString == null || queryString.indexOf(61) == -1) continue;
                if (this._srtRequestHelper._parameters == null || this._srtRequestHelper._parameters.isEmpty()) {
                    qsListItem._qsHashtable = RequestUtils.parseQueryString(queryString, this.getReaderEncoding());
                    this._srtRequestHelper._parameters = qsListItem._qsHashtable;
                    qsListItem._qs = null;
                    continue;
                }
                qsListItem._qsHashtable = tmpQueryParams = RequestUtils.parseQueryString(queryString, this.getReaderEncoding());
                qsListItem._qs = null;
                this.mergeQueryParams(tmpQueryParams);
            }
        }
    }

    private void mergeQueryParams(Hashtable tmpQueryParams) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "mergeQueryParams", "");
        }
        if (tmpQueryParams != null) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "mergeQueryParams", "tmpQueryParams.size() " + tmpQueryParams.size());
                logger.logp(Level.FINE, CLASS_NAME, "mergeQueryParams", "tmpQueryParams " + tmpQueryParams);
            }
            Enumeration enumeration = tmpQueryParams.keys();
            while (enumeration.hasMoreElements()) {
                Object key = enumeration.nextElement();
                if (this._srtRequestHelper._parameters != null && this._srtRequestHelper._parameters.containsKey(key)) {
                    int i;
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "mergeQueryParams", "_paramaters contains key " + key);
                    }
                    String[] postVals = (String[])this._srtRequestHelper._parameters.get(key);
                    String[] queryVals = (String[])tmpQueryParams.get(key);
                    String[] newVals = new String[postVals.length + queryVals.length];
                    int newValsIndex = 0;
                    for (i = 0; i < queryVals.length; ++i) {
                        newVals[newValsIndex++] = queryVals[i];
                    }
                    for (i = 0; i < postVals.length; ++i) {
                        newVals[newValsIndex++] = postVals[i];
                    }
                    this._srtRequestHelper._parameters.put(key, newVals);
                    if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) continue;
                    logger.logp(Level.FINE, CLASS_NAME, "mergeQueryParams", "put key " + key + " into _parameters.");
                    continue;
                }
                if (this._srtRequestHelper._parameters == null) {
                    this._srtRequestHelper._parameters = new Hashtable();
                }
                this._srtRequestHelper._parameters.put(key, tmpQueryParams.get(key));
                if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) continue;
                logger.logp(Level.FINE, CLASS_NAME, "mergeQueryParams", "put key " + key + " into _parameters. ");
            }
        }
    }

    private void removeQueryParams(Hashtable tmpQueryParams) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "removeQueryParams", "");
        }
        if (tmpQueryParams != null) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "removeQueryParams", "tmpQueryParams.size() " + tmpQueryParams.size());
                logger.logp(Level.FINE, CLASS_NAME, "removeQueryParams", "tmpQueryParams " + tmpQueryParams);
            }
            Enumeration enumeration = tmpQueryParams.keys();
            while (enumeration.hasMoreElements()) {
                String[] queryVals;
                String[] postVals;
                Object key = enumeration.nextElement();
                if (!this._srtRequestHelper._parameters.containsKey(key)) continue;
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "removeQueryParams", "_paramaters contains key " + key);
                }
                if ((postVals = (String[])this._srtRequestHelper._parameters.get(key)).length - (queryVals = (String[])tmpQueryParams.get(key)).length > 0) {
                    String[] newVals = new String[postVals.length - queryVals.length];
                    int newValsIndex = 0;
                    for (int i = queryVals.length; i < postVals.length; ++i) {
                        newVals[newValsIndex++] = postVals[i];
                    }
                    this._srtRequestHelper._parameters.put(key, newVals);
                    if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) continue;
                    logger.logp(Level.FINE, CLASS_NAME, "removeQueryParams", "put key " + key + " into _parameters.");
                    continue;
                }
                this._srtRequestHelper._parameters.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "finish", "entry");
        }
        try {
            int length = this.getContentLength();
            if (length > 0) {
                this._in.close();
            } else {
                this._in.finish();
            }
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webcontainer.srt.SRTServletRequest.finish", "875", this);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "finish", "Error occurred while finishing request", e);
            }
        }
        finally {
            this._srtRequestHelper = null;
            this._request.clearHeaders();
            this._request = null;
            this._requestContext.finish();
            if (!this._paramStack.isEmpty()) {
                this._paramStack.clear();
            }
        }
    }

    protected void processLocales() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "processLocales", "entry");
        }
        if (this._srtRequestHelper._localesProcessed) {
            return;
        }
        if (this._srtRequestHelper._locales == null) {
            this._srtRequestHelper._locales = new LinkedList();
        }
        this.setLocales(EncodingUtils.getLocales(this).iterator());
        this._srtRequestHelper._localesProcessed = true;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getRequestDispatcher", " path --> " + path);
        }
        return this._dispatchContext.getRequestDispatcher(path);
    }

    public String getContextPath() {
        String path = this._dispatchContext.getContextPath();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getContextPath", " path --> " + path);
        }
        return path;
    }

    public boolean isUserInRole(String role) {
        boolean userInRole = this._dispatchContext.isUserInRole(role, this);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "isUserInRole", " role --> " + role + " result --> " + String.valueOf(userInRole));
        }
        return userInRole;
    }

    public Principal getUserPrincipal() {
        Principal principal = this._dispatchContext.getUserPrincipal();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getUserPrincipal", " principal --> " + (principal != null ? principal.getName() : ""));
        }
        return principal;
    }

    public void pushParameterStack() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "pushParameterStack", "entry");
        }
        if (this._srtRequestHelper._parameters == null) {
            this._paramStack.push(null);
        } else {
            this._paramStack.push(((Hashtable)this._srtRequestHelper._parameters).clone());
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE) && this._srtRequestHelper._parameters != null) {
            this.debugParams(this._srtRequestHelper._parameters);
        }
    }

    public void popParameterStack() {
        block4: {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "popParameterStack", "entry");
            }
            try {
                this._srtRequestHelper._parameters = (Hashtable)this._paramStack.pop();
            }
            catch (EmptyStackException empty) {
                if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) break block4;
                logger.logp(Level.FINE, CLASS_NAME, "popParameterStack", "Unable to remove item from stack", empty);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE) && this._srtRequestHelper._parameters != null) {
            this.debugParams(this._srtRequestHelper._parameters);
        }
    }

    private void debugParams(Map parameters) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "debugParams", "entry");
        }
        if (parameters != null) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "debugParams", "Only displaying value retrieved by request.getParameter(). More parameters may exist for parameter name");
            }
            for (String paramName : parameters.keySet()) {
                if (this.isSecure() || paramName.toUpperCase().indexOf("PASSWORD") > -1) {
                    if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) continue;
                    logger.logp(Level.FINE, CLASS_NAME, "debugParams", "paramName --> " + paramName + " paramValue [**********]");
                    continue;
                }
                String paramValue = this.getParameter(paramName);
                if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) continue;
                logger.logp(Level.FINE, CLASS_NAME, "debugParams", "paramName --> " + paramName + " paramValue --> " + paramValue);
            }
        }
    }

    public void removeQSFromList() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "removeQSFromList", "entry");
        }
        if (this._srtRequestHelper._queryStringList != null && !this._srtRequestHelper._queryStringList.isEmpty()) {
            Map _tmpParameters = this._srtRequestHelper._parameters;
            this.popParameterStack();
            if (this._srtRequestHelper._parameters == null && _tmpParameters != null) {
                this._srtRequestHelper._parameters = _tmpParameters;
                Hashtable tmpQueryParams = ((QSListItem)((SRTServletRequestHelper)this._srtRequestHelper)._queryStringList.getLast())._qsHashtable;
                if (tmpQueryParams == null) {
                    tmpQueryParams = RequestUtils.parseQueryString(((QSListItem)((SRTServletRequestHelper)this._srtRequestHelper)._queryStringList.getLast())._qs, this.getReaderEncoding());
                }
                this.removeQueryParams(tmpQueryParams);
            }
            this._srtRequestHelper._queryStringList.removeLast();
        } else {
            this.popParameterStack();
        }
    }

    public void aggregateQueryStringParams(String additionalQueryString, boolean setQS) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "aggregateQueryStringParams", "entry qs --> " + additionalQueryString + " set --> " + String.valueOf(setQS));
        }
        QSListItem tmpQS = null;
        if (this._srtRequestHelper._parameters == null) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "aggregateQueryStringParams", "The paramater stack is currently null");
            }
            if (this._srtRequestHelper._queryStringList == null || this._srtRequestHelper._queryStringList.isEmpty()) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "aggregateQueryStringParams", "The queryStringList is empty");
                }
                if (this._srtRequestHelper._queryStringList == null) {
                    this._srtRequestHelper._queryStringList = new LinkedList();
                }
                if (this.getQueryString() != null) {
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "aggregateQueryStringParams", "getQueryString will be added first in the QSList wih value->" + this.getQueryString());
                    }
                    tmpQS = new QSListItem(this.getQueryString(), null);
                    this._srtRequestHelper._queryStringList.add(tmpQS);
                }
            }
            if (additionalQueryString != null) {
                tmpQS = new QSListItem(additionalQueryString, null);
                this._srtRequestHelper._queryStringList.add(tmpQS);
            }
        }
        if (setQS) {
            this.setQueryString(additionalQueryString);
        }
        if (this._srtRequestHelper._parameters != null && additionalQueryString != null) {
            Hashtable parameters = RequestUtils.parseQueryString(additionalQueryString, this.getReaderEncoding());
            Enumeration e = parameters.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String[] newVals = (String[])parameters.get(key);
                if (this._srtRequestHelper._parameters.containsKey(key)) {
                    int i;
                    String[] oldVals = (String[])this._srtRequestHelper._parameters.get(key);
                    Vector<String> v = new Vector<String>();
                    for (i = 0; i < newVals.length; ++i) {
                        v.add(newVals[i]);
                    }
                    for (i = 0; i < oldVals.length; ++i) {
                        v.add(oldVals[i]);
                    }
                    String[] valArray = new String[v.size()];
                    v.toArray(valArray);
                    this._srtRequestHelper._parameters.put(key, valArray);
                    continue;
                }
                this._srtRequestHelper._parameters.put(key, newVals);
            }
        }
    }

    public Map getParameterMap() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getParameterMap", "");
        }
        this.parseParameters();
        return this._srtRequestHelper._parameters;
    }

    public StringBuffer getRequestURL() {
        StringBuffer fullURL = new StringBuffer();
        String scheme = this.getScheme();
        int port = this.getServerPort();
        fullURL.append(scheme);
        fullURL.append("://");
        fullURL.append(this.getServerName());
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            fullURL.append(':');
            fullURL.append(this.getServerPort());
        }
        fullURL.append(this.getEncodedRequestURI());
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getRequestURL", "url --> " + fullURL);
        }
        return fullURL;
    }

    public byte[] getSSLId() {
        byte[] id = this._request.getSSLSessionID();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getSSLId", " id --> " + (id != null ? new String(id) : ""));
        }
        return id;
    }

    public byte[] getCookieValueAsBytes(String cookieName) {
        byte[] cookieValue = this._request.getCookieValue(cookieName);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getCookieValueAsBytes", " name --> " + cookieName + " value --> " + (cookieValue != null ? new String(cookieValue) : ""));
        }
        return cookieValue;
    }

    public List getAllCookieValues(String cookieName) {
        List cookieValues = this._request.getAllCookieValues(cookieName);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getAllCookieValues", " name --> " + cookieName + " values --> " + cookieValues);
        }
        return cookieValues;
    }

    public String getUpdatedSessionId() {
        String id = this._srtRequestHelper._updatedSessionId;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getUpdatedSessionId", " id --> " + id);
        }
        return id;
    }

    public void setSessionId(String id) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setSessionId", " id --> " + id);
        }
        this._srtRequestHelper._updatedSessionId = id;
    }

    public Object getSessionAffinityContext() {
        Object sac = this._srtRequestHelper._sessionAffinityContext;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getSessionAffinityContext", " sac --> " + sac);
        }
        return sac;
    }

    public void setSessionAffinityContext(Object sac) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setSessionAffinityContext", " sac --> " + sac);
        }
        this._srtRequestHelper._sessionAffinityContext = sac;
    }

    public String getEncodedRequestURI() {
        String uri = null;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getEncodedRequestURI", "");
        }
        uri = this._dispatchContext == null ? this._request.getRequestURI() : this._dispatchContext.getRequestURI();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getEncodedRequestURI", " uri --> " + uri);
        }
        return uri;
    }

    public SRTRequestContext getRequestContext() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getRequestContext", "");
        }
        return this._requestContext;
    }

    public boolean getRunningCollaborators() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getRunningCollaborators", " value --> " + String.valueOf(this._runningCollaborators));
        }
        return this._runningCollaborators;
    }

    public void setRunningCollaborators(boolean runningCollaborators) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setRunningCollaborators", " value --> " + String.valueOf(this._runningCollaborators));
        }
        this._runningCollaborators = runningCollaborators;
    }

    public void destroy() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "destroy", " entry");
        }
        this._requestContext.destroy();
        this._requestContext = null;
        this._connContext = null;
        this._dispatchContext = null;
        this._srtRequestHelper = null;
        this._paramStack = null;
        this._in = null;
        this._setInputStreamContentType = null;
        this._setInputStreamContentLength = -1;
        this._setInputDataStreamCalled = false;
        if (this._request instanceof IPoolable) {
            ((IPoolable)((Object)this._request)).destroy();
        }
        this._request = null;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "destroy", " exit");
        }
    }

    protected WSServletInputStream createInputStream() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "createInputStream", " entry");
        }
        return new HttpInputStream();
    }

    public static void main(String[] args) {
        System.out.println(SRTServletRequest.getEncodingFromContentType("text/html;charset='blah';action='dude'", "text/html;charset='blah';action='dude'".indexOf("charset=")));
        System.out.println(SRTServletRequest.getEncodingFromContentType("text/html;charset='blah';action=dude", "text/html;charset='blah';action=dude".indexOf("charset=")));
        System.out.println(SRTServletRequest.getEncodingFromContentType("text/html;charset='blah'", "text/html;charset='blah'".indexOf("charset=")));
        System.out.println(SRTServletRequest.getEncodingFromContentType("text/html;charset=b;action='dude'", "text/html;charset=b;action='dude'".indexOf("charset=")));
        System.out.println(SRTServletRequest.getEncodingFromContentType("text/html;action='dude';charset='blah'", "text/html;action='dude';charset='blah'".indexOf("charset=")));
    }

    public void removeHeader(String header) {
        this._request.removeHeader(header);
    }

    static {
        suppressHeadersInRequest = null;
        suppressheadersList = null;
        CLIENT_ENCODING_OVERRIDE = System.getProperty("client.encoding.override");
        DEFAULT_CLIENT_ENCODING = System.getProperty("default.client.encoding");
        suppressHeadersInRequest = WCCustomProperties.SUPPRESS_HEADERS_IN_REQUEST;
        if (suppressHeadersInRequest != null) {
            String delimiter = ",";
            suppressheadersList = new ArrayList();
            StringTokenizer st = new StringTokenizer(suppressHeadersInRequest, delimiter);
            while (st.hasMoreTokens()) {
                suppressheadersList.add(st.nextToken().trim());
            }
        }
        enableSetCharacterEncodingAfterGetReader = Boolean.valueOf(WebContainer.getWebContainerProperties().getProperty("enablesetcharacterencodingaftergetreader"));
        copyAttributesKeySet = WCCustomProperties.COPY_ATTRIBUTES_KEY_SET;
    }

    class QSListItem {
        String _qs = null;
        Hashtable _qsHashtable = null;

        QSListItem(String qs, Hashtable qsHashtable) {
            this._qs = qs;
            this._qsHashtable = qsHashtable;
        }
    }

    private class SRTServletRequestHelper
    implements Cloneable {
        private Hashtable _privateAttributes = null;
        private LinkedList _queryStringList = null;
        private Map _attributes = new HashMap();
        private Map _parameters = null;
        private String _queryString = null;
        private boolean _cookiesParsed = false;
        private String _updatedSessionId;
        private Object _sessionAffinityContext;
        private Cookie[] _cookies;
        private boolean _localesProcessed = false;
        private String _readerEncoding = null;
        private String _characterEncoding = null;
        private boolean _qsSetExplicit = false;
        private boolean _gotReader = false;
        private boolean _gotInputStream = false;
        private String _requestURI = null;
        private String _pathInfo = null;
        private String _method = null;
        private BufferedReader _reader = null;
        private LinkedList _locales = null;

        private SRTServletRequestHelper() {
        }

        protected Object clone() throws CloneNotSupportedException {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, SRTServletRequest.CLASS_NAME, "clone", "SRTRequestHelper.clone entry");
            }
            SRTServletRequestHelper _clonedHelper = null;
            _clonedHelper = (SRTServletRequestHelper)super.clone();
            if (this._privateAttributes != null) {
                _clonedHelper._privateAttributes = (Hashtable)this._privateAttributes.clone();
            }
            if (this._queryStringList != null) {
                _clonedHelper._queryStringList = (LinkedList)this._queryStringList.clone();
            }
            if (this._parameters != null) {
                _clonedHelper._parameters = (Hashtable)((Hashtable)this._parameters).clone();
            }
            if (this._attributes != null) {
                _clonedHelper._attributes = (HashMap)((HashMap)this._attributes).clone();
            }
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, SRTServletRequest.CLASS_NAME, "clone", "SRTRequestHelper.clone original -->" + this + " cloned -->" + _clonedHelper);
            }
            return _clonedHelper;
        }

        static /* synthetic */ Cookie[] access$1402(SRTServletRequestHelper x0, Cookie[] x1) {
            x0._cookies = x1;
            return x1;
        }
    }
}

