/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.srt;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.util.ByteBufferWriter;
import com.ibm.wsspi.webcontainer.util.IOutputStreamObserver;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;

public class SRTOutputStream
extends ServletOutputStream
implements ByteBufferWriter {
    private OutputStream _conn;
    private IOutputStreamObserver _observer;
    protected static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.srt");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.srt.SRTOutputStream";

    public void init(OutputStream str) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "init", "Initializing");
        }
        this._conn = str;
    }

    public void flush() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "flush", "Flushing");
        }
        this._conn.flush();
    }

    public void reset() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "reset", "Reseting");
        }
        this._conn = null;
    }

    public void close() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "close", "Closing");
        }
        if (this._observer != null) {
            this._observer.alertClose();
        }
        super.close();
    }

    protected void setObserver(IOutputStreamObserver obs) {
        this._observer = obs;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "write", "Writing");
        }
        if (this._observer != null) {
            this._observer.alertFirstWrite();
        }
        this._conn.write(b, off, len);
    }

    public void write(int b) throws IOException {
        byte[] buf = new byte[]{(byte)b};
        this.write(buf, 0, 1);
    }

    public void writeByteBuffer(WsByteBuffer[] buf) {
        ((ByteBufferWriter)((Object)this._conn)).writeByteBuffer(buf);
    }
}

