/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.servlet;

import com.ibm.ws.webcontainer.extension.DefaultExtensionProcessor;
import com.ibm.ws.webcontainer.servlet.FileServletWrapper;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipFileServletWrapper
extends FileServletWrapper {
    private ZipFile zipFile;
    private ZipEntry zipEntry;
    private int contentLength = -1;

    public ZipFileServletWrapper(IServletContext parent, DefaultExtensionProcessor parentProcessor, ZipFile zipFile, ZipEntry zipEntry) {
        super(parent, parentProcessor);
        this.zipFile = zipFile;
        this.zipEntry = zipEntry;
        this.isZip = true;
    }

    public String getServletName() {
        return "Zip File wrapper";
    }

    protected InputStream getInputStream() throws IOException {
        return this.zipFile.getInputStream(this.zipEntry);
    }

    protected long getLastModified() {
        return this.zipEntry.getTime();
    }

    protected int getContentLength() {
        return this.getContentLength(true);
    }

    protected int getContentLength(boolean update) {
        if (update) {
            this.contentLength = (int)this.zipEntry.getSize();
            return this.contentLength;
        }
        if (this.contentLength == -1) {
            this.contentLength = (int)this.zipEntry.getSize();
            return this.contentLength;
        }
        return this.contentLength;
    }

    public void setParent(IServletContext parent) {
    }

    public boolean isAvailable() {
        return new File(this.zipFile.getName()).exists();
    }

    protected RandomAccessFile getRandomAccessFile() throws IOException {
        return null;
    }
}

