/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.servlet;

import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.websphere.servlet.error.ServletErrorReport;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.servlet.TimedServletPool;
import com.ibm.ws.webcontainer.servlet.TimedServletPoolElement;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.GenericServlet;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class SingleThreadModelServlet
extends GenericServlet {
    private static NLS nls = new NLS("com.ibm.ws.webcontainer.resources.Messages");
    private TimedServletPool _pool;
    private Class _servletClass;
    protected static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.servlet");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.servlet.SingleThreadModelServlet";

    public SingleThreadModelServlet() {
    }

    public SingleThreadModelServlet(Class cls) {
        this.setServletClass(cls);
    }

    public void init() throws ServletException {
        try {
            int initialPoolSize = 5;
            long maxIdleTime = 60000L;
            String _initialPoolSize = this.getServletConfig().getServletContext().getInitParameter("singlethreadmodel.initialpoolsize");
            String _maxIdleTime = this.getServletConfig().getServletContext().getInitParameter("singlethreadmodel.maxidletime");
            if (_initialPoolSize != null) {
                try {
                    initialPoolSize = Integer.valueOf(_initialPoolSize);
                }
                catch (NumberFormatException ex) {
                    initialPoolSize = 5;
                    logger.logp(Level.SEVERE, CLASS_NAME, "init", "setting initialPoolSize to default value of 5", ex);
                }
            }
            if (_maxIdleTime != null) {
                try {
                    maxIdleTime = Long.valueOf(_maxIdleTime);
                }
                catch (NumberFormatException ex) {
                    maxIdleTime = 60000L;
                    logger.logp(Level.SEVERE, CLASS_NAME, "init", "setting maxIdleTime to default value of 60000", ex);
                }
            }
            this._pool = this.getTimedServletPool(initialPoolSize, maxIdleTime, this.getServletClass(), this.getServletConfig());
        }
        catch (Throwable th) {
            FFDCFilter.processException(th, "com.ibm.ws.webcontainer.servlet.SingleThreadModelServlet.init", "64", this);
            throw new ServletException(th);
        }
    }

    public void service(ServletRequest req, ServletResponse resp) throws ServletException, IOException {
        try {
            TimedServletPoolElement e = this._pool.getNextElement();
            e.getServlet().service(req, resp);
            this._pool.returnElement(e);
            this._pool.removeExpiredElements();
        }
        catch (Throwable th) {
            FFDCFilter.processException(th, "com.ibm.ws.webcontainer.servlet.SingleThreadModelServlet.service", "84", this);
            throw new ServletErrorReport(th);
        }
    }

    public void destroy() {
        this._pool.removeAllElements();
    }

    public Class getServletClass() {
        return this._servletClass;
    }

    public void setServletClass(Class servletClass) {
        if (!Servlet.class.isAssignableFrom(servletClass)) {
            Object[] args = new Object[]{servletClass};
            throw new IllegalArgumentException(nls.getFormattedMessage("Class.{0}.does.not.implement.servlet", args, "Class " + servletClass + " does not implement servlet"));
        }
        this._servletClass = servletClass;
    }

    public int getInstanceCount() {
        return this._pool.getSize();
    }

    protected TimedServletPool getTimedServletPool(int initialPoolSize, long maxIdleTime, Class servletClass, ServletConfig config2) throws ServletException {
        try {
            return new TimedServletPool(initialPoolSize, maxIdleTime, servletClass, config2);
        }
        catch (Throwable th) {
            FFDCFilter.processException(th, "com.ibm.ws.webcontainer.servlet.SingleThreadModelServlet.getTimedServletPool", "65", this);
            throw new ServletException(th);
        }
    }
}

