/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.filter;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.servlet.error.ServletErrorReport;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.filter.FilterInstanceWrapper;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.wsspi.webcontainer.extension.ExtensionProcessor;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.servlet.IServletWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletResponse;

public class WebAppFilterChain
implements FilterChain {
    private ArrayList _filters = new ArrayList(5);
    private int _currentFilterIndex = -1;
    private int _numberOfFilters = 0;
    private IServletWrapper requestedServlet;
    private ExtensionProcessor requestProcessor;
    private boolean _filtersDefined = false;
    protected static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.filter");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.filter.WebAppFilterChain";
    private WebApp webapp = null;

    public WebAppFilterChain() {
    }

    public WebAppFilterChain(WebApp webapp) {
        this.webapp = webapp;
    }

    protected void _doFilter(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "_doFilter");
        }
        this.doFilter(request, response);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "_doFilter");
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "doFilter");
        }
        try {
            if (!this._filtersDefined) {
                if (this.requestedServlet == null) {
                    if (this.requestProcessor != null) {
                        this.requestProcessor.handleRequest(request, response);
                    }
                    return;
                }
                this.requestedServlet.service(request, response);
            } else {
                ++this._currentFilterIndex;
                if (this._currentFilterIndex < this._numberOfFilters) {
                    FilterInstanceWrapper wrapper = (FilterInstanceWrapper)this._filters.get(this._currentFilterIndex);
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "doFilter", "executing filter -->" + wrapper.getFilterName());
                    }
                    wrapper.doFilter(request, response, this);
                } else {
                    if (this.requestedServlet == null) {
                        if (this.requestProcessor != null) {
                            this.requestProcessor.handleRequest(request, response);
                        } else {
                            ((HttpServletResponse)response).sendError(404);
                        }
                        return;
                    }
                    this.requestedServlet.service(request, response);
                }
            }
        }
        catch (UnavailableException e) {
            throw e;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (ServletException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webcontainer.filter.WebAppFilterChain.doFilter", "82", this);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.exiting(CLASS_NAME, "doFilter");
            }
            throw e;
        }
        catch (Throwable th) {
            FFDCFilter.processException(th, "com.ibm.ws.webcontainer.filter.WebAppFilterChain.doFilter", "89", this);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.exiting(CLASS_NAME, "doFilter");
            }
            throw new ServletErrorReport(th);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "doFilter");
        }
    }

    public void addFilter(FilterInstanceWrapper fiw) {
        this._filtersDefined = true;
        ++this._numberOfFilters;
        this._filters.add(fiw);
    }

    public void setRequestedServlet(IServletWrapper requestedServlet) {
        this.requestedServlet = requestedServlet;
    }

    public void setExtensionProcessor(ExtensionProcessor requestProcessor) {
        this.requestProcessor = requestProcessor;
    }
}

