/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.filter;

import com.ibm.websphere.servlet.event.FilterErrorEvent;
import com.ibm.websphere.servlet.event.FilterEvent;
import com.ibm.websphere.servlet.event.FilterInvocationEvent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.webapp.WebAppEventSource;
import com.ibm.wsspi.webcontainer.filter.IFilterConfig;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class FilterInstanceWrapper {
    public static final int FILTER_STATE_UNINITIALIZED = 0;
    public static final int FILTER_STATE_INITIALIZING = 1;
    public static final int FILTER_STATE_AVAILABLE = 2;
    public static final int FILTER_STATE_DESTROYING = 3;
    public static final int FILTER_STATE_DESTROYED = 4;
    public static final int FILTER_STATE_UNAVAILABLE = 5;
    private String _filterName;
    private Filter _filterInstance;
    private int _filterState = 0;
    private volatile int nServicing = 0;
    protected static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.filter");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.filter.FilterInstanceWrapper";
    private FilterEvent _filterEvent;
    private IFilterConfig _filterConfig;
    private WebAppEventSource _eventSource;

    public FilterInstanceWrapper(String filterName, Filter filterInstance, WebAppEventSource eventSource) {
        this._filterName = filterName;
        this._filterInstance = filterInstance;
        this._eventSource = eventSource;
    }

    public String getFilterName() {
        return this._filterName;
    }

    public Filter getFilterInstance() {
        return this._filterInstance;
    }

    public int getFilterState() {
        return this._filterState;
    }

    public void init(IFilterConfig filterConfig) throws ServletException {
        try {
            this._filterState = 1;
            this._filterConfig = filterConfig;
            if (this._eventSource != null && this._eventSource.hasFilterListeners()) {
                this._eventSource.onFilterStartInit(this.getFilterEvent());
                this._filterInstance.init(filterConfig);
                this._eventSource.onFilterFinishInit(this.getFilterEvent());
            } else {
                this._filterInstance.init(filterConfig);
            }
            this._filterState = 2;
        }
        catch (Throwable th) {
            if (this._eventSource != null && this._eventSource.hasFilterErrorListeners()) {
                FilterErrorEvent errorEvent = this.getFilterErrorEvent(th);
                this._eventSource.onFilterInitError(errorEvent);
            }
            FFDCFilter.processException(th, "com.ibm.ws.webcontainer.filter.FilterInstanceWrapper.init", "111", this);
            this._filterState = 5;
            throw new ServletException(MessageFormat.format("Filter [{0}]: could not be initialized", this._filterName), th);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException {
        block23: {
            try {
                if (this._filterState == 2) {
                    FilterInstanceWrapper filterInstanceWrapper = this;
                    synchronized (filterInstanceWrapper) {
                        ++this.nServicing;
                    }
                    try {
                        if (this._eventSource != null && this._eventSource.hasFilterInvocationListeners()) {
                            FilterInvocationEvent event = this.getFilterInvocationEvent(request);
                            this._eventSource.onFilterStartDoFilter(event);
                            this._filterInstance.doFilter(request, response, chain);
                            this._eventSource.onFilterFinishDoFilter(event);
                        } else {
                            this._filterInstance.doFilter(request, response, chain);
                        }
                        break block23;
                    }
                    catch (ServletException se) {
                        throw se;
                    }
                    catch (Throwable th) {
                        throw th;
                    }
                    finally {
                        FilterInstanceWrapper filterInstanceWrapper2 = this;
                        synchronized (filterInstanceWrapper2) {
                            --this.nServicing;
                        }
                    }
                }
                throw new ServletException(MessageFormat.format("Filter [{0}]: filter is unavailable.", this._filterName));
            }
            catch (ServletException se) {
                if (this._eventSource != null && this._eventSource.hasFilterErrorListeners()) {
                    FilterErrorEvent errorEvent = this.getFilterErrorEvent(se);
                    this._eventSource.onFilterDoFilterError(errorEvent);
                }
                FFDCFilter.processException((Throwable)se, "com.ibm.ws.webcontainer.filter.FilterInstanceWrapper.doFilter", "144", this);
                throw se;
            }
            catch (Throwable th) {
                if (this._eventSource != null && this._eventSource.hasFilterErrorListeners()) {
                    FilterErrorEvent errorEvent = this.getFilterErrorEvent(th);
                    this._eventSource.onFilterDoFilterError(errorEvent);
                }
                FFDCFilter.processException(th, "com.ibm.ws.webcontainer.filter.FilterInstanceWrapper.doFilter", "149", this);
                throw new ServletException(MessageFormat.format("Filter [{0}]: filter is unavailable.", this._filterName), th);
            }
        }
    }

    public void destroy() throws ServletException {
        try {
            this._filterState = 3;
            for (int i = 0; this.nServicing > 0 && i < 60; ++i) {
                try {
                    if (i == 0) {
                        logger.logp(Level.INFO, CLASS_NAME, "destroy", "waiting.to.destroy.filter.[{0}]", this._filterName);
                    }
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.webcontainer.servlet.ServletInstance.destroy", "377", this);
                }
            }
            if (this._eventSource != null && this._eventSource.hasFilterListeners()) {
                this._eventSource.onFilterStartDestroy(this.getFilterEvent());
                this._filterInstance.destroy();
                this._eventSource.onFilterFinishDestroy(this.getFilterEvent());
            } else {
                this._filterInstance.destroy();
            }
            this._filterState = 4;
        }
        catch (Throwable th) {
            if (this._eventSource != null && this._eventSource.hasFilterErrorListeners()) {
                FilterErrorEvent errorEvent = this.getFilterErrorEvent(th);
                this._eventSource.onFilterDestroyError(errorEvent);
            }
            FFDCFilter.processException(th, "com.ibm.ws.webcontainer.filter.FilterInstanceWrapper.destroy", "173", this);
            this._filterState = 5;
            throw new ServletException(MessageFormat.format("Filter [{0}]: could not be destroyed", this._filterName), th);
        }
    }

    private FilterEvent getFilterEvent() {
        if (this._filterEvent != null) {
            return this._filterEvent;
        }
        this._filterEvent = new FilterEvent(this, this._filterConfig);
        return this._filterEvent;
    }

    private FilterInvocationEvent getFilterInvocationEvent(ServletRequest req) {
        return new FilterInvocationEvent(this, this._filterConfig, req);
    }

    private FilterErrorEvent getFilterErrorEvent(Throwable error) {
        return new FilterErrorEvent(this, this._filterConfig, error);
    }
}

