/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util.config;

import com.ibm.ws.util.config.ConfigParams;
import java.io.File;
import java.lang.reflect.Method;

public class ConfigInstance {
    static final String create = "-create";
    static final String delete = "-delete";
    static final String host = "-host";
    static final String startPort = "-startingPort";
    static final String name = "-name";
    static final String path = "-path";
    static final String mqPath = "-mqpath";
    static final String embdpath = "-embeddedPath";
    static final String remote = "-remote";
    static String buildFile = "instance.xml";
    static String[] newArgs = new String[]{"-buildfile", "instance.xml", "create", "-quiet"};

    public static void main(String[] args) {
        ConfigParams p;
        if (args.length < 2) {
            ConfigInstance.usage();
        }
        if ((p = ConfigInstance.processArgs(args)) != null) {
            if (p.action == null || p.hostName == null) {
                ConfigInstance.usage();
                return;
            }
            ConfigInstance.runAnt(p);
        }
    }

    static ConfigParams processArgs(String[] args) {
        try {
            ConfigParams pr = new ConfigParams();
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equalsIgnoreCase(create)) {
                    pr.action = "create";
                    continue;
                }
                if (args[i].equalsIgnoreCase(delete)) {
                    pr.action = "delete";
                    continue;
                }
                if (args[i].equalsIgnoreCase(host)) {
                    pr.hostName = args[i + 1];
                    continue;
                }
                if (args[i].equalsIgnoreCase(startPort)) {
                    pr.startPort = args[i + 1];
                    continue;
                }
                if (args[i].equalsIgnoreCase(name)) {
                    pr.instanceName = args[i + 1];
                    continue;
                }
                if (args[i].equalsIgnoreCase(path)) {
                    pr.instancePath = args[i + 1];
                    continue;
                }
                if (args[i].equalsIgnoreCase(embdpath)) {
                    pr.embeddedLocation = args[i + 1];
                    continue;
                }
                if (args[i].equalsIgnoreCase(mqPath)) {
                    pr.mqLocation = args[i + 1];
                    continue;
                }
                if (args[i].equalsIgnoreCase(remote)) {
                    pr.remote = "true";
                    continue;
                }
                if (args[i].equalsIgnoreCase("-buildfile")) {
                    buildFile = args[i + 1];
                    ConfigInstance.newArgs[1] = args[i + 1];
                    continue;
                }
                if (!args[i].equalsIgnoreCase("-debug")) continue;
                ConfigInstance.newArgs[3] = "-debug";
            }
            return pr;
        }
        catch (Throwable th) {
            ConfigInstance.usage();
            System.exit(0);
            return null;
        }
    }

    static void runAnt(ConfigParams p) {
        try {
            String wasroot = System.getProperty("was.root");
            if (wasroot != null) {
                File wasrootFile = new File(wasroot);
                String canPath = wasrootFile.getCanonicalPath();
                System.setProperty("was.root", canPath);
                System.setProperty("was.root.forwardslashes", canPath.replace('\\', '/'));
            }
            System.setProperty("new.host.name", p.hostName);
            System.setProperty("instance.name", p.instanceName);
            System.setProperty("new.instance.root", p.instancePath);
            if (p.startPort != null) {
                System.setProperty("start.port", p.startPort);
            }
            if (p.embeddedLocation != null) {
                System.setProperty("embed.location", p.embeddedLocation);
            }
            if (p.mqLocation != null) {
                System.setProperty("mq.location", p.mqLocation);
            }
            if (p.remote != null) {
                System.setProperty("remote", p.remote);
            }
            ConfigInstance.newArgs[2] = p.action;
            Class<?> mainClass = Class.forName("org.apache.tools.ant.Main");
            Method main = mainClass.getMethod("main", String[].class);
            Object ret = main.invoke(null, new Object[]{newArgs});
        }
        catch (Throwable ex) {
            ConfigInstance.usage();
            System.exit(0);
        }
    }

    static void usage() {
        System.out.println("Usage:");
        System.out.println("wsinstance.bat(sh) -name instanceName -path instancePath -host hostName [-remote] [-startingPort startingPort] -create|-delete  [-debug]");
    }
}

