/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.ws.util.ThreadPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSThreadLocal<T>
extends ThreadLocal<T> {
    private static TraceComponent tc = Tr.register(WSThreadLocal.class, "Runtime", "com.ibm.ws.runtime.runtime");
    private static int count = 0;
    private int index;
    private static final int SUSPECTED_MISUSAGE_THRESHOLD = 200;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WSThreadLocal() {
        Class<WSThreadLocal> clazz = WSThreadLocal.class;
        synchronized (WSThreadLocal.class) {
            this.index = count++;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (count % 200 == 0) {
                Exception e = new Exception("WSThreadLocal: instance count = " + count + " ; potential memory leak; verify usage.");
                Manager.Ffdc.log(e, this, this.getClass().getName(), "50", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WSThreadLocal", e);
                }
            }
            return;
        }
    }

    @Override
    public T get() {
        Thread thread = Thread.currentThread();
        if (thread instanceof ThreadPool.Worker) {
            Object[] wsLocals = this.getThreadLocals((ThreadPool.Worker)thread);
            if (wsLocals[this.index] == null) {
                wsLocals[this.index] = this.initialValue();
            }
            return (T)wsLocals[this.index];
        }
        return super.get();
    }

    @Override
    public void set(T value) {
        Thread thread = Thread.currentThread();
        if (thread instanceof ThreadPool.Worker) {
            Object[] wsLocals = this.getThreadLocals((ThreadPool.Worker)thread);
            wsLocals[this.index] = value;
        } else {
            super.set(value);
        }
    }

    @Override
    public void remove() {
        Thread thread = Thread.currentThread();
        if (thread instanceof ThreadPool.Worker) {
            Object[] wsLocals = this.getThreadLocals((ThreadPool.Worker)thread);
            wsLocals[this.index] = null;
        } else {
            super.remove();
        }
    }

    private Object[] getThreadLocals(ThreadPool.Worker worker) {
        Object[] locals = worker.wsThreadLocals;
        int curCount = count;
        if (locals.length != curCount) {
            Object[] newLocals = new Object[curCount];
            System.arraycopy(locals, 0, newLocals, 0, locals.length);
            locals = newLocals;
            worker.wsThreadLocals = locals;
        }
        return locals;
    }
}

