/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.lang.reflect.Field;

public abstract class ThreadContextAccessor {
    private static final TraceComponent tc = Tr.register(ThreadContextAccessor.class, "Runtime", null);
    private static ThreadContextAccessor threadContextAccessor;

    public abstract boolean isPrivileged();

    public abstract ClassLoader getContextClassLoader(Thread var1);

    public abstract void setContextClassLoader(Thread var1, ClassLoader var2);

    public static ThreadContextAccessor getThreadContextAccessor() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("getClassLoader"));
            sm.checkPermission(new RuntimePermission("setContextClassLoader"));
        }
        return threadContextAccessor;
    }

    static {
        try {
            Field field = Thread.class.getDeclaredField("contextClassLoader");
            field.setAccessible(true);
            threadContextAccessor = new ReflectionThreadContextAccessorImpl(field);
        }
        catch (Exception ex) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "exception", ex);
            }
            threadContextAccessor = new ThreadContextAccessorImpl();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "using " + threadContextAccessor);
        }
    }

    static class ReflectionThreadContextAccessorImpl
    extends ThreadContextAccessor {
        private Field field;

        public ReflectionThreadContextAccessorImpl(Field field) {
            this.field = field;
        }

        public boolean isPrivileged() {
            return true;
        }

        public ClassLoader getContextClassLoader(Thread thread) {
            if (System.getSecurityManager() == null) {
                return thread.getContextClassLoader();
            }
            try {
                return (ClassLoader)this.field.get(thread);
            }
            catch (IllegalAccessException ex) {
                IllegalStateException ex2 = new IllegalStateException(ex.getMessage());
                ex2.initCause(ex);
                throw ex2;
            }
        }

        public void setContextClassLoader(Thread thread, ClassLoader loader) {
            if (System.getSecurityManager() == null) {
                thread.setContextClassLoader(loader);
            } else {
                try {
                    this.field.set(thread, loader);
                }
                catch (IllegalAccessException ex) {
                    IllegalStateException ex2 = new IllegalStateException(ex.getMessage());
                    ex2.initCause(ex);
                    throw ex2;
                }
            }
        }
    }

    static class ThreadContextAccessorImpl
    extends ThreadContextAccessor {
        ThreadContextAccessorImpl() {
        }

        public boolean isPrivileged() {
            return System.getSecurityManager() == null;
        }

        public ClassLoader getContextClassLoader(Thread thread) {
            return thread.getContextClassLoader();
        }

        public void setContextClassLoader(Thread thread, ClassLoader loader) {
            thread.setContextClassLoader(loader);
        }
    }
}

