/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import com.ibm.ws.http.HttpTransport;
import com.ibm.ws.util.CaptureServerSocket;
import com.ibm.ws.util.DebugServerSocket;
import com.ibm.ws.util.ReplayServerSocket;
import java.io.File;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.Arrays;
import java.util.Properties;

public class ServerSocketFactory {
    private static String SOCKET_MODE = "socketMode";
    private static String NORMAL = "normal";
    private static String TRACE = "trace";
    private static String CAPTURE = "capture";
    private static String REPLAY = "replay";
    private static String CAPTURE_FILE = "captureFile";
    private static String MAX_INTERVALS = "maxIntervals";
    private static String MAX_ITERATIONS = "maxIterations";

    public static ServerSocket getInstance(int port, int maxBacklog, InetAddress inetAddr, HttpTransport transport, Properties props) throws Exception {
        String mode = props.getProperty(SOCKET_MODE);
        if (mode == null) {
            throw new Exception(SOCKET_MODE + " not specified");
        }
        if (mode.equalsIgnoreCase(NORMAL)) {
            return new ServerSocket(port, maxBacklog, inetAddr);
        }
        if (mode.equalsIgnoreCase(TRACE)) {
            return new DebugServerSocket(port, maxBacklog, inetAddr);
        }
        if (mode.equalsIgnoreCase(CAPTURE) || mode.equalsIgnoreCase(REPLAY)) {
            String captureFile = props.getProperty(CAPTURE_FILE);
            if (captureFile == null) {
                throw new Exception(CAPTURE_FILE + " not specified");
            }
            captureFile = captureFile.replace('/', File.separatorChar);
            if (mode.equalsIgnoreCase(CAPTURE)) {
                return new CaptureServerSocket(port, maxBacklog, inetAddr, captureFile, true);
            }
            String maxIterations = props.getProperty(MAX_ITERATIONS);
            if (maxIterations == null) {
                throw new Exception(MAX_ITERATIONS + " not specified");
            }
            String maxIntervals = props.getProperty(MAX_INTERVALS);
            if (maxIntervals == null) {
                maxIntervals = "3";
            }
            int[] maxIters = new int[Integer.parseInt(maxIntervals)];
            Arrays.fill(maxIters, Integer.parseInt(maxIterations));
            return new ReplayServerSocket(transport, captureFile, maxIters);
        }
        throw new Exception("invalid " + SOCKET_MODE);
    }
}

