/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class PathUtils {
    private static TraceComponent tc = Tr.register(PathUtils.class, "Runtime", "com.ibm.ws.runtime.runtime");

    public static String arrayToString(String[] strings) {
        String resultStr = null;
        if (strings != null) {
            StringBuffer sb = new StringBuffer();
            int strlen = strings.length;
            for (int i = 0; i < strlen; ++i) {
                sb.append(strings[i]);
                sb.append(File.pathSeparatorChar);
            }
            resultStr = sb.toString();
        }
        return resultStr;
    }

    public static boolean listAddNoDup(List list, Object obj) {
        boolean isAdded = false;
        if (!list.contains(obj)) {
            list.add(obj);
            isAdded = true;
        }
        return isAdded;
    }

    public static String[] expandPaths(String[] dirs) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "expandPaths", PathUtils.arrayToString(dirs));
        }
        boolean debugEnabled = tc.isDebugEnabled();
        ArrayList appList = new ArrayList();
        for (int i = 0; i < dirs.length; ++i) {
            File appDir;
            if (debugEnabled) {
                Tr.debug(tc, "resolving paths for " + dirs[i]);
            }
            if (PathUtils.listAddNoDup(appList, (appDir = new File(dirs[i])).getPath()) && debugEnabled) {
                Tr.debug(tc, "adding path " + appDir.getPath());
            }
            if (!appDir.isDirectory()) continue;
            File[] files = appDir.listFiles();
            if (files != null) {
                for (int j = 0; j < files.length; ++j) {
                    String fileName = files[j].getName().toLowerCase();
                    if (!fileName.endsWith(".zip") && !fileName.endsWith(".jar") || !PathUtils.listAddNoDup(appList, files[j].getPath()) || !debugEnabled) continue;
                    Tr.debug(tc, "adding path " + files[j].getPath());
                }
                continue;
            }
            Tr.error(tc, "WSVR0330E", appDir);
        }
        String[] appFiles = new String[appList.size()];
        appFiles = appList.toArray(appFiles);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "expandPaths", PathUtils.arrayToString(appFiles));
        }
        return appFiles;
    }
}

