/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.ws.bootstrap.WSLauncher;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import java.io.IOException;
import java.net.URL;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ImplFactory {
    private static TraceComponent tc = Tr.register(ImplFactory.class, "Runtime", "com.ibm.ws.runtime.runtime");
    private static final String IF_PLUGIN_PATH = "META-INF/impl-factory.xml";
    private static Map _map;
    private static boolean _inEclipseEnvironment;
    static final String DISTRIBUTED = "distributed";
    static final String ZSERIES = "zos";
    static final String ISERIES = "os400";
    static final String ALL = "all";
    static final String PLATFORM = "platform";
    private static String actualPlatformString;

    private static boolean equivalent(String implName, Object o) {
        if (o instanceof IConfigurationElement) {
            return implName.equals(((IConfigurationElement)o).getAttribute("impl"));
        }
        if (o instanceof String) {
            return o.equals(implName);
        }
        return false;
    }

    private static List parseExtensionPoint(List plugins) {
        _inEclipseEnvironment = ExtensionRegistryFactory.instance().isEclipse();
        IExtensionRegistry registry = ExtensionRegistryFactory.instance().getExtensionRegistry();
        if (registry == null) {
            return plugins;
        }
        String epid = ExtensionRegistryFactory.instance().getDefaultPluginID() + ".impl-factory";
        IExtensionPoint extensionPoint = registry.getExtensionPoint(epid);
        if (extensionPoint == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "extension point: " + epid + " is null");
            }
            return plugins;
        }
        IExtension[] extensions = extensionPoint.getExtensions();
        for (int i = 0; i < extensions.length; ++i) {
            IExtension extension = extensions[i];
            IConfigurationElement[] factories = extension.getConfigurationElements();
            for (int k = 0; k < factories.length; ++k) {
                if (!factories[k].getName().equals("factories")) continue;
                FactoryList factoryList = new FactoryList();
                IConfigurationElement[] elements = factories[k].getChildren();
                for (int j = 0; j < elements.length; ++j) {
                    IConfigurationElement element = elements[j];
                    String elementName = element.getName();
                    if (elementName.equals("rank")) {
                        String value = element.getAttribute("value");
                        try {
                            factoryList.rank = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            Manager.Ffdc.log(e, ImplFactory.class, "com.ibm.ws.util.ImplFactory.parseExtensionPoint", "229");
                            if (!tc.isEventEnabled()) continue;
                            Tr.event(tc, "Problem converting rank to number: " + value, e);
                        }
                        continue;
                    }
                    if (elementName.equals("factory")) {
                        if (!ImplFactoryParsingHandler.validOn(element.getAttribute(PLATFORM))) continue;
                        Factory factory = new Factory();
                        factory.interfaceName = element.getAttribute("interface");
                        factory.implName = element.getAttribute("impl");
                        factory.configElement = element;
                        if (factory.interfaceName == null) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "interface is null");
                            continue;
                        }
                        if (factory.implName == null) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "implementation is null");
                            continue;
                        }
                        String override = element.getAttribute("override");
                        factory.isOverride = override != null && override.equalsIgnoreCase("true");
                        factoryList.factories.add(factory);
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "expecting <rank> or <factory>, but got <" + elementName + ">");
                }
                plugins.add(factoryList);
            }
        }
        return plugins;
    }

    private static List parseLegacyXmlFile(List plugins) throws Exception {
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        Enumeration<URL> pluginUrls = classloader.getResources(IF_PLUGIN_PATH);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        XMLReader xmlReader = factory.newSAXParser().getXMLReader();
        ImplFactoryParsingHandler handler = new ImplFactoryParsingHandler();
        xmlReader.setContentHandler(handler);
        xmlReader.setDTDHandler(handler);
        xmlReader.setEntityResolver(handler);
        xmlReader.setErrorHandler(handler);
        while (pluginUrls.hasMoreElements()) {
            URL url = pluginUrls.nextElement();
            try {
                xmlReader.parse(new InputSource(url.openStream()));
                FactoryList factoryList = new FactoryList();
                factoryList.rank = handler.rank;
                factoryList.factories.addAll(handler.getFactories());
                plugins.add(factoryList);
            }
            catch (Exception ex) {
                Manager.Ffdc.log(ex, ImplFactory.class, "com.ibm.ws.util.ImplFactory.parseLegacyXmlFile", "308");
                if (!tc.isEventEnabled()) continue;
                Tr.event(tc, "Exception caught parsing " + url, ex);
            }
        }
        return plugins;
    }

    public static Object loadImplFromKey(String implKey) {
        Class c = ImplFactory.loadClassFromKey(implKey);
        return ImplFactory.loadImplFromClass(c);
    }

    public static Object loadImplFromKey(Class interfaceClass) {
        return ImplFactory.loadImplFromKey(interfaceClass.getName());
    }

    public static Object loadImplFromClass(String classname) {
        try {
            Class aClass = ImplFactory.loadClass(classname);
            return ImplFactory.loadImplFromClass(aClass);
        }
        catch (ClassNotFoundException e) {
            Manager.Ffdc.log(e, ImplFactory.class, "com.ibm.ws.util.ImplFactory.loadImplFromClass", "334");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "ClassNotFoundException caught loading class " + classname, e);
            }
            throw new IllegalStateException(e);
        }
    }

    public static Object loadImplFromClass(Class c) {
        try {
            return c.newInstance();
        }
        catch (Throwable th) {
            Manager.Ffdc.log(th, ImplFactory.class, "com.ibm.ws.util.ImplFactory.loadImplFromClass", "345");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Exception caught creating new instance of " + c, th);
            }
            throw new IllegalStateException(th);
        }
    }

    public static Class loadClassFromKey(Class interfaceClass) {
        return ImplFactory.loadClassFromKey(interfaceClass.getName());
    }

    public static Class loadClassFromKey(String implKey) {
        Object factoriesElement = _map.get(implKey);
        Class loadedClass = null;
        if (factoriesElement == null) {
            throw new NoClassDefFoundError("Invalid Implementation Key, " + implKey);
        }
        try {
            loadedClass = ImplFactory.loadClass(factoriesElement);
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, ImplFactory.class, "com.ibm.ws.util.ImplFactory.loadClassFromKey", "377");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Exception caught loading class for key " + implKey, e);
            }
            throw new IllegalStateException(e);
        }
        return loadedClass;
    }

    private static Class loadClass(String className) throws ClassNotFoundException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            return cl.loadClass(className);
        }
        catch (ClassNotFoundException cnfe) {
            try {
                return ImplFactory.class.getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException cnfe2) {
                Manager.Ffdc.log(cnfe2, ImplFactory.class, "com.ibm.ws.util.ImplFactory.loadClass", "581");
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "ClassNotFoundException caught loading class " + className, cnfe2);
                }
                throw cnfe;
            }
        }
    }

    private static Class loadClass(Object configElement) throws ClassNotFoundException {
        if (configElement instanceof IConfigurationElement) {
            IConfigurationElement ce = (IConfigurationElement)configElement;
            final String className = ce.getAttribute("impl");
            if (_inEclipseEnvironment) {
                try {
                    String id = ce.getNamespace();
                    final Bundle bundle = Platform.getBundle(id);
                    return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws ClassNotFoundException {
                            return bundle.loadClass(className);
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    Manager.Ffdc.log(pae, ImplFactory.class, "com.ibm.ws.util.ImplFactory.loadClass", "610");
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Exception caught loading class " + className, pae);
                    }
                    if (pae.getCause() instanceof ClassNotFoundException) {
                        throw (ClassNotFoundException)pae.getCause();
                    }
                    throw new ClassNotFoundException(className, pae);
                }
            }
            try {
                Object o = ((IConfigurationElement)configElement).createExecutableExtension("impl");
                return o.getClass();
            }
            catch (Throwable t) {
                try {
                    Class c = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws ClassNotFoundException {
                            return Thread.currentThread().getContextClassLoader().loadClass(className);
                        }
                    });
                    return c;
                }
                catch (Throwable t2) {
                    throw new ClassNotFoundException(className, t);
                }
            }
        }
        return ImplFactory.loadClass((String)configElement);
    }

    static {
        actualPlatformString = null;
        try {
            FactoryList plugin;
            int i;
            _map = new HashMap();
            List plugins = (List)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException, ParserConfigurationException, SAXException, Exception {
                    ArrayList plugins = new ArrayList();
                    ImplFactory.parseExtensionPoint(plugins);
                    ImplFactory.parseLegacyXmlFile(plugins);
                    return plugins;
                }
            });
            Collections.sort(plugins, new RankComparator());
            int N = plugins.size();
            for (i = 0; i < N; ++i) {
                plugin = (FactoryList)plugins.get(i);
                int M = plugin.factories.size();
                for (int j = 0; j < M; ++j) {
                    Factory factory = (Factory)plugin.factories.get(j);
                    if (!_map.containsKey(factory.interfaceName)) {
                        if (factory.isOverride) {
                            Tr.warning(tc, "WSVR0071W", new Object[]{factory.interfaceName, factory.implName});
                        }
                        if (factory.configElement != null) {
                            _map.put(factory.interfaceName, factory.configElement);
                            continue;
                        }
                        _map.put(factory.interfaceName, factory.implName);
                        continue;
                    }
                    if (factory.isOverride) {
                        if (factory.configElement != null) {
                            _map.put(factory.interfaceName, factory.configElement);
                            continue;
                        }
                        _map.put(factory.interfaceName, factory.implName);
                        continue;
                    }
                    if (ImplFactory.equivalent(factory.implName, _map.get(factory.interfaceName))) continue;
                    Tr.warning(tc, "WSVR0072W", new Object[]{factory.interfaceName, factory.implName});
                }
            }
            N = plugins.size();
            for (i = 0; i < N; ++i) {
                plugin = (FactoryList)plugins.get(i);
                plugin.factories.clear();
            }
            plugins.clear();
        }
        catch (Throwable th) {
            Manager.Ffdc.log(th, ImplFactory.class, "com.ibm.ws.util.ImplFactory.<clinit>", "170");
            Tr.warning(tc, "WSVR0073W", IF_PLUGIN_PATH);
            throw new IllegalStateException(th);
        }
    }

    private static class RankComparator
    implements Comparator {
        private RankComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            FactoryList factoryList1 = (FactoryList)obj1;
            FactoryList factoryList2 = (FactoryList)obj2;
            return factoryList1.rank - factoryList2.rank;
        }
    }

    private static class ImplFactoryParsingHandler
    extends DefaultHandler {
        Locator locator;
        int rank = 0;
        List factories = new ArrayList();
        Factory factory;
        StringBuffer value = new StringBuffer();

        public List getFactories() {
            return this.factories;
        }

        public void startDocument() throws SAXException {
            this.factories.clear();
        }

        public void endDocument() throws SAXException {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.value.setLength(0);
            if (!qName.equals("factories")) {
                if (qName.equals("factory")) {
                    this.factory = new Factory();
                    this.factory.isOverride = false;
                    int attrLen = attributes.getLength();
                    for (int i = 0; i < attrLen; ++i) {
                        String attrQName = attributes.getQName(i);
                        String attrValue = attributes.getValue(i);
                        if (attrQName.equals("interface")) {
                            this.factory.interfaceName = attrValue;
                            continue;
                        }
                        if (attrQName.equals("impl")) {
                            this.factory.implName = attrValue;
                            continue;
                        }
                        if (attrQName.equals("override")) {
                            this.factory.isOverride = attrValue != null && attrValue.equalsIgnoreCase("true");
                            continue;
                        }
                        if (attrQName.equals(ImplFactory.PLATFORM)) {
                            this.factory.platforms = attrValue;
                            continue;
                        }
                        throw new SAXParseException("Invalid attribute: " + attrQName, this.locator);
                    }
                } else if (!qName.equals("rank")) {
                    throw new SAXParseException("Invalid tag: " + qName, this.locator);
                }
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals("rank")) {
                try {
                    this.rank = Integer.parseInt(this.value.toString());
                }
                catch (NumberFormatException nfe) {
                    throw new SAXParseException("Problem converting rank to number: " + this.value.toString(), this.locator);
                }
            } else if (qName.equals("factory") && this.factory != null) {
                if (ImplFactoryParsingHandler.validOn(this.factory.platforms)) {
                    this.factories.add(this.factory);
                } else {
                    this.factory = null;
                }
            }
            this.value.setLength(0);
        }

        public void warning(SAXParseException spe) throws SAXException {
            this.factory = null;
        }

        public void error(SAXParseException spe) throws SAXException {
            this.factory = null;
        }

        public void fatalError(SAXParseException spe) throws SAXException {
            this.factories.clear();
            this.factory = null;
            throw spe;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.value.append(ch, start, length);
        }

        public void setDocumentLocator(Locator loc) {
            this.locator = loc;
        }

        private static boolean validOn(String platforms) {
            if (platforms == null) {
                return true;
            }
            String[] platformList = platforms.split(",");
            int n = platformList.length;
            for (int i = 0; i < n; ++i) {
                String specifiedPlatform = platformList[i].trim();
                if (specifiedPlatform.equalsIgnoreCase(ImplFactory.ALL)) {
                    return true;
                }
                if (!specifiedPlatform.equalsIgnoreCase(actualPlatformString)) continue;
                return true;
            }
            return false;
        }

        static {
            actualPlatformString = ImplFactory.DISTRIBUTED;
            if (WSLauncher.isZOS()) {
                actualPlatformString = ImplFactory.ZSERIES;
            } else if (WSLauncher.isISeries()) {
                actualPlatformString = ImplFactory.ISERIES;
            }
        }
    }

    private static class FactoryList {
        public int rank;
        public List factories = new ArrayList();

        private FactoryList() {
        }

        public String toString() {
            return "[ rank = " + this.rank + ',' + this.factories + ']';
        }
    }

    private static class Factory {
        public String interfaceName;
        public String implName;
        public IConfigurationElement configElement;
        public boolean isOverride = false;
        public String platforms = null;

        private Factory() {
        }

        public String toString() {
            return '[' + this.interfaceName + '=' + this.implName + ',' + this.isOverride + ',' + this.platforms + ']';
        }
    }
}

