/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import com.ibm.ffdc.Manager;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Properties;

public class FieldInitializer {
    public static void initFromSystemProperties(Class c) {
        FieldInitializer.updateFieldsFromSystemProperties(c, null);
    }

    public static void initFromSystemProperties(Object o) {
        FieldInitializer.updateFieldsFromSystemProperties(o.getClass(), o);
    }

    public static void initFromSystemProperties(Class c, Properties prop) {
        FieldInitializer.updateFieldsFromProperties(c, null, prop);
    }

    public static void initFromSystemProperties(Object o, Properties prop) {
        FieldInitializer.updateFieldsFromProperties(o.getClass(), o, prop);
    }

    private static void updateFieldsFromSystemProperties(Class c, Object o) {
        FieldInitializer.updateFieldsFromProperties(c, o, System.getProperties());
    }

    private static void updateFieldsFromProperties(Class c, Object o, Properties prop) {
        Enumeration<?> propNames = prop.propertyNames();
        String prefix = c.getName();
        while (propNames.hasMoreElements()) {
            String propName = (String)propNames.nextElement();
            if (!FieldInitializer.isClassProperty(c, propName)) continue;
            Field field = null;
            try {
                int modifiers;
                String fieldName = propName.substring(propName.lastIndexOf(46) + 1);
                field = FieldInitializer.getDeclaredField(c, fieldName);
                if (field != null && o == null && !Modifier.isStatic(modifiers = field.getModifiers())) {
                    field = null;
                }
                if (field != null) {
                    field.setAccessible(true);
                    String val = (String)prop.get(propName);
                    Class<?> fClass = field.getType();
                    if (fClass == String.class) {
                        field.set(o, val);
                    } else if (fClass == Integer.TYPE) {
                        field.setInt(o, Integer.parseInt(val));
                    } else if (fClass == Boolean.TYPE) {
                        field.setBoolean(o, Boolean.valueOf(val));
                    } else if (fClass == Long.TYPE) {
                        field.setLong(o, Long.parseLong(val));
                    } else if (fClass == Byte.TYPE) {
                        field.setByte(o, Byte.parseByte(val));
                    } else if (fClass == Character.TYPE) {
                        field.setChar(o, val.charAt(0));
                    } else if (fClass == Float.TYPE) {
                        field.setFloat(o, Float.parseFloat(val));
                    } else if (fClass == Double.TYPE) {
                        field.setDouble(o, Double.parseDouble(val));
                    } else if (fClass == Short.TYPE) {
                        field.setShort(o, Short.parseShort(val));
                    }
                }
            }
            catch (IllegalAccessException iae) {
                Manager.Ffdc.log(iae, FieldInitializer.class, "com.ibm.ws.util.FieldInitializer", "110");
            }
            catch (IllegalArgumentException iae) {
                Manager.Ffdc.log(iae, FieldInitializer.class, "com.ibm.ws.util.FieldInitializer", "113");
            }
            catch (NullPointerException npe) {
                Manager.Ffdc.log(npe, FieldInitializer.class, "com.ibm.ws.util.FieldInitializer", "116");
            }
            catch (ExceptionInInitializerError eiie) {
                Manager.Ffdc.log(eiie, FieldInitializer.class, "com.ibm.ws.util.FieldInitializer", "119");
            }
            if (field == null) continue;
            field.setAccessible(false);
        }
    }

    private static Field getDeclaredField(Class c, String fieldName) {
        Field f = null;
        do {
            try {
                f = c.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException nsfe) {
                if (c == Object.class) {
                    Manager.Ffdc.log(nsfe, FieldInitializer.class, "com.ibm.ws.util.FieldInitializer", "133");
                    c = null;
                    continue;
                }
                c = c.getSuperclass();
            }
            catch (NullPointerException npe) {
                Manager.Ffdc.log(npe, FieldInitializer.class, "com.ibm.ws.util.FieldInitializer", "137");
                c = null;
            }
            catch (SecurityException se) {
                Manager.Ffdc.log(se, FieldInitializer.class, "com.ibm.ws.util.FieldInitializer", "140");
                c = null;
            }
        } while (f == null && c != null);
        return f;
    }

    private static boolean isClassProperty(Class classs, String propName) {
        boolean success = false;
        while (classs != null && !success) {
            if (propName.startsWith(classs.getName())) {
                success = true;
                continue;
            }
            classs = classs.getSuperclass();
        }
        return success;
    }
}

