/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.util.FileSystem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.servlet.ServletContext;

public class ExtendedDocumentRootUtils {
    private static TraceComponent tc = Tr.register(ExtendedDocumentRootUtils.class.getName(), "Extended_DocumentRootUtils");
    private static boolean isWindows = System.getProperty("os.name").toLowerCase().startsWith("windows");
    private Vector searchPath = new Vector();
    private boolean useContentLength = false;
    private ZipFile matchedZipFile;
    private ZipEntry matchedEntry;
    private ExtDocRootFile extDocRootFile;

    public ExtendedDocumentRootUtils(ServletContext ctxt, String extendedDocumentRoot) {
        if (extendedDocumentRoot != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "constructor: extendedDocumentRoot ", extendedDocumentRoot);
            }
            this.createSearchPath(ctxt, extendedDocumentRoot);
        }
    }

    public ExtendedDocumentRootUtils(String baseDir, String extendedDocumentRoot) {
        if (extendedDocumentRoot != null) {
            if (baseDir != null && !(baseDir = baseDir.replace('\\', '/')).endsWith("/")) {
                baseDir = baseDir + "/";
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "constructor: baseDir ", baseDir);
                Tr.debug(tc, "constructor: extendedDocumentRoot ", extendedDocumentRoot);
            }
            this.createSearchPath(baseDir, extendedDocumentRoot);
        }
    }

    public boolean searchPathExists() {
        if (tc.isDebugEnabled()) {
            String result = !this.searchPath.isEmpty() ? "true" : "false";
            Tr.debug(tc, "searchPathExists ", result);
        }
        return !this.searchPath.isEmpty();
    }

    private void createSearchPath(ServletContext ctx, String extendedDocumentRoot) {
        String baseDir = ctx.getRealPath("/../");
        this.createSearchPath(baseDir, extendedDocumentRoot);
    }

    private void createSearchPath(String baseDir, String extendedDocumentRoot) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createSearchPath: baseDir ", baseDir);
            Tr.debug(tc, "createSearchPath: extendedDocumentRoot ", extendedDocumentRoot);
        }
        StringTokenizer st = new StringTokenizer(extendedDocumentRoot, ",");
        while (st.hasMoreTokens()) {
            try {
                String currentSearchLocation = st.nextToken().trim();
                if (currentSearchLocation == null) continue;
                if (isWindows && currentSearchLocation.indexOf(":") == 1 || currentSearchLocation.startsWith("/")) {
                    File f = new File(currentSearchLocation);
                    this.searchPath.addElement(f.toString());
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "add to searchPath " + f.toString());
                    continue;
                }
                File realPath = new File(baseDir + currentSearchLocation);
                String canonicalPath = realPath.getCanonicalPath();
                this.searchPath.addElement(canonicalPath);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "add to searchPath " + canonicalPath);
            }
            catch (IOException io) {
                io.printStackTrace(System.out);
            }
        }
    }

    public void handleExtendedDocumentRoots(String filename) throws FileNotFoundException, IOException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "handleExtendedDocumentRoots: filename " + filename);
        }
        boolean foundMatch = false;
        Enumeration altDocumentRoots = this.searchPath.elements();
        while (altDocumentRoots.hasMoreElements()) {
            String currDocumentRoot = altDocumentRoots.nextElement().toString();
            File currFile = new File(currDocumentRoot);
            if (currFile.isDirectory()) {
                File tmpFile = new File(currFile, filename);
                if (!tmpFile.exists()) continue;
                foundMatch = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "handleExtendedDocumentRoots: found match in directory" + tmpFile.toString());
                }
                this.handleCaseSensitivityCheck(tmpFile.toString(), filename);
                this.extDocRootFile = new FileResource(tmpFile);
                this.useContentLength = true;
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "handleExtendedDocumentRoots: useContentLength " + this.useContentLength);
                break;
            }
            if (!currFile.exists()) continue;
            ZipFile zip = new ZipFile(currFile);
            ZipEntry zEntry = zip.getEntry(filename.substring(1).replace('\\', '/'));
            if (zEntry != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "handleExtendedDocumentRoots: found match in zip or jar file" + currFile.toString());
                }
                foundMatch = true;
                this.extDocRootFile = new ZipFileResource(currFile, zEntry.getName());
                zip.close();
                break;
            }
            zip.close();
        }
        if (!foundMatch) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "handleExtendedDocumentRoots: unable to locate resource " + filename);
            }
            throw new FileNotFoundException(filename);
        }
    }

    public InputStream getInputStream() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getInputStream for ExtendedDocumentRoot this -->" + this);
        }
        try {
            return this.extDocRootFile.getIS();
        }
        catch (Exception e) {
            return null;
        }
    }

    public File getMatchedFile() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getMatchedFile = [" + this.extDocRootFile.getMatch() + "]");
        }
        return this.extDocRootFile.getMatch();
    }

    public long getLastModifiedMatchedFile() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getLastModifiedMatchedFile = [" + (this.extDocRootFile.getMatch() == null ? 0L : this.extDocRootFile.getMatch().lastModified()) + "]");
        }
        return this.extDocRootFile.getMatch() == null ? 0L : this.extDocRootFile.getMatch().lastModified();
    }

    public boolean useContentLength() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "useContentLength = [" + this.useContentLength + "]");
        }
        return this.useContentLength;
    }

    public ZipFile getMatchedZipFile() {
        if (this.extDocRootFile instanceof ZipFileResource) {
            return ((ZipFileResource)this.extDocRootFile).getZipFile();
        }
        return null;
    }

    public ZipEntry getMatchedEntry() {
        if (this.extDocRootFile instanceof ZipFileResource) {
            return ((ZipFileResource)this.extDocRootFile).getZipEntry();
        }
        return null;
    }

    private void handleCaseSensitivityCheck(String path, String strippedPathInfo) throws FileNotFoundException, IOException {
        if (FileSystem.isCaseInsensitive) {
            File caseFile;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "file system is case insensitive");
            }
            if (!FileSystem.uriCaseCheck(caseFile = new File(path), strippedPathInfo)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "handleCaseSensitivityCheck failed for = [" + path + "]");
                }
                throw new FileNotFoundException(path);
            }
        }
    }

    protected class FileResource
    implements ExtDocRootFile {
        private File file;

        protected FileResource(File file) {
            this.file = file;
        }

        public InputStream getIS() throws IOException {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "return FileResource inputstream file -->" + this.file);
            }
            return new FileInputStream(this.file);
        }

        public File getMatch() {
            return this.file;
        }
    }

    protected class ZipFileResource
    implements ExtDocRootFile {
        private String entry;
        private File jarFile;

        protected ZipFileResource(File jarFile, String entry) {
            this.entry = entry;
            this.jarFile = jarFile;
        }

        public InputStream getIS() throws IOException {
            ZipFile zip = new ZipFile(this.jarFile);
            ZipEntry zEntry = zip.getEntry(this.entry);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "return ZipFileResource inputstream zip -->" + this.jarFile + " entry -->" + this.entry);
            }
            return zip.getInputStream(zEntry);
        }

        public File getMatch() {
            return this.jarFile;
        }

        public ZipFile getZipFile() {
            try {
                return new ZipFile(this.jarFile);
            }
            catch (Exception e) {
                return null;
            }
        }

        public ZipEntry getZipEntry() {
            try {
                return new ZipFile(this.jarFile).getEntry(this.entry);
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    protected static interface ExtDocRootFile {
        public InputStream getIS() throws IOException;

        public File getMatch();
    }
}

