/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class CaptureOutputStream
extends FilterOutputStream {
    private ByteArrayOutputStream captureOs = new ByteArrayOutputStream();

    public CaptureOutputStream(OutputStream os) {
        super(os);
    }

    public void write(int ch) throws IOException {
        super.write(ch);
        this.captureOs.write(ch);
    }

    public void write(byte[] buf) throws IOException {
        super.write(buf);
        this.captureOs.write(buf);
    }

    public void write(byte[] buf, int off, int len) throws IOException {
        super.write(buf, off, len);
        this.captureOs.write(buf, off, len);
    }

    public void flush() throws IOException {
        super.flush();
        this.captureOs.flush();
    }

    public byte[] getCapturedOutput() {
        return this.captureOs.toByteArray();
    }
}

