/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

class CaptureInputStream
extends FilterInputStream {
    private ByteArrayOutputStream captureOs = new ByteArrayOutputStream();

    public CaptureInputStream(InputStream is) {
        super(is);
    }

    public int read() throws IOException {
        int ch = super.read();
        this.captureOs.write(new Integer(ch).byteValue());
        return ch;
    }

    public int read(byte[] buf) throws IOException {
        int rtn = super.read(buf);
        if (rtn > 0) {
            this.captureOs.write(buf, 0, rtn);
        }
        return rtn;
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        int rtn = super.read(buf, off, len);
        if (rtn > 0) {
            this.captureOs.write(buf, off, rtn);
        }
        return rtn;
    }

    public void close() throws IOException {
        super.close();
        this.captureOs.flush();
    }

    public byte[] getCapturedInput() {
        return this.captureOs.toByteArray();
    }
}

