/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.timeutils;

import com.ibm.nws.ejs.ras.Tr;
import com.ibm.nws.ejs.ras.TraceComponent;
import com.ibm.ws.timeutils.QuickApproxTime;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class QuickApproxTimeT
extends QuickApproxTime {
    protected volatile long currentApproxTime = 0L;
    protected long sleepInterval = 1000L;
    protected TimeThread timeKeeper = null;
    protected TimeThreadPrivileged timeKeeperPriv = null;
    protected Thread timeKeeperThread = null;
    private static final TraceComponent tc = Tr.register(QuickApproxTimeT.class, "ChannelFramework", "com.ibm.ws.channel.resources.channelframeworkservice");

    public QuickApproxTimeT() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "QuickApproxTimeT");
        }
        this.timeKeeper = new TimeThread();
        this.timeKeeperPriv = new TimeThreadPrivileged(this.timeKeeper);
        AccessController.doPrivileged(this.timeKeeperPriv);
        this.currentApproxTime = System.currentTimeMillis();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "QuickApproxTimeT");
        }
    }

    public long getApproxTime() {
        return this.currentApproxTime;
    }

    public void setInterval(long l) {
        this.sleepInterval = l;
        TimeThreadInterruptPrivileged timeThreadInterruptPrivileged = new TimeThreadInterruptPrivileged();
        AccessController.doPrivileged(timeThreadInterruptPrivileged);
    }

    public long getInterval() {
        return this.sleepInterval;
    }

    public void destroy() {
        this.timeKeeperThread.destroy();
    }

    class TimeThreadInterruptPrivileged
    implements PrivilegedAction {
        TimeThreadInterruptPrivileged() {
        }

        public Object run() {
            if (QuickApproxTimeT.this.timeKeeperThread != null) {
                QuickApproxTimeT.this.timeKeeperThread.interrupt();
            }
            return null;
        }
    }

    class TimeThreadPrivileged
    implements PrivilegedAction {
        TimeThread tt;

        public TimeThreadPrivileged(TimeThread timeThread) {
            this.tt = timeThread;
        }

        public Object run() {
            QuickApproxTimeT.this.timeKeeperThread = new Thread(this.tt);
            QuickApproxTimeT.this.timeKeeperThread.setName("Approximate Time Keeping Thread");
            QuickApproxTimeT.this.timeKeeperThread.setDaemon(true);
            QuickApproxTimeT.this.timeKeeperThread.start();
            return null;
        }
    }

    class TimeThread
    implements Runnable {
        TimeThread() {
        }

        public void run() {
            while (true) {
                QuickApproxTimeT.this.currentApproxTime = System.currentTimeMillis();
                try {
                    Thread.sleep(QuickApproxTimeT.this.sleepInterval);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

