/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.ws.security.util.AccessController;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.security.PrivilegedAction;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class BasePanel
extends JDialog
implements ActionListener,
WindowListener,
KeyListener {
    private static final TraceComponent tc = Tr.register(BasePanel.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    public static final int PANEL_TIMEOUT = 1;
    public static final int PANEL_NO = 2;
    public static final int PANEL_YES = 3;
    public static final int USER_MESSAGES = 4;
    public static final int DEFAULT_TIMEOUT = 30;
    int timeout = 0;
    private int specifiedTimeout = 0;
    protected int width = 0;
    protected int height = 0;
    protected int selectionMade = 0;
    protected Thread inputThread = null;
    protected String targetHost = null;
    protected String trustStore = null;
    protected String subjectDN = null;
    protected String issuerDN = null;
    protected String serialNum = null;
    protected String expireDate = null;
    protected String shaDigest = null;
    protected String md5Digest = null;
    protected JFrame panelFrame = null;

    public BasePanel(String title, JFrame parent, int timeoutValue, String _targetHost, String _trustStore, String _subjectDN, String _issuerDN, String _serialNum, String _expireDate, String _shaDigest, String _md5Digest) {
        super(parent, title, true);
        this.specifiedTimeout = timeoutValue * 1000;
        this.timeout = timeoutValue * 1000;
        this.targetHost = _targetHost;
        this.trustStore = _trustStore;
        this.subjectDN = _subjectDN;
        this.issuerDN = _issuerDN;
        this.serialNum = _serialNum;
        this.expireDate = _expireDate;
        this.shaDigest = _shaDigest;
        this.md5Digest = _md5Digest;
        this.createWindow();
    }

    public void actionPerformed(ActionEvent eve) {
    }

    protected void createWindow() {
        this.setFont(new Font("Dialog", 0, 12));
        Dimension screen = this.getToolkit().getScreenSize();
        this.setSize(screen.width / 2, screen.height / 2);
        this.width = super.getSize().width;
        int dialogPositionX = (screen.width - this.width) / 2;
        this.height = super.getSize().height;
        int dialogPositionY = (screen.height - this.height) / 3;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Screen width: " + screen.width);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Screen height: " + screen.height);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "dialogPositionX: " + dialogPositionX);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "dialogPositionY: " + dialogPositionY);
        }
        this.setLocation(dialogPositionX, dialogPositionY);
        this.setResizable(true);
        this.pack();
        this.selectionMade = 0;
        this.setVisible(true);
        this.requestFocus();
    }

    public void dispose() {
        super.dispose();
    }

    public int getSelectionMade() {
        return this.selectionMade;
    }

    public void keyPressed(KeyEvent evt) {
        this.timeout += this.specifiedTimeout;
    }

    public void keyReleased(KeyEvent evt) {
    }

    public void keyTyped(KeyEvent evt) {
    }

    public synchronized int showPanel() {
        if (this.inputThread != null && this.inputThread.isAlive()) {
            try {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        BasePanel.this.inputThread.stop();
                        return null;
                    }
                });
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, this, "com.ibm.ISecurityL13SupportImpl.BasePanel.showPanel", "387", this);
            }
        }
        this.inputThread = null;
        return this.selectionMade;
    }

    public void windowActivated(WindowEvent eve) {
    }

    public void windowClosed(WindowEvent eve) {
    }

    public void windowClosing(WindowEvent eve) {
        this.selectionMade = 2;
    }

    public void windowDeactivated(WindowEvent eve) {
    }

    public void windowDeiconified(WindowEvent eve) {
    }

    public void windowIconified(WindowEvent eve) {
    }

    public void windowOpened(WindowEvent eve) {
    }

    public void setVisible(boolean isVisible) {
        if (isVisible) {
            if (this.selectionMade == 0) {
                super.setVisible(true);
            }
        } else if (this.selectionMade == 0 && this.isShowing()) {
            super.setVisible(false);
        }
    }
}

