/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.wsn.jaxb.adapters;

import com.ibm.websphere.sib.wsn.jaxb.base.TopicExpressionType;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.Text;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopicExpressionTypeAdapter
extends XmlAdapter<Object, TopicExpressionType> {
    private static final String DIALECT = "Dialect";

    public Object marshal(TopicExpressionType tx) throws Exception {
        TopicExpressionType te = new TopicExpressionType();
        te.getContent().addAll(tx.getContent());
        te.setDialect(tx.getDialect());
        Map<String, String> m = tx.getNamespacePrefixesMap();
        for (String prefix : m.keySet()) {
            String name = "xmlns:" + prefix;
            te.getOtherAttributes().put(new QName(name), m.get(prefix));
        }
        return te;
    }

    public TopicExpressionType unmarshal(Object obj) throws Exception {
        if (obj instanceof TopicExpressionType) {
            return (TopicExpressionType)obj;
        }
        if (!(obj instanceof Element)) {
            throw new Exception("Cannot unmarshal TopicExpressionType from object: " + obj);
        }
        return this.convertElementToTopicExpression((Element)obj);
    }

    private TopicExpressionType convertElementToTopicExpression(Element el) throws Exception {
        SOAPElement se = new SOAPFactory().createElement(el);
        TopicExpressionType te = this.deserialize(se);
        return te;
    }

    private TopicExpressionType deserialize(SOAPElement source) {
        TopicExpressionType te = new TopicExpressionType();
        String dialect = source.getAttribute(DIALECT);
        if (dialect == null) {
            // empty if block
        }
        te.setDialect(dialect);
        List<Object> content = te.getContent();
        Iterator children = source.getChildElements();
        while (children.hasNext()) {
            Object child = children.next();
            if (child instanceof SOAPElement) {
                content.add(child);
                continue;
            }
            if (!(child instanceof Text)) continue;
            content.add(((Text)child).getData());
        }
        Iterator prefixIt = source.getVisibleNamespacePrefixes();
        while (prefixIt.hasNext()) {
            String prefix = (String)prefixIt.next();
            String ns = source.getNamespaceURI(prefix);
            te.addPrefixMapping(prefix, ns);
        }
        Map<QName, String> otherAtts = te.getOtherAttributes();
        Iterator attsIt = source.getAllAttributes();
        while (attsIt.hasNext()) {
            String prefix;
            Name attrName = (Name)attsIt.next();
            if (DIALECT.equals(attrName.getLocalName()) || (prefix = attrName.getPrefix()).equalsIgnoreCase("xmlns")) continue;
            String attrValue = source.getAttributeValue(attrName);
            otherAtts.put(new QName(attrName.getURI(), attrName.getLocalName()), attrValue);
        }
        return te;
    }
}

