/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.token;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.wsspi.security.token.ValidationResult;
import com.ibm.wsspi.security.token.WSSecurityPropagationHelper;

public class ValidationResultImpl
implements ValidationResult {
    private static final TraceComponent tc = Tr.register(ValidationResultImpl.class, "Security");
    private ContextManager ctxMgr;
    private String uniqueId;

    private ValidationResultImpl() {
    }

    public ValidationResultImpl(ContextManager ctxMgr, String id) {
        this.ctxMgr = ctxMgr;
        this.uniqueId = id;
    }

    public String getRealmFromUniqueId() {
        String result = WSSecurityPropagationHelper.getRealmFromUniqueID((String)this.uniqueId);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getRealmFromUniqueId = " + result);
        }
        return result;
    }

    public String getUniqueId() {
        String result = this.uniqueId;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getUniqueId = " + result);
        }
        return result;
    }

    public String getUserFromUniqueId() {
        String result = WSSecurityPropagationHelper.getUserFromUniqueID((String)this.uniqueId);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getUserFromUniqueId = " + result);
        }
        return result;
    }

    public boolean requiresLogin() {
        boolean result = this.ctxMgr.isInternalServerId(this.uniqueId);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "requiresLogin = " + result);
        }
        return !result;
    }

    public String toString() {
        return super.toString() + " uniqueId = " + this.uniqueId;
    }
}

