/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.ws.security.config.GenericConfigHelper;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityConfigException;
import com.ibm.ws.security.config.SecurityConfigGlobals;
import com.ibm.ws.security.config.SecurityConfigObject;

public class TrustedAuthenticationRealm {
    private static final String REALM_LIST = "realmList";
    private static final String TRUST_ALL_REALMS = "trustAllRealms";
    private static TraceComponent tc = Tr.register(TrustedAuthenticationRealm.class, "SecurityConfig", "com.ibm.ejs.resources.security");
    private String realmList = null;
    private boolean trustAllRealms = false;

    public TrustedAuthenticationRealm(boolean isOutbound, SecurityConfigObject sco, GenericConfigHelper parent, String _cacheKey) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "ctor" + _cacheKey, new Object[]{sco, parent});
        }
        String cacheKey = " (" + _cacheKey + ")";
        if (isOutbound) {
            SecurityConfig security;
            String supportedTargetRealms;
            if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                Tr.debug(tc, "Populating outbound TrustedAuthenticationRealm" + cacheKey);
            }
            if (((supportedTargetRealms = (security = (SecurityConfig)parent).getProperty("com.ibm.CSI.supportedTargetRealms")) == null || supportedTargetRealms.length() == 0) && sco == null) {
                if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                    Tr.debug(tc, "(using defaults since both supportedATargetRealms and sco are null) trustAllRealms: " + this.trustAllRealms + " realmList: " + this.realmList + cacheKey);
                }
            } else if ((supportedTargetRealms == null || supportedTargetRealms.length() == 0) && sco != null) {
                this.trustAllRealms = sco.getBoolean(TRUST_ALL_REALMS, false);
                this.realmList = this.trustAllRealms ? "*" : sco.getString(REALM_LIST);
                if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                    Tr.debug(tc, "(supportedTargetRealms == null && sco != null) trustAllRealms: " + this.trustAllRealms + " realmList: " + this.realmList + cacheKey);
                }
            } else if (supportedTargetRealms != null && supportedTargetRealms.equals("*")) {
                this.trustAllRealms = true;
                this.realmList = "*";
                if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                    Tr.debug(tc, "(supportedTargetRealms.equals(\"*\")) trustAllRealms: " + this.trustAllRealms + " realmList: " + this.realmList + cacheKey);
                }
            } else if (supportedTargetRealms != null && supportedTargetRealms.length() > 0) {
                this.trustAllRealms = false;
                this.realmList = supportedTargetRealms;
                if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                    Tr.debug(tc, "(supportedTargetRealms.length() > 0) trustAllRealms: " + this.trustAllRealms + " realmList: " + this.realmList + cacheKey);
                }
            } else if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                Tr.debug(tc, "(using default values) trustAllRealms: " + this.trustAllRealms + " realmList: " + this.realmList + cacheKey);
            }
        } else {
            if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                Tr.debug(tc, "Populating inbound TrustedAuthenticationRealm" + cacheKey);
            }
            if (sco != null) {
                this.trustAllRealms = sco.getBoolean(TRUST_ALL_REALMS, false);
                this.realmList = sco.getString(REALM_LIST);
                if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                    Tr.debug(tc, "(sco != null) trustAllRealms: " + this.trustAllRealms + " realmList: " + this.realmList + cacheKey);
                }
            } else if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                Tr.debug(tc, "(using defaults) trustAllRealms: " + this.trustAllRealms + " realmList: " + this.realmList + cacheKey);
            }
        }
        try {
            if (!this.trustAllRealms && this.realmList != null && this.realmList.equals("*")) {
                String name = isOutbound ? "outboundTrustedAuthenticationRealm" : "inboundTrustedAuthenticationRealm";
                throw new SecurityConfigException("For entry " + name + ", trustAllRealms=false, but realmList=\"*\", contradictory assignments.");
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception loading TrustedAuthenticationRealm helper. Using default values.", new Object[]{e});
            }
            this.trustAllRealms = false;
            this.realmList = null;
            Manager.Ffdc.log(e, TrustedAuthenticationRealm.class, "com.ibm.ws.security.config.TrustedAuthenticationRealm", "1");
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "ctor" + cacheKey, this);
        }
    }

    public boolean getTrustAllRealms() {
        return this.trustAllRealms;
    }

    public String getRealmList() {
        return this.realmList;
    }
}

