/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminContext;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.config.AdminData;
import com.ibm.ws.security.config.AdminDataImpl;
import com.ibm.ws.security.config.AuditConfig;
import com.ibm.ws.security.config.AuditConfigImpl;
import com.ibm.ws.security.config.CSIv2Config;
import com.ibm.ws.security.config.CSIv2ConfigImpl;
import com.ibm.ws.security.config.DynamicTAIConfig;
import com.ibm.ws.security.config.DynamicTAIConfigImpl;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityConfigGlobals;
import com.ibm.ws.security.config.SecurityConfigImpl;
import com.ibm.ws.security.config.SecurityConfigManager;
import com.ibm.ws.security.config.SecurityConfigManagerImpl;
import com.ibm.ws.security.config.SecurityConfigObject;
import com.ibm.ws.security.config.SecurityConfigObjectFactory;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.config.naming.NamingAuthzConfig;
import com.ibm.ws.security.config.naming.NamingAuthzConfigImpl;
import com.ibm.ws.security.role.RoleBasedConfigurator;
import com.ibm.ws.security.role.RoleBasedConfiguratorNullImpl;
import com.ibm.wsspi.management.agent.AdminSubsystemServiceRegistry;

public class SecurityConfigObjectFactoryImpl
implements SecurityConfigObjectFactory {
    private static final TraceComponent tc = Tr.register(SecurityConfigObjectFactoryImpl.class, "SecurityConfig", "com.ibm.ejs.resources.security");
    private static SecurityConfigObjectFactoryImpl _inst = null;
    private static SecurityConfigManager _scm = null;
    private static RoleBasedConfigurator nullConfigurator = null;
    private static RoleBasedConfigurator enabledConfigurator = null;

    private SecurityConfigObjectFactoryImpl() {
    }

    public static synchronized SecurityConfigObjectFactoryImpl getInstance() {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance");
        }
        if (_inst == null) {
            _inst = new SecurityConfigObjectFactoryImpl();
            if (_scm == null) {
                _scm = SecurityConfigManagerImpl.getInstance();
            }
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance");
        }
        return _inst;
    }

    public SecurityConfigManager getSecurityConfigManager() {
        if (_scm == null) {
            _scm = SecurityConfigManagerImpl.getInstance();
        }
        return _scm;
    }

    public SecurityConfig createSecurityConfig(String scope, boolean inherit, String cacheKey) {
        SecurityConfigObject obj;
        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
            Tr.debug(tc, "createSecurityConfig() scope=" + scope + " inherit=" + inherit + " " + cacheKey);
        }
        if ((obj = _scm.getObject(scope, inherit)) == null) {
            return null;
        }
        return new SecurityConfigImpl(obj, cacheKey);
    }

    public AuditConfig createAuditConfig(String cacheKey) {
        SecurityConfigObject obj;
        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
            Tr.debug(tc, "createAuditConfig() " + cacheKey);
        }
        if ((obj = _scm.getObject("audit", false)) == null) {
            return null;
        }
        return new AuditConfigImpl(obj, cacheKey);
    }

    public CSIv2Config createCSIv2Config(String cacheKey, Object endPointMgr) {
        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
            Tr.debug(tc, "createCSIv2Config() " + cacheKey);
        }
        return new CSIv2ConfigImpl(cacheKey, endPointMgr);
    }

    public NamingAuthzConfig createNamingAuthzConfig(String cacheKey) {
        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
            Tr.debug(tc, "createNamingAuthzConfig() " + cacheKey);
        }
        return new NamingAuthzConfigImpl(cacheKey);
    }

    public DynamicTAIConfig createDynamicTAIConfig() {
        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
            Tr.debug(tc, "createDynamicTAIConfig()");
        }
        return new DynamicTAIConfigImpl();
    }

    public AdminData createAdminData(String cacheKey) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "createAdminData " + cacheKey);
        }
        String uid = AdminContext.peek();
        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
            Tr.debug(tc, "Creating AdminDataImpl for uid: " + uid);
        }
        AdminDataImpl profileData = new AdminDataImpl(cacheKey);
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "createAdminData");
        }
        return profileData;
    }

    public Object getRoleBasedConfigurator() {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getRoleBasedConfigurator");
        }
        RoleBasedConfigurator configurator = null;
        if (AdminContext.peek() != null) {
            if (SecurityObjectLocator.getCSIv2Config().getBoolean("com.ibm.CORBA.securityEnabled")) {
                configurator = (RoleBasedConfigurator)AdminSubsystemServiceRegistry.getService((String)"RoleBasedConfigurator");
                if (configurator == null) {
                    if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                        Tr.debug(tc, "getRoleBasedConfigurator did not find configurator in AdminSubsystemServiceRegistry, creating new one");
                    }
                    try {
                        configurator = (RoleBasedConfigurator)Class.forName("com.ibm.ws.security.role.RoleBasedConfiguratorImpl").newInstance();
                        if (configurator != null) {
                            AdminSubsystemServiceRegistry.addService((String)"RoleBasedConfigurator", (Object)configurator);
                        }
                    }
                    catch (Exception e) {
                        FFDCFilter.processException(e, "com.ibm.ws.security.role.RoleBasedConfiguratorFactory.getConfigurator", "99");
                    }
                }
            } else {
                if (nullConfigurator == null) {
                    nullConfigurator = new RoleBasedConfiguratorNullImpl();
                }
                configurator = nullConfigurator;
            }
        } else if (SecurityObjectLocator.getSecurityConfig("security").getBoolean("enabled")) {
            if (enabledConfigurator == null) {
                try {
                    enabledConfigurator = (RoleBasedConfigurator)Class.forName("com.ibm.ws.security.role.RoleBasedConfiguratorImpl").newInstance();
                }
                catch (Exception e) {
                    FFDCFilter.processException(e, "com.ibm.ws.security.role.RoleBasedConfiguratorFactory.getConfigurator", "99");
                }
            }
            configurator = enabledConfigurator;
        } else {
            if (nullConfigurator == null) {
                nullConfigurator = new RoleBasedConfiguratorNullImpl();
            }
            configurator = nullConfigurator;
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getRoleBasedConfigurator " + configurator);
        }
        return configurator;
    }

    public void releaseRoleBasedConfigurator() {
        AdminSubsystemServiceRegistry.removeService((String)"RoleBasedConfigurator");
    }
}

