/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.config.GenericConfigHelper;
import com.ibm.ws.security.config.SecurityConfigException;
import com.ibm.ws.security.config.SecurityConfigGlobals;
import com.ibm.ws.security.config.SecurityConfigManager;
import com.ibm.ws.security.config.SecurityConfigObject;
import com.ibm.ws.security.config.SecurityObjectLocator;
import java.util.HashMap;

public abstract class GenericConfigHelperImpl
implements GenericConfigHelper {
    static SecurityConfigManager scm = SecurityObjectLocator.getSecurityConfigManager();
    protected SecurityConfigObject sco = null;
    protected GenericConfigHelperImpl parent = null;
    protected String cacheKey = null;
    protected static final TraceComponent tc = Tr.register(GenericConfigHelperImpl.class, "SecurityConfig", "com.ibm.ejs.resources.security");
    protected boolean initialized = false;
    protected boolean refreshable = false;
    protected HashMap<String, Object> generatedData = null;
    protected HashMap<String, Object> defaults = null;
    private static final Boolean defaultBoolean = false;
    private static final Integer defaultInteger = 0;
    private static final Long defaultLong = 0L;
    private static final Float defaultFloat = Float.valueOf(0.0f);

    public void initialize(SecurityConfigObject _sco, GenericConfigHelperImpl _parent, String _cacheKey) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize" + _cacheKey, new Object[]{_sco, _parent});
        }
        if (!this.initialized) {
            this.sco = _sco;
            this.parent = _parent;
            this.cacheKey = " (" + _cacheKey + ") ";
            this.generatedData = new HashMap();
            this.defaults = new HashMap();
            this.initialized = true;
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize" + this.cacheKey, this);
        }
    }

    public SecurityConfigObject getSCO() {
        return this.sco;
    }

    public void refresh() throws SecurityConfigException {
        throw new SecurityConfigException("Refresh support is not implemented yet");
    }

    public boolean isRefreshEnabled() {
        return this.refreshable;
    }

    public void setRefreshEnabled(boolean value) {
        this.refreshable = value;
    }

    public boolean isSet(String key) {
        return this.sco.isSet(key);
    }

    private Boolean getBooleanDefault(String key) {
        Boolean def = (Boolean)this.defaults.get(key);
        return def != null ? def : defaultBoolean;
    }

    private Integer getIntegerDefault(String key) {
        Integer def = (Integer)this.defaults.get(key);
        return def != null ? def : defaultInteger;
    }

    private Long getLongDefault(String key) {
        Long def = (Long)this.defaults.get(key);
        return def != null ? def : defaultLong;
    }

    private Float getFloatDefault(String key) {
        Float def = (Float)this.defaults.get(key);
        return def != null ? def : defaultFloat;
    }

    private String getStringDefault(String key) {
        return (String)this.defaults.get(key);
    }

    public boolean getBoolean(String key) {
        Object result;
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getBoolean: key=" + key + this.cacheKey);
        }
        if ((result = this.getObject(key, null)) == null) {
            result = scm.getBoolean(this.sco, null, key, this.getBooleanDefault(key));
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getBoolean" + this.cacheKey, result);
        }
        return (Boolean)result;
    }

    public float getFloat(String key) {
        Object result;
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getFloat: key=" + key + this.cacheKey);
        }
        if ((result = this.getObject(key, null)) == null) {
            result = scm.getFloat(this.sco, null, key, this.getFloatDefault(key).floatValue());
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getFloat" + this.cacheKey, result);
        }
        return ((Float)result).floatValue();
    }

    public int getInteger(String key) {
        Object result;
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getInteger: key=" + key + this.cacheKey);
        }
        if ((result = this.getObject(key, null)) == null) {
            result = scm.getInteger(this.sco, null, key, this.getIntegerDefault(key));
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getInteger" + this.cacheKey, result);
        }
        return (Integer)result;
    }

    public long getLong(String key) {
        Object result;
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getLong: key=" + key + this.cacheKey);
        }
        if ((result = this.getObject(key, null)) == null) {
            result = scm.getLong(this.sco, null, key, this.getLongDefault(key));
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getLong" + this.cacheKey, result);
        }
        return (Long)result;
    }

    public Object getObject(String key) {
        return this.getObject(key, null);
    }

    public Object getObject(String key, Object defaultValue) {
        Object result;
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getObject: key=" + key + this.cacheKey);
        }
        if ((result = this.generatedData.get(key)) == null) {
            result = defaultValue;
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getObject" + this.cacheKey, result);
        }
        return result;
    }

    public String getString(String key) {
        Object result;
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getString: key=" + key + this.cacheKey);
        }
        if ((result = this.getObject(key, null)) == null) {
            result = scm.getString(this.sco, null, key, this.getStringDefault(key), false, true);
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getString" + this.cacheKey, result);
        }
        return (String)result;
    }

    public String getUnexpandedString(String key) {
        Object result;
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getUnexpandedString: key=" + key + this.cacheKey);
        }
        if ((result = this.getObject(key, null)) == null) {
            return scm.getString(this.sco, null, key, this.getStringDefault(key), false, false);
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getUnexpandedString" + this.cacheKey, result);
        }
        return (String)result;
    }

    public String getDecodedString(String key) {
        String result;
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getDecodedString: key=" + key + this.cacheKey);
        }
        if ((result = (String)this.getObject(key, null)) == null) {
            result = scm.getString(this.sco, null, key, this.getStringDefault(key), true, true);
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getDecodedString" + this.cacheKey, result);
        }
        return result;
    }

    public void setBoolean(String key, Boolean value) {
        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
            Tr.debug(tc, "setBoolean: key=" + key + this.cacheKey, value);
        }
        this.generatedData.put(key, value);
    }

    public void setBoolean(String key, boolean value) {
        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
            Tr.debug(tc, "setBoolean: key=" + key + this.cacheKey, value);
        }
        this.generatedData.put(key, value);
    }

    public void setFloat(String key, Float value) {
        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
            Tr.debug(tc, "setFloat: key=" + key + this.cacheKey, value);
        }
        this.generatedData.put(key, value);
    }

    public void setFloat(String key, float value) {
        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
            Tr.debug(tc, "setFloat: key=" + key + this.cacheKey, Float.valueOf(value));
        }
        this.generatedData.put(key, new Float(value));
    }

    public void setInteger(String key, Integer value) {
        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
            Tr.debug(tc, "setInteger: key=" + key + this.cacheKey, value);
        }
        this.generatedData.put(key, value);
    }

    public void setInteger(String key, int value) {
        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
            Tr.debug(tc, "setInteger: key=" + key + this.cacheKey, value);
        }
        this.generatedData.put(key, value);
    }

    public void setLong(String key, Long value) {
        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
            Tr.debug(tc, "setLong: key=" + key + this.cacheKey, value);
        }
        this.generatedData.put(key, value);
    }

    public void setLong(String key, long value) {
        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
            Tr.debug(tc, "setLong: key=" + key + this.cacheKey, value);
        }
        this.generatedData.put(key, value);
    }

    public void setObject(String key, Object value) {
        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled() && key != null && key.toLowerCase().indexOf("password") != -1) {
            Tr.debug(tc, "setObject: key=" + key + this.cacheKey, "****");
        } else if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
            Tr.debug(tc, "setObject: key=" + key + this.cacheKey, value);
        }
        this.generatedData.put(key, value);
    }

    public void setString(String key, String value) {
        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled() && key != null && key.toLowerCase().indexOf("password") != -1) {
            Tr.debug(tc, "setString: key=" + key + this.cacheKey, "****");
        } else if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
            Tr.debug(tc, "setString: key=" + key + this.cacheKey, value);
        }
        this.generatedData.put(key, value);
    }

    protected void unsetBoolean(String key) {
        this.generatedData.remove(key);
    }

    protected void unsetFloat(String key) {
        this.generatedData.remove(key);
    }

    protected void unsetInteger(String key) {
        this.generatedData.remove(key);
    }

    protected void unsetLong(String key) {
        this.generatedData.remove(key);
    }

    protected void unsetObject(String key) {
        this.generatedData.remove(key);
    }

    protected void unsetString(String key) {
        this.generatedData.remove(key);
    }

    protected void dumpDefaults() {
        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
            Tr.debug(tc, "Contents of defaults:");
        }
        this.dumpHashMap(this.defaults);
    }

    protected void dumpGeneratedData() {
        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
            Tr.debug(tc, "Contents of generatedData:");
        }
        this.dumpHashMap(this.generatedData);
    }

    private void dumpHashMap(HashMap map) {
        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
            Tr.debug(tc, map.toString());
        }
    }

    public String toString() {
        return super.toString() + " " + this.sco.getConfigFilePath() + "/" + this.sco.getConfigFileName() + " " + this.cacheKey;
    }
}

