/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.ws.security.config.DynamicTAI;
import com.ibm.ws.security.config.DynamicTAIConfig;
import com.ibm.ws.security.config.SecurityConfigGlobals;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicTAIConfigImpl
implements DynamicTAIConfig {
    private static TraceComponent tc = Tr.register(DynamicTAIConfigImpl.class, "SecurityConfig", "com.ibm.ejs.resources.security");
    private List<DynamicTAI> interceptors = null;
    private static final WebSphereRuntimePermission ADD_INTERCEPTOR = new WebSphereRuntimePermission("addInterceptor");

    public DynamicTAIConfigImpl() {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "ctor");
        }
        this.initialize_defaults();
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "ctor");
        }
    }

    private void initialize_defaults() {
        this.interceptors = new LinkedList<DynamicTAI>();
    }

    @Override
    public void addInterceptor(DynamicTAI thisTAI) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + ADD_INTERCEPTOR.toString());
            }
            sm.checkPermission(ADD_INTERCEPTOR);
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getInterceptors");
        }
        this.interceptors.add(thisTAI);
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getInterceptors", this.interceptors);
        }
    }

    @Override
    public List<DynamicTAI> getInterceptors() {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getInterceptors");
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getInterceptors", this.interceptors);
        }
        return this.interceptors;
    }
}

