/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.config;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.config.SecurityConfigGlobals;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.util.ConfigUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.Properties;
import org.omg.CORBA.SystemException;

public class ConfigURLProperties
extends Properties {
    private static final long serialVersionUID = 4327870282077085354L;
    private static final TraceComponent tc = Tr.register(ConfigURLProperties.class, "SASRas", "com.ibm.ISecurityL13SupportImpl.sec");
    private static ConfigURLProperties _inst = null;
    private boolean queryORB = false;
    private ORB _orb = null;

    private ConfigURLProperties() {
    }

    public static ConfigURLProperties getInstance() {
        if (_inst == null) {
            _inst = new ConfigURLProperties();
        }
        return _inst;
    }

    public void init(String propertiesURL, ORB orb) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "ConfigURLProperties.init", propertiesURL);
        }
        this._orb = orb;
        if (ConfigUtils.stringToBoolean((String)System.getProperty("com.ibm.ws.security.config.SupportORBConfig"))) {
            this.queryORB = true;
        }
        if (!this.loadPropertiesFile(propertiesURL)) {
            return;
        }
        String value = this.getProperty("com.ibm.ws.security.CommTrace.ExcludeServiceContexts");
        if (value != null) {
            this.setProperty("com.ibm.ws.security.CommTrace.ExcludeServiceContexts", value);
        } else if (!"".equals("")) {
            this.setProperty("com.ibm.ws.security.CommTrace.ExcludeServiceContexts", "");
        }
        this.dumpProperties();
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "ConfigURLProperties.init");
        }
    }

    protected boolean loadPropertiesFile(String in_propertiesURL) throws SystemException {
        String propertiesURL;
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "loadPropertiesFile", in_propertiesURL);
        }
        if ((propertiesURL = in_propertiesURL) == null) {
            if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
                Tr.exit(tc, "loadPropertiesFile");
            }
            return false;
        }
        try {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        InputStream istream = null;
                        try {
                            URL url = new URL(propertiesURL);
                            istream = url.openStream();
                            ConfigURLProperties.this.load(istream);
                        }
                        catch (Exception ex) {
                            throw ex;
                        }
                        finally {
                            if (istream != null) {
                                istream.close();
                            }
                        }
                        return null;
                    }
                });
                if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
                    Tr.exit(tc, "loadPropertiesFile");
                }
                return true;
            }
            catch (PrivilegedActionException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.config.ConfigURLProperties.loadPropertiesFile", "255", this);
                Tr.warning(tc, "security.JSAS0631E", new Object[]{propertiesURL, e});
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.config.ConfigURLProperties.loadPropertiesFile", "263", this);
            Tr.warning(tc, "security.JSAS0631E", new Object[]{propertiesURL, e});
        }
        String propertiesURL_retry = this.scrubURL(propertiesURL);
        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
            Tr.debug(tc, "Retry URL = " + propertiesURL_retry);
        }
        try {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        InputStream istream = null;
                        try {
                            URL url = new URL(propertiesURL);
                            istream = url.openStream();
                            ConfigURLProperties.this.load(istream);
                        }
                        catch (Exception ex) {
                            throw ex;
                        }
                        finally {
                            if (istream != null) {
                                istream.close();
                            }
                        }
                        return null;
                    }
                });
                if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
                    Tr.exit(tc, "loadPropertiesFile");
                }
                return true;
            }
            catch (PrivilegedActionException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.config.ConfigURLProperties.loadPropertiesFile", "298", this);
                Tr.error(tc, "security.JSAS0629E", new Object[]{"loadPropertiesFile", propertiesURL_retry, e.getException()});
                throw e.getException();
            }
        }
        catch (MalformedURLException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.config.ConfigURLProperties.loadPropertiesFile", "306", this);
            Tr.error(tc, "security.JSAS1478W");
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.config.ConfigURLProperties.loadPropertiesFile", "312", this);
            Tr.error(tc, "security.JSAS1478W");
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.config.ConfigURLProperties.loadPropertiesFile", "318", this);
            Tr.error(tc, "security.JSAS1478W");
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "loadPropertiesFile");
        }
        return false;
    }

    String scrubURL(String propertiesURL) {
        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
            Tr.debug(tc, "Existing propertiesURL: " + propertiesURL);
        }
        StringBuffer temp = new StringBuffer();
        int end = 0;
        for (int i = propertiesURL.indexOf(58, 0) + 1; i < propertiesURL.length(); ++i) {
            if (propertiesURL.charAt(i) == '/' || propertiesURL.charAt(i) == '\\') continue;
            end = i;
            break;
        }
        temp.append("file:/");
        temp.append(propertiesURL.substring(end));
        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
            Tr.debug(tc, "New propertiesURL: " + temp.toString());
        }
        return temp.toString();
    }

    public String getProperty(String in_name) {
        String value = null;
        if (this.queryORB) {
            value = this._orb.getProperty(in_name);
        }
        if (value == null || value.equals("")) {
            value = System.getProperty(in_name);
        }
        if (value == null || value.equals("")) {
            value = super.getProperty(in_name);
        }
        return value;
    }

    public void dumpProperties() {
        if (this.size() == 0) {
            return;
        }
        if (!tc.isDebugEnabled()) {
            return;
        }
        Tr.debug(tc, "Printing ConfigURLProperties...");
        Enumeration<?> e = this.propertyNames();
        while (e.hasMoreElements()) {
            String attribute = (String)e.nextElement();
            if (attribute == null) continue;
            String value = this.getProperty(attribute);
            if (attribute.endsWith("Password")) {
                value = ConfigUtils.mask((String)value);
            }
            Tr.debug(tc, attribute + " = " + value);
        }
    }
}

