/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.config;

import com.ibm.ISecurityUtilityImpl.PasswordUtil;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.security.krb5.internal.Config;
import com.ibm.security.krb5.internal.ktab.KeyTab;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.config.AuthMechanismConfig;
import com.ibm.ws.security.config.FiltersConfig;
import com.ibm.ws.security.config.FiltersConfigImpl;
import com.ibm.ws.security.config.GenericConfigHelperImpl;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityConfigGlobals;
import com.ibm.ws.security.config.SecurityConfigImpl;
import com.ibm.ws.security.config.SecurityConfigObject;
import com.ibm.ws.security.config.SecurityConfigObjectList;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.config.SingleSignonConfig;
import com.ibm.ws.security.config.SingleSignonConfigImpl;
import com.ibm.ws.security.util.ConfigUtils;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.SSLConfig;
import com.ibm.ws.ssl.config.WSKeyStore;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.util.PlatformHelperFactory;
import java.io.IOException;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthMechanismConfigImpl
extends GenericConfigHelperImpl
implements AuthMechanismConfig {
    private static final String SINGLE_SIGNON = "singleSignon";
    private static final String FILTERS = "filters";
    private static TraceComponent tc = Tr.register(AuthMechanismConfigImpl.class, "SecurityConfig", "com.ibm.ejs.resources.security");
    private SingleSignonConfig sso = null;
    private String type = null;
    private LinkedList<FiltersConfig> filters = null;
    private Properties filterProps = null;
    private boolean initializeRSAPropertiesCalled = false;
    private boolean krbAllowLTPAAuth = true;
    private String authMechOID = null;
    private SecurityConfigObject domainSCO = null;
    private int KRB5_CLOCK_SKEW = 300000;

    public AuthMechanismConfigImpl(SecurityConfigObject obj, GenericConfigHelperImpl parent, String _cacheKey) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "ctor " + _cacheKey, new Object[]{obj, parent});
        }
        super.initialize(obj, parent, _cacheKey);
        this.initialize_defaults();
        this.initialization();
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "ctor " + this.cacheKey, this);
        }
    }

    public AuthMechanismConfigImpl(SecurityConfigObject _adminSCO, SecurityConfigObject _domainSCO, GenericConfigHelperImpl parent, String _cacheKey) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "ctor " + _cacheKey, new Object[]{_adminSCO, _domainSCO, parent});
        }
        super.initialize(_adminSCO, parent, _cacheKey);
        this.domainSCO = _domainSCO;
        this.initialize_defaults();
        this.initialization();
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "ctor " + this.cacheKey, this);
        }
    }

    private void initialize_defaults() {
        this.defaults.put("OID", null);
        this.defaults.put("authContextImplClass", null);
        this.defaults.put("authConfig", null);
        this.defaults.put("simpleAuthConfig", null);
        this.defaults.put("authValidationConfig", null);
        this.defaults.put("timeout", 120L);
        this.defaults.put("password", null);
        this.defaults.put("keySetGroup", null);
        this.defaults.put("trimUserName", Boolean.FALSE);
        this.defaults.put("enabledGssCredDelegate", Boolean.FALSE);
        this.defaults.put("krb5Realm", null);
        this.defaults.put("krb5Config", null);
        this.defaults.put("krb5Keytab", null);
        this.defaults.put("krb5Spn", null);
        this.defaults.put("krb5SpnPassword", null);
        this.defaults.put("allowLPTAAuth", Boolean.TRUE);
        this.defaults.put("isCredentialForwardable", Boolean.TRUE);
    }

    private void initializeRSA() {
        SecurityConfigObject adminCertificate;
        Long rsaPropagationNonceTimeout;
        Long rsaPropagationTokenExpiration;
        String rsaPropagationAuthContextImplClass;
        String rsaPropagationOID;
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeRSA " + this.cacheKey);
        }
        if ((rsaPropagationOID = this.sco.getString("OID", null)) != null) {
            this.setString("OID", rsaPropagationOID);
        }
        if ((rsaPropagationAuthContextImplClass = this.sco.getString("authContextImplClass", null)) != null) {
            this.setString("authContextImplClass", rsaPropagationAuthContextImplClass);
        }
        if ((rsaPropagationTokenExpiration = this.sco.getLong("tokenExpiration", 600L)) != null) {
            this.setLong("rsaTokenExpiration", rsaPropagationTokenExpiration);
        }
        if ((rsaPropagationNonceTimeout = this.sco.getLong("nonceCacheTimeout", 1200L)) != null) {
            this.setLong("rsaTokenNonceCacheTimeout", rsaPropagationNonceTimeout);
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
            Tr.debug(tc, "Admin RSA token OID: " + rsaPropagationOID);
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
            Tr.debug(tc, "Admin RSA token context impl class: " + rsaPropagationAuthContextImplClass);
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
            Tr.debug(tc, "Admin RSA token expiration: " + rsaPropagationTokenExpiration);
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
            Tr.debug(tc, "Admin RSA token nonce cache timeout: " + rsaPropagationNonceTimeout);
        }
        if ((adminCertificate = this.sco.getObject("adminCertificate")) != null) {
            try {
                String adminPersonalKeyStorePasswordString;
                String adminPersonalKeyStoreName;
                String adminPersonalCertificateAlias = adminCertificate.getString("alias");
                if (adminPersonalCertificateAlias != null) {
                    this.setString("rsaTokenCertificateAlias", adminPersonalCertificateAlias);
                }
                if ((adminPersonalKeyStoreName = adminCertificate.getObject("keyStore").getString("name")) != null) {
                    this.setString("rsaTokenKeyStoreName", adminPersonalKeyStoreName);
                }
                if ((adminPersonalKeyStorePasswordString = adminCertificate.getObject("keyStore").getString("password")) != null && adminPersonalKeyStorePasswordString.length() > 0) {
                    adminPersonalKeyStorePasswordString = PasswordUtil.passwordDecode(adminPersonalKeyStorePasswordString);
                    char[] adminPersonalKeyStorePassword = adminPersonalKeyStorePasswordString.toCharArray();
                    this.setObject("rsaTokenKeyStorePassword", adminPersonalKeyStorePassword);
                }
                if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Admin personal keystore name is: " + adminPersonalKeyStoreName);
                }
                if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Admin personal certificate alias is: " + adminPersonalCertificateAlias);
                }
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception getting the admin certificate.", new Object[]{e});
                }
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.config.AuthMechanismConfigImpl.initializeRSA", "190", this);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RSA propagation is enabled but admin personal certificate is not specified in the security.xml.");
            }
            throw new IllegalArgumentException("Admin rsa propagation is enabled but the admin certificate is not configured.");
        }
        try {
            String adminTrustStoreName = this.sco.getObject("adminCertificateTrustStore").getString("name");
            this.setString("rsaTokenTrustStoreName", adminTrustStoreName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Admin trust store name is: " + adminTrustStoreName);
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RSA propagation is enabled but admin trust store is not specified in the security.xml.", new Object[]{e});
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.config.AuthMechanismConfigImpl.initializeRSA", "209", this);
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeRSA " + this.cacheKey);
        }
    }

    private void initializeSPNEGOProperties() {
        String spengoAuthContextImplClass;
        String spnegoOID;
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeSPNEGOProperties " + this.cacheKey);
        }
        if ((spnegoOID = this.sco.getString("OID", null)) != null) {
            this.setString("OID", spnegoOID);
        }
        if ((spengoAuthContextImplClass = this.sco.getString("authContextImplClass", null)) != null) {
            this.setString("authContextImplClass", spengoAuthContextImplClass);
        }
        Boolean spengoEnabled = this.sco.getBoolean("enabled");
        this.setBoolean("spengoEnabled", spengoEnabled);
        Boolean spnegoAllowAppAuthMethodFallback = this.sco.getBoolean("allowAppAuthMethodFallback");
        this.setBoolean("spengoAllowAppAuthMethodFallback", spnegoAllowAppAuthMethodFallback);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SPNEGO OID: " + spnegoOID);
            Tr.debug(tc, "spengoAuthContextImplClass: " + spengoAuthContextImplClass);
            Tr.debug(tc, "spengoEnabled: " + spengoEnabled);
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeSPNEGOProperties " + this.cacheKey);
        }
    }

    private void initializeLTPAProperties() {
        String keyval = null;
        SecurityConfigObject key = this.sco.getObject("private");
        if (key != null) {
            keyval = key.getString("byteArray");
            this.setString("com.ibm.websphere.ltpa.PrivateKey", keyval);
            keyval = null;
        }
        if ((key = this.sco.getObject("public")) != null) {
            keyval = key.getString("byteArray");
            this.setString("com.ibm.websphere.ltpa.PublicKey", keyval);
            keyval = null;
        }
        if ((key = this.sco.getObject("shared")) != null) {
            keyval = key.getString("byteArray");
            this.setString("com.ibm.websphere.ltpa.3DESKey", keyval);
        }
        if (this.parent.getSCO().isDomainConfig() && !this.sco.isDomainConfig()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "This LTPA authMech is defined within a multi domain environment, checking for domain LTPA timeout value");
            }
            if (this.domainSCO == null) {
                AuthMechanismConfig domainLTPA = ((SecurityConfig)((Object)this.parent)).getAuthMechanism("LTPA");
                if (domainLTPA != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found domain LTPA with timeout: " + domainLTPA.getLong("timeout"));
                    }
                    this.setLong("timeout", domainLTPA.getLong("timeout"));
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No domain LTPA found");
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Loading for list");
                }
                if (this.domainSCO.isSet("timeout")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Domain LTPA with timeout: " + this.domainSCO.getLong("timeout"));
                    }
                    this.setLong("timeout", this.domainSCO.getLong("timeout"));
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Domain LTPA does not defined timeout, ignoring");
                }
            }
        }
    }

    private void initializeKerberosProperties() {
        AuthMechanismConfig ltpa;
        String krb5AuthContextImplClass;
        String krb5OID = this.sco.getString("OID", null);
        if (krb5OID != null) {
            this.setString("OID", krb5OID);
        }
        if ((krb5AuthContextImplClass = this.sco.getString("authContextImplClass", null)) != null) {
            this.setString("authContextImplClass", krb5AuthContextImplClass);
        }
        String uxpKrb5Config = null;
        String krb5Config = null;
        try {
            uxpKrb5Config = this.getUnexpandedString("krb5Config");
            if (uxpKrb5Config != null && (krb5Config = ConfigUtils.expandKrbFile((String)uxpKrb5Config)) != null) {
                this.setString("krb5Config", krb5Config);
                this.setKrbConfigProp(krb5Config);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String krb5Keytab = this.sco.getString("krb5Keytab", null);
        String krb5Realm = this.sco.getString("krb5Realm", null);
        try {
            AuthMechanismConfigImpl.setUseAllCredsProp();
            if ((krb5Keytab == null || krb5Keytab.length() == 0) && krb5Config != null && krb5Config.length() != 0) {
                krb5Keytab = this.getDefaultKeytab(krb5Config);
            }
            if (krb5Keytab != null) {
                this.setString("krb5Keytab", krb5Keytab);
                AuthMechanismConfigImpl.setKrbKeytabProp(krb5Keytab);
            }
            if ((krb5Realm == null || krb5Realm.length() == 0) && krb5Config != null && krb5Config.length() != 0) {
                krb5Realm = this.getDefaultRealm(krb5Config);
            }
            if (krb5Realm != null) {
                this.setString("krb5Realm", krb5Realm);
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting the Kerberos configuration.", new Object[]{e});
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.krb5.readConfiguration", "331", this);
        }
        Boolean trimUserName = this.sco.getBoolean("trimUserName");
        this.setBoolean("trimUserName", trimUserName);
        Boolean enabledGssCredDelegate = this.sco.getBoolean("enabledGssCredDelegate");
        this.setBoolean("enabledGssCredDelegate", enabledGssCredDelegate);
        boolean isSetTimeout = this.isSet("timeout");
        this.krbAllowLTPAAuth = ((SecurityConfig)((Object)this.parent)).getPropertyBool("com.ibm.websphere.security.krb.allowLTPAAuth");
        this.setBoolean("allowLPTAAuth", this.krbAllowLTPAAuth);
        if (!isSetTimeout && (ltpa = ((SecurityConfig)((Object)this.parent)).getAuthMechanism("LTPA")) != null) {
            this.setLong("timeout", ltpa.getLong("timeout"));
        }
        String spn = null;
        if (this.isSet("krb5Spn")) {
            spn = this.getUnexpandedString("krb5Spn");
            try {
                this.setString("krb5Spn", ConfigUtils.expandHost((SecurityConfig)((SecurityConfig)((Object)this.parent)), (String)spn, null));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "KRB5 OID: " + krb5OID);
            Tr.debug(tc, "krb5AuthContextImplClass: " + krb5AuthContextImplClass);
            Tr.debug(tc, "spn: " + spn);
            Tr.debug(tc, "expand spn: " + this.getString("krb5Spn"));
            Tr.debug(tc, "krb5Config: " + uxpKrb5Config);
            Tr.debug(tc, "expand krb5Config: " + krb5Config);
            Tr.debug(tc, "krb5Keytab: " + krb5Keytab);
            Tr.debug(tc, "krb5Realm: " + krb5Realm);
            Tr.debug(tc, "trimUserName: " + trimUserName);
            Tr.debug(tc, "enabledGssCredDelegate: " + enabledGssCredDelegate);
            Tr.debug(tc, "krbAllowLTPAAuth: " + this.krbAllowLTPAAuth);
        }
    }

    private void initialization() {
        String type = this.getType();
        if (type.equals("SWAM")) {
            this.setBoolean("isCredentialForwardable", false);
        } else if (type.equals("LTPA")) {
            this.initializeLTPAProperties();
            this.setString("keySetGroup", this.getKeySetGroupName(false));
        } else if (type.equals("RSATOKEN")) {
            this.initializeRSA();
        } else if (type.equals("KRB5")) {
            if (this.krbAllowLTPAAuth) {
                this.initializeKerberosProperties();
                this.setString("keySetGroup", this.getKeySetGroupName(true));
            } else {
                this.setString("keySetGroup", this.getKeySetGroupName(false));
            }
        } else if (type.equals("SPNEGO")) {
            this.initializeSPNEGOProperties();
        }
        if (type.equals("LTPA")) {
            this.setBoolean("isCredentialForwardable", Boolean.TRUE);
        } else if (type.equals("SWAM")) {
            String aciClass = this.sco.getString("authContextImplClass", null);
            if (aciClass == null) {
                aciClass = "";
            }
            this.setString("authContextImplClass", aciClass);
            this.setString("OID", "No OID for this mechanism");
            this.setBoolean("isCredentialForwardable", Boolean.FALSE);
        } else if (type.equals("RSATOKEN")) {
            this.setBoolean("isCredentialForwardable", Boolean.TRUE);
        } else if (type.equals("CUSTOM")) {
            this.setBoolean("isCredentialForwardable", Boolean.TRUE);
        } else if (type.equals("KRB5")) {
            this.setBoolean("isCredentialForwardable", Boolean.TRUE);
        }
        if (!type.equals("SWAM")) {
            String defaultLoginConfig = ((SecurityConfig)((Object)this.parent)).getProperty("com.ibm.ws.security.defaultLoginConfig");
            if (defaultLoginConfig == null || defaultLoginConfig.equals("")) {
                defaultLoginConfig = "system.LTPA";
            }
            this.setString("authConfig", defaultLoginConfig);
            this.setString("simpleAuthConfig", defaultLoginConfig);
            this.setString("authValidationConfig", defaultLoginConfig);
        }
        if (this.sco.getDescriptor().contains("activeAuthMechanism") && type.equals("SWAM")) {
            String customSwamLoginConfig = ((SecurityConfig)((Object)this.parent)).getProperty("com.ibm.ws.security.SWAMLoginConfig");
            String swamLoginConfig = "system.SWAM";
            if (customSwamLoginConfig != null && !customSwamLoginConfig.equals("")) {
                swamLoginConfig = customSwamLoginConfig;
            }
            ((SecurityConfigImpl)this.parent).setProperty("com.ibm.CSI.rmiOutboundPropagationEnabled", "false");
            ((SecurityConfigImpl)this.parent).setProperty("com.ibm.CSI.rmiInboundPropagationEnabled", "false");
            ((SecurityConfigImpl)this.parent).setProperty("com.ibm.CSI.rmiOutboundLoginEnabled", "false");
            ((SecurityConfigImpl)this.parent).setProperty("com.ibm.ws.security.webInboundPropagationEnabled", "false");
            ((SecurityConfigImpl)this.parent).setProperty("com.ibm.ws.security.ssoInteropModeEnabled", "true");
            ((SecurityConfigImpl)this.parent).setProperty("com.ibm.CSI.rmiInboundLoginConfig", swamLoginConfig);
            ((SecurityConfigImpl)this.parent).setProperty("com.ibm.CSI.rmiOutboundLoginConfig", "system.RMI_OUTBOUND");
            ((SecurityConfigImpl)this.parent).setProperty("com.ibm.ws.security.webInboundLoginConfig", swamLoginConfig);
            ((SecurityConfigImpl)this.parent).setProperty("com.ibm.ws.security.defaultLoginConfig", swamLoginConfig);
        }
    }

    private String getKeySetGroupName(boolean checkLTPA) {
        SecurityConfigObject ksg = null;
        ksg = this.sco.getObject("keySetGroup");
        if (ksg != null) {
            return ksg.getString("name");
        }
        if (checkLTPA) {
            AuthMechanismConfigImpl ltpa = (AuthMechanismConfigImpl)((SecurityConfig)((Object)this.parent)).getAuthMechanism("LTPA");
            if (ltpa == null) {
                return null;
            }
            ksg = ltpa.getSCO().getObject("keySetGroup");
            if (ksg != null) {
                return ksg.getString("name");
            }
        }
        return null;
    }

    private synchronized void do_initializeRSAProperties() {
        block39: {
            if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
                Tr.entry(tc, "initializeRSAProperties");
            }
            if (this.initializeRSAPropertiesCalled) {
                if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
                    Tr.exit(tc, "RSA properties already initialized.");
                }
                return;
            }
            this.initializeRSAPropertiesCalled = true;
            try {
                WSKeyStore wsks = KeyStoreManager.getInstance().getKeyStore(this.getString("rsaTokenKeyStoreName"));
                WSKeyStore wsts = KeyStoreManager.getInstance().getKeyStore(this.getString("rsaTokenTrustStoreName"));
                if (!PlatformHelperFactory.getPlatformHelper().isZOS() || PlatformHelperFactory.getPlatformHelper().isZOS() && !PlatformHelperFactory.getPlatformHelper().isServantJvm()) {
                    if (wsks != null) {
                        SSLConfig config2 = new SSLConfig();
                        config2.setProperty("com.ibm.ssl.keyStoreName", "rsaTokenKeyStoreName");
                        Certificate signer = KeyStoreManager.getInstance().checkIfKeyStoreExistsAndCreateIfNot(wsks, config2);
                        config2.setProperty("com.ibm.ssl.trustStoreName", "rsaTokenTrustStoreName");
                        KeyStoreManager.getInstance().checkIfTrustStoreExistsAndCreateIfNot(wsts, config2, signer);
                        KeyStore ks = wsks.getKeyStore(true, false);
                        if (ks != null) {
                            String alias = this.getString("rsaTokenCertificateAlias");
                            if (alias == null || alias.equalsIgnoreCase("")) {
                                if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "RSAToken certificate alias is not set, getting first alias from keystore.");
                                }
                                Enumeration<String> aliases = ks.aliases();
                                while (aliases.hasMoreElements()) {
                                    alias = aliases.nextElement();
                                    if (ks.isKeyEntry(alias)) {
                                        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Setting alias: " + alias);
                                        }
                                        this.setString("rsaTokenCertificateAlias", alias);
                                        break;
                                    }
                                    alias = null;
                                }
                            }
                            if (alias == null || alias.equalsIgnoreCase("")) {
                                throw new IllegalArgumentException("The admin certificate alias could not be determined.");
                            }
                            Certificate[] admin_certificate_chain = ks.getCertificateChain(alias);
                            PrivateKey admin_private_key = (PrivateKey)ks.getKey(alias, (char[])this.getObject("rsaTokenKeyStorePassword"));
                            if (admin_certificate_chain == null || admin_private_key == null) {
                                throw new IllegalArgumentException("The admin certificate alias was not found in the admin keystore.");
                            }
                            try {
                                for (int i = 0; i < admin_certificate_chain.length; ++i) {
                                    X509Certificate cert = (X509Certificate)admin_certificate_chain[i];
                                    cert.checkValidity();
                                }
                            }
                            catch (Exception e) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Exception checking the validity of the RSA token ", new Object[]{e});
                                }
                                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.config.AuthMechanismConfigImpl.do_initializeRSAProperties", "659", this);
                                throw e;
                            }
                            this.setObject("rsaTokenCertificate", admin_certificate_chain);
                            this.setObject("rsaTokenPrivateKey", admin_private_key);
                            if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Set the admin certificate and private key.");
                            }
                            break block39;
                        }
                        throw new IllegalArgumentException("The admin keystore is not valid.");
                    }
                    throw new IllegalArgumentException("The admin keystore alias is not found.");
                }
                if (wsks != null) {
                    WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(wsks);
                    String method = "";
                    Object[] parms = null;
                    if (wsksr != null) {
                        String adminPersonalCertificateAlias = this.getString("rsaTokenCertificateAlias");
                        PrivateKey admin_private_key = null;
                        if (adminPersonalCertificateAlias == null || adminPersonalCertificateAlias.equalsIgnoreCase("")) {
                            Object[] aliases;
                            if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                                Tr.debug(tc, "RSAToken certificate alias is not set, getting first alias from keystore.");
                            }
                            if ((aliases = wsksr.invokeKeyStoreCommand(method = "aliases", parms)) != null) {
                                for (int i = 0; i < aliases.length; ++i) {
                                    method = "isKeyEntry";
                                    adminPersonalCertificateAlias = (String)aliases[0];
                                    parms = new Object[]{adminPersonalCertificateAlias};
                                    Object[] isKeyEntry = wsks.invokeKeyStoreCommand(method, parms);
                                    if (((Boolean)isKeyEntry[0]).booleanValue()) {
                                        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Setting alias: " + adminPersonalCertificateAlias);
                                        }
                                        this.setString("rsaTokenCertificateAlias", adminPersonalCertificateAlias);
                                        break;
                                    }
                                    adminPersonalCertificateAlias = null;
                                }
                            }
                        }
                        if (adminPersonalCertificateAlias == null || adminPersonalCertificateAlias.equalsIgnoreCase("")) {
                            throw new IllegalArgumentException("The admin certificate alias could not be determined.");
                        }
                        method = "getKey";
                        parms = new Object[]{adminPersonalCertificateAlias, (char[])this.getObject("rsaTokenKeyStorePassword")};
                        Object[] key = wsksr.invokeKeyStoreCommand(method, parms);
                        if (key == null) {
                            throw new IllegalArgumentException("The admin certificate alias was not found in the admin keystore.");
                        }
                        admin_private_key = (PrivateKey)key[0];
                        this.setObject("rsaTokenPrivateKey", admin_private_key);
                        method = "getCertificateChain";
                        parms = new Object[]{adminPersonalCertificateAlias};
                        Object[] cert = wsksr.invokeKeyStoreCommand(method, parms);
                        if (cert == null) {
                            throw new IllegalArgumentException("The admin certificate alias was not found in the admin keystore.");
                        }
                        Certificate[] admin_certificate_chain = (Certificate[])cert[0];
                        try {
                            if (cert.length > 0) {
                                for (int i = 0; i < admin_certificate_chain.length; ++i) {
                                    X509Certificate checkCert = (X509Certificate)admin_certificate_chain[i];
                                    checkCert.checkValidity();
                                }
                            }
                        }
                        catch (Exception e) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Exception checking the validity of the RSA token ", new Object[]{e});
                            }
                            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.config.AuthMechanismConfigImpl.do_initializeRSAProperties", "767", this);
                            throw e;
                        }
                        this.setObject("rsaTokenCertificate", admin_certificate_chain);
                        if (admin_certificate_chain == null || admin_private_key == null) {
                            throw new IllegalArgumentException("The admin certificate alias was not found in the admin keystore.");
                        }
                        break block39;
                    }
                    throw new IllegalArgumentException("The admin keystore is not valid.");
                }
                throw new IllegalArgumentException("The admin keystore alias is not found.");
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception getting the admin certificate.", new Object[]{e});
                }
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.rsatoken.RSAPropagationManager.readConfiguration", "314", this);
            }
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeRSAProperties");
        }
    }

    @Override
    public void initializeRSAProperties() {
        if (!this.initializeRSAPropertiesCalled) {
            this.do_initializeRSAProperties();
        } else if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
            Tr.debug(tc, "RSA properties already initialized.");
        }
    }

    @Override
    public void reinitializeRSAProperties() {
        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
            Tr.debug(tc, "Reinitialize the RSA certificate/RSA token.");
        }
        super.unsetString("rsaTokenCertificateAlias");
        super.unsetObject("rsaTokenCertificate");
        super.unsetObject("rsaTokenPrivateKey");
        this.initializeRSAPropertiesCalled = false;
        this.do_initializeRSAProperties();
    }

    @Override
    public Object getObject(String key) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getObject" + this.cacheKey, key);
        }
        Object value = super.getObject(key);
        if ((key.equals("rsaTokenCertificate") || key.equals("rsaTokenPrivateKey")) && value == null) {
            this.initializeRSAPropertiesCalled = false;
            this.initializeRSAProperties();
            value = super.getObject(key);
            if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
                Tr.exit(tc, "getObject" + this.cacheKey, value);
            }
            return value;
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getObject" + this.cacheKey, value);
        }
        return value;
    }

    @Override
    public String getType() {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getType" + this.cacheKey);
        }
        if (this.type == null) {
            if (this.sco.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/security.xmi", "LTPA")) {
                this.type = "LTPA";
            } else if (this.sco.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/security.xmi", "SPNEGO")) {
                this.type = "SPNEGO";
            } else if (this.sco.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/security.xmi", "KRB5")) {
                this.type = "KRB5";
            } else if (this.sco.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/security.xmi", "RSAToken")) {
                this.type = "RSATOKEN";
            } else if (this.sco.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/security.xmi", "SWAMAuthentication")) {
                this.type = "SWAM";
            } else if (this.sco.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/security.xmi", "CustomAuthMechanism")) {
                this.type = "CUSTOM";
            } else if (tc.isDebugEnabled()) {
                Tr.error(tc, "Unknown authMechanism type");
            }
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getType" + this.cacheKey, this.type);
        }
        return this.type;
    }

    private SingleSignonConfig getLTPASingleSignon() {
        AuthMechanismConfigImpl ltpa = (AuthMechanismConfigImpl)((SecurityConfig)((Object)this.parent)).getAuthMechanism("LTPA");
        if (ltpa != null) {
            SecurityConfigObject sco_sso = ltpa.getSCO().getObject(SINGLE_SIGNON, false);
            if (sco_sso == null) {
                return null;
            }
            this.sso = new SingleSignonConfigImpl(sco_sso, this, this.cacheKey);
        }
        return this.sso;
    }

    private synchronized void do_getSingleSignon() {
        if (this.sso == null) {
            SecurityConfigObject sco_sso = this.sco.getObject(SINGLE_SIGNON, false);
            if (sco_sso == null) {
                if (this.getType().equals("KRB5") && this.krbAllowLTPAAuth) {
                    this.sso = this.getLTPASingleSignon();
                }
            } else {
                this.sso = new SingleSignonConfigImpl(sco_sso, this, this.cacheKey);
            }
        }
    }

    @Override
    public SingleSignonConfig getSingleSignon() {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getSingleSignon" + this.cacheKey);
        }
        if (this.sso == null) {
            this.do_getSingleSignon();
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getSingleSignon" + this.cacheKey, this.sso);
        }
        return this.sso;
    }

    private synchronized void do_getFilters() {
        if (this.filters == null) {
            SecurityConfigObjectList scol = this.sco.getObjectList(FILTERS);
            int size = scol.size();
            this.filters = new LinkedList();
            for (int i = 0; i < size; ++i) {
                this.filters.add(new FiltersConfigImpl(scol.get(i), this, this.cacheKey));
            }
        }
    }

    @Override
    public List<FiltersConfig> getFilters() {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getFilters" + this.cacheKey);
        }
        if (this.filters == null) {
            this.do_getFilters();
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getFilters" + this.cacheKey, this.filters);
        }
        return this.filters;
    }

    private synchronized void do_getSpnegoFilterProps() {
        String prefix = "com.ibm.ws.security.spnego.SPN";
        String hostName = null;
        String krb5Realm = null;
        String filterClass = null;
        String filterCriteria = null;
        Boolean enabledGssCredDelegate = false;
        String spnegoNotSupportedPage = null;
        String ntlmTokenReceivedPage = null;
        Boolean trimUserName = false;
        if (this.filterProps == null) {
            this.filterProps = new Properties();
            List<FiltersConfig> filters = this.getFilters();
            for (int i = 0; i < filters.size(); ++i) {
                int ix = i + 1;
                FiltersConfigImpl filter = (FiltersConfigImpl)filters.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "filter: " + filter);
                }
                if ((hostName = filter.getString("hostName")) != null && hostName.length() != 0) {
                    this.filterProps.setProperty(prefix + ix + "." + "hostName", hostName);
                }
                if ((krb5Realm = filter.getString("krb5Realm")) != null && krb5Realm.length() != 0) {
                    this.filterProps.setProperty(prefix + ix + "." + "krb5Realm", krb5Realm);
                }
                if ((filterClass = filter.getString("filterClass")) != null && filterClass.length() != 0) {
                    this.filterProps.setProperty(prefix + ix + "." + "filterClass", filterClass);
                }
                if ((filterCriteria = filter.getString("filterCriteria")) != null && filterCriteria.length() != 0) {
                    this.filterProps.setProperty(prefix + ix + "." + "filter", filterCriteria);
                }
                enabledGssCredDelegate = filter.getBoolean("enabledGssCredDelegate");
                this.filterProps.setProperty(prefix + ix + "." + "enableCredDelegate", enabledGssCredDelegate.toString());
                spnegoNotSupportedPage = filter.getString("spnegoNotSupportedPage");
                if (spnegoNotSupportedPage != null && spnegoNotSupportedPage.length() != 0) {
                    this.filterProps.setProperty(prefix + ix + "." + "spnegoNotSupportedPage", spnegoNotSupportedPage);
                }
                if ((ntlmTokenReceivedPage = filter.getString("ntlmTokenReceivedPage")) != null && ntlmTokenReceivedPage.length() != 0) {
                    this.filterProps.setProperty(prefix + ix + "." + "ntlmTokenReceivedPage", ntlmTokenReceivedPage);
                }
                trimUserName = filter.getBoolean("trimUserName");
                this.filterProps.setProperty(prefix + ix + "." + "trimUserName", trimUserName.toString());
                if (!SecurityConfigGlobals.enableVerbose || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "SPN" + ix + ": " + this.filterProps);
            }
        }
    }

    @Override
    public Properties getSpnegoFilterProps() {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getSpnegoFilterProps");
        }
        if (this.filterProps == null) {
            this.do_getSpnegoFilterProps();
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getSpnegoFilterProps " + this.filterProps);
        }
        return this.filterProps;
    }

    @Override
    public String getString(String key) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getString() key=" + key + " " + this.cacheKey);
        }
        String returnValue = null;
        returnValue = key == "OID" || key.equals("OID") ? (this.authMechOID != null && !this.authMechOID.equals("") ? this.authMechOID : (this.authMechOID = super.getString(key))) : super.getString(key);
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getString" + this.cacheKey, returnValue);
        }
        return returnValue;
    }

    public String getDefaultRealm(String krb5Config) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultRealm");
        }
        String defaultKrb5Realm = null;
        try {
            if (krb5Config == null || krb5Config.length() == 0) {
                krb5Config = SecurityObjectLocator.getSecurityConfig().getAuthMechanism("KRB5").getString("krb5Config");
            }
            if (krb5Config != null && krb5Config.length() > 0) {
                Config krb5Cfg = Config.getInstance();
                Config.refresh();
                krb5Cfg = Config.getInstance();
                defaultKrb5Realm = krb5Cfg.getDefaultRealm();
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.config.AuthMechanismConfigImpl.getDefaultRealm", "1081");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, e.getMessage(), new Object[]{e});
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultRealm " + defaultKrb5Realm);
        }
        return defaultKrb5Realm;
    }

    public String getDefaultKeytab(String krb5Config) throws Exception {
        String defaultKrb5Keytab;
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getDefaultKeytab");
            }
            defaultKrb5Keytab = null;
            String keytab = null;
            try {
                if (krb5Config == null || krb5Config.length() == 0) {
                    krb5Config = SecurityObjectLocator.getSecurityConfig().getAuthMechanism("KRB5").getString("krb5Config");
                }
                if (krb5Config != null && krb5Config.length() > 0) {
                    Config krb5Cfg = Config.getInstance();
                    Config.refresh();
                    krb5Cfg = Config.getInstance();
                    keytab = krb5Cfg.getDefault("default_keytab_name", "libdefaults");
                }
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.security.config.AuthMechanismConfigImpl.getDefaultKeytab", "1120");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, e.getMessage(), new Object[]{e});
                }
                throw e;
            }
            if (keytab != null && keytab.length() > 0 && ((defaultKrb5Keytab = keytab.substring(keytab.indexOf(":") + 1, keytab.length())) == null || defaultKrb5Keytab.length() == 0)) {
                defaultKrb5Keytab = keytab;
            }
            if (defaultKrb5Keytab != null && defaultKrb5Keytab.length() > 0) {
                try {
                    KeyTab.getInstance((String)defaultKrb5Keytab);
                    KeyTab.refresh();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Reloaded the keytab file");
                    }
                }
                catch (IOException e) {
                    FFDCFilter.processException(e, "com.ibm.ws.security.config.AuthMechanismConfigImpl.getDefaultKeytab", "1139");
                    if (!tc.isDebugEnabled()) break block12;
                    Tr.debug(tc, e.getMessage(), new Object[]{e});
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultKeytab " + defaultKrb5Keytab);
        }
        return defaultKrb5Keytab;
    }

    public void setKrbConfigProp(String krb5Config) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setKrbConfigProp");
        }
        if (krb5Config != null && krb5Config.length() != 0) {
            String cf;
            block9: {
                final String inKrb5Config = krb5Config;
                cf = AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        String property = "java.security.krb5.conf";
                        String c = System.getProperty("java.security.krb5.conf");
                        System.setProperty("java.security.krb5.conf", inKrb5Config);
                        return c;
                    }
                });
                try {
                    int clockSkew;
                    Config krb5Cfg = Config.getInstance();
                    Config.refresh();
                    krb5Cfg = Config.getInstance();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Reloaded the kerberos config file.");
                    }
                    if ((clockSkew = krb5Cfg.getDefaultIntValue("clockskew")) > 0) {
                        this.KRB5_CLOCK_SKEW = clockSkew * 1000;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The kerberos clock skew in milliseconds is " + this.KRB5_CLOCK_SKEW);
                    }
                }
                catch (Exception e) {
                    FFDCFilter.processException(e, "com.ibm.ws.security.config.AuthMechanismConfigImpl.setKrbConfigProp", "1189");
                    if (!tc.isDebugEnabled()) break block9;
                    Tr.debug(tc, e.getMessage(), new Object[]{e});
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "java.security.krb5.conf property previous: " + (cf != null ? cf : "<null>") + " and now: " + krb5Config);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setKrbConfigProp");
        }
    }

    public static void setUseAllCredsProp() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setUseAllCredsProp");
        }
        String prop = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                String property = "javax.security.auth.useAllCreds";
                String oldValue = System.getProperty("javax.security.auth.useAllCreds");
                System.setProperty("javax.security.auth.useAllCreds", "true");
                return oldValue;
            }
        });
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "javax.security.auth.useAllCreds property previous: " + (prop != null ? prop : "<null>") + " and now: true");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setUseAllCredsProp");
        }
    }

    public static void setKrbKeytabProp(String krb5Keytab) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setKrbKeytabProp");
        }
        if (krb5Keytab != null && krb5Keytab.length() != 0) {
            String kt;
            block7: {
                final String inKrb5Keytab = krb5Keytab;
                kt = (String)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        String k = System.getProperty("KRB5_KTNAME");
                        System.setProperty("KRB5_KTNAME", inKrb5Keytab);
                        return k;
                    }
                });
                try {
                    KeyTab.getInstance((String)krb5Keytab);
                    KeyTab.refresh();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Reloaded the keytab file");
                    }
                }
                catch (IOException e) {
                    FFDCFilter.processException(e, "com.ibm.ws.security.config.AuthMechanismConfigImpl.setKrbKeytabProp", "1252");
                    if (!tc.isDebugEnabled()) break block7;
                    Tr.debug(tc, e.getMessage(), new Object[]{e});
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "KRB5_KTNAME property previous: " + (kt != null ? kt : "<null>") + " and now: " + krb5Keytab);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setKrbKeytabProp");
        }
    }

    @Override
    public String toString() {
        return "type=" + this.type + " " + super.toString();
    }

    @Override
    public int getKrb5ClockSkew() {
        return this.KRB5_CLOCK_SKEW;
    }
}

