/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.security.config.AuditConfig;
import com.ibm.ws.security.config.AuditKeystoreConfig;
import com.ibm.ws.security.config.AuditKeystoreConfigImpl;
import com.ibm.ws.security.config.GenericConfigHelperImpl;
import com.ibm.ws.security.config.SecurityConfigGlobals;
import com.ibm.ws.security.config.SecurityConfigObject;
import com.ibm.ws.security.config.SecurityConfigObjectImpl;
import com.ibm.ws.security.config.SecurityConfigObjectList;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.security.audit.AuditEventFactory;
import com.ibm.wsspi.security.audit.AuditServiceProvider;
import java.io.File;
import java.security.ProviderException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuditConfigImpl
extends GenericConfigHelperImpl
implements AuditConfig {
    private static final String AUDIT_POLICY_OBJ = "auditPolicy";
    private static final String AUDIT_MONITOR_OBJ = "auditNotificationMonitor";
    private static final String ENCRYPTION_CERT_OBJ = "encryptionCert";
    private static final String KEY_STORES = "keyStores";
    private static final TraceComponent tc = Tr.register(AuditConfigImpl.class, "SecurityConfig", "com.ibm.ejs.resources.security");
    private List<AuditKeystoreConfig> auditKeystores = null;
    private static final int maximpls = 10;
    private HashMap<String, AuditEventFactory> _factory = new HashMap(10);
    private HashMap<String, AuditServiceProvider> _provider = new HashMap(10);
    private HashMap<String, List<AuditServiceProvider>> _factoryProviderMapping = new HashMap(10);

    public AuditConfigImpl(SecurityConfigObject obj, String _cacheKey) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "ctor " + _cacheKey, obj);
        }
        super.initialize(obj, null, _cacheKey);
        this.initialize_defaults();
        this.initialization();
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "ctor " + this.cacheKey, this);
        }
    }

    private void initialize_defaults() {
        this.defaults.put("auditEnabled", Boolean.FALSE);
        this.defaults.put("encrypt", Boolean.FALSE);
        this.defaults.put("sign", Boolean.FALSE);
        this.defaults.put("verbose", Boolean.FALSE);
        this.defaults.put("batching", Boolean.FALSE);
        this.defaults.put(AUDIT_POLICY_OBJ, "NOWARN");
        this.defaults.put("com.ibm.audit.report.granularity", "low");
        this.defaults.put("auditMonitorEnabled", Boolean.FALSE);
    }

    private void initialization() {
        SecurityConfigObject am;
        SecurityConfigObject ap;
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "initialization " + this.cacheKey);
        }
        if ((ap = this.sco.getObject(AUDIT_POLICY_OBJ)) != null) {
            if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                Tr.debug(tc, "Extracting data from auditPolicy");
            }
            this.setBoolean("auditEnabled", ap.getBoolean("auditEnabled", (Boolean)this.defaults.get("auditEnabled")));
            this.setBoolean("encrypt", ap.getBoolean("encrypt", (Boolean)this.defaults.get("encrypt")));
            this.setBoolean("sign", ap.getBoolean("sign", (Boolean)this.defaults.get("sign")));
            this.setBoolean("verbose", ap.getBoolean("verbose", (Boolean)this.defaults.get("verbose")));
            this.setBoolean("batching", ap.getBoolean("batching", (Boolean)this.defaults.get("batching")));
            this.setString(AUDIT_POLICY_OBJ, ap.getString(AUDIT_POLICY_OBJ, (String)this.defaults.get(AUDIT_POLICY_OBJ)));
            this.setString("securityXmlSignerKeyStoreName", ap.getString("securityXmlSignerKeyStoreName", null));
            this.setString("securityXmlSignerCertAlias", ap.getString("securityXmlSignerCertAlias", null));
            this.setString("securityXmlSignerScopeName", ap.getString("securityXmlSignerScopeName", null));
            this.setString("auditorId", ap.getString("auditorId", null));
            String passwd = null;
            try {
                passwd = ap.getString("auditorPwd", null);
            }
            catch (Exception e) {
                passwd = ap.getUnexpandedString("auditorPwd", null);
            }
            this.setString("auditorPwd", passwd);
            SecurityConfigObject ec = ap.getObject(ENCRYPTION_CERT_OBJ);
            if (ec != null) {
                if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Extracting data from encryptionCert");
                }
                this.setString("encryptionCertName", ec.getString("alias", null));
            }
            List props = ap.getObjectList("properties").getList();
            if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                Tr.entry(tc, "CUSTOM PROPERTIES: " + props.toString());
            }
            if (props != null) {
                for (int i = 0; i < props.size(); ++i) {
                    ConfigObject prop = (ConfigObject)props.get(i);
                    String name = prop.getString("name", null);
                    String value = prop.getString("value", null);
                    if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                        Tr.debug(tc, "custom property: name: " + name + " value: " + value);
                    }
                    if (!name.equals("com.ibm.audit.report.granularity")) continue;
                    this.setString("com.ibm.audit.report.granularity", value);
                }
            }
        }
        if ((am = this.sco.getObject(AUDIT_MONITOR_OBJ)) != null) {
            if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                Tr.debug(tc, "Extracting data from auditNotificationMonitor");
            }
            this.setString("auditMonitorName", am.getString("name", null));
            this.setBoolean("auditMonitorEnabled", am.getBoolean("enabled", (Boolean)this.defaults.get("auditMonitorEnabled")));
            SecurityConfigObject notification = am.getObject("wsNotification");
            if (notification != null) {
                this.setBoolean("auditNotificationSendEmail", notification.getBoolean("sendEmail"));
                this.setString("auditNotificationEmailList", notification.getString("emailList"));
            }
        }
        if (!this.getString(AUDIT_POLICY_OBJ).equalsIgnoreCase("NOWARN") && am == null) {
            Tr.error(tc, "security.audit.notify.config.error");
            throw new ProviderException("Audit notification not configured properly.");
        }
        if (tc.isDebugEnabled()) {
            super.dumpGeneratedData();
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "initialization " + this.cacheKey);
        }
    }

    @Override
    public AuditKeystoreConfig getActiveAuditKeystore() {
        SecurityConfigObject ks;
        SecurityConfigObject ec;
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getActiveAuditKeystore " + this.cacheKey);
        }
        AuditKeystoreConfigImpl aks = null;
        SecurityConfigObject ap = this.sco.getObject(AUDIT_POLICY_OBJ);
        if (ap != null && (ec = ap.getObject(ENCRYPTION_CERT_OBJ)) != null && (ks = ec.getObject("keyStore")) != null) {
            aks = new AuditKeystoreConfigImpl(ks, this, this.cacheKey);
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getActiveAuditKeystore " + this.cacheKey);
        }
        return aks;
    }

    @Override
    public AuditKeystoreConfig getAuditKeystore(String name) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getAuditKeystore " + this.cacheKey);
        }
        AuditKeystoreConfigImpl aks = null;
        SecurityConfigObjectList ks = this.sco.getObjectList(KEY_STORES);
        if (ks != null && ks.size() > 0) {
            for (int i = 0; i < ks.size(); ++i) {
                SecurityConfigObject keyS = ks.get(i);
                String ksName = keyS.getString("name");
                if (!ksName.equals(name)) continue;
                aks = new AuditKeystoreConfigImpl(keyS, this, this.cacheKey);
            }
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getAuditKeystore " + this.cacheKey, aks);
        }
        return aks;
    }

    private synchronized void do_getAuditKeystores() {
        SecurityConfigObjectList scol;
        if (this.auditKeystores == null && (scol = this.sco.getObjectList(KEY_STORES)) != null) {
            int size = scol.size();
            this.auditKeystores = new LinkedList<AuditKeystoreConfig>();
            for (int i = 0; i < size; ++i) {
                this.auditKeystores.add(new AuditKeystoreConfigImpl(scol.get(i), this, this.cacheKey));
            }
        }
    }

    @Override
    public List<AuditKeystoreConfig> getAuditKeystores() {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getAuditKeystores " + this.cacheKey);
        }
        if (this.auditKeystores == null) {
            this.do_getAuditKeystores();
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getAuditKeystores " + this.cacheKey);
        }
        return this.auditKeystores;
    }

    public void setActive(String factoryName, String auditEventType, String auditOutcome) {
        if (this._factory == null) {
            return;
        }
        AuditEventFactory factory = this._factory.get(factoryName);
        if (factory != null) {
            factory.setActive(auditEventType, auditOutcome);
        }
    }

    public void setActiveProviderSpec(String providerName, String auditEventType, String auditOutcome) {
        if (this._provider == null) {
            return;
        }
        AuditServiceProvider provider = this._provider.get(providerName);
        if (provider != null) {
            provider.setActiveProviderSpec(auditEventType, auditOutcome);
        }
    }

    @Override
    public Map getFactoriesAndProviders(HashMap context, Map keyStoreProps, boolean failOnIncompleteConfig) throws Exception {
        SecurityConfigObject aP;
        SecurityConfigObjectList fList;
        List factories;
        HashMap<String, Boolean> _secProps = null;
        AuditServiceProvider _providerObj = null;
        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
            Tr.entry(tc, "getFactoriesAndProviders " + this.cacheKey, new Object[]{context, keyStoreProps, failOnIncompleteConfig});
        }
        if ((factories = (fList = (aP = this.sco.getObject(AUDIT_POLICY_OBJ)).getObjectList("auditEventFactories")).getList()) != null && factories.size() > 0) {
            for (int i = 0; i < fList.size(); ++i) {
                String factoryClass;
                SecurityConfigObject ef = fList.get(i);
                String factoryName = ef.getString("name");
                if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                    Tr.debug(tc, "FactoryName = " + factoryName);
                }
                if ((factoryClass = ef.getString("className")).length() > 0) {
                    try {
                        String providerClass;
                        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                            Tr.debug(tc, "FactoryClass = " + factoryClass);
                        }
                        Class<?> c = null;
                        try {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Trying to load class: " + factoryClass);
                            }
                            c = Class.forName(factoryClass);
                        }
                        catch (ClassNotFoundException cn) {
                            try {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Trying to load class: " + factoryClass + " with contextClassLoader");
                                }
                                c = Class.forName(factoryClass, true, Thread.currentThread().getContextClassLoader());
                            }
                            catch (ClassNotFoundException cn1) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Trying to load class: " + factoryClass + " with extClassLoader");
                                }
                                c = Class.forName(factoryClass, true, ExtClassLoader.getInstance());
                            }
                        }
                        AuditEventFactory factory = null;
                        if (c != null) {
                            factory = (AuditEventFactory)c.newInstance();
                        }
                        HashMap<String, String> efProps = new HashMap<String, String>();
                        SecurityConfigObjectList eventFactoryProperties = ef.getObjectList("properties");
                        if (eventFactoryProperties != null && eventFactoryProperties.size() > 0) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "props = " + eventFactoryProperties);
                            }
                            for (int j = 0; j < eventFactoryProperties.size(); ++j) {
                                SecurityConfigObject property = eventFactoryProperties.get(j);
                                if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "name: " + property.getString("name") + " value: " + property.getString("value"));
                                }
                                efProps.put(property.getString("name"), property.getString("value"));
                            }
                        }
                        factory.init(factoryName, efProps, context);
                        this._factory.put(factoryName, factory);
                        SecurityConfigObjectList eventFactoryAuditSpecs = ef.getObjectList("auditSpecifications");
                        for (int k = 0; k < eventFactoryAuditSpecs.size(); ++k) {
                            SecurityConfigObject spec = eventFactoryAuditSpecs.get(k);
                            if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                                Tr.debug(tc, "factory spec[" + k + "]: " + spec.toString());
                            }
                            Boolean enabledFlag = spec.getBoolean("enabled");
                            if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                                Tr.debug(tc, "enabledFlag: " + enabledFlag.toString());
                            }
                            if (!enabledFlag.booleanValue()) continue;
                            ConfigObject rcsObject = ((SecurityConfigObjectImpl)spec).getConfigObject();
                            if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                                Tr.debug(tc, "rcsObject = " + rcsObject.toString());
                            }
                            List nameList = rcsObject.getStringList("event");
                            if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                                Tr.debug(tc, "nameList = " + nameList.toString());
                            }
                            List outcomeList = rcsObject.getStringList("outcome");
                            if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                                Tr.debug(tc, "outcomeList = " + outcomeList.toString());
                            }
                            Iterator nIt = nameList.iterator();
                            while (nIt.hasNext()) {
                                Iterator oIt = outcomeList.iterator();
                                String event = nIt.next().toString();
                                while (oIt.hasNext()) {
                                    String outcome = oIt.next().toString();
                                    if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Setting event factory name: " + factoryName + " factoryClass: " + factoryClass + " Filter: event: " + event + " outcome: " + outcome);
                                    }
                                    this.setActive(factoryName, event, outcome);
                                }
                            }
                        }
                        SecurityConfigObject sp = ef.getObject("auditServiceProvider");
                        String providerName = sp.getString("name");
                        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                            Tr.debug(tc, "ProviderName = " + providerName);
                        }
                        if ((providerClass = sp.getString("className")).equals("com.ibm.ws.security.audit.BinaryEmitterImpl")) {
                            File file;
                            String fileLocation;
                            String maxLogs;
                            String maxFileSize;
                            block80: {
                                maxFileSize = sp.getString("maxFileSize");
                                maxLogs = sp.getString("maxLogs");
                                fileLocation = null;
                                try {
                                    fileLocation = sp.getUnexpandedString("fileLocation");
                                }
                                catch (Exception e) {
                                    fileLocation = sp.getString("fileLocation");
                                }
                                if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "FILELOCATION: " + fileLocation);
                                }
                                int index = fileLocation.indexOf("$(LOG_ROOT)");
                                if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "fileLocation: " + fileLocation + " index: " + index);
                                }
                                if (index != -1) {
                                    String firstPart = fileLocation.substring(0, index);
                                    String lastPart = fileLocation.substring(index + "$(LOG_ROOT)".length());
                                    if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                                        Tr.debug(tc, "processing LOG_ROOT, firstPart: " + firstPart + " lastPart: " + lastPart);
                                    }
                                    String userRoot = System.getProperty("user.install.root");
                                    if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                                        Tr.debug(tc, "User install root: " + userRoot);
                                    }
                                    String logRoot = userRoot + File.separator + "logs" + File.separator;
                                    if (userRoot != null) {
                                        fileLocation = firstPart != null && !firstPart.equals("") ? firstPart + logRoot + lastPart : logRoot + lastPart;
                                    }
                                    if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                                        Tr.debug(tc, "fileLocation 1: " + fileLocation);
                                    }
                                    if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                                        Tr.debug(tc, "lastPart.length: " + lastPart.length());
                                    }
                                    if (lastPart.length() == 0) {
                                        String sName = (String)context.get("server");
                                        fileLocation = fileLocation.endsWith(File.separator) ? fileLocation + sName : fileLocation + File.separator + sName;
                                    }
                                    if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                                        Tr.debug(tc, "adjusted fileLocation after massaging logRoot: " + fileLocation);
                                    }
                                } else {
                                    String sName = (String)context.get("server");
                                }
                                if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "final fileLocation: " + fileLocation);
                                }
                                file = null;
                                try {
                                    file = new File(fileLocation);
                                }
                                catch (Exception fe) {
                                    if (!SecurityConfigGlobals.enableVerbose || !tc.isDebugEnabled()) break block80;
                                    Tr.debug(tc, "caught exception doing a new file: " + fe.getMessage());
                                }
                            }
                            if (!file.exists()) {
                                if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "could not do a new file for fileLocation: " + fileLocation);
                                }
                                try {
                                    file.mkdirs();
                                }
                                catch (Exception e) {
                                    Tr.error(tc, "security.audit.service.loading.error", new Object[]{"AuditServiceProvider", providerName, providerClass});
                                    throw new MissingResourceException("Cannot load AuditServiceProvider name: " + providerName + " Class name: " + providerClass + " at audit log location: " + fileLocation, providerClass, providerName);
                                }
                            }
                            if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                                Tr.debug(tc, "maxFileSize: " + maxFileSize + " maxLogs: " + maxLogs + " fileLocation: " + fileLocation);
                            }
                            if (_secProps == null) {
                                _secProps = new HashMap();
                            }
                            _secProps.put("maxFileSize", (Boolean)((Object)maxFileSize));
                            _secProps.put("maxLogs", (Boolean)((Object)maxLogs));
                            _secProps.put("fileLocation", (Boolean)((Object)fileLocation));
                        }
                        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                            Tr.debug(tc, "ProviderClass = " + providerClass);
                        }
                        if (providerClass.length() > 0) {
                            try {
                                try {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Trying to load class: " + providerClass);
                                    }
                                    c = Class.forName(providerClass);
                                }
                                catch (ClassNotFoundException cn) {
                                    try {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Trying to load class: " + providerClass + " with contextClassLoader");
                                        }
                                        c = Class.forName(providerClass, true, Thread.currentThread().getContextClassLoader());
                                    }
                                    catch (ClassNotFoundException cn1) {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Trying to load class: " + providerClass + " with extClassLoader");
                                        }
                                        c = Class.forName(providerClass, true, ExtClassLoader.getInstance());
                                    }
                                }
                                if (c != null) {
                                    _providerObj = (AuditServiceProvider)c.newInstance();
                                }
                                HashMap<String, String> spProps = new HashMap<String, String>();
                                SecurityConfigObjectList serviceProviderProperties = sp.getObjectList("properties");
                                if (serviceProviderProperties != null && serviceProviderProperties.size() > 0) {
                                    if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                                        Tr.debug(tc, "service props = " + serviceProviderProperties);
                                    }
                                    for (int j = 0; j < serviceProviderProperties.size(); ++j) {
                                        SecurityConfigObject property = serviceProviderProperties.get(j);
                                        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                                            Tr.debug(tc, "name: " + property.getString("name") + " value: " + property.getString("value"));
                                        }
                                        spProps.put(property.getString("name"), property.getString("value"));
                                    }
                                }
                                if (_secProps == null) {
                                    _secProps = new HashMap<String, Boolean>();
                                }
                                _secProps.put("encrypt", this.getBoolean("encrypt"));
                                _secProps.put("sign", this.getBoolean("sign"));
                                _providerObj.init(providerName, spProps, _secProps, keyStoreProps);
                            }
                            catch (Exception e) {
                                Tr.error(tc, "security.audit.service.loading.error", new Object[]{"AuditServiceProvider", providerName, providerClass});
                                throw e;
                            }
                            Tr.info(tc, "security.audit.service.provider.info", new Object[]{"AuditServiceProvider", providerName, providerClass});
                        } else {
                            Tr.error(tc, "security.audit.service.invalid.error", new Object[]{"com.ibm.wsspi.security.audit.auditServiceProvider", providerName, providerClass});
                        }
                        this._provider.put(providerName, _providerObj);
                        List<AuditServiceProvider> pList = new ArrayList<AuditServiceProvider>();
                        if (this._factoryProviderMapping.containsKey(factoryName)) {
                            pList = this._factoryProviderMapping.get(factoryName);
                        }
                        pList.add(_providerObj);
                        this._factoryProviderMapping.put(factoryName, pList);
                        SecurityConfigObjectList providerAuditSpecs = sp.getObjectList("auditSpecifications");
                        for (int k = 0; k < providerAuditSpecs.size(); ++k) {
                            SecurityConfigObject spec = providerAuditSpecs.get(k);
                            if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                                Tr.debug(tc, "service spec: " + spec.toString());
                            }
                            Boolean enabledFlag = spec.getBoolean("enabled");
                            if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                                Tr.debug(tc, "enabledFlag: " + enabledFlag.toString());
                            }
                            if (!enabledFlag.booleanValue()) continue;
                            ConfigObject rcsObject = ((SecurityConfigObjectImpl)spec).getConfigObject();
                            List nameList = rcsObject.getStringList("event");
                            List outcomeList = rcsObject.getStringList("outcome");
                            Iterator nIt = nameList.iterator();
                            while (nIt.hasNext()) {
                                Iterator oIt = outcomeList.iterator();
                                String event = nIt.next().toString();
                                while (oIt.hasNext()) {
                                    String outcome = oIt.next().toString();
                                    if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Setting service provider name: " + providerName + " providerClass: " + providerClass + " Filter: event: " + event + " outcome: " + outcome);
                                    }
                                    this.setActiveProviderSpec(providerName, event, outcome);
                                }
                            }
                        }
                    }
                    catch (Exception e1) {
                        Tr.error(tc, "security.audit.service.loading.error", new Object[]{"AuditEventFactory", factoryName, factoryClass});
                        throw new Exception(e1);
                    }
                    Tr.info(tc, "security.audit.service.provider.info", new Object[]{"AuditEventFactory", factoryName, factoryClass});
                    continue;
                }
                Tr.error(tc, "security.audit.service.invalid.error", new Object[]{"com.ibm.wsspi.security.audit.auditEventFactory", factories, factoryClass});
            }
        } else {
            Tr.warning(tc, "security.audit.service.missing.warning", new Object[]{"com.ibm.wsspi.security.audit.auditEventFactory"});
        }
        HashMap<String, HashMap<String, Object>> fpmap = new HashMap<String, HashMap<String, Object>>();
        fpmap.put("factories", this._factory);
        fpmap.put("providers", this._provider);
        fpmap.put("mapping", this._factoryProviderMapping);
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getFactoriesAndProviders " + this.cacheKey, fpmap);
        }
        return fpmap;
    }
}

