/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth;

import com.ibm.ISecurityUtilityImpl.RealmSecurityName;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.security.auth.SerialDeserialSubjectException;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.auth.WSCredentialImpl;
import com.ibm.ws.security.common.auth.WSPrincipalImpl;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.security.token.Token;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import javax.security.auth.AuthPermission;
import javax.security.auth.Subject;

public class WSLoginHelperImpl {
    private static Hashtable asynchSubjectCache = new Hashtable();
    private static final Class thisClass = WSLoginHelperImpl.class;
    private static final AuthPermission GET_SUBJECT_PERMISSION = new AuthPermission("getSubject");
    private static final PrivilegedExceptionAction getSubjectAction = new PrivilegedExceptionAction(){

        public Object run() throws WSSecurityException, GeneralSecurityException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getSubjectAction.run()");
            }
            Subject invocation_subject = null;
            Subject caller_subject = null;
            ContextManager ctxMgr = ContextManagerFactory.getInstance();
            invocation_subject = ctxMgr.getInvocationSubject();
            caller_subject = ctxMgr.getCallerSubject();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSubjectAction.run()", new Object[]{new Boolean(invocation_subject != null), new Boolean(caller_subject != null)});
            }
            return new Subject[]{invocation_subject, caller_subject};
        }
    };
    private static final PrivilegedExceptionAction getNonForwardableSubjectAction = new PrivilegedExceptionAction(){

        public Object run() throws WSSecurityException, GeneralSecurityException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getNonForwardableSubjectAction.run()");
            }
            Subject invocation_subject = null;
            Subject caller_subject = null;
            Object cred = null;
            Object creds = null;
            Subject subj = null;
            ContextManager ctxMgr = ContextManagerFactory.getInstance();
            subj = ctxMgr.getInvocationSubject();
            if (subj != null) {
                invocation_subject = this.createNonForwardableSubjectFromSubject(subj);
            }
            subj = null;
            subj = ctxMgr.getCallerSubject();
            if (subj != null) {
                caller_subject = this.createNonForwardableSubjectFromSubject(subj);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSubjectAction.run()");
            }
            return new Subject[]{invocation_subject, caller_subject};
        }

        private Subject createNonForwardableSubjectFromSubject(Subject subj) throws WSSecurityException, GeneralSecurityException {
            Set<Principal> principals;
            Set<Object> privateCredentials;
            String createTokenSubjectForAsynchLogin;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createNonForwardableSubjectFromSubject");
            }
            if ((createTokenSubjectForAsynchLogin = ContextManagerFactory.getInstance().getProperty("com.ibm.ws.security.createTokenSubjectForAsynchLogin", "false")) != null && (createTokenSubjectForAsynchLogin.equalsIgnoreCase("yes") || createTokenSubjectForAsynchLogin.equalsIgnoreCase("true"))) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createNonForwardableSubjectFromSubject (createTokenSubjectForAsynchLogin=true)");
                }
                return subj;
            }
            Subject subject = new Subject();
            WSCredentialImpl cred = null;
            WSCredentialImpl urCred = null;
            WSCredentialImpl newCred = null;
            Hashtable table = null;
            Set<Object> publicCredentials = subj.getPublicCredentials();
            if (publicCredentials != null && publicCredentials.size() > 0) {
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Got some public credentials to iterate through.");
                }
                for (Object obj : publicCredentials) {
                    if (obj == null || obj instanceof Token) continue;
                    cred = null;
                    urCred = null;
                    newCred = null;
                    if (tc.isEntryEnabled()) {
                        Tr.debug(tc, "public credentials:" + obj);
                    }
                    if (obj instanceof WSCredentialImpl) {
                        cred = (WSCredentialImpl)obj;
                    }
                    if (cred != null && cred.isForwardable()) {
                        table = cred.getTable();
                        urCred = new WSCredentialImpl(cred.getRealmName(), cred.getSecurityName(), cred.getUniqueSecurityName(), cred.getPrimaryGroupId(), cred.getAccessId(), cred.getRoles(), cred.getGroupIds());
                        newCred = new WSCredentialImpl((WSCredential)urCred, cred.getOID(), new byte[0], false, 0L);
                        newCred.setTable(table);
                        subject.getPublicCredentials().add(newCred);
                        continue;
                    }
                    subject.getPublicCredentials().add(obj);
                }
            }
            if ((privateCredentials = subj.getPrivateCredentials()) != null && privateCredentials.size() > 0) {
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Got some private credentials to iterate through.");
                }
                for (Object obj : privateCredentials) {
                    if (obj == null || obj instanceof Token) continue;
                    cred = null;
                    urCred = null;
                    newCred = null;
                    if (tc.isEntryEnabled()) {
                        Tr.debug(tc, "private credentials:" + obj);
                    }
                    if (obj instanceof WSCredentialImpl) {
                        cred = (WSCredentialImpl)obj;
                    }
                    if (cred != null && cred.isForwardable()) {
                        table = cred.getTable();
                        urCred = new WSCredentialImpl(cred.getRealmName(), cred.getSecurityName(), cred.getUniqueSecurityName(), cred.getPrimaryGroupId(), cred.getAccessId(), cred.getRoles(), cred.getGroupIds());
                        newCred = new WSCredentialImpl((WSCredential)urCred, cred.getOID(), new byte[0], false, 0L);
                        newCred.setTable(table);
                        subject.getPrivateCredentials().add(newCred);
                        continue;
                    }
                    subject.getPrivateCredentials().add(obj);
                }
            }
            if ((principals = subj.getPrincipals()) != null && principals.size() > 0) {
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Got some principals to iterate through.");
                }
                for (Principal obj : principals) {
                    if (obj == null) continue;
                    if (tc.isEntryEnabled()) {
                        Tr.debug(tc, "principal:" + obj);
                    }
                    subject.getPrincipals().add(obj);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createNonForwardableSubjectFromSubject");
            }
            return subject;
        }
    };
    private static final PrivilegedExceptionAction getSerializableSubjectAction = new PrivilegedExceptionAction(){

        public Object run() throws WSSecurityException, GeneralSecurityException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getSerializableSubjectAction.run()");
            }
            Subject invocation_subject = null;
            Subject caller_subject = null;
            WSCredential cred = null;
            WSCredential[] creds = null;
            ContextManager ctxMgr = ContextManagerFactory.getInstance();
            cred = ctxMgr.getInvocationCredential();
            if (cred != null) {
                invocation_subject = this.createSubjectFromWSCredential(cred);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invocation credential is null.");
            }
            creds = ctxMgr.getCallerCredentials();
            if (creds != null && creds[0] != null) {
                caller_subject = this.createSubjectFromWSCredential(cred);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Caller credential is null.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSerializableSubjectAction.run()");
            }
            return new Subject[]{invocation_subject, caller_subject};
        }

        private Subject createSubjectFromWSCredential(WSCredential cred) throws WSSecurityException, GeneralSecurityException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getSerializableSubjectAction.createSubjectFromWSCredential()");
            }
            Subject subject = null;
            if (cred != null) {
                subject = new Subject();
                WSPrincipal wsPrin = ContextManagerFactory.getInstance().createPrincipal(cred);
                subject.getPrincipals().add(wsPrin);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "credential is null, null Subject is returned");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSerializableSubjectAction.createSubjectFromWSCredential()");
            }
            return subject;
        }
    };
    private static final PrivilegedExceptionAction getUnauthSubjectAction = new PrivilegedExceptionAction(){

        public Object run() throws GeneralSecurityException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getUnauthSubjectAction.run()");
            }
            Subject subject = null;
            ContextManager ctxMgr = ContextManagerFactory.getInstance();
            WSCredential cred = ctxMgr.getUnauthenticatedCredential();
            if (cred != null) {
                subject = new Subject();
                WSPrincipal wsPrin = ctxMgr.createPrincipal(cred);
                subject.getPrincipals().add(wsPrin);
                subject.getPublicCredentials().add(cred);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No unauthenticated credential, null Subject is returned");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUnauthSubjectAction.run()");
            }
            return subject;
        }
    };
    private static final PrivilegedExceptionAction getSerializableUnauthSubjectAction = new PrivilegedExceptionAction(){

        public Object run() throws GeneralSecurityException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getSerializableUnauthSubjectAction.run()");
            }
            Subject subject = null;
            ContextManager ctxMgr = ContextManagerFactory.getInstance();
            WSCredential cred = ctxMgr.getUnauthenticatedCredential();
            if (cred != null) {
                subject = new Subject();
                WSPrincipal wsPrin = ctxMgr.createPrincipal(cred);
                subject.getPrincipals().add(wsPrin);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No unauthenticated credential, null Subject is returned");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSerializableUnauthSubjectAction.run()");
            }
            return subject;
        }
    };
    private static final TraceComponent tc = Tr.register(WSLoginHelperImpl.class, null, "com.ibm.ejs.resources.security");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WSCredential authenticate(String username, String realmname, String password) throws WSSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "authenticate(username = \"" + username + "\", realmname = \"" + realmname + "\", password = \"XXXXXXXX\")");
        }
        WSLoginHelperImpl.disableAuthRetryForThread();
        WSCredential ret = null;
        try {
            ContextManager ctxMgr = ContextManagerFactory.getInstance();
            if (ctxMgr.isCellSecurityEnabled()) {
                ret = ctxMgr.authenticate(realmname, username, password);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Security is disabled, no authentication is performed, null credential will be returned");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "authenticate(username, realmname, password)");
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            WSLoginHelperImpl.enableAuthRetryForThread();
            throw throwable;
        }
        WSLoginHelperImpl.enableAuthRetryForThread();
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WSCredential validate(byte[] credToken) throws WSSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate(credToken)");
        }
        WSLoginHelperImpl.disableAuthRetryForThread();
        WSCredential ret = null;
        try {
            ContextManager ctxMgr = ContextManagerFactory.getInstance();
            if (ctxMgr.isCellSecurityEnabled()) {
                ret = ctxMgr.authenticate(WSLoginHelperImpl.getDefaultRealmName(), credToken);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Security is disabled, no validation is performed, null credential will be returned");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validate(credToken)");
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            WSLoginHelperImpl.enableAuthRetryForThread();
            throw throwable;
        }
        WSLoginHelperImpl.enableAuthRetryForThread();
        return ret;
    }

    public static Subject getSubject() throws WSSecurityException {
        Subject[] subject_list;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSubject()");
        }
        if ((subject_list = WSLoginHelperImpl.getSubjects()) != null && subject_list[0] != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSubject()");
            }
            return subject_list[0];
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSubject() - null Subject returned.");
        }
        return null;
    }

    public static Subject[] getSubjects() throws WSSecurityException {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSubject()");
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(GET_SUBJECT_PERMISSION);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Java 2 Security Permission Check passed");
            }
        }
        Subject[] subject_array = null;
        if (ContextManagerFactory.getInstance().isCellSecurityEnabled()) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Getting invocation and caller subjects from thread.");
                }
                subject_array = (Subject[])AccessController.doPrivileged(getSubjectAction);
            }
            catch (PrivilegedActionException pae) {
                Exception e = pae.getException();
                Manager.Ffdc.log(e, thisClass, "com.ibm.ws.security.auth.WSLoginHelperImpl.getSubject", "245");
                if (e instanceof WSSecurityException) {
                    throw (WSSecurityException)e;
                }
                throw new WSSecurityException(e.getMessage(), e);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Security is disabled, null subject will be returned");
            }
            subject_array = new Subject[]{};
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSubject()", new Integer(subject_array.length));
        }
        return subject_array;
    }

    public static Subject getNonForwardableSubject() throws WSSecurityException {
        Subject[] subject_list;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNonForwardableSubjects()");
        }
        if ((subject_list = WSLoginHelperImpl.getNonForwardableSubjects()) != null && subject_list[0] != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getNonForwardableSubject()");
            }
            return subject_list[0];
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNonForwardableSubject() - null Subject returned.");
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static Subject[] getNonForwardableSubjects() throws WSSecurityException {
        if (WSLoginHelperImpl.tc.isEntryEnabled()) {
            Tr.entry(WSLoginHelperImpl.tc, "getNonForwardableSubjects()");
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(WSLoginHelperImpl.GET_SUBJECT_PERMISSION);
            if (WSLoginHelperImpl.tc.isDebugEnabled()) {
                Tr.debug(WSLoginHelperImpl.tc, "Java 2 Security Permission Check passed");
            }
        }
        subject = null;
        if (ContextManagerFactory.getInstance().isCellSecurityEnabled()) {
            try {
                if (WSLoginHelperImpl.tc.isDebugEnabled()) {
                    Tr.debug(WSLoginHelperImpl.tc, "Getting the subject from credential on the Current Thread of Execution");
                }
                subject = (Subject[])AccessController.doPrivileged(WSLoginHelperImpl.getNonForwardableSubjectAction);
                if (!WSLoginHelperImpl.tc.isDebugEnabled()) ** GOTO lbl25
                Tr.debug(WSLoginHelperImpl.tc, "Got the subject from credential on the Current Thread of Execution");
            }
            catch (PrivilegedActionException pae) {
                e = pae.getException();
                Manager.Ffdc.log(e, WSLoginHelperImpl.thisClass, "com.ibm.ws.security.auth.WSLoginHelperImpl.getNonForwardableSubject", "245");
                subject = null;
                if (e instanceof WSSecurityException) {
                    throw (WSSecurityException)e;
                }
                throw new WSSecurityException(e.getMessage(), e);
            }
        } else if (WSLoginHelperImpl.tc.isDebugEnabled()) {
            Tr.debug(WSLoginHelperImpl.tc, "Security is disabled, null subject will be returned");
        }
lbl25:
        // 5 sources

        if (WSLoginHelperImpl.tc.isEntryEnabled()) {
            Tr.exit(WSLoginHelperImpl.tc, "getNonForwardableSubject()");
        }
        return subject;
    }

    public static Subject getSerializableSubject() throws WSSecurityException {
        Subject[] subject_list;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSerializableSubject()");
        }
        if ((subject_list = WSLoginHelperImpl.getSerializableSubjects()) != null && subject_list[0] != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSerializableSubject()");
            }
            return subject_list[0];
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSerializableSubject() - null Subject returned.");
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static Subject[] getSerializableSubjects() throws WSSecurityException {
        if (WSLoginHelperImpl.tc.isEntryEnabled()) {
            Tr.entry(WSLoginHelperImpl.tc, "getSerializableSubjects()");
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(WSLoginHelperImpl.GET_SUBJECT_PERMISSION);
            if (WSLoginHelperImpl.tc.isDebugEnabled()) {
                Tr.debug(WSLoginHelperImpl.tc, "Java 2 Security Permission Check passed");
            }
        }
        subject_array = null;
        if (ContextManagerFactory.getInstance().isCellSecurityEnabled()) {
            try {
                if (WSLoginHelperImpl.tc.isDebugEnabled()) {
                    Tr.debug(WSLoginHelperImpl.tc, "Getting the serializable subject from credential on the current thread of execution");
                }
                subject_array = (Subject[])AccessController.doPrivileged(WSLoginHelperImpl.getSerializableSubjectAction);
                if (!WSLoginHelperImpl.tc.isDebugEnabled()) ** GOTO lbl25
                Tr.debug(WSLoginHelperImpl.tc, "Got the serializable subject from credential on the current thread of execution");
            }
            catch (PrivilegedActionException pae) {
                e = pae.getException();
                Manager.Ffdc.log(e, WSLoginHelperImpl.thisClass, "com.ibm.ws.security.auth.WSLoginHelperImpl.getSerializableSubject", "245");
                subject_array = null;
                if (e instanceof WSSecurityException) {
                    throw (WSSecurityException)e;
                }
                throw new WSSecurityException(e.getMessage(), e);
            }
        } else if (WSLoginHelperImpl.tc.isDebugEnabled()) {
            Tr.debug(WSLoginHelperImpl.tc, "Security is disabled, null subject will be returned");
        }
lbl25:
        // 5 sources

        if (WSLoginHelperImpl.tc.isEntryEnabled()) {
            Tr.exit(WSLoginHelperImpl.tc, "getSerializableSubjects()");
        }
        return subject_array;
    }

    public static Subject getUnauthenticatedSubject() throws WSSecurityException {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUnauthenticatedSubjecy()");
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(GET_SUBJECT_PERMISSION);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Java 2 Security Permission Check passed");
            }
        }
        Subject subject = null;
        if (ContextManagerFactory.getInstance().isCellSecurityEnabled()) {
            try {
                subject = (Subject)AccessController.doPrivileged(getUnauthSubjectAction);
            }
            catch (PrivilegedActionException pae) {
                Exception e = pae.getException();
                Manager.Ffdc.log(e, thisClass, "com.ibm.ws.security.auth.WSLoginHelperImpl.getUnauthenticatedSubject", "431");
                subject = null;
                if (e instanceof WSSecurityException) {
                    throw (WSSecurityException)e;
                }
                throw new WSSecurityException(e.getMessage(), e);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Security is disabled, null subject will be returned");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUnauthenticatedSubjecy()");
        }
        return subject;
    }

    public static Subject getSerializableUnauthSubject() throws WSSecurityException {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSerializableUnauthSubject()");
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(GET_SUBJECT_PERMISSION);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Java 2 Security Permission Check passed");
            }
        }
        Subject subject = null;
        if (ContextManagerFactory.getInstance().isCellSecurityEnabled()) {
            try {
                subject = (Subject)AccessController.doPrivileged(getSerializableUnauthSubjectAction);
            }
            catch (PrivilegedActionException pae) {
                Exception e = pae.getException();
                Manager.Ffdc.log(e, thisClass, "com.ibm.ws.security.auth.WSLoginHelperImpl.getUnauthenticatedSubject", "485");
                subject = null;
                if (e instanceof WSSecurityException) {
                    throw (WSSecurityException)e;
                }
                throw new WSSecurityException(e.getMessage(), e);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Security is disabled, null subject will be returned");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSerializableUnauthSubject()");
        }
        return subject;
    }

    public static Subject restoreSerializedSubject(Subject in_s, WSCredential in_cred) throws SerialDeserialSubjectException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "restoreSerializedSubject()");
        }
        Subject privileged_subject = SubjectHelper.createSubjectFromWSCredential(in_cred);
        Subject[] return_subject_list = null;
        return_subject_list = WSLoginHelperImpl.restoreSerializedSubjects(new Subject[]{in_s}, privileged_subject);
        if (return_subject_list != null && return_subject_list[0] != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "restoreSerializedSubject()");
            }
            return return_subject_list[0];
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "restoreSerializedSubject() - null Subject returned.");
        }
        return null;
    }

    public static Subject[] restoreSerializedSubjects(Subject[] in_subject_array, Subject privileged_subject) throws SerialDeserialSubjectException {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "restoreSerializedSubjects()");
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(GET_SUBJECT_PERMISSION);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Java 2 Security Permission Check passed");
            }
        }
        if (in_subject_array != null) {
            for (int i = 0; i < in_subject_array.length; ++i) {
                if (in_subject_array[i] == null || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Subject[" + i + "] in passed in subject array is not null.");
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Passed in Subject array is null");
            }
            throw new SerialDeserialSubjectException("Passed in Subject array is null");
        }
        if (privileged_subject != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Privileged subject is not null.");
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Privileged subject is not null.");
            }
            throw new SerialDeserialSubjectException("Privileged subject is null.");
        }
        Subject[] return_subject_array = new Subject[in_subject_array.length];
        for (int j = 0; j < in_subject_array.length; ++j) {
            return_subject_array[j] = in_subject_array[j] != null ? WSLoginHelperImpl.deserializeSubject(in_subject_array[j], privileged_subject) : null;
        }
        return return_subject_array;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Subject deserializeSubject(final Subject in_s, Subject pushedSubject) throws SerialDeserialSubjectException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deserializeSubject()");
        }
        Subject retSub = null;
        Subject savedSubject = null;
        final ContextManager ctxMgr = ContextManagerFactory.getInstance();
        try {
            block15: {
                try {
                    if (ctxMgr.isCellSecurityEnabled()) {
                        try {
                            savedSubject = ctxMgr.pushInvocationSubject(pushedSubject);
                        }
                        catch (WSSecurityException e) {
                            SerialDeserialSubjectException ex = new SerialDeserialSubjectException(e.getMessage());
                            ex.addException(e);
                            throw ex;
                        }
                        retSub = (Subject)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws SerialDeserialSubjectException {
                                Subject subject = null;
                                String username = null;
                                String realm = null;
                                WSPrincipal wsPrincipal = SubjectHelper.getPrincipalFromSubject(in_s);
                                if (wsPrincipal != null) {
                                    username = ((WSPrincipalImpl)wsPrincipal).getUserName();
                                    realm = RealmSecurityName.getRealm(((WSPrincipalImpl)wsPrincipal).getName());
                                }
                                if (username != null && username.compareTo(ctxMgr.getUnauthenticatedString()) == 0) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Restoring unauthenticated credential");
                                    }
                                    try {
                                        return ctxMgr.createUnauthenticatedSubject();
                                    }
                                    catch (WSSecurityException e) {
                                        Manager.Ffdc.log(e, thisClass, "com.ibm.ws.security.auth.WSLoginHelperImpl.restoreSerializedSubject", "776");
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "JAAS login exception for principal: " + username);
                                        }
                                        Tr.error(tc, "security.jaas.create.credential", new Object[]{e});
                                        SerialDeserialSubjectException ex = new SerialDeserialSubjectException();
                                        ex.addException(e);
                                        throw ex;
                                    }
                                }
                                if (username != null) {
                                    subject = (Subject)asynchSubjectCache.get(username);
                                    if (subject != null) {
                                        if (tc.isEntryEnabled()) {
                                            Tr.exit(tc, "Returning existing asynch Subject from the cache (size=" + asynchSubjectCache.size() + ").");
                                        }
                                        return subject;
                                    }
                                } else {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "No Principals found from the serialized subject");
                                    }
                                    throw new SerialDeserialSubjectException();
                                }
                                String createTokenSubjectForAsynchLogin = ctxMgr.getProperty("com.ibm.ws.security.createTokenSubjectForAsynchLogin", "false");
                                if (createTokenSubjectForAsynchLogin != null && (createTokenSubjectForAsynchLogin.equalsIgnoreCase("yes") || createTokenSubjectForAsynchLogin.equalsIgnoreCase("true"))) {
                                    try {
                                        subject = ctxMgr.login(realm, username);
                                    }
                                    catch (WSLoginFailedException e) {
                                        Manager.Ffdc.log(e, thisClass, "com.ibm.ws.security.auth.WSLoginHelperImpl.restoreSerializedSubject", "817");
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "JAAS login exception for principal: " + username);
                                        }
                                        Tr.error(tc, "security.jaas.create.credential", new Object[]{e});
                                        SerialDeserialSubjectException ex = new SerialDeserialSubjectException();
                                        ex.addException(e);
                                        throw ex;
                                    }
                                }
                                InitialContext ic2 = null;
                                UserRegistry uReg = null;
                                Object objref = null;
                                try {
                                    ic2 = new InitialContext();
                                    objref = ic2.lookup("UserRegistry");
                                    uReg = (UserRegistry)PortableRemoteObject.narrow((Object)objref, UserRegistry.class);
                                    if (uReg == null) {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "No User Registry is available, null Subject is returned");
                                        }
                                        throw new SerialDeserialSubjectException();
                                    }
                                    WSCredential cred = null;
                                    WSCredential regcred = null;
                                    subject = new Subject();
                                    if (username.compareTo(ctxMgr.getUnauthenticatedString()) == 0) {
                                        cred = ctxMgr.getUnauthenticatedCredential();
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Restoring unauthenticated credential");
                                        }
                                    } else {
                                        if (ctxMgr.isInternalServerId(username)) {
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug(tc, "Restoring server subject for: " + username);
                                            }
                                            regcred = ctxMgr.getServerCredential();
                                        } else {
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug(tc, "Restoring user subject for: " + username);
                                            }
                                            regcred = uReg.createCredential(username);
                                        }
                                        if (regcred != null) {
                                            String isForwardable = ctxMgr.getProperty("com.ibm.CSI.WSSecurityContextActiveForwardable", "true");
                                            boolean forwardable = isForwardable != null && (isForwardable.equalsIgnoreCase("true") || isForwardable.equalsIgnoreCase("yes"));
                                            String oid = ctxMgr.getProperty("com.ibm.CSI.WSSecurityContextActiveOID", "NONE");
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug(tc, "OID: " + oid + ", Forwardable: " + isForwardable);
                                            }
                                            byte[] token = regcred.getCredentialToken();
                                            long expiration = regcred.getExpiration();
                                            if (oid.equals("NONE")) {
                                                if (tc.isDebugEnabled()) {
                                                    Tr.debug(tc, "Configured authetication mechanism is unknown. Failed to restore Subject.");
                                                }
                                                throw new SerialDeserialSubjectException("Configured authetication mechanism is unknown. Failed to restore Subject.");
                                            }
                                            cred = new WSCredentialImpl(regcred, oid, token, forwardable, expiration);
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug(tc, "Restored identity credential");
                                            }
                                        } else {
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug(tc, "Failed to restore the identity credential");
                                            }
                                            throw new SerialDeserialSubjectException();
                                        }
                                    }
                                    subject.getPrincipals().add(wsPrincipal);
                                    subject.getPublicCredentials().add(cred);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Restoring Subject is completed");
                                    }
                                }
                                catch (NamingException e) {
                                    Manager.Ffdc.log(e, this, "com.ibm.ws.security.auth.WSLoginHelperImpl.restoreSerializedSubject", "576");
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Failed to get initial Naming Context. Failed to resolve for UserRegistry");
                                    }
                                    Tr.error(tc, "security.jaas.get.initCtx", new Object[]{e});
                                    SerialDeserialSubjectException ex = new SerialDeserialSubjectException();
                                    ex.addException(e);
                                    throw ex;
                                }
                                catch (CustomRegistryException e) {
                                    Manager.Ffdc.log(e, this, "com.ibm.ws.security.auth.WSLoginHelperImpl.restoreSerializedSubject", "585");
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "CustomRegistryException is caught. Failed to create credential");
                                    }
                                    Tr.error(tc, "security.jaas.create.credential", new Object[]{e});
                                    SerialDeserialSubjectException ex = new SerialDeserialSubjectException();
                                    ex.addException(e);
                                    throw ex;
                                }
                                catch (SerialDeserialSubjectException e) {
                                    throw e;
                                }
                                catch (Exception e) {
                                    Manager.Ffdc.log(e, this, "com.ibm.ws.security.auth.WSLoginHelperImpl.restoreSerializedSubject", "594");
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "An exception is caught: " + e.toString());
                                    }
                                    Tr.error(tc, "security.jaas.restore.exception", new Object[]{e});
                                    SerialDeserialSubjectException ex = new SerialDeserialSubjectException();
                                    ex.addException(e);
                                    throw ex;
                                }
                                if (asynchSubjectCache.size() > 50) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Clearing aysnch Subject cache, larger than 50 objects.");
                                    }
                                    asynchSubjectCache.clear();
                                }
                                asynchSubjectCache.put(username, subject);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Added subject to the cache (size=" + asynchSubjectCache.size() + ").");
                                }
                                return subject;
                            }
                        });
                        break block15;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Security is disabled, null subject will be returned");
                    }
                }
                catch (PrivilegedActionException e) {
                    SerialDeserialSubjectException ex = (SerialDeserialSubjectException)e.getException();
                    Manager.Ffdc.log(ex, thisClass, "com.ibm.ws.security.auth.WSLoginHelperImpl.restoreSerializedSubject", "606");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "PrivilegedActionException is caught while serialized Subject is being restored");
                    }
                    Tr.error(tc, "security.jaas.priv.exception", new Object[]{ex});
                    throw ex;
                }
            }
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                ctxMgr.popInvocationSubject(savedSubject);
                throw throwable;
            }
            catch (WSSecurityException e) {
                Manager.Ffdc.log(e, thisClass, "com.ibm.ws.security.auth.WSLoginHelperImpl.restoreSerializedSubject", "631");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "InvalidCredentialType exception is caught while serialized Subject is being restored");
                }
                Tr.error(tc, "security.jaas.invalidType2.cred.exception", new Object[]{e});
                SerialDeserialSubjectException ex = new SerialDeserialSubjectException(e.getMessage());
                ex.addException(e);
                throw ex;
            }
        }
        try {}
        catch (WSSecurityException e) {
            Manager.Ffdc.log(e, thisClass, "com.ibm.ws.security.auth.WSLoginHelperImpl.restoreSerializedSubject", "631");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "InvalidCredentialType exception is caught while serialized Subject is being restored");
            }
            Tr.error(tc, "security.jaas.invalidType2.cred.exception", new Object[]{e});
            SerialDeserialSubjectException ex = new SerialDeserialSubjectException(e.getMessage());
            ex.addException(e);
            throw ex;
        }
        ctxMgr.popInvocationSubject(savedSubject);
        if (!tc.isEntryEnabled()) return retSub;
        Tr.exit(tc, "deserializeSubject()");
        return retSub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WSCredential refresh(String username, String realmname, String password) throws WSSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "refresh(username = \"" + username + "\", realmname = \"" + realmname + "\", password = \"XXXXXXXX\")");
        }
        WSLoginHelperImpl.disableAuthRetryForThread();
        WSCredential cred = null;
        try {
            ContextManager ctxMgr = ContextManagerFactory.getInstance();
            if (ctxMgr.isCellSecurityEnabled()) {
                cred = ctxMgr.authenticate(realmname, username, password);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "returned from login");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Security is disabled, credential is not refreshed, null credential will be returned");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "refresh(username, realmname, password)");
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            WSLoginHelperImpl.enableAuthRetryForThread();
            throw throwable;
        }
        WSLoginHelperImpl.enableAuthRetryForThread();
        return cred;
    }

    public static String getDefaultRealmName() {
        return ContextManagerFactory.getInstance().getDefaultRealm();
    }

    private WSLoginHelperImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSLoginHelperImpl()");
        }
        Tr.error(tc, "security.jaas.NoWSLoginHelperImpl");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSLoginHelperImpl()");
        }
    }

    private static void disableAuthRetryForThread() {
        ContextManagerFactory.getInstance().put("wssecurity.disableauthretry", new Boolean(true));
    }

    private static void enableAuthRetryForThread() {
        ContextManagerFactory.getInstance().put("wssecurity.disableauthretry", new Boolean(false));
    }
}

