/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component.binder;

import com.ibm.ejs.models.base.resources.J2EEResourceProperty;
import com.ibm.ejs.models.base.resources.J2EEResourcePropertySet;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.component.binder.ResourceBinder;
import com.ibm.ws.runtime.component.binder.ResourceBindingException;
import java.util.Map;
import java.util.Properties;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.xmi.XMIResource;

public abstract class ResourceBinderImpl
extends ComponentImpl
implements ResourceBinder {
    private static TraceComponent tc = Tr.register(ResourceBinderImpl.class, "ResourceBinders", "com.ibm.ws.runtime.runtime");

    protected void checkRequiredProperty(Object object, String error) throws ResourceBindingException {
        if (object == null) {
            throw new ResourceBindingException(error);
        }
    }

    protected void addPropertySet(Properties to, J2EEResourcePropertySet from) {
        this.addPropertySet(to, from, true);
    }

    protected void setProperty(Properties p, String key, Object obj) {
        this.setProperty(p, key, obj, false);
    }

    public void setCache(Map cache) {
    }

    public void initialize(Object config2) throws ConfigurationWarning, ConfigurationError {
    }

    protected void addPropertySet(Properties to, J2EEResourcePropertySet from, boolean expand) {
        if (from == null) {
            return;
        }
        if (to == null) {
            return;
        }
        EList propertyList = from.getResourceProperties();
        for (int i = 0; i < propertyList.size(); ++i) {
            J2EEResourceProperty property = (J2EEResourceProperty)propertyList.get(i);
            if (property == null) continue;
            String name = property.getName();
            String value = property.getValue();
            if (expand) {
                try {
                    value = this.expandVariable(value);
                }
                catch (IllegalArgumentException e) {
                    String uri = from.eResource().getResourceSet().getURIConverter().normalize(from.eResource().getURI()).toString();
                    Tr.warning(tc, "WSVR0022W", new Object[]{value, ((XMIResource)from.eContainer().eResource()).getID(from.eContainer()), uri});
                }
            }
            if (name == null || value == null) continue;
            to.setProperty(name, value);
        }
    }

    protected void setProperty(Properties p, String key, Object obj, boolean expand) {
        if (obj == null) {
            return;
        }
        String value = obj.toString();
        if (expand) {
            try {
                value = this.expandVariable(value);
            }
            catch (IllegalArgumentException e) {
                Manager.Ffdc.log(e, this, ResourceBinderImpl.class.getName(), "223");
            }
        }
        if (key != null && value != null) {
            p.setProperty(key, value);
        }
    }
}

