/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component.binder;

import com.ibm.ejs.jms.JMSResourceRefBuilder;
import com.ibm.ejs.jms.JMSResourceRefBuilderFactory;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.binder.JMSBinder;
import com.ibm.ws.runtime.component.binder.ResourceBindingException;
import com.ibm.wsspi.runtime.config.ConfigObject;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import javax.naming.Referenceable;

public class MQTopicBinder
extends JMSBinder {
    private static TraceComponent tc = Tr.register(MQTopicBinder.class, "ResourceBinders", "com.ibm.ejs.jms.messaging");

    public boolean isUsedFor(ConfigObject resource) {
        return resource.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/resources.jms.mqseries.xmi", "MQTopic");
    }

    public Object getBindingObject(ConfigObject resource) throws ResourceBindingException {
        int intValueMulticast;
        int intValueTargetClient;
        Boolean nativeEnc;
        int intValueExpiry;
        int intValuePriority;
        int intValuePersistence;
        Properties jmsProps = new Properties();
        ConfigObject jmsProvider = resource.getParent();
        String j2EEResourceFactoryName = resource.getString("name", "__null__");
        this.addPropertySet(jmsProps, resource.getObject("propertySet"), true);
        this.addPropertySet(jmsProps, jmsProvider.getObject("propertySet"), true);
        this.setProperty(jmsProps, "NAME", j2EEResourceFactoryName, true);
        this.setProperty(jmsProps, "DESC", resource.getString("description", "__null__"), true);
        String stringValue = resource.getString("persistence", "APPLICATION_DEFINED");
        if (stringValue.equals("APPLICATION_DEFINED")) {
            intValuePersistence = -2;
        } else if (stringValue.equals("NONPERSISTENT")) {
            intValuePersistence = 1;
        } else if (stringValue.equals("PERSISTENT")) {
            intValuePersistence = 2;
        } else if (stringValue.equals("QUEUE_DEFINED")) {
            intValuePersistence = -1;
        } else if (stringValue.equals("HIGH")) {
            intValuePersistence = 3;
        } else {
            throw new IllegalStateException(stringValue);
        }
        this.checkRequiredProperty(j2EEResourceFactoryName, "persistence", resource.isSet("persistence") ? Integer.valueOf(intValuePersistence) : null);
        this.setProperty(jmsProps, "PER", intValuePersistence, true);
        stringValue = resource.getString("priority", "APPLICATION_DEFINED");
        if (stringValue.equals("APPLICATION_DEFINED")) {
            intValuePriority = -2;
        } else if (stringValue.equals("SPECIFIED")) {
            intValuePriority = -3;
        } else if (stringValue.equals("QUEUE_DEFINED")) {
            intValuePriority = -1;
        } else {
            throw new IllegalStateException(stringValue);
        }
        this.checkRequiredProperty(j2EEResourceFactoryName, "priority", resource.isSet("priority") ? Integer.valueOf(intValuePriority) : null);
        if (intValuePriority == -2 || intValuePriority == -1) {
            this.setProperty(jmsProps, "PRI", intValuePriority, true);
        } else {
            this.checkRequiredProperty(j2EEResourceFactoryName, "specifiedPriority", resource.isSet("specifiedPriority") ? Integer.valueOf(resource.getInt("specifiedPriority", 0)) : null);
            this.setProperty(jmsProps, "PRI", resource.getInt("specifiedPriority", 0), true);
        }
        stringValue = resource.getString("expiry", "APPLICATION_DEFINED");
        if (stringValue.equals("APPLICATION_DEFINED")) {
            intValueExpiry = -2;
        } else if (stringValue.equals("SPECIFIED")) {
            intValueExpiry = -3;
        } else if (stringValue.equals("UNLIMITED")) {
            intValueExpiry = 0;
        } else {
            throw new IllegalStateException(stringValue);
        }
        this.checkRequiredProperty(j2EEResourceFactoryName, "expiry", resource.isSet("expiry") ? Long.valueOf(intValueExpiry) : null);
        if (intValueExpiry == -2 || intValueExpiry == 0) {
            this.setProperty(jmsProps, "EXP", intValueExpiry, true);
        } else {
            this.checkRequiredProperty(j2EEResourceFactoryName, "specifiedExpiry", resource.isSet("specifiedExpiry") ? new Long(resource.getLong("specifiedExpiry", 0L)) : null);
            this.setProperty(jmsProps, "EXP", new Long(resource.getLong("specifiedExpiry", 0L)), true);
        }
        Boolean bl = nativeEnc = resource.isSet("useNativeEncoding") ? new Boolean(resource.getBoolean("useNativeEncoding", false)) : null;
        if (nativeEnc != null && nativeEnc.booleanValue()) {
            this.setProperty(jmsProps, "ENC", "NATIVE", true);
        } else {
            String encString = new String("");
            encString = !resource.isSet("integerEncoding") || resource.getString("integerEncoding", "Normal").equals("Normal") ? encString + "N" : encString + "R";
            encString = !resource.isSet("decimalEncoding") || resource.getString("decimalEncoding", "Normal").equals("Normal") ? encString + "N" : encString + "R";
            encString = !resource.isSet("floatingPointEncoding") || resource.getString("floatingPointEncoding", "IEEENormal").equals("IEEENormal") ? encString + "N" : (resource.getString("floatingPointEncoding", "IEEENormal").equals("IEEEReversed") ? encString + "R" : encString + "3");
            this.setProperty(jmsProps, "ENC", encString, true);
        }
        this.setProperty(jmsProps, "TOP", resource.getString("baseTopicName", "__null__"), true);
        this.setProperty(jmsProps, "CCS", resource.isSet("CCSID") ? new Integer(resource.getInt("CCSID", 0)) : null, true);
        stringValue = resource.getString("targetClient", "JMS");
        if (stringValue.equals("JMS")) {
            intValueTargetClient = 0;
        } else if (stringValue.equals("MQ")) {
            intValueTargetClient = 1;
        } else {
            throw new IllegalStateException(stringValue);
        }
        this.setProperty(jmsProps, "TC", resource.isSet("targetClient") ? Integer.valueOf(intValueTargetClient) : null, true);
        this.setProperty(jmsProps, "BDSUB", resource.getString("brokerDurSubQueue", "__null__"), true);
        this.setProperty(jmsProps, "CCDSUB", resource.getString("brokerCCDurSubQueue", "__null__"), true);
        stringValue = resource.getString("multicast", "AS_CF");
        if (stringValue.equals("AS_CF")) {
            intValueMulticast = -1;
        } else if (stringValue.equals("DISABLED")) {
            intValueMulticast = 0;
        } else if (stringValue.equals("ENABLED")) {
            intValueMulticast = 7;
        } else if (stringValue.equals("NOT_RELIABLE")) {
            intValueMulticast = 3;
        } else if (stringValue.equals("RELIABLE")) {
            intValueMulticast = 5;
        } else {
            throw new IllegalStateException(stringValue);
        }
        this.setProperty(jmsProps, "MCAST", intValueMulticast, true);
        stringValue = resource.getString("sendAsync", "YES");
        if (stringValue.equals("QUEUE_DEFINED")) {
            stringValue = "AS_TOPIC_DEF";
        } else if (!stringValue.equals("YES") && !stringValue.equals("NO")) {
            throw new IllegalStateException(stringValue);
        }
        this.setProperty(jmsProps, "PAALD", stringValue, false);
        stringValue = resource.getString("readAhead", "YES");
        if (stringValue.equals("QUEUE_DEFINED")) {
            stringValue = "AS_TOPIC_DEF";
        } else if (!stringValue.equals("YES") && !stringValue.equals("NO")) {
            throw new IllegalStateException(stringValue);
        }
        this.setProperty(jmsProps, "RAALD", stringValue, false);
        stringValue = resource.getString("readAheadClose", "DELIVERALL");
        if (stringValue.equals("DELIVERALL")) {
            stringValue = "DELIVER_ALL";
        } else if (stringValue.equals("DELIVERCURRENT")) {
            stringValue = "DELIVER_CURRENT";
        } else {
            throw new IllegalStateException(stringValue);
        }
        this.setProperty(jmsProps, "RACP", stringValue, false);
        stringValue = resource.getString("brokerVersion", "V1");
        if (!stringValue.equals("V1") && !stringValue.equals("V2")) {
            throw new IllegalStateException(stringValue);
        }
        this.setProperty(jmsProps, "BVER", stringValue, true);
        stringValue = resource.getString("wildcardFormat", null);
        if (stringValue != null) {
            if (stringValue.equals("characterWildcards")) {
                this.setProperty(jmsProps, "WCFMT", "CHAR_ONLY", true);
            } else if (stringValue.equals("topicWildcards")) {
                this.setProperty(jmsProps, "WCFMT", "TOPIC_ONLY", true);
            } else {
                throw new IllegalStateException(stringValue);
            }
        }
        this.setProperty(jmsProps, "BPUB", resource.getString("brokerPubQueue", "__null__"), true);
        this.setProperty(jmsProps, "BPQM", resource.getString("brokerPubQmgr", "__null__"), true);
        this.addCustomPropertySet(jmsProps, resource.getObject("propertySet"));
        JMSResourceRefBuilder refBuilder = JMSResourceRefBuilderFactory.createJMSResourceRefBuilder();
        Referenceable ref = null;
        try {
            ref = refBuilder.createMQTopicReferenceable(jmsProps);
        }
        catch (ResourceBindingException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.runtime.component.binder.MQTopicBinder.getBindingObject", "127", this);
            throw e;
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.runtime.component.binder.MQTopicBinder.getBindingObject", "132", this);
            throw new ResourceBindingException(t.toString());
        }
        return ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addCustomPropertySet(Properties jmsProps, ConfigObject customProps) throws ResourceBindingException {
        HashSet<String> unknownCustomPropertiesSet;
        boolean brokerverSet;
        block13: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "addCustomPropertySet", new Object[]{jmsProps, customProps});
            }
            brokerverSet = false;
            unknownCustomPropertiesSet = new HashSet<String>();
            if (jmsProps != null && customProps != null) break block13;
            if (!tc.isEntryEnabled()) return;
            Tr.exit(tc, "addCustomPropertySet", new Object[]{jmsProps});
            return;
        }
        try {
            List propertyList = customProps.getObjectList("resourceProperties");
            for (int i = 0; i < propertyList.size(); ++i) {
                ConfigObject property = (ConfigObject)propertyList.get(i);
                if (property == null) continue;
                String name = property.getString("name", "__null__");
                String value = property.getString("value", "__null__");
                try {
                    value = this.expandVariable(value);
                }
                catch (IllegalArgumentException e) {
                    throw new ResourceBindingException("Illegal value '" + value + "' for Custom Property '" + name + "'");
                }
                if (name == null) {
                    throw new ResourceBindingException("Illegal Custom Property name " + name);
                }
                if (value == null) {
                    throw new ResourceBindingException("Illegal Custom Property value " + value);
                }
                if (name.equalsIgnoreCase("BROKERVER")) {
                    if (brokerverSet) {
                        throw new ResourceBindingException("Custom Property '" + name.toUpperCase() + "' already set");
                    }
                    this.setProperty(jmsProps, "BVER", value, true);
                    brokerverSet = true;
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "adding unknown custom property <" + name + "=" + value + ">");
                }
                if (unknownCustomPropertiesSet.contains(name.toUpperCase())) {
                    throw new ResourceBindingException("Custom Property '" + name.toUpperCase() + "' already set");
                }
                this.setProperty(jmsProps, name, value, true);
                unknownCustomPropertiesSet.add(name.toUpperCase());
            }
            if (!tc.isEntryEnabled()) return;
        }
        catch (Throwable throwable) {
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "addCustomPropertySet", new Object[]{jmsProps});
            throw throwable;
        }
        Tr.exit(tc, "addCustomPropertySet", new Object[]{jmsProps});
    }
}

