/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component.binder;

import com.ibm.ejs.jms.JMSResourceRefBuilder;
import com.ibm.ejs.jms.JMSResourceRefBuilderFactory;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.binder.JMSBinder;
import com.ibm.ws.runtime.component.binder.ResourceBindingException;
import com.ibm.wsspi.runtime.config.ConfigObject;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import javax.naming.Referenceable;

public class MQQueueConnectionFactoryBinder
extends JMSBinder {
    private static TraceComponent tc = Tr.register(MQQueueConnectionFactoryBinder.class, "ResourceBinders", "com.ibm.ejs.jms.messaging");

    public boolean isUsedFor(ConfigObject resource) {
        return resource.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/resources.jms.mqseries.xmi", "MQQueueConnectionFactory");
    }

    public Object getBindingObject(ConfigObject resource) throws ResourceBindingException {
        int intValueTransportType;
        Properties jmsProps = new Properties();
        ConfigObject jmsProvider = resource.getParent();
        ConfigObject connectionPool = resource.getObject("connectionPool");
        this.checkRequiredProperty(resource.getString("name", "__null__"), "ConnectionPool", connectionPool);
        ConfigObject sessionPool = resource.getObject("sessionPool");
        this.addPropertySet(jmsProps, jmsProvider.getObject("propertySet"), true);
        this.setProperty(jmsProps, "NAME", resource.getString("name", "__null__"), true);
        this.setProperty(jmsProps, "DESC", resource.getString("description", "__null__"), true);
        this.setProperty(jmsProps, "QMGR", resource.getString("queueManager", "__null__"), true);
        String stringValue = resource.getString("transportType", "BINDINGS");
        if (stringValue.equals("BINDINGS_THEN_CLIENT")) {
            intValueTransportType = 8;
        } else if (stringValue.equals("BINDINGS")) {
            intValueTransportType = 0;
        } else if (stringValue.equals("CLIENT")) {
            intValueTransportType = 1;
        } else if (stringValue.equals("DIRECT")) {
            intValueTransportType = 2;
        } else if (stringValue.equals("DIRECTHTTP")) {
            intValueTransportType = 4;
        } else {
            throw new IllegalStateException(stringValue);
        }
        this.setProperty(jmsProps, "TRAN", resource.isSet("transportType") ? Integer.valueOf(intValueTransportType) : null, true);
        if (intValueTransportType != 0) {
            this.setNonBindingsModeProperties(jmsProps, resource);
        }
        this.setProperty(jmsProps, "TM", resource.getString("tempModel", "__null__"), true);
        this.setProperty(jmsProps, "CID", resource.getString("clientID", "__null__"), true);
        this.setProperty(jmsProps, "MRET", resource.isSet("msgRetention") ? new Boolean(resource.getBoolean("msgRetention", true)) : null, true);
        this.setProperty(jmsProps, "XAEnabled", resource.isSet("XAEnabled") ? new Boolean(resource.getBoolean("XAEnabled", true)) : Boolean.TRUE, true);
        this.setProperty(jmsProps, "FIQ", resource.isSet("failIfQuiesce") ? new Boolean(resource.getBoolean("failIfQuiesce", true)) : null, true);
        this.setProperty(jmsProps, "PINT", new Integer(resource.getInt("pollingInterval", 5000)), true);
        this.setProperty(jmsProps, "RINT", resource.isSet("rescanInterval") ? new Integer(resource.getInt("rescanInterval", 5000)) : null, true);
        this.setProperty(jmsProps, "TQP", resource.getString("tempQueuePrefix", "__null__"), true);
        this.setProperty(jmsProps, "UCP", resource.isSet("useConnectionPooling") ? new Boolean(resource.getBoolean("useConnectionPooling", true)) : null, true);
        stringValue = resource.getString("compressHeaders", "NONE");
        this.setProperty(jmsProps, "HC", stringValue, true);
        stringValue = resource.getString("compressPayload", "NONE");
        this.setProperty(jmsProps, "MC", stringValue, true);
        stringValue = resource.getString("providerVersion", "__null__");
        if (stringValue == null || stringValue.trim().length() == 0) {
            stringValue = "UNSPECIFIED";
        }
        this.setProperty(jmsProps, "PVER", stringValue, true);
        if (this.checkMapNameStyleCompatiability()) {
            this.setProperty(jmsProps, "MAPNAMESTYLE", "COMPATIBLE", true);
        }
        if ((stringValue = resource.getString("replyWithRFH2", "AS_REPLY_DEST")).equals("ALWAYS")) {
            stringValue = "NO";
        } else if (stringValue.equals("AS_REPLY_DEST")) {
            stringValue = "YES";
        } else {
            throw new IllegalStateException(stringValue);
        }
        this.setProperty(jmsProps, "TCM", stringValue, true);
        this.setProperty(jmsProps, "MBS", resource.isSet("maxBatchSize") ? new Integer(resource.getInt("maxBatchSize", 10)) : null, true);
        this.setAuthenticationProperties(resource, jmsProps);
        Properties connectionPoolProperties = new Properties();
        stringValue = resource.getString("xaRecoveryAuthAlias", "__null__");
        this.setProperty(connectionPoolProperties, "XA_RECOVERY_AUTH_ALIAS", stringValue, true);
        this.addConnectionPoolProperties(connectionPoolProperties, connectionPool);
        this.addJ2EEHrefProperties(connectionPoolProperties, resource);
        Properties sessionPoolProperties = new Properties();
        this.addConnectionPoolProperties(sessionPoolProperties, sessionPool);
        this.addCustomPropertySet(jmsProps, resource.getObject("propertySet"));
        JMSResourceRefBuilder refBuilder = JMSResourceRefBuilderFactory.createJMSResourceRefBuilder();
        Referenceable ref = null;
        try {
            ref = refBuilder.createMQQueueConnectionFactoryReferenceable(jmsProps, connectionPoolProperties, sessionPoolProperties);
        }
        catch (ResourceBindingException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.runtime.component.binder.MQQueueConnectionFactoryBinder.getBindingObject", "124", this);
            throw e;
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.runtime.component.binder.MQQueueConnectionFactoryBinder.getBindingObject", "129", this);
            throw new ResourceBindingException(t.toString());
        }
        return ref;
    }

    private void setNonBindingsModeProperties(Properties jmsProps, ConfigObject resource) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setNonBindingsModeProperties", new Object[]{jmsProps, resource});
        }
        this.setProperty(jmsProps, "HOST", resource.getString("host", "__null__"), true);
        this.setProperty(jmsProps, "PORT", resource.isSet("port") ? Integer.valueOf(resource.getInt("port", 0)) : null, true);
        this.setProperty(jmsProps, "CHAN", resource.getString("channel", "__null__"), true);
        this.setProperty(jmsProps, "CCS", resource.getString("CCSID", "__null__"), true);
        this.setProperty(jmsProps, "LA", resource.getString("localAddress", "__null__"), true);
        this.setProperty(jmsProps, "SRC", resource.isSet("sslResetCount") ? Integer.valueOf(resource.getInt("sslResetCount", 0)) : null, true);
        this.setProperty(jmsProps, "CCDT", resource.getString("ccdtUrl", "__null__"), true);
        this.setProperty(jmsProps, "SCPHS", resource.getString("sslCipherSuite", "__null__"), true);
        this.setProperty(jmsProps, "SCRL", resource.getString("sslCRL", "__null__"), true);
        this.setProperty(jmsProps, "SPEER", resource.getString("sslPeerName", "__null__"), true);
        this.setProperty(jmsProps, "SCX", resource.getString("secExit", "__null__"), true);
        this.setProperty(jmsProps, "SCXI", resource.getString("secExitInitData", "__null__"), true);
        this.setProperty(jmsProps, "RCX", resource.getString("rcvExit", "__null__"), true);
        this.setProperty(jmsProps, "RCXI", resource.getString("rcvExitInitData", "__null__"), true);
        this.setProperty(jmsProps, "SDX", resource.getString("sendExit", "__null__"), true);
        this.setProperty(jmsProps, "SDXI", resource.getString("sendExitInitData", "__null__"), true);
        if (jmsProps.containsKey("CCDT")) {
            String sslConfigurationValue = resource.getString("sslConfiguration", "__null__");
            if (sslConfigurationValue == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Null ssl configuration assuming central");
                }
                this.setProperty(jmsProps, "sslType", "CENTRAL", true);
            } else {
                this.setProperty(jmsProps, "sslType", "SPECIFIC", true);
                this.setProperty(jmsProps, "sslConfiguration", sslConfigurationValue, true);
            }
        } else {
            String sslTypeValue = resource.getString("sslType", "NONE");
            if (sslTypeValue.equals("CENTRAL")) {
                this.setProperty(jmsProps, "sslType", "CENTRAL", true);
            } else if (sslTypeValue.equals("SPECIFIC")) {
                String sslConfigurationValue = resource.getString("sslConfiguration", "__null__");
                this.setProperty(jmsProps, "sslType", "SPECIFIC", true);
                this.setProperty(jmsProps, "sslConfiguration", sslConfigurationValue, true);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setNonBindingsModeProperties");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addCustomPropertySet(Properties jmsProps, ConfigObject customProps) throws ResourceBindingException {
        HashSet<String> unknownCustomPropertiesSet;
        boolean recexitinitSet;
        boolean recexitSet;
        boolean sendexitinitSet;
        boolean sendexitSet;
        boolean secexitinitSet;
        boolean secexitSet;
        boolean sslcrlSet;
        boolean sslciphersuiteSet;
        boolean sslpeernameSet;
        block30: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "addCustomPropertySet", new Object[]{jmsProps, customProps});
            }
            sslpeernameSet = false;
            sslciphersuiteSet = false;
            sslcrlSet = false;
            secexitSet = false;
            secexitinitSet = false;
            sendexitSet = false;
            sendexitinitSet = false;
            recexitSet = false;
            recexitinitSet = false;
            unknownCustomPropertiesSet = new HashSet<String>();
            if (jmsProps != null && customProps != null) break block30;
            if (!tc.isEntryEnabled()) return;
            Tr.exit(tc, "addCustomPropertySet", new Object[]{jmsProps});
            return;
        }
        try {
            List propertyList = customProps.getObjectList("resourceProperties");
            for (int i = 0; i < propertyList.size(); ++i) {
                ConfigObject property = (ConfigObject)propertyList.get(i);
                if (property == null) continue;
                String name = property.getString("name", "__null__");
                String value = property.getString("value", "__null__");
                try {
                    value = this.expandVariable(value);
                }
                catch (IllegalArgumentException e) {
                    throw new ResourceBindingException("Illegal value '" + value + "' for Custom Property '" + name + "'");
                }
                if (name == null) {
                    throw new ResourceBindingException("Illegal Custom Property name " + name);
                }
                if (value == null) {
                    throw new ResourceBindingException("Illegal Custom Property value " + value);
                }
                if (name.equalsIgnoreCase("SSLPEERNAME")) {
                    if (sslpeernameSet) {
                        throw new ResourceBindingException("Custom Property '" + name.toUpperCase() + "' already set");
                    }
                    this.setProperty(jmsProps, "SPEER", value, true);
                    sslpeernameSet = true;
                    continue;
                }
                if (name.equalsIgnoreCase("SSLCIPHERSUITE")) {
                    if (sslciphersuiteSet) {
                        throw new ResourceBindingException("Custom Property '" + name.toUpperCase() + "' already set");
                    }
                    this.setProperty(jmsProps, "SCPHS", value, true);
                    sslciphersuiteSet = true;
                    continue;
                }
                if (name.equalsIgnoreCase("SSLCRL")) {
                    if (sslcrlSet) {
                        throw new ResourceBindingException("Custom Property '" + name.toUpperCase() + "' already set");
                    }
                    this.setProperty(jmsProps, "SCRL", value, true);
                    sslcrlSet = true;
                    continue;
                }
                if (name.equalsIgnoreCase("SECEXIT")) {
                    if (secexitSet) {
                        throw new ResourceBindingException("Custom Property '" + name.toUpperCase() + "' already set");
                    }
                    this.setProperty(jmsProps, "SCX", value, true);
                    secexitSet = true;
                    continue;
                }
                if (name.equalsIgnoreCase("SECEXITINIT")) {
                    if (secexitinitSet) {
                        throw new ResourceBindingException("Custom Property '" + name.toUpperCase() + "' already set");
                    }
                    this.setProperty(jmsProps, "SCXI", value, true);
                    secexitinitSet = true;
                    continue;
                }
                if (name.equalsIgnoreCase("RECEXIT")) {
                    if (recexitSet) {
                        throw new ResourceBindingException("Custom Property '" + name.toUpperCase() + "' already set");
                    }
                    this.setProperty(jmsProps, "RCX", value, true);
                    recexitSet = true;
                    continue;
                }
                if (name.equalsIgnoreCase("RECEXITINIT")) {
                    if (recexitinitSet) {
                        throw new ResourceBindingException("Custom Property '" + name.toUpperCase() + "' already set");
                    }
                    this.setProperty(jmsProps, "RCXI", value, true);
                    recexitinitSet = true;
                    continue;
                }
                if (name.equalsIgnoreCase("SENDEXIT")) {
                    if (sendexitSet) {
                        throw new ResourceBindingException("Custom Property '" + name.toUpperCase() + "' already set");
                    }
                    this.setProperty(jmsProps, "SDX", value, true);
                    sendexitSet = true;
                    continue;
                }
                if (name.equalsIgnoreCase("SENDEXITINIT")) {
                    if (sendexitinitSet) {
                        throw new ResourceBindingException("Custom Property '" + name.toUpperCase() + "' already set");
                    }
                    this.setProperty(jmsProps, "SDXI", value, true);
                    sendexitinitSet = true;
                    continue;
                }
                if (name.equalsIgnoreCase("ssl.repertoire")) {
                    this.setProperty(jmsProps, "ssl.repertoire", value, true);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "adding unknown custom property <" + name + "=" + value + ">");
                }
                if (unknownCustomPropertiesSet.contains(name.toUpperCase())) {
                    throw new ResourceBindingException("Custom Property '" + name.toUpperCase() + "' already set");
                }
                this.setProperty(jmsProps, name, value, true);
                unknownCustomPropertiesSet.add(name.toUpperCase());
            }
            if (!tc.isEntryEnabled()) return;
        }
        catch (Throwable throwable) {
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "addCustomPropertySet", new Object[]{jmsProps});
            throw throwable;
        }
        Tr.exit(tc, "addCustomPropertySet", new Object[]{jmsProps});
    }
}

