/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component.binder;

import com.ibm.ejs.j2c.ConnectionFactoryRefBuilder;
import com.ibm.ejs.j2c.ConnectionFactoryRefBuilderFactory;
import com.ibm.ejs.j2c.ConnectorProperties;
import com.ibm.ejs.j2c.ConnectorProperty;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.runtime.component.binder.J2CBinder;
import com.ibm.ws.runtime.component.binder.ResourceBindingException;
import com.ibm.ws.security.auth.j2c.WSDefaultPrincipalMapping;
import com.ibm.ws.security.cred.AuthDataCredential;
import com.ibm.wsspi.runtime.config.ConfigObject;
import java.util.Properties;
import javax.security.auth.login.LoginException;

public class J2CConnectionFactoryBinder
extends J2CBinder {
    private static final TraceComponent tc = Tr.register(J2CConnectionFactoryBinder.class, "WAS.j2c", "com.ibm.ws.j2c.resources.J2CAMessages");

    public boolean isUsedFor(ConfigObject resource) {
        return resource.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/resources.j2c.xmi", "J2CConnectionFactory");
    }

    public String getNamePrefix() {
        return "eis";
    }

    public Object getBindingObject(ConfigObject j2cCF) throws ResourceBindingException {
        String xaRecoveryAuthAlias;
        Properties properties = new Properties();
        ConnectorProperties configProps = new ConnectorProperties();
        ConfigObject ra = j2cCF.getParent();
        String j2cCFName = j2cCF.getString("name", "__null__");
        ConfigObject c = ra.getObject("deploymentDescriptor");
        if (c == null) {
            throw new ResourceBindingException("No JCA Connector defined");
        }
        boolean isJCA15 = this.checkJCA15(c.getString("specVersion", "__null__"));
        String authDataAlias = j2cCF.getString("authDataAlias", "__null__");
        String userName = null;
        String password = null;
        if (authDataAlias != null) {
            try {
                AuthDataCredential authDC = WSDefaultPrincipalMapping.getAuthData((String)authDataAlias);
                if (authDC != null) {
                    int status = authDC.getStatus();
                    if (status == 1) {
                        Object[] parms = new Object[]{"Connection Factory", j2cCFName, authDataAlias};
                        Tr.warning(tc, "MISSING_AUTH_DATA_ENTRY_J2CA0130", parms);
                    } else {
                        ConnectorProperty connProp = new ConnectorProperty("OptionC_authDataAlias", "java.lang.String", authDataAlias);
                        configProps.add((Object)connProp);
                    }
                    userName = authDC.getUserName();
                    password = authDC.getPassword();
                }
            }
            catch (LoginException le) {
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((xaRecoveryAuthAlias = j2cCF.getString("xaRecoveryAuthAlias", "__null__")) != null) {
            ConnectorProperty connProp = new ConnectorProperty("XA_RECOVERY_AUTH_ALIAS", "java.lang.String", xaRecoveryAuthAlias);
            configProps.add((Object)connProp);
        }
        ConfigObject mapMod = j2cCF.getObject("mapping");
        ConfigObject pool = j2cCF.getObject("connectionPool");
        this.checkRequiredProperty(pool, "Invalid Configuration! The J2CConnectionFactory: " + j2cCFName + " has a null ConnectionPool property.");
        this.addJ2CResourceAdapterProperties(properties, ra);
        if (isJCA15) {
            this.addConnectionDefinitionProperties(properties, j2cCF.getObject("connectionDefinition"));
        }
        String raKey = null;
        try {
            raKey = AdminServiceFactory.getAdminService().getMBeanFactory().getConfigId(ra);
        }
        catch (AdminException e) {
            // empty catch block
        }
        this.checkSetProperty(properties, "resourceAdapterJavaBeanKey", raKey);
        this.setProperty(properties, "name", j2cCFName, false);
        this.setProperty(properties, "authMechanismPreference", j2cCF.getString("authMechanismPreference", "BASIC_PASSWORD"), false);
        if (isJCA15) {
            this.setProperty(properties, "manageCachedHandles", new Boolean(j2cCF.getBoolean("manageCachedHandles", false)), false);
            this.setProperty(properties, "logMissingTransactionContext", new Boolean(j2cCF.getBoolean("logMissingTransactionContext", true)), false);
        }
        this.setProperty(properties, "diagnoseConnectionUsage", new Boolean(j2cCF.getBoolean("diagnoseConnectionUsage", false)), false);
        if (mapMod != null) {
            this.setProperty(properties, "mappingConfigAlias", mapMod.getString("mappingConfigAlias", "__null__"), false);
            String optionAAlias = mapMod.getString("authDataAlias", "__null__");
            if (optionAAlias != null) {
                this.setProperty(properties, "authDataAlias", optionAAlias, false);
            }
        }
        this.addJ2EEHrefProperties(properties, j2cCF);
        this.addConnectionPoolProperties(properties, pool);
        this.addConnectorPropertySet(configProps, j2cCF.getObject("propertySet"));
        ConnectionFactoryRefBuilder refBuilder = ConnectionFactoryRefBuilderFactory.create();
        return refBuilder.createConnectorReferenceableObject(properties, configProps);
    }
}

