/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.service.ORB;
import com.ibm.ws.runtime.service.WLC;
import com.ibm.ws.runtime.workloadcontroller.OrbWorkloadRegulator;
import com.ibm.ws.runtime.workloadcontroller.WorkloadController;
import com.ibm.ws.security.util.AccessController;
import java.security.PrivilegedAction;

public class WLCImpl
extends ComponentImpl
implements WLC {
    private static TraceComponent tc = Tr.register(WLCImpl.class);
    private boolean StopImmediate = false;

    public void initialize(Object config2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        this.addService(WLC.class);
        this.StopImmediate = false;
        boolean rtn = WorkloadController.starting();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize : rtn = " + rtn);
        }
    }

    public void destroy() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy");
        }
        boolean rtn = WorkloadController.quiesce(0);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "destroy : rtn = " + rtn);
        }
    }

    public void start() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        this.StopImmediate = false;
        ORB orbService = (ORB)this.getService(ORB.class);
        if (orbService != null) {
            OrbWorkloadRegulator.getInstance().setORB(orbService.getORB());
        }
        boolean rtn = WorkloadController.started();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start : rtn = " + rtn);
        }
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop");
        }
        int quiesceTimeout = 180;
        if (!this.StopImmediate) {
            String timeoutString = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("com.ibm.ejs.sm.server.quiesceTimeout");
                }
            });
            if (tc.isEventEnabled()) {
                Tr.event(tc, "stop: com.ibm.ejs.sm.server.quiesceTimeout String = " + timeoutString);
            }
            if (timeoutString != null) {
                try {
                    quiesceTimeout = Integer.parseInt(timeoutString);
                }
                catch (NumberFormatException nfe) {
                    FFDCFilter.processException((Throwable)nfe, "com.ibm.ws.runtime.component.WLCImpl.stop", "91", this);
                    quiesceTimeout = 180;
                }
            }
        } else {
            quiesceTimeout = 0;
        }
        boolean rtn = WorkloadController.quiesce(quiesceTimeout);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop : rtn = " + rtn + " Quiesce Timeout = " + quiesceTimeout);
        }
    }

    public void stopImmediate() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stopImmediate");
        }
        this.StopImmediate = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopImmediate : StopImmediate = " + this.StopImmediate);
        }
    }
}

