/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.ws.runtime.InstalledOptionalPackageDependencyResolutionPolicy;
import com.ibm.ws.runtime.InstalledOptionalPackageDependencyResolver;
import com.ibm.ws.runtime.InstalledOptionalPackageMetaData;
import com.ibm.ws.runtime.ManifestDependencyDeclaration;
import com.ibm.ws.util.PathUtils;
import com.ibm.ws.util.service.VariableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;

public class ModuleManifestParser {
    private static final TraceComponent tc = Tr.register(ModuleManifestParser.class, "RuntimeUtils", "com.ibm.ws.utils.resources.nls.UtilsMessages");
    private static final String CLASS_NAME = "com.ibm.ws.runtime.ModuleManifestParser";

    public static InstalledOptionalPackageMetaData[] getInstalledOptionalPackageMetaData(ModuleFile module, Map libraryNameByInstalledOptionalPackages) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstalledOptionalPackageMetaData");
        }
        InstalledOptionalPackageMetaData[] result = null;
        InstalledOptionalPackageMetaData[] individualResult = null;
        InstalledOptionalPackageDependencyResolutionPolicy resolutionPolicy = null;
        try {
            ArchiveManifest mf;
            Attributes mainAttributes;
            String extensionListValue;
            String[] extensionList;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing module -> " + module.getName());
            }
            if ((extensionList = ModuleManifestParser.parseSpaceDelimitedStringToList(extensionListValue = (mainAttributes = (mf = module.getManifest()).getMainAttributes()).getValue(Attributes.Name.EXTENSION_LIST))) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Number of extension identified in MANIFEST.MF = " + extensionList.length);
                }
                result = new InstalledOptionalPackageMetaData[extensionList.length];
                block10: for (int i = 0; i < extensionList.length; ++i) {
                    resolutionPolicy = InstalledOptionalPackageDependencyResolver.getResolutionDependencyPolicy(extensionList[i].trim(), mainAttributes);
                    individualResult = resolutionPolicy.resolveDependency(libraryNameByInstalledOptionalPackages);
                    result[i] = individualResult[0];
                    if (result[i].specifiedDependenciesAreResolved()) continue;
                    String listPrefix = "";
                    if (extensionList[i] != null) {
                        listPrefix = extensionList[i] + "-";
                    }
                    switch (result[i].getTypeOfUnresolvedDependency()) {
                        case 0: {
                            continue block10;
                        }
                        case 1: {
                            Tr.error(tc, "UTLS0004", new Object[]{listPrefix + "Specification-Version", module.getName()});
                            continue block10;
                        }
                        case 2: {
                            continue block10;
                        }
                        case 3: {
                            Tr.error(tc, "UTLS0004", new Object[]{listPrefix + "Specification-Version", module.getName()});
                            continue block10;
                        }
                        case 4: {
                            continue block10;
                        }
                        case 5: {
                            Tr.error(tc, "UTLS0001", new Object[]{module.getName()});
                        }
                    }
                }
            }
        }
        catch (Throwable t) {
            Manager.Ffdc.log(t, ModuleManifestParser.class, "com.ibm.ws.runtime.ModuleManifestParser.getInstalledOptionalPackageMetaData", "100");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception:", t);
            }
            Tr.error(tc, "UTLS0001", new Object[]{module.getName()});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstalledOptionalPackageMetaData");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void addInstalledOptionalPackages(Map installedOptionalPackageMap, List classpaths, String libraryName, VariableMap variableMap) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addInstalledOptionalPackages");
        }
        InstalledOptionalPackageMetaData key = null;
        ArrayList<String> expandedClassPathList = new ArrayList<String>();
        Iterator it = classpaths.iterator();
        String currCP = null;
        while (it.hasNext()) {
            try {
                currCP = (String)it.next();
                currCP = variableMap.expand(currCP);
                expandedClassPathList.add(currCP);
            }
            catch (IllegalArgumentException iae) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Exception caught, " + iae + ", skipping invalid classpath=" + currCP);
            }
        }
        String[] classPathArray = new String[expandedClassPathList.size()];
        classPathArray = expandedClassPathList.toArray(classPathArray);
        expandedClassPathList.clear();
        String[] expandedClassPath = PathUtils.expandPaths(classPathArray);
        for (int i = 0; i < expandedClassPath.length; ++i) {
            String classPathEntry = expandedClassPath[i];
            if (!classPathEntry.toLowerCase().endsWith(".jar")) continue;
            expandedClassPathList.add(classPathEntry);
        }
        for (int j = 0; j < expandedClassPathList.size(); ++j) {
            JarFile sharedLibrary;
            block29: {
                String extensionListValue;
                Attributes mainAttributes;
                String cpe = (String)expandedClassPathList.get(j);
                sharedLibrary = null;
                try {
                    sharedLibrary = new JarFile(cpe);
                }
                catch (Throwable t) {
                    Manager.Ffdc.log(t, ModuleManifestParser.class, "com.ibm.ws.runtime.ModuleManifestParser.addInstalledOptionalPackages", "200");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception:", t);
                    }
                    Tr.error(tc, "UTLS0002", new Object[]{libraryName, cpe});
                }
                if (sharedLibrary == null) continue;
                Manifest manifest = sharedLibrary.getManifest();
                if (manifest == null || (mainAttributes = manifest.getMainAttributes()) == null || (extensionListValue = mainAttributes.getValue(Attributes.Name.EXTENSION_LIST)) != null) break block29;
                String preExistingLibraryName = null;
                ManifestDependencyDeclaration dependencyDefinition = new ManifestDependencyDeclaration(mainAttributes);
                switch (dependencyDefinition.dependencyClassification) {
                    case 0: {
                        if (!tc.isDebugEnabled()) break;
                        Tr.debug(tc, "ManifestDependencyDeclaration.UNDEFINED: Entry ignored for libraryName = " + libraryName);
                        break;
                    }
                    case 1: {
                        if (!tc.isDebugEnabled()) break;
                        Tr.debug(tc, "ManifestDependencyDeclaration.MINIMUMLY_QUALIFIED: Entry ignored for libraryName = " + libraryName);
                        break;
                    }
                    case 2: {
                        key = dependencyDefinition.getMetaData();
                        preExistingLibraryName = installedOptionalPackageMap.put(key, libraryName);
                        if (preExistingLibraryName != null) {
                            Tr.warning(tc, "UTLS0005", new Object[]{libraryName, preExistingLibraryName});
                        }
                        if (!tc.isDebugEnabled()) break;
                        Tr.debug(tc, "ManifestDependencyDeclaration.SPECIFICATION_BASED: Entry for specification based dependency added to map for InstalledOptionalPackage with key -> " + key.toString() + ":: for libraryName = " + libraryName);
                        break;
                    }
                    case 3: {
                        if (!tc.isDebugEnabled()) break;
                        Tr.debug(tc, "ManifestDependencyDeclaration.IMPLEMENTATION_BASED: Entry ignored for libraryName = " + libraryName);
                        break;
                    }
                    case 4: {
                        key = dependencyDefinition.getMetaData();
                        preExistingLibraryName = installedOptionalPackageMap.put(key, libraryName);
                        if (preExistingLibraryName != null) {
                            Tr.warning(tc, "UTLS0005", new Object[]{libraryName, preExistingLibraryName});
                        }
                        if (!tc.isDebugEnabled()) break;
                        Tr.debug(tc, "ManifestDependencyDeclaration.FULLY_QUALIFIED: Entry for specification based dependency added to map for InstalledOptionalPackage with key -> " + key.toString() + ":: for libraryName = " + libraryName);
                        break;
                    }
                    case 5: {
                        Tr.error(tc, "UTLS0003", new Object[]{libraryName});
                    }
                }
            }
            Object var19_21 = null;
            try {
                sharedLibrary.close();
            }
            catch (IOException ex) {
                Manager.Ffdc.log(ex, ModuleManifestParser.class, "com.ibm.ws.runtime.ModuleManifestParser.addInstalledOptionalPackages", "294");
            }
            continue;
            {
                catch (Throwable t) {
                    Manager.Ffdc.log(t, ModuleManifestParser.class, "com.ibm.ws.runtime.ModuleManifestParser.addInstalledOptionalPackages", "205");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception:", t);
                    }
                    Tr.error(tc, "UTLS0003", new Object[]{libraryName});
                    var19_21 = null;
                    try {
                        sharedLibrary.close();
                    }
                    catch (IOException ex) {
                        Manager.Ffdc.log(ex, ModuleManifestParser.class, "com.ibm.ws.runtime.ModuleManifestParser.addInstalledOptionalPackages", "294");
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                var19_21 = null;
                try {
                    sharedLibrary.close();
                }
                catch (IOException ex) {
                    Manager.Ffdc.log(ex, ModuleManifestParser.class, "com.ibm.ws.runtime.ModuleManifestParser.addInstalledOptionalPackages", "294");
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addInstalledOptionalPackages");
        }
    }

    private static String[] parseSpaceDelimitedStringToList(String extensionListValue) {
        if (extensionListValue != null) {
            return extensionListValue.split(" ");
        }
        return null;
    }
}

