/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.util;

import com.ibm.ws.policyset.admin.PolicyConstants;
import com.ibm.ws.policyset.util.FFDC;
import com.ibm.ws.policyset.util.FFDCFactory;
import com.ibm.ws.policyset.util.Trace;
import com.ibm.ws.policyset.util.TraceComponent;
import com.ibm.ws.policyset.util.TraceFactory;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;

public class Tr {
    private static final String clsName = Tr.class.getName();
    private static Trace trace;
    private static FFDC ffdc;
    private static Properties traceSettings;

    public static void init() {
        String tracefactory = null;
        String ffdcfactory = null;
        if (traceSettings == null) {
            traceSettings = new Properties();
            InputStream in = AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

                @Override
                public InputStream run() {
                    ClassLoader cl = this.getClass().getClassLoader();
                    Object adminServiceFactory = null;
                    Object aService = null;
                    InputStream in2 = null;
                    if (cl != null) {
                        in2 = cl.getResourceAsStream(PolicyConstants.PLATFORM_WEBSPHERE_THINCLIENT_PROP_FILE);
                        if (in2 != null) {
                            String adminServiceFactoryClassname = "com.ibm.websphere.management.AdminServiceFactory";
                            try {
                                adminServiceFactory = cl.loadClass(adminServiceFactoryClassname).newInstance();
                            }
                            catch (Exception e) {
                                try {
                                    adminServiceFactory = Class.forName(adminServiceFactoryClassname).newInstance();
                                }
                                catch (Exception ex) {
                                    e.printStackTrace();
                                }
                            }
                            if (adminServiceFactory != null) {
                                String getServiceMethod = "getAdminService";
                                Class<?> aClazz = adminServiceFactory.getClass();
                                try {
                                    Method aMethod = aClazz.getMethod(getServiceMethod, new Class[0]);
                                    aService = aMethod.invoke(adminServiceFactory, new Object[0]);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                            if (aService != null) {
                                in2 = cl.getResourceAsStream(PolicyConstants.PLATFORM_WEBSPHERE_SERVER_PROP_FILE);
                            }
                        } else {
                            in2 = cl.getResourceAsStream(PolicyConstants.PLATFORM_AXIS2_PROP_FILE);
                        }
                    }
                    return in2;
                }
            });
            if (in != null) {
                try {
                    traceSettings.load(in);
                    tracefactory = traceSettings.getProperty("com.ibm.ws.policyset.util.TraceFactory");
                    ffdcfactory = traceSettings.getProperty("com.ibm.ws.policyset.util.FFDCFactory");
                }
                catch (IOException ex) {
                    Tr.processException(ex, clsName + ".init", "43");
                }
            }
            if (tracefactory == null) {
                tracefactory = "com.ibm.ws.policyset.platform.axis2.util.LoggerTraceFactoryImpl";
            }
        }
        TraceFactory tf = (TraceFactory)Tr.loadImplFromClass(tracefactory);
        trace = tf.createTrace();
        if (ffdcfactory != null) {
            FFDCFactory ff = (FFDCFactory)Tr.loadImplFromClass(ffdcfactory);
            ffdc = ff.createFFDC();
        }
    }

    public static TraceComponent register(Class aClass, String group, String resourceBundleName) {
        if (trace == null) {
            Tr.init();
        }
        return trace.register(aClass, group, resourceBundleName);
    }

    public static final void audit(TraceComponent tc, String msgKey) {
        trace.audit(tc, msgKey);
    }

    public static final void audit(TraceComponent tc, String msgKey, Object objs) {
        trace.audit(tc, msgKey, objs);
    }

    public static final void debug(TraceComponent tc, String msg) {
        trace.debug(tc, msg);
    }

    public static final void debug(TraceComponent tc, String msg, Object objs) {
        trace.debug(tc, msg, objs);
    }

    public static final void error(TraceComponent tc, String msgKey) {
        trace.error(tc, msgKey);
    }

    public static final void error(TraceComponent tc, String msgKey, Object objs) {
        trace.error(tc, msgKey, objs);
    }

    public static final void warning(TraceComponent tc, String msgKey) {
        trace.warning(tc, msgKey);
    }

    public static final void warning(TraceComponent tc, String msgKey, Object objs) {
        trace.warning(tc, msgKey, objs);
    }

    public static final void info(TraceComponent tc, String msgKey) {
        trace.info(tc, msgKey);
    }

    public static final void info(TraceComponent tc, String msgKey, Object objs) {
        trace.info(tc, msgKey, objs);
    }

    public static final void entry(TraceComponent tc, String msg) {
        trace.entry(tc, msg);
    }

    public static final void entry(TraceComponent tc, String msg, Object objs) {
        trace.entry(tc, msg, objs);
    }

    public static final void exit(TraceComponent tc, String msg) {
        trace.exit(tc, msg);
    }

    public static final void exit(TraceComponent tc, String msg, Object objs) {
        trace.exit(tc, msg, objs);
    }

    public static Object loadImplFromClass(String classname) {
        ClassLoader cl = Tr.class.getClassLoader();
        try {
            Class<?> aClass = cl.loadClass(classname);
            return aClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            Tr.processException(e, clsName + ".loadImplFromClass", "137");
            e.printStackTrace();
            throw new IllegalStateException(e.getMessage());
        }
        catch (InstantiationException ex) {
            Tr.processException(ex, clsName + ".loadImplFromClass", "141");
            ex.printStackTrace();
            throw new IllegalStateException(ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            Tr.processException(ex, clsName + ".loadImplFromClass", "145");
            ex.printStackTrace();
            throw new IllegalStateException(ex.getMessage());
        }
    }

    public static void processException(Throwable th, String sourceId, String probeId) {
        if (ffdc != null) {
            ffdc.processException(th, sourceId, probeId);
        }
    }

    public static void processException(Throwable th, String sourceId, String probeId, Object callerThis) {
        if (ffdc != null) {
            ffdc.processException(th, sourceId, probeId, callerThis);
        }
    }

    public static void processException(Throwable th, String sourceId, String probeId, Object[] objectArray) {
        if (ffdc != null) {
            ffdc.processException(th, sourceId, probeId, objectArray);
        }
    }

    public static void processException(Throwable th, String sourceId, String probeId, Object callerThis, Object[] objectArray) {
        if (ffdc != null) {
            ffdc.processException(th, sourceId, probeId, callerThis, objectArray);
        }
    }

    static {
        traceSettings = null;
    }
}

