/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.util;

import com.ibm.ws.policyset.admin.PolicyConstants;
import com.ibm.ws.policyset.util.PlatformContextUtil;
import com.ibm.ws.policyset.util.Tr;
import com.ibm.ws.policyset.util.TraceComponent;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;

public class PolicySetFactoryBuilder {
    private static final TraceComponent tc = Tr.register(PolicySetFactoryBuilder.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private static Hashtable _factoryImpl = new Hashtable();
    private static Hashtable _factoryImplClassNames = new Hashtable();
    private static Hashtable _jarFactoryImpl = new Hashtable();
    private static Hashtable _jarFactoryImplClassNames = new Hashtable();

    public static Object getInstance(String factoryClass) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance", factoryClass);
        }
        if (_factoryImpl != null && _factoryImpl.containsKey(factoryClass)) {
            return _factoryImpl.get(factoryClass);
        }
        final String className = (String)PolicySetFactoryBuilder.getImplClassName(factoryClass);
        Object cf = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return PolicySetFactoryBuilder.loadImplFromClass(className);
            }
        });
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "factory key = " + factoryClass);
            Tr.debug(tc, "factory impl class = " + className);
        }
        _factoryImpl.put(factoryClass, cf);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance, factoryClass=", factoryClass + ", className=" + className);
        }
        return cf;
    }

    public static Object getInstance(String factoryClass, boolean cache) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance, factoryClass=", factoryClass + ", cache=" + cache);
        }
        if (cache) {
            return PolicySetFactoryBuilder.getInstance(factoryClass);
        }
        final String className = (String)PolicySetFactoryBuilder.getImplClassName(factoryClass);
        Object cf = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return PolicySetFactoryBuilder.loadImplFromClass(className);
            }
        });
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "factory key = " + factoryClass);
            Tr.debug(tc, "factory impl class = " + className);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance, factoryClass=", factoryClass + ", className=" + className);
        }
        return cf;
    }

    public static Object getInstance(String factoryClass, String envContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance, factoryClass=", factoryClass + ", envContext=" + envContext);
        }
        if (envContext == null || envContext.equals("")) {
            return PolicySetFactoryBuilder.getInstance(factoryClass);
        }
        if (envContext.equals(PolicyConstants.JAR_CONTEXT)) {
            if (_jarFactoryImpl != null && _jarFactoryImpl.containsKey(factoryClass)) {
                return _jarFactoryImpl.get(factoryClass);
            }
        } else if (_factoryImpl != null && _factoryImpl.containsKey(factoryClass)) {
            return _factoryImpl.get(factoryClass);
        }
        final String className = (String)PolicySetFactoryBuilder.getImplClassName(factoryClass, envContext);
        Object cf = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return PolicySetFactoryBuilder.loadImplFromClass(className);
            }
        });
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "factory key = " + factoryClass);
            Tr.debug(tc, "factory impl class = " + className);
        }
        if (envContext.equals(PolicyConstants.JAR_CONTEXT)) {
            _jarFactoryImpl.put(factoryClass, cf);
        } else {
            _factoryImpl.put(factoryClass, cf);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance, factoryClass=", factoryClass + ", className=" + className);
        }
        return cf;
    }

    public static Object loadImplFromClass(String classname) {
        ClassLoader cl = PolicySetFactoryBuilder.class.getClassLoader();
        try {
            Class<?> aClass = cl.loadClass(classname);
            return aClass.newInstance();
        }
        catch (Exception e) {
            try {
                Class<?> bClass = Class.forName(classname);
                return bClass.newInstance();
            }
            catch (Exception ex) {
                if (tc.isDebugEnabled()) {
                    ex.printStackTrace();
                }
                return null;
            }
        }
    }

    public static Object getImplClassName(String factoryClass) {
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getImplClassName", factoryClass);
            }
            if (_factoryImplClassNames != null && !_factoryImplClassNames.isEmpty()) {
                return _factoryImplClassNames.get(factoryClass);
            }
            String platform = null;
            platform = PlatformContextUtil.isWebSphereThinClient() ? PolicyConstants.PLATFORM_WEBSPHERE_THINCLIENT_PROP_FILE : (PlatformContextUtil.isWebSphereServerProcess() ? PolicyConstants.PLATFORM_WEBSPHERE_SERVER_PROP_FILE : PolicyConstants.PLATFORM_AXIS2_PROP_FILE);
            InputStream in = PolicySetFactoryBuilder.class.getClassLoader().getResourceAsStream(platform);
            if (in == null) {
                ClassLoader loader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() {
                        return Thread.currentThread().getContextClassLoader();
                    }
                });
                in = loader == null ? ClassLoader.getSystemResourceAsStream(platform) : loader.getResourceAsStream(platform);
            }
            if (in != null) {
                try {
                    String line;
                    BufferedReader br = new BufferedReader(new InputStreamReader(in));
                    while ((line = br.readLine()) != null) {
                        if (!line.startsWith("com.ibm") || line.indexOf(61) <= 0) continue;
                        int begin_index = line.indexOf(61) + 1;
                        String key = line.substring(0, begin_index - 1);
                        String value = line.substring(begin_index);
                        if (key == null || value == null) continue;
                        _factoryImplClassNames.put(key, value);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "factory key = " + key);
                        Tr.debug(tc, "factory impl class name = " + value);
                    }
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block8;
                    Tr.debug(tc, "Exception while create WSSecurity factory.", e);
                    e.printStackTrace();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getImplClassName, factoryClass=", factoryClass);
        }
        return _factoryImplClassNames.get(factoryClass);
    }

    public static Object getImplClassName(String factoryClass, String envContext) {
        String returnClass;
        block14: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getImplClassName", factoryClass + ", envContext=" + envContext);
            }
            if (envContext == null || envContext.equals("")) {
                return PolicySetFactoryBuilder.getImplClassName(factoryClass);
            }
            if (envContext.equals(PolicyConstants.JAR_CONTEXT)) {
                if (_jarFactoryImplClassNames != null && !_jarFactoryImplClassNames.isEmpty()) {
                    return _jarFactoryImplClassNames.get(factoryClass);
                }
            } else if (_factoryImplClassNames != null && !_factoryImplClassNames.isEmpty()) {
                return _factoryImplClassNames.get(factoryClass);
            }
            String platform = null;
            returnClass = null;
            platform = envContext.equals(PolicyConstants.CLIENT_CONTEXT) || envContext.equals(PolicyConstants.JAR_CONTEXT) ? PolicyConstants.PLATFORM_WEBSPHERE_THINCLIENT_PROP_FILE : (envContext.equals(PolicyConstants.SERVER_CONTEXT) ? PolicyConstants.PLATFORM_WEBSPHERE_SERVER_PROP_FILE : PolicyConstants.PLATFORM_AXIS2_PROP_FILE);
            InputStream in = PolicySetFactoryBuilder.class.getClassLoader().getResourceAsStream(platform);
            if (in == null) {
                ClassLoader loader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() {
                        return Thread.currentThread().getContextClassLoader();
                    }
                });
                in = loader == null ? ClassLoader.getSystemResourceAsStream(platform) : loader.getResourceAsStream(platform);
            }
            if (in != null) {
                try {
                    String line;
                    boolean foundKey = false;
                    BufferedReader br = new BufferedReader(new InputStreamReader(in));
                    while ((line = br.readLine()) != null && !foundKey) {
                        if (!line.startsWith("com.ibm") || line.indexOf(61) <= 0) continue;
                        int begin_index = line.indexOf(61) + 1;
                        String key = line.substring(0, begin_index - 1);
                        String value = line.substring(begin_index);
                        if (key == null || value == null || !key.equals(factoryClass)) continue;
                        returnClass = value;
                        foundKey = true;
                        if (envContext.equals(PolicyConstants.JAR_CONTEXT)) {
                            _jarFactoryImplClassNames.put(key, value);
                        } else {
                            _factoryImplClassNames.put(key, value);
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "factory key = " + key);
                        Tr.debug(tc, "factory impl class name = " + value);
                    }
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block14;
                    Tr.debug(tc, "Exception while create WSSecurity factory.", e);
                    e.printStackTrace();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getImplClassName, factoryClass=", factoryClass + ", envContext=" + envContext);
        }
        return returnClass;
    }
}

