/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.util;

import com.ibm.ws.policyset.admin.PolicyConstants;
import com.ibm.ws.policyset.platform.util.PlatformContext;
import com.ibm.ws.policyset.util.Tr;
import com.ibm.ws.policyset.util.TraceComponent;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class PlatformContextUtil {
    private static final TraceComponent tc = Tr.register(PlatformContextUtil.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private static boolean isWebSphereServerProcess = false;
    private static boolean isWebSphereThinClient = false;
    private static boolean initialized = false;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean initialize() {
        String platform = PolicyConstants.PLATFORM_WEBSPHERE_THINCLIENT_PROP_FILE;
        ClassLoader loader = PlatformContextUtil.class.getClassLoader();
        InputStream in = loader.getResourceAsStream(platform);
        if (in == null) {
            loader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
            in = loader == null ? ClassLoader.getSystemResourceAsStream(platform) : loader.getResourceAsStream(platform);
        }
        PlatformContext pc = null;
        if (in != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WebSphere platform.");
            }
            String classname = "com.ibm.ws.policyset.util.PlatformContextImpl";
            try {
                pc = loader != null ? (PlatformContext)loader.loadClass(classname).newInstance() : (PlatformContext)Class.forName(classname).newInstance();
            }
            catch (Exception e) {
                try {
                    pc = (PlatformContext)Class.forName(classname).newInstance();
                }
                catch (Exception ex) {
                    e.printStackTrace();
                }
            }
            if (pc == null) {
                Tr.error(tc, "Runtime is unable to identify process environment.");
                throw new RuntimeException("Runtime is unable to identify process environment.");
            }
            isWebSphereThinClient = pc.isClientProcess();
            isWebSphereServerProcess = pc.isServerProcess();
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Not WebSphere platform.");
        }
        initialized = true;
        return true;
    }

    public static boolean isWebSphereServerProcess() {
        if (!initialized) {
            PlatformContextUtil.initialize();
        }
        return isWebSphereServerProcess;
    }

    public static boolean isWebSphereThinClient() {
        if (!initialized) {
            PlatformContextUtil.initialize();
        }
        return isWebSphereThinClient;
    }
}

