/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.util;

import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.policyset.platform.util.PlatformContext;
import com.ibm.ws.policyset.util.Tr;
import com.ibm.ws.policyset.util.TraceComponent;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class PlatformContextImpl
implements PlatformContext {
    private static final TraceComponent tc = Tr.register(PlatformContextImpl.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private static boolean isWebSphereServerProcess = false;
    private static boolean isWebSphereThinClient = false;
    private static boolean initialized = false;

    private static boolean initialize() {
        initialized = false;
        AdminService adminService = null;
        try {
            adminService = AccessController.doPrivileged(new PrivilegedAction<AdminService>(){

                @Override
                public AdminService run() {
                    return AdminServiceFactory.getAdminService();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (adminService != null) {
            isWebSphereServerProcess = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isWebSphereServerProcess = " + isWebSphereServerProcess);
            }
        } else {
            isWebSphereThinClient = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isWebSphereThinClient:" + isWebSphereThinClient);
            }
        }
        initialized = true;
        return true;
    }

    public boolean isServerProcess() {
        if (!initialized) {
            PlatformContextImpl.initialize();
        }
        return isWebSphereServerProcess;
    }

    public boolean isClientProcess() {
        if (!initialized) {
            PlatformContextImpl.initialize();
        }
        return isWebSphereThinClient;
    }
}

