/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.runtime;

import com.ibm.ws.policyset.runtime.PolicySetAttachments;
import com.ibm.ws.policyset.runtime.WSPolicyEnabler;
import com.ibm.ws.policyset.util.Tr;
import com.ibm.ws.policyset.util.TraceComponent;
import com.ibm.ws.wspolicy.policyset.WSPolicyAttachments;
import com.ibm.ws.wspolicy.policyset.WSPolicyFactory;
import com.ibm.ws.wspolicy.policyset.WSPolicyProcessor;
import java.util.Locale;
import java.util.ResourceBundle;

public class WSPolicyEnablerImpl
implements WSPolicyEnabler {
    private static TraceComponent tc = Tr.register(WSPolicyEnablerImpl.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", Locale.getDefault());
    protected String SOURCE_FILE = this.getClass().getName();
    private WSPolicyProcessor wsPolicyProcessor = null;
    private String pathName = null;
    private String serviceName = null;
    private String moduleName = null;

    public void createWSPolicyProcessor(String path, String service, String module) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createWSPolicyProcessor, path=", path + ", service=" + service + ", module=" + module);
        }
        this.pathName = path;
        this.serviceName = service;
        this.moduleName = module;
        this.wsPolicyProcessor = WSPolicyFactory.newInstance().createPolicyProcessor(this.pathName.substring(0, this.pathName.indexOf("clientPolicyAttachments.xml") - 1), this.serviceName, this.moduleName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createWSPolicyProcessor");
        }
    }

    public boolean isWSPolicyProcessingRequired() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isWSPolicyProcessingRequired");
        }
        boolean wsPolicyEnabled = false;
        if (this.wsPolicyProcessor != null) {
            wsPolicyEnabled = this.wsPolicyProcessor.isWSPolicyProcessingRequired();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isWSPolicyProcessingRequired", wsPolicyEnabled);
        }
        return wsPolicyEnabled;
    }

    public PolicySetAttachments getAttachments(PolicySetAttachments attachments) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttachments, attachments=", attachments);
        }
        WSPolicyAttachments wsPolicyAttachments = WSPolicyFactory.newInstance().createWSPolicyAttachments(this.wsPolicyProcessor, attachments, this.pathName, this.serviceName, this.moduleName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttachments");
        }
        return wsPolicyAttachments;
    }
}

