/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.runtime;

import com.ibm.ws.policyset.admin.PolicyConstants;
import com.ibm.ws.policyset.runtime.BindingAggregator;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.policyset.runtime.PolicySetConfigurationImpl;
import com.ibm.ws.policyset.runtime.PolicyTypeAggregator;
import com.ibm.ws.policyset.runtime.ResourceEvaluator;
import com.ibm.ws.policyset.runtime.TrustClientPolicySetAttachments;
import com.ibm.ws.policyset.util.Tr;
import com.ibm.ws.policyset.util.TraceComponent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TrustClientPolicySetAttachmentsImpl
implements TrustClientPolicySetAttachments {
    private String applicationPath = null;
    String attachmentType = "client";
    private Map attachmentConfigs = null;
    private PolicySetConfiguration emptyPsConfig = new PolicySetConfigurationImpl();
    private PolicySetConfigurationImpl _policySetConfig = null;
    private static TraceComponent tc = Tr.register(TrustClientPolicySetAttachmentsImpl.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");

    public TrustClientPolicySetAttachmentsImpl(String parentDir) {
        this.applicationPath = parentDir;
        this.attachmentConfigs = new HashMap();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "TrustClientPolicySetAttachmentsImpl new instance");
        }
    }

    @Override
    public PolicySetConfiguration getPolicySet(ClassLoader appClassLoader, ClassLoader systemClassLoader, String policySetName, String bindingName, String bindingScope) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "TrustClientPolicySetAttachmentsImpl.getPolicySet(ClassLoader appClassLoader, ClassLoader systemClassLoader, String policySetName = " + policySetName + ",String bindingName = " + bindingName + ", String bindingScope = " + bindingScope + ")", new Object[]{appClassLoader, systemClassLoader});
        }
        PolicySetConfiguration psConfig = null;
        if (policySetName != null && !policySetName.equals("")) {
            if (psConfig == null) {
                psConfig = this.getPSConfig(appClassLoader, systemClassLoader, policySetName, bindingName, bindingScope, null);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getPolicySet, policy set name is null");
            }
            psConfig = this.emptyPsConfig;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "TrustClientPolicySetAttachmentsImpl.getPolicySet(ClassLoader appClassLoader, ClassLoader systemClassLoader, String policySetName = " + policySetName + ",String bindingName = " + bindingName + ", String bindingScope = " + bindingScope + ")");
        }
        return psConfig;
    }

    @Override
    public PolicySetConfiguration getPolicySet(ClassLoader appClassLoader, ClassLoader systemClassLoader, String policySetName, String bindingName, String bindingScope, boolean loadFromJar) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "TrustClientPolicySetAttachmentsImpl.getPolicySet(ClassLoader appClassLoader, ClassLoader systemClassLoader, String policySetName = " + policySetName + ",String bindingName = " + bindingName + ", String bindingScope = " + bindingScope + ", String loadFromJar = " + loadFromJar + ")", new Object[]{appClassLoader, systemClassLoader});
        }
        if (!loadFromJar) {
            return this.getPolicySet(appClassLoader, systemClassLoader, policySetName, bindingName, bindingScope);
        }
        PolicySetConfiguration psConfig = null;
        if (policySetName != null && !policySetName.equals("")) {
            String savedApplicationPath = this.applicationPath;
            this.applicationPath = "META-INF";
            if (psConfig == null) {
                psConfig = this.getPSConfig(appClassLoader, systemClassLoader, policySetName, bindingName, bindingScope, PolicyConstants.JAR_CONTEXT);
            }
            this.applicationPath = savedApplicationPath;
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getPolicySet, policy set name is null");
            }
            psConfig = this.emptyPsConfig;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "TrustClientPolicySetAttachmentsImpl.getPolicySet(ClassLoader appClassLoader, ClassLoader systemClassLoader, String policySetName = " + policySetName + ",String bindingName = " + bindingName + ", String bindingScope = " + bindingScope + ", String loadFromJar = " + loadFromJar + ")");
        }
        return psConfig;
    }

    @Override
    public PolicySetConfiguration getPolicySet(String resourceName, ClassLoader appClassLoader, ClassLoader systemClassLoader) {
        return this._policySetConfig;
    }

    @Override
    public PolicySetConfiguration getPolicySet(String resourceName, ResourceEvaluator resourceEvaluator, ClassLoader appClassLoader, ClassLoader systemClassLoader) {
        return this._policySetConfig;
    }

    @Override
    public boolean isAttached(String resourceName) {
        return false;
    }

    @Override
    public boolean isAttached(String resourceName, ResourceEvaluator resourceEvaluator) {
        return false;
    }

    @Override
    public List<String> getResourceNames() {
        return null;
    }

    private PolicySetConfiguration getPSConfig(ClassLoader appCL, ClassLoader sysCL, String psName, String bindingName, String bindingScope, String envContext) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "TrustClientPolicySetAttachmentsImpl.getPSConfig", new Object[]{psName, bindingName, bindingScope, envContext});
        }
        List<?> types = TrustClientPolicySetAttachmentsImpl.getTypesForPolicySet(psName, envContext);
        PolicySetConfiguration psConfig = PolicyTypeAggregator.getPolicySetConfiguration(sysCL, psName, types, envContext);
        psConfig.setPolicyTypeConfiguration("attachmentType", this.attachmentType);
        if (bindingScope == null && bindingName != null && !bindingName.equals("")) {
            boolean exists = BindingAggregator.doesBindingExist(this.applicationPath, bindingName, "application", envContext);
            if (exists) {
                bindingScope = "application";
            } else {
                exists = BindingAggregator.doesBindingExist(this.applicationPath, bindingName, "domain", envContext);
                if (exists) {
                    bindingScope = "domain";
                }
            }
        }
        BindingAggregator.getCustomBinding(this.applicationPath, bindingName, appCL, sysCL, psConfig, types, this.attachmentType, bindingScope, envContext);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "TrustClientPolicySetAttachmentsImpl.getPSConfig", psName);
        }
        return psConfig;
    }

    private static synchronized List<?> getTypesForPolicySet(String policySet, String envContext) throws Exception {
        List types = PolicyTypeAggregator.getTypesForPolicySet(policySet, envContext);
        return types;
    }

    private PolicySetConfiguration getPSConfigFromCache(TrustClientAttachmentConfig inputClass) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPSConfigFromCache");
        }
        PolicySetConfiguration psConfig = null;
        boolean matchFound = false;
        Set configKeys = this.attachmentConfigs.keySet();
        Iterator iter = configKeys.iterator();
        while (iter.hasNext() && !matchFound) {
            TrustClientAttachmentConfig attachConfig = (TrustClientAttachmentConfig)iter.next();
            if (attachConfig == null || !attachConfig.isEqual(inputClass)) continue;
            matchFound = true;
            psConfig = (PolicySetConfiguration)this.attachmentConfigs.get(attachConfig);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPSConfigFromCache");
        }
        return psConfig;
    }

    private static class TrustClientAttachmentConfig {
        private ClassLoader applicationCL;
        private ClassLoader systemCL;
        private String policySetName;
        private String bindingName;
        private String bindingScope;
        private String envContext;

        private TrustClientAttachmentConfig(ClassLoader appCL, ClassLoader sysCL, String psName, String bindName, String bindScope, String envCxt) {
            this.applicationCL = appCL;
            this.systemCL = sysCL;
            this.policySetName = psName;
            this.bindingName = bindName;
            this.bindingScope = bindScope;
            this.envContext = envCxt;
        }

        private boolean isEqual(TrustClientAttachmentConfig inputClass) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "isEqual, inputClass=" + inputClass);
            }
            ClassLoader appCL = inputClass.applicationCL;
            ClassLoader sysCL = inputClass.systemCL;
            String psName = inputClass.policySetName;
            String bindName = inputClass.bindingName;
            String bindScope = inputClass.bindingScope;
            String envCxt = inputClass.envContext;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isEqual, input class: appCL = " + appCL + ", sysCL = " + sysCL + ", psName = " + psName + ", bindName = " + bindName + ", bindScope = " + bindScope + ", envCxt = " + envCxt);
                Tr.debug(tc, "isEqual, base class: applicationCL = " + this.applicationCL + ", systemCL = " + this.systemCL + ", policySetName = " + this.policySetName + ", bindingName = " + this.bindingName + ", bindingScope = " + this.bindingScope + ", envContext = " + this.envContext);
            }
            boolean classEqual = false;
            classEqual = this.applicationCL != null && appCL != null ? this.applicationCL.equals(appCL) : this.applicationCL == null && appCL == null;
            if (classEqual) {
                classEqual = this.systemCL != null && sysCL != null ? this.systemCL.equals(sysCL) : this.systemCL == null && sysCL == null;
            }
            if (classEqual) {
                classEqual = this.policySetName != null && psName != null ? this.policySetName.equals(psName) : this.policySetName == null && psName == null;
            }
            if (classEqual) {
                classEqual = this.bindingName != null && bindName != null ? this.bindingName.equals(bindName) : this.bindingName == null && bindName == null;
            }
            if (classEqual) {
                classEqual = this.bindingScope != null && bindScope != null ? this.bindingScope.equals(bindScope) : this.bindingScope == null && bindScope == null;
            }
            if (classEqual) {
                classEqual = this.envContext != null && envCxt != null ? this.envContext.equals(envCxt) : this.envContext == null && envCxt == null;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isEqual, classEqual=" + classEqual);
            }
            return classEqual;
        }
    }
}

