/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.runtime;

import com.ibm.ws.policyset.admin.PolicySetHelper;
import com.ibm.ws.policyset.admin.PolicySetHelperFactory;
import com.ibm.ws.policyset.admin.commands.util.CommonUtil;
import com.ibm.ws.policyset.runtime.ExtensionLoader;
import com.ibm.ws.policyset.runtime.ExtensionLoaderFactory;
import com.ibm.ws.policyset.runtime.FileAccessor;
import com.ibm.ws.policyset.runtime.FileLocator;
import com.ibm.ws.policyset.runtime.FileLocatorFactory;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.policyset.runtime.PolicySetConfigurationImpl;
import com.ibm.ws.policyset.runtime.PolicySetUtil;
import com.ibm.ws.policyset.runtime.PolicyTypeLoader;
import com.ibm.ws.policyset.runtime.VariableExpander;
import com.ibm.ws.policyset.runtime.VariableExpanderFactory;
import com.ibm.ws.policyset.util.Tr;
import com.ibm.ws.policyset.util.TraceComponent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.bind.JAXBException;

public class PolicyTypeAggregator {
    private static TraceComponent tc = Tr.register(PolicyTypeAggregator.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", Locale.getDefault());
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private static final String FFDC_ID_3 = "FFDC-3";
    private static final String FFDC_ID_4 = "FFDC-4";
    private static final String FFDC_ID_5 = "FFDC-5";
    private static final String FFDC_ID_6 = "FFDC-6";
    private static final String FFDC_ID_7 = "FFDC-7";
    private static final String FFDC_ID_8 = "FFDC-8";
    private static final String FFDC_ID_9 = "FFDC-9";
    private static final String FFDC_ID_10 = "FFDC-10";
    private static final String FFDC_ID_11 = "FFDC-11";
    private static String className = "com.ibm.ws.policyset.runtime.PolicyTypeAggregator";
    private static Map policySetConfigs = new HashMap();
    private static Map policySetTypes = new HashMap();
    private static Integer policySetConfigsLock = new Integer(0);
    private static List extensions = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PolicySetConfiguration getPolicySetConfiguration(ClassLoader systemCL, String policySetName, List types) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPolicySetConfiguration", policySetName);
        }
        PolicySetConfigurationImpl psConfig = null;
        Integer n = policySetConfigsLock;
        synchronized (n) {
            psConfig = (PolicySetConfigurationImpl)policySetConfigs.get(policySetName);
            if (psConfig == null) {
                try {
                    psConfig = new PolicySetConfigurationImpl();
                    psConfig.setPolicyTypeConfiguration("com.ibm.ws.policyset.POLICY_NAME_KEY", policySetName);
                    List extensions = PolicyTypeAggregator.getExtensions();
                    VariableExpander variableExpander = VariableExpanderFactory.getVariableExpander();
                    for (PolicyTypeLoader loader : extensions) {
                        try {
                            if (types != null && types.contains(loader.getType())) {
                                InputStream policyTypeConfig = PolicyTypeAggregator.getPolicyTypeInputStream(policySetName, loader.getType());
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "About to call load on " + loader.getClass().getName());
                                }
                                loader.load(systemCL, variableExpander, policyTypeConfig, psConfig);
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "Back from load on " + loader.getClass().getName());
                                continue;
                            }
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Policy type is not included in policy set: " + loader.getType());
                        }
                        catch (Throwable t) {
                            Tr.processException(t, className, FFDC_ID_1);
                        }
                    }
                    policySetConfigs.put(policySetName, psConfig);
                }
                catch (Throwable t) {
                    Tr.processException(t, className, FFDC_ID_2);
                }
            }
            psConfig = new PolicySetConfigurationImpl(psConfig);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPolicySetConfiguration", policySetName);
        }
        return psConfig;
    }

    public static PolicySetConfiguration getPolicySetConfiguration(ClassLoader systemCL, String policySetName, List types, String envContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPolicySetConfiguration", policySetName + ", envContext=" + envContext);
        }
        if (envContext == null || envContext.equals("")) {
            return PolicyTypeAggregator.getPolicySetConfiguration(systemCL, policySetName, types);
        }
        PolicySetConfigurationImpl psConfig = null;
        try {
            psConfig = new PolicySetConfigurationImpl();
            psConfig.setPolicyTypeConfiguration("com.ibm.ws.policyset.POLICY_NAME_KEY", policySetName);
            List extensions = PolicyTypeAggregator.getExtensions();
            VariableExpander variableExpander = VariableExpanderFactory.getVariableExpander();
            for (PolicyTypeLoader loader : extensions) {
                try {
                    if (types != null && types.contains(loader.getType())) {
                        InputStream policyTypeConfig = PolicyTypeAggregator.getPolicyTypeInputStream(policySetName, loader.getType(), envContext);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "About to call load on " + loader.getClass().getName());
                        }
                        loader.load(systemCL, variableExpander, policyTypeConfig, psConfig);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Back from load on " + loader.getClass().getName());
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Policy type is not included in policy set: " + loader.getType());
                }
                catch (Throwable t) {
                    Tr.processException(t, className, FFDC_ID_7);
                }
            }
        }
        catch (Throwable t) {
            Tr.processException(t, className, FFDC_ID_8);
        }
        psConfig = new PolicySetConfigurationImpl(psConfig);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPolicySetConfiguration", policySetName + ", envContext=" + envContext);
        }
        return psConfig;
    }

    public static List getExtensions() {
        if (extensions == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Loading policy type loader extensions");
            }
            extensions = new ArrayList();
            String extensionPointId = PolicySetUtil.isClient() ? "com.ibm.wsfp.thinclient.ibmaxis2-qos-policytypeloader" : "com.ibm.wsfp.main.ibmaxis2-qos-policytypeloader";
            ExtensionLoader extLoader = ExtensionLoaderFactory.getExtensionLoader();
            String[] elements = extLoader.getElements(extensionPointId, "com.ibm.wsfp.main.ibmaxis2-qos-policytypeloader");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found " + elements.length + " extensions for " + extensionPointId);
            }
            if (elements != null) {
                HashMap properties = new HashMap();
                for (int i = 0; i < elements.length; ++i) {
                    try {
                        String classname = elements[i];
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found " + classname);
                        }
                        Class<?> loaderClass = Class.forName(classname);
                        Constructor<?> constructor = loaderClass.getConstructor(new Class[0]);
                        PolicyTypeLoader loader = (PolicyTypeLoader)constructor.newInstance(new Object[0]);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "About to call init on " + classname);
                        }
                        loader.init(properties);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "back from call init on " + classname);
                        }
                        extensions.add(loader);
                        continue;
                    }
                    catch (Throwable t) {
                        Tr.processException(t, className, FFDC_ID_3);
                    }
                }
            }
        }
        return extensions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized List getTypesForPolicySet(String policySet) throws Exception {
        List types = null;
        Integer n = policySetConfigsLock;
        synchronized (n) {
            types = (List)policySetTypes.get(policySet);
            if (types == null) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Looking up types for policy set " + policySet);
                    }
                    String path = FileLocatorFactory.getFileLocator().getPolicySetPath(policySet);
                    final InputStream istream = FileAccessor.getInputStream(path);
                    try {
                        types = AccessController.doPrivileged(new PrivilegedExceptionAction<List>(){

                            @Override
                            public List run() throws JAXBException, FileNotFoundException, IOException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
                                PolicySetHelper psHelper = PolicySetHelperFactory.createHelper(istream);
                                return psHelper.listEnabledPolicyTypes();
                            }
                        });
                    }
                    catch (PrivilegedActionException e) {
                        Tr.processException(e, "com.ibm.ws.policyset.runtime.PolicyTypeAggregator", FFDC_ID_4);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception thrown in listEnabledPolicyTypes");
                        }
                        throw e.getException();
                    }
                    policySetTypes.put(policySet, types);
                    if (tc.isDebugEnabled()) {
                        String list = "";
                        if (types != null) {
                            Iterator i = types.iterator();
                            while (i.hasNext()) {
                                list = list + (String)i.next() + " ";
                            }
                        }
                        Tr.debug(tc, "Policy set has types " + list);
                    }
                }
                catch (FileNotFoundException e) {
                    Tr.processException(e, "com.ibm.ws.policyset.runtime.PolicyTypeAggregator", FFDC_ID_5);
                    throw new FileNotFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0055E", new Object[]{policySet}, "Policy set is not found: {0}"));
                }
                catch (Throwable t) {
                    Tr.processException(t, "com.ibm.ws.policyset.runtime.PolicyTypeAggregator", FFDC_ID_6);
                }
            }
        }
        return types;
    }

    public static List getTypesForPolicySet(String policySet, String envContext) throws Exception {
        if (envContext == null || envContext.equals("")) {
            return PolicyTypeAggregator.getTypesForPolicySet(policySet);
        }
        List types = null;
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Looking up types for policy set " + policySet);
            }
            String path = FileLocatorFactory.getFileLocator(envContext).getPolicySetPath(policySet);
            final InputStream istream = FileAccessor.getInputStream(path, envContext);
            try {
                types = AccessController.doPrivileged(new PrivilegedExceptionAction<List>(){

                    @Override
                    public List run() throws JAXBException, FileNotFoundException, IOException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
                        PolicySetHelper psHelper = PolicySetHelperFactory.createHelper(istream);
                        return psHelper.listEnabledPolicyTypes();
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Tr.processException(e, "com.ibm.ws.policyset.runtime.PolicyTypeAggregator", FFDC_ID_9);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception thrown in listEnabledPolicyTypes");
                }
                throw e.getException();
            }
            if (tc.isDebugEnabled()) {
                String list = "";
                if (types != null) {
                    Iterator i = types.iterator();
                    while (i.hasNext()) {
                        list = list + (String)i.next() + " ";
                    }
                }
                Tr.debug(tc, "Policy set has types " + list);
            }
        }
        catch (FileNotFoundException e) {
            Tr.processException(e, "com.ibm.ws.policyset.runtime.PolicyTypeAggregator", FFDC_ID_10);
            throw new FileNotFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0055E", new Object[]{policySet}, "Policy set is not found: {0}"));
        }
        catch (Throwable t) {
            Tr.processException(t, "com.ibm.ws.policyset.runtime.PolicyTypeAggregator", FFDC_ID_11);
        }
        return types;
    }

    public static InputStream getPolicyTypeInputStream(String policySet, String policyType) {
        FileLocator locator = FileLocatorFactory.getFileLocator();
        String path = locator.getPolicyTypeConfigPath(policySet, policyType);
        InputStream input = FileAccessor.getInputStream(path);
        return input;
    }

    public static InputStream getPolicyTypeInputStream(String policySet, String policyType, String envContext) {
        FileLocator locator = FileLocatorFactory.getFileLocator(envContext);
        String path = locator.getPolicyTypeConfigPath(policySet, policyType);
        InputStream input = FileAccessor.getInputStream(path, envContext);
        return input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void refresh() {
        Integer n = policySetConfigsLock;
        synchronized (n) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Resetting policySetConfigs and policySetTypes");
            }
            policySetConfigs = new HashMap();
            policySetTypes = new HashMap();
        }
    }
}

