/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.runtime;

import com.ibm.ws.policyset.admin.PolicySetAttachmentHelper;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelperFactory;
import com.ibm.ws.policyset.admin.commands.util.CommonUtil;
import com.ibm.ws.policyset.runtime.BindingAggregator;
import com.ibm.ws.policyset.runtime.EmptyPolicySetAttachmentsImpl;
import com.ibm.ws.policyset.runtime.FileAccessor;
import com.ibm.ws.policyset.runtime.FileLocator;
import com.ibm.ws.policyset.runtime.FileLocatorFactory;
import com.ibm.ws.policyset.runtime.PolicySetAttachments;
import com.ibm.ws.policyset.runtime.PolicySetAttachmentsImpl;
import com.ibm.ws.policyset.runtime.PolicySetRuntimeUtil;
import com.ibm.ws.policyset.runtime.PolicySetRuntimeUtilFactory;
import com.ibm.ws.policyset.runtime.TrustClientPolicySetAttachments;
import com.ibm.ws.policyset.runtime.TrustClientPolicySetAttachmentsImpl;
import com.ibm.ws.policyset.runtime.WSPolicyEnabler;
import com.ibm.ws.policyset.runtime.WSPolicyEnablerFactory;
import com.ibm.ws.policyset.util.PlatformContextUtil;
import com.ibm.ws.policyset.util.Tr;
import com.ibm.ws.policyset.util.TraceComponent;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.PolicySetAttachment;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.xml.bind.JAXBException;

public class PolicySetUtil {
    private static TraceComponent tc = Tr.register(PolicySetUtil.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", Locale.getDefault());
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private String className = this.getClass().getName();
    private static PolicySetUtil policySetUtil = null;
    private ClassLoader systemCL = null;
    private static FileLocator fileLocator = null;
    private static Boolean client = null;
    public static final ThreadLocal<String> _CU_NAME = new ThreadLocal();

    public static synchronized PolicySetUtil getInstance(ClassLoader sysCL) {
        if (policySetUtil == null) {
            policySetUtil = new PolicySetUtil();
            policySetUtil.init(sysCL);
            policySetUtil.initMBean();
        }
        return policySetUtil;
    }

    private PolicySetUtil() {
    }

    private void init(ClassLoader sysCL) {
        this.systemCL = sysCL;
    }

    public PolicySetAttachments getAttachments(String appName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttachments", appName);
        }
        String pathname = this.getAttachmentPath(appName, "policyAttachments.xml");
        PolicySetAttachments attachments = this.getAttachmentsFromFile(pathname, "application");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttachments", appName);
        }
        return attachments;
    }

    public PolicySetAttachments getClientAttachments(String appName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClientAttachments", appName);
        }
        String pathname = this.getAttachmentPath(appName, "clientPolicyAttachments.xml");
        PolicySetAttachments attachments = this.getAttachmentsFromFile(pathname, "client");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClientAttachments", appName);
        }
        return attachments;
    }

    public PolicySetAttachments getClientAttachments(String appName, String serviceName, String moduleName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClientAttachments", appName);
        }
        String pathname = this.getAttachmentPath(appName, "clientPolicyAttachments.xml");
        PolicySetAttachments attachments = this.getAttachmentsFromFile(pathname, "client");
        if (pathname != null) {
            WSPolicyEnabler wsPolicyEnabler = WSPolicyEnablerFactory.createEnabler();
            wsPolicyEnabler.createWSPolicyProcessor(pathname, serviceName, moduleName);
            if (wsPolicyEnabler.isWSPolicyProcessingRequired()) {
                PolicySetAttachments wsPolicyAttachments;
                attachments = wsPolicyAttachments = wsPolicyEnabler.getAttachments(attachments);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClientAttachments", appName);
        }
        return attachments;
    }

    public PolicySetAttachments getClientAttachments(String busName, String wsnServiceName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClientAttachments, busName=", busName + ", wsnServiceName=" + wsnServiceName);
        }
        String pathname = this.getWsnClientAttachmentPath(busName, wsnServiceName, "clientPolicyAttachments.xml");
        PolicySetAttachments attachments = this.getAttachmentsFromFile(pathname, "client");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClientAttachments, busName=", busName + ", wsnServiceName=" + wsnServiceName);
        }
        return attachments;
    }

    public PolicySetAttachments getAttachments(Properties assetProps) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttachments, assetProps=", assetProps);
        }
        String pathname = null;
        if (assetProps.containsKey("cuName")) {
            String cuName = assetProps.getProperty("cuName");
            pathname = this.getCUAttachmentPath(cuName, "policyAttachments.xml");
        }
        PolicySetAttachments attachments = this.getAttachmentsFromFile(pathname, "application");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttachments, assetProps=", assetProps);
        }
        return attachments;
    }

    public PolicySetAttachments getClientAttachments(Properties assetProps) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClientAttachments, assetProps=", assetProps);
        }
        String pathname = null;
        if (assetProps.containsKey("cuName")) {
            String cuName = assetProps.getProperty("cuName");
            pathname = this.getCUAttachmentPath(cuName, "clientPolicyAttachments.xml");
        }
        PolicySetAttachments attachments = this.getAttachmentsFromFile(pathname, "client");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClientAttachments, assetProps=", assetProps);
        }
        return attachments;
    }

    public PolicySetAttachments getSystemAttachments(String type) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSystemAttachments", type);
        }
        if (!type.equals("system/trust")) {
            throw new Exception(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0088E", new Object[]{type}, "Unknown system policy set type: {0}"));
        }
        String context = "sts/policy";
        String pathname = this.getSystemAttachmentPath(context);
        PolicySetAttachments attachments = this.getAttachmentsFromFile(pathname, type);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSystemAttachments", type);
        }
        return attachments;
    }

    public TrustClientPolicySetAttachments getTrustClientAttachments(Properties assetProps) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSystemAttachments(assetProps)", new Object[]{assetProps});
        }
        TrustClientPolicySetAttachmentsImpl attachments = null;
        String appName = assetProps.getProperty("applicationName");
        String pathname = null;
        pathname = this.getAttachmentPath(appName, "clientPolicyAttachments.xml");
        String parentDir = this.getFileLocator().getParent(pathname);
        attachments = new TrustClientPolicySetAttachmentsImpl(parentDir);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSystemAttachments(Properties assetProps)");
        }
        return attachments;
    }

    public void refresh() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "refresh");
        }
        PolicySetRuntimeUtil runtimeUtil = PolicySetRuntimeUtilFactory.getPolicySetRuntimeUtil();
        runtimeUtil.refresh();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "refresh");
        }
    }

    private PolicySetAttachments getAttachmentsFromFile(String pathname, String type) throws Exception {
        PolicySetAttachments attachments;
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getAttachmentsFromFile", pathname);
            }
            attachments = null;
            try {
                if (pathname != null && FileAccessor.exists(pathname)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found attachments");
                    }
                    BindingAggregator.getDefaultBinding(this.systemCL, type);
                    PolicySetAttachment psa = null;
                    final InputStream input = FileAccessor.getInputStream(pathname);
                    try {
                        psa = AccessController.doPrivileged(new PrivilegedExceptionAction<PolicySetAttachment>(){

                            @Override
                            public PolicySetAttachment run() throws JAXBException, FileNotFoundException, IOException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
                                PolicySetAttachmentHelper psaHelper = PolicySetAttachmentHelperFactory.createHelper(input);
                                PolicySetAttachment psa = psaHelper.getPolicySetAttachmentObject();
                                return psa;
                            }
                        });
                    }
                    catch (PrivilegedActionException e) {
                        Tr.processException(e, this.className + ".getAttachmentsFromFile", FFDC_ID_2);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception thrown in getPolicySetAttachmentObject");
                        }
                        throw e.getException();
                    }
                    String parentDir = this.getFileLocator().getParent(pathname);
                    attachments = new PolicySetAttachmentsImpl(parentDir, psa, type);
                    break block10;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found no attachments at " + pathname);
                }
                attachments = new EmptyPolicySetAttachmentsImpl();
            }
            catch (Exception e) {
                Tr.processException(e, this.className + ".getAttachmentsFromFile", FFDC_ID_1);
                throw e;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttachmentsFromFile", pathname);
        }
        return attachments;
    }

    private synchronized FileLocator getFileLocator() {
        if (fileLocator == null) {
            fileLocator = FileLocatorFactory.getFileLocator();
        }
        return fileLocator;
    }

    private String getAttachmentPath(String appName, String type) {
        FileLocator locator = this.getFileLocator();
        String path = locator.getAttachmentPath(appName, type);
        return path;
    }

    private String getWsnClientAttachmentPath(String busName, String wsnServiceName, String type) {
        FileLocator locator = this.getFileLocator();
        String path = locator.getAttachmentPath(busName, wsnServiceName, type);
        return path;
    }

    private String getCUAttachmentPath(String cuName, String type) {
        FileLocator locator = this.getFileLocator();
        String path = locator.getCUAttachmentPath(cuName, type);
        return path;
    }

    private String getSystemAttachmentPath(String type) {
        FileLocator locator = this.getFileLocator();
        String path = locator.getSystemAttachmentPath(type);
        return path;
    }

    public static boolean isClient() {
        if (client == null) {
            if (PlatformContextUtil.isWebSphereThinClient() || !PlatformContextUtil.isWebSphereThinClient() && !PlatformContextUtil.isWebSphereServerProcess()) {
                client = Boolean.TRUE;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting client flag to " + client);
                }
            } else {
                client = Boolean.FALSE;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting client flag to " + client);
            }
        }
        return client;
    }

    void initMBean() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initMBean");
        }
        PolicySetRuntimeUtil runtimeUtil = PolicySetRuntimeUtilFactory.getPolicySetRuntimeUtil();
        runtimeUtil.initMBean();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initMBean");
        }
    }
}

