/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.runtime;

import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessorFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.policyset.admin.BindingDefinitionHelper;
import com.ibm.ws.policyset.admin.BindingDefinitionHelperFactory;
import com.ibm.ws.policyset.admin.exceptions.NoItemFoundException;
import com.ibm.ws.policyset.runtime.BindingAggregator;
import com.ibm.ws.policyset.runtime.FileAccessor;
import com.ibm.ws.policyset.runtime.FileLocatorFactory;
import com.ibm.ws.policyset.runtime.PolicySetRuntimeUtil;
import com.ibm.ws.policyset.runtime.PolicySetUtil;
import com.ibm.ws.policyset.runtime.PolicyTypeAggregator;
import com.ibm.ws.policyset.util.Tr;
import com.ibm.ws.policyset.util.TraceComponent;
import com.ibm.ws.security.config.SecurityObjectLocator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.bind.JAXBException;

public class PolicySetRuntimeUtilImpl
implements PolicySetRuntimeUtil {
    private static TraceComponent tc = Tr.register(PolicySetRuntimeUtilImpl.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", Locale.getDefault());
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private static final String FFDC_ID_3 = "FFDC-3";

    public String getVersion(String rootDir) throws Exception {
        String nodeVersion;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getVersion, rootDir = " + rootDir);
        }
        String version = "7.0.0.0";
        if (!(rootDir == null || rootDir.contains("sts/policy") || rootDir.contains("buses") && rootDir.contains("wsn") || !(version = PolicySetRuntimeUtilImpl.getCustomBindingVersion(rootDir)).startsWith("7") || PolicySetUtil.isClient() || !(nodeVersion = PolicySetRuntimeUtilImpl.getModuleTargetVersion()).startsWith("6.1"))) {
            version = "6.1.0.0";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getVersion, version = " + version);
        }
        return version;
    }

    public String getVersion(String rootDir, String envContext) throws Exception {
        String nodeVersion;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getVersion, rootDir = " + rootDir + ", envContext=" + envContext);
        }
        if (envContext == null || envContext.equals("")) {
            return this.getVersion(rootDir);
        }
        String version = "7.0.0.0";
        if (!(rootDir == null || rootDir.contains("sts/policy") || rootDir.contains("buses") && rootDir.contains("wsn") || !(version = PolicySetRuntimeUtilImpl.getCustomBindingVersion(rootDir, envContext)).startsWith("7") || PolicySetUtil.isClient() || !(nodeVersion = PolicySetRuntimeUtilImpl.getModuleTargetVersion()).startsWith("6.1"))) {
            version = "6.1.0.0";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getVersion, version = " + version);
        }
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDomainForServer() throws Exception, Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDomainForServer");
        }
        String domain = null;
        boolean pushed = false;
        try {
            pushed = SecurityObjectLocator.pushContext("", "application");
            domain = SecurityObjectLocator.getSecurityConfigManager().getDomainName();
        }
        finally {
            if (pushed) {
                SecurityObjectLocator.popContext();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDomainForServer, domain=" + domain);
        }
        return domain;
    }

    public void initMBean() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initMBean");
        }
        if (!PolicySetUtil.isClient()) {
            try {
                DefaultRuntimeCollaborator collab = new DefaultRuntimeCollaborator(this, "PolicySetManager");
                AdminServiceFactory.getMBeanFactory().activateMBean("PolicySetManager", collab, "PolicySetManager", "META-INF/PolicySetManager.xml");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Activated PolicySetManager MBean");
                }
            }
            catch (Throwable t) {
                Tr.processException(t, "PolicySetUtil.initMBean", FFDC_ID_3);
                Tr.error(tc, "CWPST0027E", t);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initMBean");
        }
    }

    public void refresh() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "refresh");
        }
        BindingAggregator.refresh();
        PolicyTypeAggregator.refresh();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "refresh");
        }
    }

    private static String getCustomBindingVersion(String rootDir) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCustomBindingVersion, rootDir = " + rootDir);
        }
        String version = "7.0.0.0";
        final File appfile = new File(rootDir);
        File[] appFiles = AccessController.doPrivileged(new PrivilegedAction<File[]>(){

            @Override
            public File[] run() {
                File[] files = null;
                if (appfile.exists()) {
                    files = appfile.listFiles();
                }
                return files;
            }
        });
        if (appFiles != null) {
            for (int i = 0; i < appFiles.length && version.startsWith("7"); ++i) {
                FilenameFilter policyTypesFilter;
                String[] policyTypes;
                final File bindingFile = appFiles[i];
                Boolean fileIsDirectory = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                    @Override
                    public Boolean run() {
                        boolean checkDirectory = bindingFile.isDirectory();
                        return checkDirectory;
                    }
                });
                boolean isDirectory = fileIsDirectory;
                if (!isDirectory || (policyTypes = AccessController.doPrivileged(new PrivilegedAction<String[]>(policyTypesFilter = new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.contains("PolicyTypes");
                    }
                }){
                    final /* synthetic */ FilenameFilter val$policyTypesFilter;
                    {
                        this.val$policyTypesFilter = filenameFilter;
                    }

                    @Override
                    public String[] run() {
                        return bindingFile.list(this.val$policyTypesFilter);
                    }
                })).length <= 0) continue;
                final FilenameFilter bindingDefFilter = new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.contains("bindingDefinition.xml");
                    }
                };
                File[] bindingDefList = AccessController.doPrivileged(new PrivilegedAction<File[]>(){

                    @Override
                    public File[] run() {
                        return bindingFile.listFiles(bindingDefFilter);
                    }
                });
                if (bindingDefList.length > 0) {
                    File bindingDef = bindingDefList[0];
                    String path = bindingDef.toString();
                    final InputStream instream = FileAccessor.getInputStream(path);
                    try {
                        version = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                            @Override
                            public String run() throws JAXBException, FileNotFoundException, IOException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, NoItemFoundException {
                                BindingDefinitionHelper bindingDefHelper = BindingDefinitionHelperFactory.createHelper(instream);
                                return bindingDefHelper.getVersion();
                            }
                        });
                        continue;
                    }
                    catch (PrivilegedActionException e) {
                        Tr.processException(e, "com.ibm.ws.policyset.runtime.BindingAggregator", FFDC_ID_1);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception thrown in getServerDefaults");
                        }
                        throw e.getException();
                    }
                }
                version = "6.1.0.0";
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCustomBindingVersion, version = " + version);
        }
        return version;
    }

    private static String getCustomBindingVersion(String rootDir, String envContext) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCustomBindingVersion, rootDir = " + rootDir + ", envContext=" + envContext);
        }
        if (envContext == null || envContext.equals("")) {
            return PolicySetRuntimeUtilImpl.getCustomBindingVersion(rootDir);
        }
        String version = "7.0.0.0";
        final File appfile = new File(rootDir);
        File[] appFiles = AccessController.doPrivileged(new PrivilegedAction<File[]>(){

            @Override
            public File[] run() {
                File[] files = null;
                if (appfile.exists()) {
                    files = appfile.listFiles();
                }
                return files;
            }
        });
        if (appFiles != null) {
            for (int i = 0; i < appFiles.length && version.startsWith("7"); ++i) {
                FilenameFilter policyTypesFilter;
                String[] policyTypes;
                final File bindingFile = appFiles[i];
                Boolean fileIsDirectory = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                    @Override
                    public Boolean run() {
                        boolean checkDirectory = bindingFile.isDirectory();
                        return checkDirectory;
                    }
                });
                boolean isDirectory = fileIsDirectory;
                if (!isDirectory || (policyTypes = AccessController.doPrivileged(new PrivilegedAction<String[]>(policyTypesFilter = new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.contains("PolicyTypes");
                    }
                }){
                    final /* synthetic */ FilenameFilter val$policyTypesFilter;
                    {
                        this.val$policyTypesFilter = filenameFilter;
                    }

                    @Override
                    public String[] run() {
                        return bindingFile.list(this.val$policyTypesFilter);
                    }
                })).length <= 0) continue;
                final FilenameFilter bindingDefFilter = new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.contains("bindingDefinition.xml");
                    }
                };
                File[] bindingDefList = AccessController.doPrivileged(new PrivilegedAction<File[]>(){

                    @Override
                    public File[] run() {
                        return bindingFile.listFiles(bindingDefFilter);
                    }
                });
                if (bindingDefList.length > 0) {
                    File bindingDef = bindingDefList[0];
                    String path = bindingDef.toString();
                    final InputStream instream = FileAccessor.getInputStream(path, envContext);
                    try {
                        version = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                            @Override
                            public String run() throws JAXBException, FileNotFoundException, IOException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, NoItemFoundException {
                                BindingDefinitionHelper bindingDefHelper = BindingDefinitionHelperFactory.createHelper(instream);
                                return bindingDefHelper.getVersion();
                            }
                        });
                        continue;
                    }
                    catch (PrivilegedActionException e) {
                        Tr.processException(e, "com.ibm.ws.policyset.runtime.BindingAggregator", FFDC_ID_1);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception thrown in getServerDefaults");
                        }
                        throw e.getException();
                    }
                }
                version = "6.1.0.0";
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCustomBindingVersion, version = " + version);
        }
        return version;
    }

    private static String getModuleTargetVersion() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getModuleTargetVersion");
        }
        final String node = FileLocatorFactory.getFileLocator().getResourceName("node");
        String baseVersion = null;
        try {
            baseVersion = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    ManagedObjectMetadataHelper helper = new ManagedObjectMetadataHelper(ManagedObjectMetadataAccessorFactory.createAccessor(null));
                    return helper.getNodeBaseProductVersion(node);
                }
            });
        }
        catch (PrivilegedActionException e) {
            Tr.processException(e, "com.ibm.ws.policyset.runtime.BindingAggregator", FFDC_ID_2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown in getModuleTargetVersion - ManagedObjectMetadataAccessorFactory.createAccessor()");
            }
            throw e.getException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getModuleTargetVersion, baseVersion = " + baseVersion);
        }
        return baseVersion;
    }
}

