/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.runtime;

import com.ibm.ws.policyset.admin.deploy.PolicyResource;
import com.ibm.ws.policyset.runtime.BindingAggregator;
import com.ibm.ws.policyset.runtime.DefaultResourceEvaluator;
import com.ibm.ws.policyset.runtime.PolicySetAttachments;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.policyset.runtime.PolicySetConfigurationImpl;
import com.ibm.ws.policyset.runtime.PolicyTypeAggregator;
import com.ibm.ws.policyset.runtime.ResourceEvaluator;
import com.ibm.ws.policyset.util.Tr;
import com.ibm.ws.policyset.util.TraceComponent;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.PolicySetAttachment;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.PolicySetBinding;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.PolicySetReference;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PolicySetAttachmentsImpl
implements PolicySetAttachments {
    private static TraceComponent tc = Tr.register(PolicySetAttachmentsImpl.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private String applicationPath = null;
    private PolicySetAttachment attachments = null;
    private Map attachmentConfigs = null;
    private String attachmentType = null;
    private PolicySetConfiguration emptyPsConfig = new PolicySetConfigurationImpl();
    private ResourceEvaluator defaultResourceEvaluator = null;

    public PolicySetAttachmentsImpl(String appPath, PolicySetAttachment psa, String type) {
        this.applicationPath = appPath;
        this.attachments = psa;
        this.attachmentConfigs = new HashMap();
        this.attachmentType = type;
        this.defaultResourceEvaluator = new DefaultResourceEvaluator();
    }

    @Override
    public PolicySetConfiguration getPolicySet(String resourceName, ClassLoader appCL, ClassLoader systemCL) throws Exception {
        return this.getPolicySet(resourceName, this.defaultResourceEvaluator, appCL, systemCL);
    }

    @Override
    public PolicySetConfiguration getPolicySet(String resourceName, ResourceEvaluator resourceEvaluator, ClassLoader appCL, ClassLoader systemCL) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPolicySet", resourceName);
        }
        PolicySetConfiguration psConfig = null;
        PolicySetReference psRef = this.findAttachment(resourceName, resourceEvaluator);
        if (psRef != null) {
            String attachmentId = psRef.getId();
            psConfig = (PolicySetConfiguration)this.attachmentConfigs.get(attachmentId);
            if (psConfig == null) {
                String psName = psRef.getName();
                if (psName != null && !psName.equals("")) {
                    String bindingName = null;
                    String bindingScope = null;
                    PolicySetBinding psBinding = psRef.getPolicySetBinding();
                    if (psBinding != null) {
                        bindingName = psBinding.getName();
                        bindingScope = psBinding.getScope();
                    }
                    psConfig = this.getPSConfig(appCL, systemCL, psName, bindingName, bindingScope);
                    this.attachmentConfigs.put(attachmentId, psConfig);
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "getPolicySet, policy set name is null");
                    }
                    psConfig = this.emptyPsConfig;
                }
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getPolicySet, attachment is null");
            }
            psConfig = this.emptyPsConfig;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPolicySet", resourceName);
        }
        return psConfig;
    }

    @Override
    public boolean isAttached(String resourceName) {
        return this.isAttached(resourceName, this.defaultResourceEvaluator);
    }

    @Override
    public boolean isAttached(String resourceName, ResourceEvaluator resourceEvaluator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAttached, resourceName=" + resourceName);
        }
        boolean attached = false;
        if (resourceName != null) {
            if (!resourceName.endsWith("/")) {
                resourceName = resourceName + "/";
            }
            List<PolicySetReference> referenceList = this.attachments.getPolicySetReference();
            Iterator<PolicySetReference> references = referenceList.iterator();
            block0: while (!attached && references.hasNext()) {
                PolicySetReference reference = references.next();
                Tr.debug(tc, "Testing attachment id " + reference.getId());
                Tr.debug(tc, "   Policy set name is " + reference.getName());
                List<Resource> resourceList = reference.getResource();
                Iterator<Resource> resources = resourceList.iterator();
                while (resources.hasNext()) {
                    String resourcePattern = resources.next().getPattern();
                    if (resourcePattern == null) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "findAttachment, resourcePattern is null, skip it");
                        continue;
                    }
                    if (!resourcePattern.endsWith("/")) {
                        resourcePattern = resourcePattern + "/";
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "resourceName=" + resourceName + ", resourcePattern=" + resourcePattern);
                    }
                    if (!resourceEvaluator.matches(resourcePattern, resourceName)) continue;
                    attached = true;
                    if (!tc.isDebugEnabled()) continue block0;
                    Tr.debug(tc, "Found attachment: " + resourcePattern);
                    continue block0;
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "resourceName is null");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAttached", attached ? Boolean.TRUE : Boolean.FALSE);
        }
        return attached;
    }

    private PolicySetConfiguration getPSConfig(ClassLoader appCL, ClassLoader sysCL, String psName, String bindingName, String bindingScope) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPSConfig", psName);
        }
        List types = PolicySetAttachmentsImpl.getTypesForPolicySet(psName);
        PolicySetConfiguration psConfig = PolicyTypeAggregator.getPolicySetConfiguration(sysCL, psName, types);
        psConfig.setPolicyTypeConfiguration("attachmentType", this.attachmentType);
        BindingAggregator.getCustomBinding(this.applicationPath, bindingName, appCL, sysCL, psConfig, types, this.attachmentType, bindingScope);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPSConfig", psName);
        }
        return psConfig;
    }

    private PolicySetReference findAttachment(String resourceName, ResourceEvaluator resourceEvaluator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findAttachment", resourceName);
        }
        PolicySetReference policyRef = null;
        int matchDistance = Integer.MAX_VALUE;
        PolicySetReference savedPolicyRef = null;
        int savedMatchDistance = Integer.MAX_VALUE;
        if (resourceName != null) {
            if (!resourceName.endsWith("/")) {
                resourceName = resourceName + "/";
            }
            String resourceWithoutModule = resourceName;
            String savedResourceName = resourceName;
            boolean keepSearching = true;
            boolean resourceContainsModule = false;
            if (this.attachmentType.equals("client") && !resourceName.equals(resourceWithoutModule = this.removeModuleName(resourceName))) {
                resourceContainsModule = true;
            }
            while (keepSearching) {
                List<PolicySetReference> referenceList = this.attachments.getPolicySetReference();
                Iterator<PolicySetReference> references = referenceList.iterator();
                block1: while (matchDistance != 0 && references.hasNext()) {
                    PolicySetReference reference = references.next();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Testing attachment id " + reference.getId());
                        Tr.debug(tc, "   Policy set name is " + reference.getName());
                        Tr.debug(tc, "   Binding is " + reference.getPolicySetBinding());
                    }
                    List<Resource> resourceList = reference.getResource();
                    Iterator<Resource> resources = resourceList.iterator();
                    while (resources.hasNext()) {
                        int distance;
                        String resourcePattern = resources.next().getPattern();
                        if (resourcePattern == null) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "findAttachment, resourcePattern is null, skip it");
                            continue;
                        }
                        if (!resourcePattern.endsWith("/")) {
                            resourcePattern = resourcePattern + "/";
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "resourceName=" + resourceName + ", resourcePattern=" + resourcePattern);
                        }
                        if ((distance = resourceEvaluator.getMatchDistance(resourcePattern, resourceName)) < 0) continue;
                        if (distance < matchDistance) {
                            policyRef = reference;
                            matchDistance = distance;
                        }
                        if (matchDistance != 0) continue;
                        continue block1;
                    }
                }
                if (this.attachmentType.equals("client")) {
                    if (matchDistance != 0 && resourceContainsModule) {
                        savedPolicyRef = policyRef;
                        savedMatchDistance = matchDistance;
                        resourceName = resourceWithoutModule;
                        resourceContainsModule = false;
                        matchDistance = Integer.MAX_VALUE;
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "match distance = " + savedMatchDistance);
                        Tr.debug(tc, "getting ready to check without moduleName, updated resourceName = " + resourceName);
                        continue;
                    }
                    keepSearching = false;
                    continue;
                }
                keepSearching = false;
            }
            if (this.attachmentType.equals("client") && savedMatchDistance <= matchDistance) {
                policyRef = savedPolicyRef;
                matchDistance = savedMatchDistance;
                resourceName = savedResourceName;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Closer match, so using policy reference with module name");
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "resourceName is null");
        }
        if (tc.isDebugEnabled()) {
            if (matchDistance < Integer.MAX_VALUE) {
                Tr.debug(tc, "Found attachment with id, name, and matchDistance of:", new Object[]{policyRef.getId(), policyRef.getName(), new Integer(matchDistance)});
            } else {
                Tr.debug(tc, "Found no attachment");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findAttachment", resourceName);
        }
        return policyRef;
    }

    public static synchronized List getTypesForPolicySet(String policySet) throws Exception {
        List types = PolicyTypeAggregator.getTypesForPolicySet(policySet);
        return types;
    }

    private String removeModuleName(String resourceName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeModuleName", resourceName);
        }
        String updatedResource = resourceName;
        PolicyResource policyResource = new PolicyResource(resourceName);
        String moduleName = policyResource.getModuleName();
        if (moduleName != null) {
            StringBuffer strBuf = new StringBuffer();
            strBuf.append(resourceName.substring(0, resourceName.indexOf(moduleName)));
            strBuf.append(resourceName.substring(resourceName.indexOf(moduleName) + moduleName.length() + 1));
            updatedResource = strBuf.toString();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Resource contains module name");
                Tr.debug(tc, "Resource without moduleName is: " + updatedResource);
            }
        }
        return updatedResource;
    }

    public PolicySetAttachment getAttachments() {
        return this.attachments;
    }

    @Override
    public List<String> getResourceNames() {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceNames", this);
        }
        ArrayList<String> resultList = new ArrayList<String>();
        List<PolicySetReference> referenceList = this.attachments.getPolicySetReference();
        for (PolicySetReference reference : referenceList) {
            List<Resource> resourceList = reference.getResource();
            Iterator<Resource> resources = resourceList.iterator();
            while (resources.hasNext()) {
                String resourcePattern = resources.next().getPattern();
                if (resourcePattern == null) continue;
                resultList.add(resourcePattern);
            }
        }
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceNames", resultList);
        }
        return resultList;
    }
}

