/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.runtime;

import com.ibm.ws.policyset.admin.PolicyConstants;
import com.ibm.ws.policyset.runtime.FileLocator;
import com.ibm.ws.policyset.util.PolicySetFactoryBuilder;
import com.ibm.ws.policyset.util.Tr;
import com.ibm.ws.policyset.util.TraceComponent;

public class FileLocatorFactory {
    private static TraceComponent tc = Tr.register(FileLocatorFactory.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private static final String FACTORY_KEY = "com.ibm.ws.policyset.runtime.FileLocator";
    private static FileLocator fileLocator = null;
    private static FileLocator jarFileLocator = null;
    private static FileLocator clientFileLocator = null;
    private static FileLocator serverFileLocator = null;

    public static synchronized FileLocator getFileLocator() {
        if (fileLocator == null) {
            try {
                fileLocator = (FileLocator)PolicySetFactoryBuilder.getInstance(FACTORY_KEY);
            }
            catch (Throwable t) {
                Tr.processException(t, "com.ibm.ws.policyset.runtime.FileLocatorFactory", "42");
            }
        }
        return fileLocator;
    }

    public static synchronized FileLocator getFileLocator(String envContext) {
        FileLocator selectedFileLocator = fileLocator;
        if (envContext == null || envContext.equals("")) {
            return FileLocatorFactory.getFileLocator();
        }
        if (envContext.equals(PolicyConstants.JAR_CONTEXT)) {
            selectedFileLocator = jarFileLocator;
        } else if (envContext.equals(PolicyConstants.CLIENT_CONTEXT)) {
            selectedFileLocator = clientFileLocator;
        } else if (envContext.equals(PolicyConstants.SERVER_CONTEXT)) {
            selectedFileLocator = serverFileLocator;
        }
        if (selectedFileLocator == null) {
            try {
                selectedFileLocator = (FileLocator)PolicySetFactoryBuilder.getInstance(FACTORY_KEY, envContext);
                if (envContext.equals(PolicyConstants.JAR_CONTEXT)) {
                    jarFileLocator = selectedFileLocator;
                } else if (envContext.equals(PolicyConstants.CLIENT_CONTEXT)) {
                    clientFileLocator = selectedFileLocator;
                } else if (envContext.equals(PolicyConstants.SERVER_CONTEXT)) {
                    serverFileLocator = selectedFileLocator;
                }
            }
            catch (Throwable t) {
                Tr.processException(t, "com.ibm.ws.policyset.runtime.FileLocatorFactory", "43");
            }
        }
        return selectedFileLocator;
    }
}

