/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.runtime;

import com.ibm.ws.policyset.admin.PolicyConstants;
import com.ibm.ws.policyset.util.PlatformContextUtil;
import com.ibm.ws.policyset.util.Tr;
import com.ibm.ws.policyset.util.TraceComponent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class FileAccessor {
    private static TraceComponent tc = Tr.register(FileAccessor.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");

    public static boolean exists(String pathname) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exists", pathname);
        }
        final String path = pathname;
        boolean found = false;
        if (PlatformContextUtil.isWebSphereThinClient() || !PlatformContextUtil.isWebSphereThinClient() && !PlatformContextUtil.isWebSphereServerProcess()) {
            Boolean isFound = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    boolean exists = false;
                    URL url = FileAccessor.class.getClassLoader().getResource(path);
                    if (url != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "exists, FileAccessor.class.getClassLoader().getResource returns url=" + url);
                        }
                        exists = true;
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "exists, cannot find URL, try Thread.currentThread().getContextClassLoader()");
                        }
                        if ((url = Thread.currentThread().getContextClassLoader().getResource(path)) != null) {
                            exists = true;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "exists, Thread.currentThread().getContextClassLoader() returns url=" + url);
                        }
                    }
                    return exists;
                }
            });
            found = isFound;
        } else {
            final File file = new File(pathname);
            Boolean isFound = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    boolean exists = file.exists();
                    return exists;
                }
            });
            found = isFound;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exists", new Object[]{pathname, found ? Boolean.TRUE : Boolean.FALSE});
        }
        return found;
    }

    public static boolean exists(String pathname, String envContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exists", pathname + ", envContext=" + envContext);
        }
        final String path = pathname;
        boolean found = false;
        if (envContext == null || envContext.equals("")) {
            return FileAccessor.exists(pathname);
        }
        if (!envContext.equals(PolicyConstants.JAR_CONTEXT)) {
            return FileAccessor.exists(pathname);
        }
        Boolean isFound = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                boolean exists = false;
                URL url = FileAccessor.class.getClassLoader().getResource(path);
                if (url != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "exists, FileAccessor.class.getClassLoader().getResource returns url=" + url);
                    }
                    exists = true;
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "exists, cannot find URL, try Thread.currentThread().getContextClassLoader()");
                    }
                    if ((url = Thread.currentThread().getContextClassLoader().getResource(path)) != null) {
                        exists = true;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "exists, Thread.currentThread().getContextClassLoader() returns url=" + url);
                    }
                }
                return exists;
            }
        });
        found = isFound;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exists", new Object[]{pathname, found ? Boolean.TRUE : Boolean.FALSE});
        }
        return found;
    }

    public static InputStream getInputStream(String pathname) {
        InputStream stream;
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getInputStream", pathname);
            }
            stream = null;
            if (pathname != null) {
                if (PlatformContextUtil.isWebSphereThinClient() || !PlatformContextUtil.isWebSphereThinClient() && !PlatformContextUtil.isWebSphereServerProcess()) {
                    InputStream istream;
                    final String path = pathname;
                    stream = istream = AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

                        @Override
                        public InputStream run() {
                            InputStream stream = FileAccessor.class.getClassLoader().getResourceAsStream(path);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "getInputStream, FileAccessor.class.getClassLoader().getResourceAsStream returns stream=" + stream + ", pathname=" + path);
                            }
                            if (stream == null) {
                                stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "getInputStream, Thread.currentThread().getContextClassLoader().getResourceAsStream returns stream=" + stream + ", pathname=" + path);
                                }
                            }
                            return stream;
                        }
                    });
                } else {
                    try {
                        final File file = new File(pathname);
                        FileInputStream fis = AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

                            @Override
                            public FileInputStream run() throws FileNotFoundException {
                                return new FileInputStream(file);
                            }
                        });
                        stream = fis;
                    }
                    catch (PrivilegedActionException e) {
                        if (!tc.isDebugEnabled()) break block7;
                        Tr.debug(tc, "FileNotFound: " + pathname);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInputStream", pathname);
        }
        return stream;
    }

    public static InputStream getInputStream(String pathname, String envContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInputStream", pathname + ", envContext=" + envContext);
        }
        InputStream stream = null;
        if (pathname != null) {
            InputStream istream;
            if (envContext == null || envContext.equals("")) {
                return FileAccessor.getInputStream(pathname);
            }
            if (!envContext.equals(PolicyConstants.JAR_CONTEXT)) {
                return FileAccessor.getInputStream(pathname);
            }
            final String path = pathname;
            stream = istream = AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

                @Override
                public InputStream run() {
                    InputStream stream = FileAccessor.class.getClassLoader().getResourceAsStream(path);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "getInputStream, FileAccessor.class.getClassLoader().getResourceAsStream returns stream=" + stream + ", pathname=" + path);
                    }
                    if (stream == null) {
                        stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "getInputStream, Thread.currentThread().getContextClassLoader().getResourceAsStream returns stream=" + stream + ", pathname=" + path);
                        }
                    }
                    return stream;
                }
            });
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInputStream", pathname);
        }
        return stream;
    }
}

