/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.runtime;

import com.ibm.ws.policyset.admin.DefaultBindingsHelper;
import com.ibm.ws.policyset.admin.DefaultBindingsHelperFactory;
import com.ibm.ws.policyset.admin.PolicyConstants;
import com.ibm.ws.policyset.admin.exceptions.NoItemFoundException;
import com.ibm.ws.policyset.runtime.BindingLoader;
import com.ibm.ws.policyset.runtime.DefaultBinding;
import com.ibm.ws.policyset.runtime.DefaultBindingImpl;
import com.ibm.ws.policyset.runtime.ExtensionLoader;
import com.ibm.ws.policyset.runtime.ExtensionLoaderFactory;
import com.ibm.ws.policyset.runtime.FileAccessor;
import com.ibm.ws.policyset.runtime.FileLocator;
import com.ibm.ws.policyset.runtime.FileLocatorFactory;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.policyset.runtime.PolicySetRuntimeUtil;
import com.ibm.ws.policyset.runtime.PolicySetRuntimeUtilFactory;
import com.ibm.ws.policyset.runtime.PolicySetUtil;
import com.ibm.ws.policyset.runtime.VariableExpander;
import com.ibm.ws.policyset.runtime.VariableExpanderFactory;
import com.ibm.ws.policyset.util.Tr;
import com.ibm.ws.policyset.util.TraceComponent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.bind.JAXBException;

public class BindingAggregator {
    private static TraceComponent tc = Tr.register(BindingAggregator.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private static final String FFDC_ID_3 = "FFDC-3";
    private static final String FFDC_ID_4 = "FFDC-4";
    private static final String FFDC_ID_5 = "FFDC-5";
    private static final String FFDC_ID_6 = "FFDC-6";
    private static final String FFDC_ID_7 = "FFDC-7";
    private static final String FFDC_ID_8 = "FFDC-8";
    private static final String FFDC_ID_10 = "FFDC-10";
    private static final String FFDC_ID_11 = "FFDC-11";
    private static final String FFDC_ID_12 = "FFDC-12";
    private static final String FFDC_ID_13 = "FFDC-13";
    private static final String FFDC_ID_14 = "FFDC-14";
    private static final String FFDC_ID_15 = "FFDC-15";
    private static final String FFDC_ID_16 = "FFDC-16";
    private static final String FFDC_ID_17 = "FFDC-17";
    private static final String FFDC_ID_18 = "FFDC-18";
    private static final String FFDC_ID_19 = "FFDC-19";
    private static final String FFDC_ID_20 = "FFDC-20";
    private static final String FFDC_ID_21 = "FFDC-21";
    private static String className = "com.ibm.ws.policyset.runtime.BindingAggregator";
    private static DefaultBinding default61Binding = null;
    private static DefaultBinding appDefaultBinding = null;
    private static DefaultBinding clientDefaultBinding = null;
    private static Integer defaultBindingLock = new Integer(0);
    private static List extensions = null;
    private static Map bindingsMap = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized DefaultBinding getDefaultBinding(ClassLoader systemCL, String type) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultBinding");
        }
        String bindingName = null;
        boolean loadedBinding = false;
        Integer n = defaultBindingLock;
        synchronized (n) {
            if (type.equals("application") && appDefaultBinding == null || type.equals("client") && clientDefaultBinding == null) {
                try {
                    if (type.equals("application")) {
                        appDefaultBinding = new DefaultBindingImpl();
                    } else {
                        clientDefaultBinding = new DefaultBindingImpl();
                    }
                    if (bindingsMap == null) {
                        bindingsMap = new HashMap();
                    }
                    List extensions = BindingAggregator.getExtensions();
                    bindingName = BindingAggregator.getDefaultBindingName(type);
                    VariableExpander variableExpander = VariableExpanderFactory.getVariableExpander();
                    for (BindingLoader loader : extensions) {
                        try {
                            InputStream policyTypeBinding = BindingAggregator.getDefaultBindingInputStream(loader.getType(), bindingName);
                            if (type.equals("application")) {
                                loader.loadDefault(systemCL, variableExpander, policyTypeBinding, appDefaultBinding);
                                continue;
                            }
                            loader.loadDefault(systemCL, variableExpander, policyTypeBinding, clientDefaultBinding);
                        }
                        catch (Throwable t) {
                            Tr.processException(t, className, FFDC_ID_10);
                        }
                    }
                    loadedBinding = true;
                }
                catch (Throwable t) {
                    Tr.processException(t, className, FFDC_ID_11);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultBinding");
        }
        if (type.equals("application")) {
            if (loadedBinding && bindingName != null) {
                bindingsMap.put(bindingName, appDefaultBinding);
            }
            return appDefaultBinding;
        }
        if (loadedBinding && bindingName != null) {
            bindingsMap.put(bindingName, clientDefaultBinding);
        }
        return clientDefaultBinding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized DefaultBinding get61DefaultBinding(ClassLoader systemCL) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "get61DefaultBinding");
        }
        Integer n = defaultBindingLock;
        synchronized (n) {
            if (default61Binding == null) {
                try {
                    default61Binding = new DefaultBindingImpl();
                    List extensions = BindingAggregator.getExtensions();
                    VariableExpander variableExpander = VariableExpanderFactory.getVariableExpander();
                    for (BindingLoader loader : extensions) {
                        try {
                            InputStream policyTypeBinding = BindingAggregator.get61DefaultBindingInputStream(loader.getType());
                            loader.loadDefault(systemCL, variableExpander, policyTypeBinding, default61Binding);
                        }
                        catch (Throwable t) {
                            Tr.processException(t, className, FFDC_ID_12);
                        }
                    }
                }
                catch (Throwable t) {
                    Tr.processException(t, className, FFDC_ID_13);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "get61DefaultBinding");
        }
        return default61Binding;
    }

    public static synchronized void getCustomBinding(String rootDir, String bindingName, ClassLoader appCL, ClassLoader systemCL, PolicySetConfiguration psConfig, List types, String type, String bindingScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCustomBinding");
        }
        String version = "7.0.0.0";
        try {
            psConfig.setPolicyTypeConfiguration("com.ibm.ws.policyset.BINDING_NAME_KEY", bindingName);
            psConfig.setPolicyTypeConfiguration("com.ibm.ws.policyset.BINDING_SCOPE_KEY", bindingScope);
            PolicySetRuntimeUtil runtimeUtil = PolicySetRuntimeUtilFactory.getPolicySetRuntimeUtil();
            version = runtimeUtil.getVersion(rootDir);
            DefaultBinding generalBinding = null;
            Boolean isGeneralBinding = false;
            if (version.startsWith("6.1")) {
                BindingAggregator.get61DefaultBinding(systemCL);
            } else {
                BindingAggregator.getDefaultBinding(systemCL, type);
                if (bindingName != null && bindingScope != null && bindingScope.equals("domain")) {
                    generalBinding = BindingAggregator.getGeneralBinding(systemCL, bindingName);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "General binding loaded..." + generalBinding);
                    }
                    isGeneralBinding = true;
                }
            }
            List extensions = BindingAggregator.getExtensions();
            VariableExpander variableExpander = VariableExpanderFactory.getVariableExpander();
            for (BindingLoader loader : extensions) {
                try {
                    if (types == null || !types.contains(loader.getType())) continue;
                    InputStream policyTypeBinding = null;
                    if (isGeneralBinding.booleanValue()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "About to call loadCustom for general binding on " + loader.getClass().getName());
                        }
                        loader.loadCustom(systemCL, appCL, variableExpander, policyTypeBinding, generalBinding, psConfig);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Back from loadCustom on " + loader.getClass().getName());
                        continue;
                    }
                    if (bindingName != null) {
                        policyTypeBinding = BindingAggregator.getCustomBindingInputStream(rootDir, bindingName, loader.getType());
                    }
                    if (version.equals("6.1.0.0")) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "About to call loadCustom and sending 6.1 default bindings on " + loader.getClass().getName());
                        }
                        loader.loadCustom(systemCL, appCL, variableExpander, policyTypeBinding, default61Binding, psConfig);
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "About to call loadCustom and using 7.0 default bindings on " + loader.getClass().getName());
                        }
                        if (type.equals("application")) {
                            loader.loadCustom(systemCL, appCL, variableExpander, policyTypeBinding, appDefaultBinding, psConfig);
                        } else {
                            loader.loadCustom(systemCL, appCL, variableExpander, policyTypeBinding, clientDefaultBinding, psConfig);
                        }
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Back from loadCustom on " + loader.getClass().getName());
                }
                catch (Throwable t) {
                    Tr.processException(t, className, FFDC_ID_5);
                }
            }
        }
        catch (Throwable t) {
            Tr.processException(t, className, FFDC_ID_6);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCustomBinding");
        }
    }

    public static synchronized void getCustomBinding(String rootDir, String bindingName, ClassLoader appCL, ClassLoader systemCL, PolicySetConfiguration psConfig, List types, String type, String bindingScope, String envContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCustomBinding");
        }
        if (envContext == null || envContext.equals("") || !envContext.equals(PolicyConstants.JAR_CONTEXT)) {
            BindingAggregator.getCustomBinding(rootDir, bindingName, appCL, systemCL, psConfig, types, type, bindingScope);
        } else {
            String version = "7.0.0.0";
            try {
                psConfig.setPolicyTypeConfiguration("com.ibm.ws.policyset.BINDING_NAME_KEY", bindingName);
                psConfig.setPolicyTypeConfiguration("com.ibm.ws.policyset.BINDING_SCOPE_KEY", bindingScope);
                PolicySetRuntimeUtil runtimeUtil = PolicySetRuntimeUtilFactory.getPolicySetRuntimeUtil();
                version = runtimeUtil.getVersion(rootDir, envContext);
                DefaultBinding generalBinding = null;
                Boolean isGeneralBinding = false;
                if (version.startsWith("6.1")) {
                    BindingAggregator.get61DefaultBinding(systemCL);
                } else {
                    BindingAggregator.getDefaultBinding(systemCL, type);
                    if (bindingName != null && bindingScope != null && bindingScope.equals("domain")) {
                        generalBinding = BindingAggregator.getGeneralBinding(systemCL, bindingName, envContext);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "General binding loaded..." + generalBinding);
                        }
                        isGeneralBinding = true;
                    }
                }
                List extensions = BindingAggregator.getExtensions();
                VariableExpander variableExpander = VariableExpanderFactory.getVariableExpander();
                for (BindingLoader loader : extensions) {
                    try {
                        if (types == null || !types.contains(loader.getType())) continue;
                        InputStream policyTypeBinding = null;
                        if (isGeneralBinding.booleanValue()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "About to call loadCustom for general binding on " + loader.getClass().getName());
                            }
                            loader.loadCustom(systemCL, appCL, variableExpander, policyTypeBinding, generalBinding, psConfig);
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Back from loadCustom on " + loader.getClass().getName());
                            continue;
                        }
                        if (bindingName != null) {
                            policyTypeBinding = BindingAggregator.getCustomBindingInputStream(rootDir, bindingName, loader.getType(), envContext);
                        }
                        if (version.equals("6.1.0.0")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "About to call loadCustom and sending 6.1 default bindings on " + loader.getClass().getName());
                            }
                            loader.loadCustom(systemCL, appCL, variableExpander, policyTypeBinding, default61Binding, psConfig);
                        } else {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "About to call loadCustom and using 7.0 default bindings on " + loader.getClass().getName());
                            }
                            if (type.equals("application")) {
                                loader.loadCustom(systemCL, appCL, variableExpander, policyTypeBinding, appDefaultBinding, psConfig);
                            } else {
                                loader.loadCustom(systemCL, appCL, variableExpander, policyTypeBinding, clientDefaultBinding, psConfig);
                            }
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Back from loadCustom on " + loader.getClass().getName());
                    }
                    catch (Throwable t) {
                        Tr.processException(t, className, FFDC_ID_17);
                    }
                }
            }
            catch (Throwable t) {
                Tr.processException(t, className, FFDC_ID_18);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCustomBinding");
        }
    }

    private static List getExtensions() throws Throwable {
        if (extensions == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Loading policy binding loader extensions");
            }
            extensions = new ArrayList();
            try {
                String extensionPointId = PolicySetUtil.isClient() ? "com.ibm.wsfp.thinclient.ibmaxis2-qos-bindingloader" : "com.ibm.wsfp.main.ibmaxis2-qos-bindingloader";
                ExtensionLoader extLoader = ExtensionLoaderFactory.getExtensionLoader();
                String[] elements = extLoader.getElements(extensionPointId, "com.ibm.wsfp.main.ibmaxis2-qos-bindingloader");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found " + elements.length + " extensions for " + extensionPointId);
                }
                if (elements != null) {
                    HashMap properties = new HashMap();
                    for (int i = 0; i < elements.length; ++i) {
                        try {
                            String classname = elements[i];
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Found " + classname);
                            }
                            Class<?> loaderClass = Class.forName(classname);
                            Constructor<?> constructor = loaderClass.getConstructor(new Class[0]);
                            BindingLoader loader = (BindingLoader)constructor.newInstance(new Object[0]);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "About to call init on " + classname);
                            }
                            loader.init(properties);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Back from init on " + classname);
                            }
                            extensions.add(loader);
                            continue;
                        }
                        catch (Throwable t) {
                            Tr.processException(t, className, FFDC_ID_3);
                        }
                    }
                }
            }
            catch (Throwable t) {
                Tr.processException(t, className, FFDC_ID_4);
                throw t;
            }
        }
        return extensions;
    }

    public static InputStream get61DefaultBindingInputStream(String policyType) {
        FileLocator locator = FileLocatorFactory.getFileLocator();
        String path = locator.get61DefaultBindingPath(policyType);
        InputStream input = FileAccessor.getInputStream(path);
        return input;
    }

    public static InputStream getDefaultBindingInputStream(String policyType, String bindingName) {
        FileLocator locator = FileLocatorFactory.getFileLocator();
        String path = locator.getDefaultBindingPath(policyType, bindingName);
        InputStream input = FileAccessor.getInputStream(path);
        return input;
    }

    public static InputStream getGeneralBindingInputStream(String policyType, String bindingName) {
        FileLocator locator = FileLocatorFactory.getFileLocator();
        String path = locator.getGeneralBindingPath(policyType, bindingName);
        InputStream input = FileAccessor.getInputStream(path);
        return input;
    }

    public static InputStream getCustomBindingInputStream(String rootDir, String bindingName, String policyType) {
        FileLocator locator = FileLocatorFactory.getFileLocator();
        String path = locator.getCustomBindingPath(rootDir, bindingName, policyType);
        InputStream input = FileAccessor.getInputStream(path);
        return input;
    }

    public static InputStream getGeneralBindingInputStream(String policyType, String bindingName, String envContext) {
        FileLocator locator = FileLocatorFactory.getFileLocator(envContext);
        String path = locator.getGeneralBindingPath(policyType, bindingName);
        InputStream input = FileAccessor.getInputStream(path, envContext);
        return input;
    }

    public static InputStream getCustomBindingInputStream(String rootDir, String bindingName, String policyType, String envContext) {
        FileLocator locator = FileLocatorFactory.getFileLocator(envContext);
        String path = locator.getCustomBindingPath(rootDir, bindingName, policyType);
        InputStream input = FileAccessor.getInputStream(path, envContext);
        return input;
    }

    public static String getDefaultBindingName(String type) throws Throwable {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Looking up default binding file");
        }
        Properties bindingNames = new Properties();
        String defaultBinding = null;
        String path = FileLocatorFactory.getFileLocator().getDefaultBindingsFilePath();
        final InputStream istream = FileAccessor.getInputStream(path);
        if (istream != null) {
            final String node = FileLocatorFactory.getFileLocator().getResourceName("node");
            final String server = FileLocatorFactory.getFileLocator().getResourceName("server");
            try {
                bindingNames = AccessController.doPrivileged(new PrivilegedExceptionAction<Properties>(){

                    @Override
                    public Properties run() throws JAXBException, FileNotFoundException, IOException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, NoItemFoundException {
                        DefaultBindingsHelper bindingsHelper = DefaultBindingsHelperFactory.createHelper(istream);
                        Properties props = bindingsHelper.getServerDefaults(server, node);
                        return props;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Tr.processException(e, "com.ibm.ws.policyset.runtime.BindingAggregator", FFDC_ID_7);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception thrown in getServerDefaults");
                }
                throw e.getException();
            }
            boolean checkGlobalDefaults = false;
            boolean checkDomainDefaults = false;
            if (bindingNames != null && !bindingNames.isEmpty()) {
                defaultBinding = type.equals("application") ? bindingNames.getProperty("provider") : bindingNames.getProperty("client");
                if (defaultBinding == null) {
                    checkDomainDefaults = true;
                } else if (defaultBinding.equals("")) {
                    checkDomainDefaults = true;
                }
            } else {
                checkDomainDefaults = true;
            }
            if (checkDomainDefaults) {
                PolicySetRuntimeUtil runtimeUtil = PolicySetRuntimeUtilFactory.getPolicySetRuntimeUtil();
                final String domain = runtimeUtil.getDomainForServer();
                if (domain != null) {
                    final InputStream instream = FileAccessor.getInputStream(path);
                    try {
                        bindingNames = AccessController.doPrivileged(new PrivilegedExceptionAction<Properties>(){

                            @Override
                            public Properties run() throws JAXBException, FileNotFoundException, IOException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, NoItemFoundException {
                                DefaultBindingsHelper bindingsHelper = DefaultBindingsHelperFactory.createHelper(instream);
                                Properties props = bindingsHelper.getDomainDefaults(domain);
                                return props;
                            }
                        });
                    }
                    catch (PrivilegedActionException e) {
                        Tr.processException(e, "com.ibm.ws.policyset.runtime.BindingAggregator", FFDC_ID_8);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception thrown in getServerDefaults");
                        }
                        throw e.getException();
                    }
                    if (bindingNames != null && !bindingNames.isEmpty()) {
                        defaultBinding = type.equals("application") ? bindingNames.getProperty("provider") : bindingNames.getProperty("client");
                        if (defaultBinding == null) {
                            checkGlobalDefaults = true;
                        } else if (defaultBinding.equals("")) {
                            checkGlobalDefaults = true;
                        }
                    } else {
                        checkGlobalDefaults = true;
                    }
                } else {
                    checkGlobalDefaults = true;
                }
            }
            if (checkGlobalDefaults) {
                final InputStream instream = FileAccessor.getInputStream(path);
                try {
                    bindingNames = AccessController.doPrivileged(new PrivilegedExceptionAction<Properties>(){

                        @Override
                        public Properties run() throws JAXBException, FileNotFoundException, IOException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, NoItemFoundException {
                            DefaultBindingsHelper bindingsHelper = DefaultBindingsHelperFactory.createHelper(instream);
                            Properties props = bindingsHelper.getDomainDefaults("global");
                            return props;
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    Tr.processException(e, "com.ibm.ws.policyset.runtime.BindingAggregator", FFDC_ID_14);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception thrown in getServerDefaults");
                    }
                    throw e.getException();
                }
            }
        }
        if (bindingNames != null && !bindingNames.isEmpty() && (defaultBinding = type.equals("application") ? bindingNames.getProperty("provider") : bindingNames.getProperty("client")) != null && defaultBinding.equals("")) {
            defaultBinding = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultBindingNames", defaultBinding);
        }
        return defaultBinding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized DefaultBinding getGeneralBinding(ClassLoader systemCL, String bindingName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGeneralBinding, bindingName = " + bindingName);
        }
        boolean loadedBinding = false;
        DefaultBinding generalBinding = null;
        Integer n = defaultBindingLock;
        synchronized (n) {
            generalBinding = (DefaultBinding)bindingsMap.get(bindingName);
            if (generalBinding == null) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "General binding not already loaded; need to load it");
                    }
                    generalBinding = new DefaultBindingImpl();
                    List extensions = BindingAggregator.getExtensions();
                    VariableExpander variableExpander = VariableExpanderFactory.getVariableExpander();
                    for (BindingLoader loader : extensions) {
                        try {
                            InputStream policyTypeBinding = BindingAggregator.getGeneralBindingInputStream(loader.getType(), bindingName);
                            if (policyTypeBinding == null) continue;
                            loader.loadDefault(systemCL, variableExpander, policyTypeBinding, generalBinding);
                        }
                        catch (Throwable t) {
                            Tr.processException(t, className, FFDC_ID_15);
                        }
                    }
                    loadedBinding = true;
                }
                catch (Throwable t) {
                    Tr.processException(t, className, FFDC_ID_16);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGeneralBinding");
        }
        if (loadedBinding && bindingName != null) {
            bindingsMap.put(bindingName, generalBinding);
        }
        return generalBinding;
    }

    private static synchronized DefaultBinding getGeneralBinding(ClassLoader systemCL, String bindingName, String envContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGeneralBinding, bindingName = " + bindingName + ", envContext=" + envContext);
        }
        if (envContext == null || envContext.equals("")) {
            return BindingAggregator.getGeneralBinding(systemCL, bindingName);
        }
        DefaultBindingImpl generalBinding = null;
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "General binding not already loaded; need to load it");
            }
            generalBinding = new DefaultBindingImpl();
            List extensions = BindingAggregator.getExtensions();
            VariableExpander variableExpander = VariableExpanderFactory.getVariableExpander();
            for (BindingLoader loader : extensions) {
                try {
                    InputStream policyTypeBinding = BindingAggregator.getGeneralBindingInputStream(loader.getType(), bindingName, envContext);
                    if (policyTypeBinding == null) continue;
                    loader.loadDefault(systemCL, variableExpander, policyTypeBinding, generalBinding);
                }
                catch (Throwable t) {
                    Tr.processException(t, className, FFDC_ID_19);
                }
            }
        }
        catch (Throwable t) {
            Tr.processException(t, className, FFDC_ID_20);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGeneralBinding");
        }
        return generalBinding;
    }

    public static boolean doesBindingExist(String rootDir, String bindingName, String bindingScope, String envContext) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doesBindingExist, bindingName = " + bindingName + ", bindingScope=" + bindingScope + ", envContext=" + envContext);
        }
        boolean bindingExists = false;
        String path = null;
        if (bindingScope != null) {
            if (bindingScope.equals("application")) {
                path = FileLocatorFactory.getFileLocator(envContext).getCustomBindingsDirectoryPath(rootDir, bindingName);
            } else if (bindingScope.equals("domain")) {
                path = FileLocatorFactory.getFileLocator(envContext).getGeneralBindingsDirectoryPath(bindingName);
            }
            if (path != null) {
                bindingExists = FileAccessor.exists(path, envContext);
            }
        }
        return bindingExists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void refresh() {
        Integer n = defaultBindingLock;
        synchronized (n) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Resetting default bindings and bindings map");
            }
            default61Binding = null;
            appDefaultBinding = null;
            clientDefaultBinding = null;
            bindingsMap = null;
        }
    }
}

