/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.impl;

import com.ibm.ws.policyset.admin.DefaultBindingsHelper;
import com.ibm.ws.policyset.admin.PolicyConstants;
import com.ibm.ws.policyset.admin.commands.util.CommonUtil;
import com.ibm.ws.policyset.admin.exceptions.NoItemFoundException;
import com.ibm.ws.policyset.util.Tr;
import com.ibm.ws.policyset.util.TraceComponent;
import com.ibm.xmlns.prod.websphere._200711.defaultbindings.Client;
import com.ibm.xmlns.prod.websphere._200711.defaultbindings.DefaultBindings;
import com.ibm.xmlns.prod.websphere._200711.defaultbindings.Domain;
import com.ibm.xmlns.prod.websphere._200711.defaultbindings.Provider;
import com.ibm.xmlns.prod.websphere._200711.defaultbindings.Server;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBindingsHelperImpl
implements DefaultBindingsHelper,
PolicyConstants {
    private String fileName = null;
    private DefaultBindings defaultBindings = null;
    private int rc = 0;
    private boolean fileLoaded = false;
    protected String className = this.getClass().getName();
    private InputStream inputStream = null;
    private boolean readOnly = false;
    private static Locale _locale = null;
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", DefaultBindingsHelperImpl.getLocale());
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private static final String FFDC_ID_3 = "FFDC-3";
    private static final String FFDC_ID_4 = "FFDC-4";
    private static final String FFDC_ID_5 = "FFDC-5";
    private static final String FFDC_ID_6 = "FFDC-6";
    private static final String FFDC_ID_7 = "FFDC-7";
    private static TraceComponent tc = Tr.register(DefaultBindingsHelperImpl.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");

    public DefaultBindingsHelperImpl(String fileName) {
        this.fileName = fileName;
    }

    public DefaultBindingsHelperImpl(InputStream istream) {
        this.inputStream = istream;
        this.readOnly = true;
    }

    private void loadData() throws JAXBException, FileNotFoundException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadData for file " + this.fileName);
        }
        this.defaultBindings = null;
        InputStream istream = this.inputStream;
        boolean createdStream = false;
        try {
            if (istream == null) {
                if (this.fileName != null) {
                    istream = new FileInputStream(this.fileName);
                    createdStream = true;
                } else {
                    throw new FileNotFoundException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0067E", new Object[0], "The file name is invalid"));
                }
            }
            JAXBContext jc = JAXBContext.newInstance((String)"com.ibm.xmlns.prod.websphere._200711.defaultbindings");
            Unmarshaller um = jc.createUnmarshaller();
            this.defaultBindings = (DefaultBindings)um.unmarshal(istream);
            if (createdStream) {
                istream.close();
            }
        }
        catch (JAXBException jaxe) {
            Tr.processException(jaxe, this.className, FFDC_ID_1);
            Tr.error(tc, "CWPST0001E", new Object[]{jaxe.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loadData - caught JAXBException while parsing file");
                jaxe.printStackTrace();
            }
            if (createdStream) {
                istream.close();
            }
            throw jaxe;
        }
        catch (FileNotFoundException fnfe) {
            Tr.processException(fnfe, this.className, FFDC_ID_2);
            Tr.error(tc, "CWPST0001E", new Object[]{fnfe.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loadData - caught FileNotFoundException while parsing file");
                fnfe.printStackTrace();
            }
            throw fnfe;
        }
        catch (IOException ioe) {
            Tr.processException(ioe, this.className, FFDC_ID_7);
            Tr.error(tc, "CWPST0001E", new Object[]{ioe.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loadData - caught IOException while parsing file");
                ioe.printStackTrace();
            }
            throw ioe;
        }
        this.fileLoaded = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadData for file " + this.fileName);
        }
    }

    private int saveData() throws JAXBException, FileNotFoundException, IllegalArgumentException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "saveData for file " + this.fileName);
        }
        if (this.readOnly) {
            throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0075E", new Object[0], "Cannot write to this read only instance"));
        }
        int retCode = 0;
        FileOutputStream outStream = null;
        try {
            JAXBContext jc = JAXBContext.newInstance((String)"com.ibm.xmlns.prod.websphere._200711.defaultbindings");
            outStream = new FileOutputStream(this.fileName);
            Marshaller m = jc.createMarshaller();
            try {
                m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            }
            catch (PropertyException e) {
                // empty catch block
            }
            m.marshal((Object)this.defaultBindings, (OutputStream)outStream);
            ((OutputStream)outStream).close();
        }
        catch (JAXBException jaxe) {
            Tr.processException(jaxe, this.className, FFDC_ID_3);
            Tr.error(tc, "CWPST0002E", new Object[]{jaxe.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "saveData - caught JAXBException while writing file");
                jaxe.printStackTrace();
            }
            ((OutputStream)outStream).close();
            throw jaxe;
        }
        catch (FileNotFoundException fnfe) {
            Tr.processException(fnfe, this.className, FFDC_ID_4);
            Tr.error(tc, "CWPST0002E", new Object[]{fnfe.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "saveData - caught FileNotFoundException while writing file");
                fnfe.printStackTrace();
            }
            throw fnfe;
        }
        catch (IllegalArgumentException iae) {
            Tr.processException(iae, this.className, FFDC_ID_5);
            Tr.error(tc, "CWPST0002E", new Object[]{iae.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "saveData - caught IllegalArgumentException while writing file");
                iae.printStackTrace();
            }
            if (outStream != null) {
                ((OutputStream)outStream).close();
            }
            throw iae;
        }
        catch (IOException ioe) {
            Tr.processException(ioe, this.className, FFDC_ID_6);
            Tr.error(tc, "CWPST0002E", new Object[]{ioe.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "saveData - caught IOException while writing file");
                ioe.printStackTrace();
            }
            throw ioe;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "saveData for file " + this.fileName);
        }
        return retCode;
    }

    @Override
    public DefaultBindings getDefaultBindingsObject() throws JAXBException, FileNotFoundException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", DefaultBindingsHelperImpl.getLocale());
        if (!this.fileLoaded) {
            this.loadData();
        }
        return this.defaultBindings;
    }

    @Override
    public int createDefaultBindings() throws JAXBException, FileNotFoundException, IllegalArgumentException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", DefaultBindingsHelperImpl.getLocale());
        if (this.readOnly) {
            throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0075E", new Object[0], "Cannot write to this read only instance"));
        }
        this.rc = 0;
        if (this.fileName == null || !this.fileName.contains("defaultBindings.xml")) {
            throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0080E", new Object[]{this.fileName}, "The following file name is invalid: {0}"));
        }
        this.defaultBindings = new DefaultBindings();
        this.rc = this.saveData();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createDefaultBindings, rc = " + this.rc);
        }
        return this.rc;
    }

    @Override
    public Properties getDomainDefaults(String domain) throws JAXBException, FileNotFoundException, NoItemFoundException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", DefaultBindingsHelperImpl.getLocale());
        this.rc = 0;
        Properties props = new Properties();
        if (!this.fileLoaded) {
            this.loadData();
        }
        if (this.defaultBindings != null) {
            List<Domain> domainDefaults = this.defaultBindings.getDomain();
            for (Domain dom : domainDefaults) {
                if (!dom.getName().equals(domain)) continue;
                Provider provider = dom.getProvider();
                if (provider != null) {
                    props.setProperty("provider", provider.getName());
                } else {
                    props.setProperty("provider", "");
                }
                Client client = dom.getClient();
                if (client != null) {
                    props.setProperty("client", client.getName());
                    continue;
                }
                props.setProperty("client", "");
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getDomainDefaults, rc = " + this.rc);
        }
        return props;
    }

    @Override
    public int setDomainDefaults(String domain, Properties bindings) throws JAXBException, FileNotFoundException, IllegalArgumentException, NoItemFoundException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", DefaultBindingsHelperImpl.getLocale());
        this.rc = 0;
        boolean foundEntry = false;
        boolean removeProvider = false;
        boolean removeClient = false;
        if (bindings != null && !bindings.isEmpty()) {
            String clientValue;
            String providerValue = bindings.getProperty("provider");
            if (providerValue != null && providerValue.equals("")) {
                removeProvider = true;
            }
            if ((clientValue = bindings.getProperty("client")) != null && clientValue.equals("")) {
                removeClient = true;
            }
            if (domain.equals("global") && (removeProvider || removeClient)) {
                this.rc = -7;
                throw new IllegalArgumentException(CommonUtil.getFormattedMessage(resourceBundle, "CWPST0132E", new Object[0], "The default bindings cannot be removed for the global security domain"));
            }
            if (!this.fileLoaded) {
                this.loadData();
            }
            if (this.defaultBindings != null) {
                List<Domain> domainDefaults = this.defaultBindings.getDomain();
                for (Domain dom : domainDefaults) {
                    if (!dom.getName().equals(domain)) continue;
                    if (removeProvider && removeClient) {
                        this.defaultBindings.getDomain().remove(dom);
                    } else {
                        if (providerValue != null) {
                            if (removeProvider) {
                                dom.setProvider(null);
                            } else {
                                Provider provider = dom.getProvider();
                                if (provider == null) {
                                    provider = new Provider();
                                }
                                provider.setName(providerValue);
                                dom.setProvider(provider);
                            }
                        }
                        if (clientValue != null) {
                            if (removeClient) {
                                dom.setClient(null);
                            } else {
                                Client client = dom.getClient();
                                if (client == null) {
                                    client = new Client();
                                }
                                client.setName(clientValue);
                                dom.setClient(client);
                            }
                        }
                    }
                    foundEntry = true;
                    break;
                }
                if (!foundEntry) {
                    boolean setProvider = false;
                    boolean setClient = false;
                    Domain dom = new Domain();
                    dom.setName(domain);
                    if (providerValue != null && !removeProvider) {
                        Provider provider = new Provider();
                        provider.setName(providerValue);
                        dom.setProvider(provider);
                        setProvider = true;
                    }
                    if (clientValue != null && !removeClient) {
                        Client client = new Client();
                        client.setName(clientValue);
                        dom.setClient(client);
                        setClient = true;
                    }
                    if (setProvider || setClient) {
                        this.defaultBindings.getDomain().add(dom);
                    }
                }
                this.rc = this.saveData();
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setDomainDefaults, rc = " + this.rc);
        }
        return this.rc;
    }

    @Override
    public Properties getServerDefaults(String server, String node) throws JAXBException, FileNotFoundException, NoItemFoundException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", DefaultBindingsHelperImpl.getLocale());
        this.rc = 0;
        Properties props = new Properties();
        if (!this.fileLoaded) {
            this.loadData();
        }
        if (this.defaultBindings != null) {
            List<Server> serverDefaults = this.defaultBindings.getServer();
            for (Server serv : serverDefaults) {
                if (!serv.getName().equals(server) || !serv.getNode().equals(node)) continue;
                Provider provider = serv.getProvider();
                if (provider != null) {
                    props.setProperty("provider", provider.getName());
                } else {
                    props.setProperty("provider", "");
                }
                Client client = serv.getClient();
                if (client != null) {
                    props.setProperty("client", client.getName());
                    continue;
                }
                props.setProperty("client", "");
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getServerDefaults, rc = " + this.rc);
        }
        return props;
    }

    @Override
    public int setServerDefaults(String server, String node, Properties bindings) throws JAXBException, FileNotFoundException, IllegalArgumentException, NoItemFoundException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", DefaultBindingsHelperImpl.getLocale());
        this.rc = 0;
        boolean foundEntry = false;
        boolean removeProvider = false;
        boolean removeClient = false;
        if (bindings != null && !bindings.isEmpty()) {
            String clientValue;
            String providerValue = bindings.getProperty("provider");
            if (providerValue != null && providerValue.equals("")) {
                removeProvider = true;
            }
            if ((clientValue = bindings.getProperty("client")) != null && clientValue.equals("")) {
                removeClient = true;
            }
            if (!this.fileLoaded) {
                this.loadData();
            }
            if (this.defaultBindings != null) {
                List<Server> serverDefaults = this.defaultBindings.getServer();
                for (Server serv : serverDefaults) {
                    if (!serv.getName().equals(server) || !serv.getNode().equals(node)) continue;
                    if (removeProvider && removeClient) {
                        this.defaultBindings.getServer().remove(serv);
                    } else {
                        if (providerValue != null) {
                            if (removeProvider) {
                                serv.setProvider(null);
                            } else {
                                Provider provider = serv.getProvider();
                                if (provider == null) {
                                    provider = new Provider();
                                }
                                provider.setName(providerValue);
                                serv.setProvider(provider);
                            }
                        }
                        if (clientValue != null) {
                            if (removeClient) {
                                serv.setClient(null);
                            } else {
                                Client client = serv.getClient();
                                if (client == null) {
                                    client = new Client();
                                }
                                client.setName(clientValue);
                                serv.setClient(client);
                            }
                        }
                    }
                    foundEntry = true;
                    break;
                }
                if (!foundEntry) {
                    boolean setProvider = false;
                    boolean setClient = false;
                    Server serv = new Server();
                    serv.setName(server);
                    serv.setNode(node);
                    if (providerValue != null && !removeProvider) {
                        Provider provider = new Provider();
                        provider.setName(providerValue);
                        serv.setProvider(provider);
                        setProvider = true;
                    }
                    if (clientValue != null && !removeClient) {
                        Client client = new Client();
                        client.setName(clientValue);
                        serv.setClient(client);
                        setClient = true;
                    }
                    if (setProvider || setClient) {
                        this.defaultBindings.getServer().add(serv);
                    }
                }
                this.rc = this.saveData();
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setServerDefaults, rc = " + this.rc);
        }
        return this.rc;
    }

    @Override
    public List<String> getDomainsDefaultedToBinding(String binding, String type) throws JAXBException, FileNotFoundException, NoItemFoundException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", DefaultBindingsHelperImpl.getLocale());
        ArrayList<String> bindingList = new ArrayList<String>();
        if (!this.fileLoaded) {
            this.loadData();
        }
        if (this.defaultBindings != null) {
            List<Domain> domainDefaults = this.defaultBindings.getDomain();
            for (Domain dom : domainDefaults) {
                Client client;
                String name;
                Provider provider;
                if ("provider".equals(type) && (provider = dom.getProvider()) != null && (name = provider.getName()).equals(binding)) {
                    bindingList.add(dom.getName());
                }
                if (!"client".equals(type) || (client = dom.getClient()) == null || !(name = client.getName()).equals(binding)) continue;
                bindingList.add(dom.getName());
            }
        }
        return bindingList;
    }

    @Override
    public List<String> getServersDefaultedToBinding(String binding, String type) throws JAXBException, FileNotFoundException, NoItemFoundException, IOException {
        resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", DefaultBindingsHelperImpl.getLocale());
        ArrayList<String> bindingList = new ArrayList<String>();
        if (!this.fileLoaded) {
            this.loadData();
        }
        if (this.defaultBindings != null) {
            List<Server> serverDefaults = this.defaultBindings.getServer();
            for (Server server : serverDefaults) {
                Client client;
                String name;
                Provider provider;
                if ("provider".equals(type) && (provider = server.getProvider()) != null && (name = provider.getName()).equals(binding)) {
                    bindingList.add(server.getNode() + "/" + server.getName());
                }
                if (!"client".equals(type) || (client = server.getClient()) == null || !(name = client.getName()).equals(binding)) continue;
                bindingList.add(server.getNode() + "/" + server.getName());
            }
        }
        return bindingList;
    }

    @Override
    public void setLocale(Locale locale) {
        _locale = locale;
    }

    private static Locale getLocale() {
        if (_locale == null) {
            return Locale.getDefault();
        }
        return _locale;
    }
}

