/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.deploy;

import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelper;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelperFactory;
import com.ibm.ws.policyset.util.Tr;
import com.ibm.ws.policyset.util.TraceComponent;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.PolicySetAttachment;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.PolicySetBinding;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.PolicySetReference;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

public class PolicySetAttachmentReadTask
extends AbstractTask {
    private static TraceComponent tc = Tr.register(PolicySetAttachmentReadTask.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    protected String className = ((Object)((Object)this)).getClass().getName();
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private RepositoryContext _deployContext = null;

    public boolean performTask() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "PolicySetAttachmentReadTask.performTask()");
        }
        try {
            Map bindings;
            PolicySetAttachmentHelper attachmentHelper;
            PolicySetAttachment attachment;
            this._deployContext = AppUtils.findAppContextFromConfig((String)this.scheduler.getAppName(), (WorkSpace)this.scheduler.getWorkSpace(), (Hashtable)this.scheduler.getProperties());
            String relativePath = "META-INF" + File.separator + "policyAttachments.xml";
            String filename = this._deployContext.getPath() + File.separator + relativePath;
            File fileobj = new File(filename);
            if (fileobj.exists() && (attachment = (attachmentHelper = PolicySetAttachmentHelperFactory.createHelper(filename)).getPolicySetAttachmentObject()) != null) {
                this.scheduler.getProperties().put("PolicySetAttachmentTask.PolicySetAttachments", attachment);
                bindings = this.readBindings(attachment);
                this.scheduler.getProperties().put("PolicySetAttachmentTask.PolicySetBindings", bindings);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "PolicySetAttachmentReadTask.performTask(), cache attachment=" + attachment + ", bindings=" + bindings);
                }
            }
            relativePath = "META-INF" + File.separator + "clientPolicyAttachments.xml";
            filename = this._deployContext.getPath() + File.separator + relativePath;
            fileobj = new File(filename);
            if (fileobj.exists() && (attachment = (attachmentHelper = PolicySetAttachmentHelperFactory.createHelper(filename)).getPolicySetAttachmentObject()) != null) {
                this.scheduler.getProperties().put("PolicySetAttachmentTask.ClientPolicySetAttachments", attachment);
                bindings = this.readBindings(attachment);
                this.scheduler.getProperties().put("PolicySetAttachmentTask.ClientPolicySetBindings", bindings);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "PolicySetAttachmentReadTask.performTask(), cache client attachment=" + attachment + ", client bindings=" + bindings);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "PolicySetAttachmentReadTask.performTask()");
            }
            return true;
        }
        catch (Throwable th) {
            Tr.processException(th, this.className, FFDC_ID_1);
            this.scheduler.propagateTaskEvent(this.createNotification("Failed", "ADMA5006E", new String[]{this.scheduler.getAppName(), th.toString()}));
            if (th instanceof AdminException) {
                throw (AdminException)th;
            }
            throw new AdminException(th, AppUtils.getMessage((ResourceBundle)this.getResourceBundle(), (String)"ADMA0066E"));
        }
    }

    private Map readBindings(PolicySetAttachment attachment) {
        HashMap<String, Map> bindings = new HashMap<String, Map>();
        List<PolicySetReference> referenceList = attachment.getPolicySetReference();
        for (PolicySetReference reference : referenceList) {
            Map bindingFiles;
            PolicySetBinding binding = reference.getPolicySetBinding();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "readBindings, binding=" + binding + ", reference.getName()=" + reference.getName());
            }
            if (binding == null || reference.getName() == null || (bindingFiles = this.readBindings(binding.getName())) == null || bindingFiles.isEmpty()) continue;
            bindings.put(reference.getName(), bindingFiles);
        }
        return bindings;
    }

    private Map readBindings(String bindingName) {
        File policyTypesDir;
        HashMap<String, byte[]> bindingsMap = new HashMap<String, byte[]>();
        String basePath = this._deployContext.getPath() + File.separator + "META-INF";
        File bindingDir = new File(basePath + File.separator + bindingName);
        if (bindingDir.exists() && bindingDir.isDirectory() && (policyTypesDir = new File(basePath + File.separator + bindingName + File.separator + "PolicyTypes")).exists() && policyTypesDir.isDirectory()) {
            File[] files = policyTypesDir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File bindings = new File(files[i].getPath() + File.separator + "bindings.xml");
                if (!bindings.exists() || !bindings.isFile()) continue;
                byte[] bytes = new byte[(int)bindings.length()];
                try {
                    FileInputStream is = new FileInputStream(bindings);
                    is.read(bytes);
                    bindingsMap.put(this.getRelativePath(bindings.getPath(), bindingName), bytes);
                    continue;
                }
                catch (Exception ex) {
                    Tr.processException(ex, this.className, FFDC_ID_2);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Exception, " + ex + ", while reading " + bindings + " ignored.");
                }
            }
        }
        return bindingsMap;
    }

    private String getRelativePath(String path, String bindingName) {
        int ndx = path.lastIndexOf(bindingName);
        return path.substring(ndx);
    }
}

