/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.deploy;

import com.ibm.ws.policyset.admin.deploy.PolicyResource;
import com.ibm.ws.policyset.admin.deploy.PolicySetAttachmentInstallTask;
import com.ibm.ws.policyset.util.Tr;
import com.ibm.ws.policyset.util.TraceComponent;
import com.ibm.ws.webservices.admin.exceptions.NoItemFoundException;
import com.ibm.ws.webservices.admin.serviceindex.ServiceIndexHelper;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.PolicySetAttachment;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.PolicySetBinding;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.PolicySetReference;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.Resource;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import org.xml.sax.SAXException;

public class PolicySetAttachmentProcessor {
    private static TraceComponent tc = Tr.register(PolicySetAttachmentInstallTask.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private PolicySetAttachment _attachment = null;
    private PolicySetAttachment _clientAttachment = null;
    private Map _serviceIndex = null;
    private Map _bindings = null;
    private Map _clientBindings = null;
    private List _bindingDeleteList = new ArrayList();
    protected String SOURCE_FILE = this.getClass().getName();
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private static final String FFDC_ID_3 = "FFDC-3";
    private static final String FFDC_ID_4 = "FFDC-4";
    private static final String FFDC_ID_5 = "FFDC-5";
    private static final String FFDC_ID_6 = "FFDC-6";
    private static final String FFDC_ID_7 = "FFDC-7";
    private static final String FFDC_ID_8 = "FFDC-8";
    private static final String FFDC_ID_9 = "FFDC-9";
    private static final String FFDC_ID_10 = "FFDC-10";
    private static final String FFDC_ID_11 = "FFDC-11";
    private static final String FFDC_ID_12 = "FFDC-12";

    PolicySetAttachmentProcessor() {
    }

    public PolicySetAttachment getPolicySetAttachment() {
        return this._attachment;
    }

    public void setPolicySetAttachment(PolicySetAttachment _attachment) {
        this._attachment = _attachment;
    }

    public PolicySetAttachment getClientPolicySetAttachment() {
        return this._clientAttachment;
    }

    public void setClientPolicySetAttachment(PolicySetAttachment _attachment) {
        this._clientAttachment = _attachment;
    }

    public List getBindingDeleteList() {
        return this._bindingDeleteList;
    }

    public Map getBindings() {
        return this._bindings;
    }

    public void setBindings(Map _bindings) {
        this._bindings = _bindings;
    }

    public Map getClientBindings() {
        return this._clientBindings;
    }

    public void setClientBindings(Map _bindings) {
        this._clientBindings = _bindings;
    }

    public Map getServiceIndex() {
        return this._serviceIndex;
    }

    public void setServiceIndex(Map index) {
        this._serviceIndex = index;
    }

    private List getEndpointHelpers(List helperList, PolicyResource resource, boolean client) {
        ArrayList<ServiceIndexHelper> list = new ArrayList<ServiceIndexHelper>();
        for (ServiceIndexHelper helper : helperList) {
            try {
                AttributeList alist = helper.getEndpoint(resource.getServiceName(), resource.getEndpointName(), client);
                if (alist == null || alist.isEmpty()) continue;
                list.add(helper);
            }
            catch (NoItemFoundException nifex) {
                Tr.processException(nifex, this.SOURCE_FILE + ".getEndpointHelpers", FFDC_ID_1);
            }
            catch (FileNotFoundException fnf) {
                Tr.processException(fnf, this.SOURCE_FILE + ".getEndpointHelpers", FFDC_ID_2);
            }
            catch (IOException ioex) {
                Tr.processException(ioex, this.SOURCE_FILE + ".getEndpointHelpers", FFDC_ID_3);
            }
            catch (SAXException saxe) {
                Tr.processException(saxe, this.SOURCE_FILE + ".getEndpointHelpers", FFDC_ID_4);
            }
        }
        return list;
    }

    private List getOperationHelpers(List helperList, PolicyResource resource, boolean client) {
        ArrayList<ServiceIndexHelper> list = new ArrayList<ServiceIndexHelper>();
        for (ServiceIndexHelper helper : helperList) {
            try {
                List oplist = helper.listOperations(resource.getServiceName(), resource.getEndpointName(), client);
                AttributeList opAttrList2 = null;
                if (oplist == null) continue;
                for (AttributeList opAttrList2 : oplist) {
                    Attribute attr = (Attribute)opAttrList2.get(0);
                    if (!attr.getValue().equals(resource.getOperationName())) continue;
                    list.add(helper);
                }
            }
            catch (NoItemFoundException nifex) {
                Tr.processException(nifex, this.SOURCE_FILE + ".getOperationHelpers", FFDC_ID_5);
            }
            catch (FileNotFoundException fnf) {
                Tr.processException(fnf, this.SOURCE_FILE + ".getOperationHelpers", FFDC_ID_6);
            }
            catch (IOException ioex) {
                Tr.processException(ioex, this.SOURCE_FILE + ".getOperationHelpers", FFDC_ID_7);
            }
            catch (SAXException saxe) {
                Tr.processException(saxe, this.SOURCE_FILE + ".getOperationHelpers", FFDC_ID_8);
            }
        }
        return list;
    }

    private String getRelativePath(String path, String bindingName) {
        int ndx = path.lastIndexOf(bindingName);
        return path.substring(ndx);
    }

    private List getServiceHelpers(PolicyResource resource, boolean client) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "PolicySetAttachmentProcessor.getServiceHelpers", new Object[]{resource.toString(), client});
        }
        ArrayList<ServiceIndexHelper> list = new ArrayList<ServiceIndexHelper>();
        Collection<Object> helperCollection = null;
        if (resource.getModuleName() != null) {
            helperCollection = new ArrayList();
            ServiceIndexHelper helper = (ServiceIndexHelper)this._serviceIndex.get(resource.getModuleName());
            if (helper != null) {
                helperCollection.add(helper);
            }
        } else {
            helperCollection = this._serviceIndex.values();
        }
        for (ServiceIndexHelper serviceIndexHelper : helperCollection) {
            try {
                AttributeList alist = serviceIndexHelper.getWebService(resource.getServiceName(), client);
                if (alist == null || alist.isEmpty()) continue;
                list.add(serviceIndexHelper);
            }
            catch (NoItemFoundException nifex) {
                Tr.processException(nifex, this.SOURCE_FILE + ".getServiceHelpers", FFDC_ID_9);
            }
            catch (FileNotFoundException fnf) {
                Tr.processException(fnf, this.SOURCE_FILE + ".getServiceHelpers", FFDC_ID_10);
            }
            catch (IOException ioex) {
                Tr.processException(ioex, this.SOURCE_FILE + ".getServiceHelpers", FFDC_ID_11);
            }
            catch (SAXException saxe) {
                Tr.processException(saxe, this.SOURCE_FILE + ".getServiceHelpers", FFDC_ID_12);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "PolicySetAttachmentProcessor.getServiceHelpers, list size=" + list.size());
        }
        return list;
    }

    private boolean indexContains(PolicyResource resource, boolean client) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "PolicySetAttachmentProcessor.indexConstants", new Object[]{resource, client});
        }
        if (resource.getServiceName() == null) {
            return true;
        }
        List list = this.getServiceHelpers(resource, client);
        if (list != null && !list.isEmpty()) {
            if (resource.getEndpointName() == null) {
                return true;
            }
            if ((list = this.getEndpointHelpers(list, resource, client)) != null && !list.isEmpty()) {
                if (resource.getOperationName() == null) {
                    return true;
                }
                return (list = this.getOperationHelpers(list, resource, client)) != null && !list.isEmpty();
            }
        }
        return false;
    }

    public boolean process() {
        boolean madeChanges = false;
        if (this._attachment != null) {
            madeChanges |= this.processReferences(this._attachment.getPolicySetReference(), this._bindings, false);
        }
        if (this._clientAttachment != null) {
            madeChanges |= this.processReferences(this._clientAttachment.getPolicySetReference(), this._clientBindings, true);
        }
        return madeChanges |= this.cleanupBindings();
    }

    private boolean processReferences(List referenceList, Map bindings, boolean client) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "PolicysetAttachmentProcessor.processReferrences", new Object[]{referenceList, bindings, client});
        }
        boolean madeChanges = false;
        for (PolicySetReference reference : referenceList) {
            List<Resource> resourceList = reference.getResource();
            Iterator<Resource> resources = resourceList.iterator();
            while (resources.hasNext()) {
                Resource resource = resources.next();
                PolicyResource policyResource = new PolicyResource(resource);
                if (!policyResource.isValid() || this.indexContains(policyResource, client)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "processReferences, remove resource because it is not found in servicesIndex.xml: " + policyResource);
                }
                madeChanges = true;
                resources.remove();
            }
        }
        Iterator references = referenceList.iterator();
        while (references.hasNext()) {
            PolicySetReference reference;
            reference = (PolicySetReference)references.next();
            PolicySetBinding binding = reference.getPolicySetBinding();
            List<Resource> resourceList = reference.getResource();
            if (resourceList != null && !resourceList.isEmpty()) continue;
            madeChanges = true;
            if (reference.getName() != null) {
                bindings.remove(reference.getName());
            }
            references.remove();
            if (this._bindingDeleteList.contains(binding.getName())) continue;
            this._bindingDeleteList.add(binding.getName());
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "processReferences, remove binding=" + binding.getName());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "PolicysetAttachmentProcessor.processReferrences, madeChanges=" + madeChanges);
        }
        return madeChanges;
    }

    private boolean cleanupBindings() {
        boolean madeChanges = false;
        ArrayList<String> removeList = new ArrayList<String>();
        for (String name : this._bindingDeleteList) {
            if ((this._attachment == null || !this.used(name, this._attachment.getPolicySetReference())) && (this._clientAttachment == null || !this.used(name, this._clientAttachment.getPolicySetReference()))) continue;
            removeList.add(name);
        }
        for (String name : removeList) {
            this._bindingDeleteList.remove(name);
        }
        return madeChanges;
    }

    private boolean used(String name, List referenceList) {
        for (PolicySetReference reference : referenceList) {
            PolicySetBinding binding = reference.getPolicySetBinding();
            List<Resource> resourceList = reference.getResource();
            if (!name.equalsIgnoreCase(binding.getName())) continue;
            return true;
        }
        return false;
    }
}

